/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.Plane3D$;
import org.locationtech.jts.math.Vector3D;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005e;Qa\u0005\u000b\t\u0002u1Qa\b\u000b\t\u0002\u0001BQaJ\u0001\u0005\u0002!Bq!K\u0001C\u0002\u0013\u0005!\u0006\u0003\u0004/\u0003\u0001\u0006Ia\u000b\u0005\b_\u0005\u0011\r\u0011\"\u0001+\u0011\u0019\u0001\u0014\u0001)A\u0005W!9\u0011'\u0001b\u0001\n\u0003Q\u0003B\u0002\u001a\u0002A\u0003%1F\u0002\u0003 )\u0001\u0019\u0004\u0002\u0003\u001b\n\u0005\u0003\u0007I\u0011A\u001b\t\u0011eJ!\u00111A\u0005\u0002iB\u0001\u0002Q\u0005\u0003\u0002\u0003\u0006KA\u000e\u0005\t\u0003&\u0011\t\u0019!C\u0001\u0005\"A\u0011*\u0003BA\u0002\u0013\u0005!\n\u0003\u0005M\u0013\t\u0005\t\u0015)\u0003D\u0011\u00159\u0013\u0002\"\u0001N\u0011\u0015\t\u0016\u0002\"\u0001S\u0011\u0015A\u0016\u0002\"\u0001+\u0003\u001d\u0001F.\u00198fg\u0011S!!\u0006\f\u0002\t5\fG\u000f\u001b\u0006\u0003/a\t1A\u001b;t\u0015\tI\"$\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u001c\u0003\ry'oZ\u0002\u0001!\tq\u0012!D\u0001\u0015\u0005\u001d\u0001F.\u00198fg\u0011\u001b\"!A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ$\u0001\u0005Y3~\u0003F*\u0011(F+\u0005Y\u0003C\u0001\u0012-\u0013\ti3EA\u0002J]R\f\u0011\u0002W-`!2\u000be*\u0012\u0011\u0002\u0011eSv\f\u0015'B\u001d\u0016\u000b\u0011\"\u0017.`!2\u000be*\u0012\u0011\u0002\u0011aSv\f\u0015'B\u001d\u0016\u000b\u0011\u0002\u0017.`!2\u000be*\u0012\u0011\u0014\u0005%\t\u0013A\u00028pe6\fG.F\u00017!\tqr'\u0003\u00029)\tAa+Z2u_J\u001cD)\u0001\u0006o_Jl\u0017\r\\0%KF$\"a\u000f \u0011\u0005\tb\u0014BA\u001f$\u0005\u0011)f.\u001b;\t\u000f}Z\u0011\u0011!a\u0001m\u0005\u0019\u0001\u0010J\u0019\u0002\u000f9|'/\\1mA\u00051!-Y:f!R,\u0012a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rZ\tAaZ3p[&\u0011\u0001*\u0012\u0002\u000b\u0007>|'\u000fZ5oCR,\u0017A\u00032bg\u0016\u0004Fo\u0018\u0013fcR\u00111h\u0013\u0005\b\u007f9\t\t\u00111\u0001D\u0003\u001d\u0011\u0017m]3Qi\u0002\"2AT(Q!\tq\u0012\u0002C\u00035!\u0001\u0007a\u0007C\u0003B!\u0001\u00071)\u0001\tpe&,g\u000e^3e\t&\u001cH/\u00198dKR\u00111K\u0016\t\u0003EQK!!V\u0012\u0003\r\u0011{WO\u00197f\u0011\u00159\u0016\u00031\u0001D\u0003\u0005\u0001\u0018\u0001E2m_N,7\u000f^!ySN\u0004F.\u00198f\u0001")
public class Plane3D {
    private Vector3D normal;
    private Coordinate basePt;

    public static int XZ_PLANE() {
        return Plane3D$.MODULE$.XZ_PLANE();
    }

    public static int YZ_PLANE() {
        return Plane3D$.MODULE$.YZ_PLANE();
    }

    public static int XY_PLANE() {
        return Plane3D$.MODULE$.XY_PLANE();
    }

    public Vector3D normal() {
        return this.normal;
    }

    public void normal_$eq(Vector3D x$1) {
        this.normal = x$1;
    }

    public Coordinate basePt() {
        return this.basePt;
    }

    public void basePt_$eq(Coordinate x$1) {
        this.basePt = x$1;
    }

    public double orientedDistance(Coordinate p) {
        Vector3D pb = new Vector3D(p, this.basePt());
        double pbdDotNormal = pb.dot(this.normal());
        if (Double.isNaN(pbdDotNormal)) {
            throw new IllegalArgumentException("3D Coordinate has NaN ordinate");
        }
        double d = pbdDotNormal / this.normal().length();
        return d;
    }

    public int closestAxisPlane() {
        double xmag = Math.abs(this.normal().getX());
        double ymag = Math.abs(this.normal().getY());
        double zmag = Math.abs(this.normal().getZ());
        if (xmag > ymag) {
            if (xmag > zmag) {
                return Plane3D$.MODULE$.YZ_PLANE();
            }
            return Plane3D$.MODULE$.XY_PLANE();
        }
        if (zmag > ymag) {
            return Plane3D$.MODULE$.XY_PLANE();
        }
        return Plane3D$.MODULE$.XZ_PLANE();
    }

    public Plane3D(Vector3D normal, Coordinate basePt) {
        this.normal = normal;
        this.basePt = basePt;
    }
}

