/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import org.locationtech.jts.algorithm.Angle$;
import org.locationtech.jts.algorithm.CGAlgorithmsDD$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Coordinate$;
import org.locationtech.jts.math.Vector2D$;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015v!B\u0017/\u0011\u00039d!B\u001d/\u0011\u0003Q\u0004\"B!\u0002\t\u0003\u0011\u0005\"B\"\u0002\t\u0003!\u0005BB\"\u0002\t\u0003\ti\b\u0003\u0004D\u0003\u0011\u0005\u0011\u0011\u0011\u0005\u0007\u0007\u0006!\t!!\"\t\u0013\u0005-\u0015!%A\u0005\u0002\u00055\u0005\"CAR\u0003E\u0005I\u0011AAG\r\u0011Id\u0006\u0001$\t\u0011\u001dK!Q1A\u0005\u0012!C\u0001\u0002T\u0005\u0003\u0002\u0003\u0006I!\u0013\u0005\t\u001b&\u0011)\u0019!C\t\u0011\"Aa*\u0003B\u0001B\u0003%\u0011\nC\u0003B\u0013\u0011\u0005q\nC\u0003B\u0013\u0011\u0005!\u000bC\u0003B\u0013\u0011\u0005Q\u000bC\u0003B\u0013\u0011\u0005\u0001\rC\u0003c\u0013\u0011\u0005\u0001\nC\u0003d\u0013\u0011\u0005\u0001\nC\u0003e\u0013\u0011\u0005Q\rC\u0003l\u0013\u0011\u0005A\u000eC\u0003o\u0013\u0011\u0005q\u000eC\u0003r\u0013\u0011\u0005!\u000fC\u0003v\u0013\u0011\u0005a\u000fC\u0003y\u0013\u0011\u0005\u0011\u0010C\u0003{\u0013\u0011\u0005\u0001\nC\u0003|\u0013\u0011\u0005\u0001\nC\u0003}\u0013\u0011\u0005\u0011\u0010C\u0003~\u0013\u0011\u0005a\u0010C\u0004\u0002\u0002%!\t!a\u0001\t\u000f\u0005-\u0011\u0002\"\u0001\u0002\u000e!9\u0011\u0011C\u0005\u0005\u0002\u0005M\u0001BBA\f\u0013\u0011\u0005\u0001\nC\u0004\u0002\u0018%!\t!!\u0007\t\u000f\u0005u\u0011\u0002\"\u0001\u0002 !9\u00111E\u0005\u0005\u0002\u0005\u0015\u0002bBA\u0015\u0013\u0011\u0005\u00111\u0006\u0005\b\u0003cIA\u0011AA\u001a\u0011\u001d\ti$\u0003C\u0001\u0003\u007fAq!!\u0012\n\t\u0003\t9\u0005C\u0004\u0002J%!\t%a\u0013\t\u000f\u00055\u0013\u0002\"\u0011\u0002P!9\u0011qM\u0005\u0005B\u0005%\u0004bBA;\u0013\u0011\u0005\u0013qO\u0001\t-\u0016\u001cGo\u001c:3\t*\u0011q\u0006M\u0001\u0005[\u0006$\bN\u0003\u00022e\u0005\u0019!\u000e^:\u000b\u0005M\"\u0014\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005a\nQ\"\u0001\u0018\u0003\u0011Y+7\r^8se\u0011\u001b\"!A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq'\u0001\u0004de\u0016\fG/\u001a\u000b\u0006\u000b\u0006e\u00141\u0010\t\u0003q%\u0019\"!C\u001e\u0002\u0003a,\u0012!\u0013\t\u0003y)K!aS\u001f\u0003\r\u0011{WO\u00197f\u0003\tA\b%A\u0001z\u0003\tI\b\u0005F\u0002F!FCqa\u0012\b\u0011\u0002\u0003\u0007\u0011\nC\u0004N\u001dA\u0005\t\u0019A%\u0015\u0005\u0015\u001b\u0006\"\u0002+\u0010\u0001\u0004)\u0015!\u0001<\u0015\u0007\u00153f\fC\u0003X!\u0001\u0007\u0001,\u0001\u0003ge>l\u0007CA-]\u001b\u0005Q&BA.1\u0003\u00119Wm\\7\n\u0005uS&AC\"p_J$\u0017N\\1uK\")q\f\u0005a\u00011\u0006\u0011Ao\u001c\u000b\u0003\u000b\u0006DQ\u0001V\tA\u0002a\u000bAaZ3u1\u0006!q-\u001a;Z\u000319W\r^\"p[B|g.\u001a8u)\tIe\rC\u0003h)\u0001\u0007\u0001.A\u0003j]\u0012,\u0007\u0010\u0005\u0002=S&\u0011!.\u0010\u0002\u0004\u0013:$\u0018aA1eIR\u0011Q)\u001c\u0005\u0006)V\u0001\r!R\u0001\tgV\u0014GO]1diR\u0011Q\t\u001d\u0005\u0006)Z\u0001\r!R\u0001\t[VdG/\u001b9msR\u0011Qi\u001d\u0005\u0006i^\u0001\r!S\u0001\u0002I\u00061A-\u001b<jI\u0016$\"!R<\t\u000bQD\u0002\u0019A%\u0002\r9,w-\u0019;f+\u0005)\u0015A\u00027f]\u001e$\b.A\u0007mK:<G\u000f[*rk\u0006\u0014X\rZ\u0001\n]>\u0014X.\u00197ju\u0016\fq!\u0019<fe\u0006<W\r\u0006\u0002F\u007f\")A+\ba\u0001\u000b\u0006Yq/Z5hQR,GmU;n)\u0015)\u0015QAA\u0004\u0011\u0015!f\u00041\u0001F\u0011\u0019\tIA\ba\u0001\u0013\u0006!aM]1d\u0003!!\u0017n\u001d;b]\u000e,GcA%\u0002\u0010!)Ak\ba\u0001\u000b\u0006\u0019Am\u001c;\u0015\u0007%\u000b)\u0002C\u0003UA\u0001\u0007Q)A\u0003b]\u001edW\rF\u0002J\u00037AQ\u0001\u0016\u0012A\u0002\u0015\u000bq!\u00198hY\u0016$v\u000eF\u0002J\u0003CAQ\u0001V\u0012A\u0002\u0015\u000baA]8uCR,GcA#\u0002(!1\u0011q\u0003\u0013A\u0002%\u000bQC]8uCR,')_)vCJ$XM]\"je\u000edW\rF\u0002F\u0003[Aa!a\f&\u0001\u0004A\u0017a\u00038v[F+\u0018M\u001d;feN\f!\"[:QCJ\fG\u000e\\3m)\u0011\t)$a\u000f\u0011\u0007q\n9$C\u0002\u0002:u\u0012qAQ8pY\u0016\fg\u000eC\u0003UM\u0001\u0007Q)A\u0005ue\u0006t7\u000f\\1uKR\u0019\u0001,!\u0011\t\r\u0005\rs\u00051\u0001Y\u0003\u0015\u0019wn\u001c:e\u00031!xnQ8pe\u0012Lg.\u0019;f+\u0005A\u0016!B2m_:,G#A#\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0015\u0011\t\u0005M\u0013\u0011\r\b\u0005\u0003+\ni\u0006E\u0002\u0002Xuj!!!\u0017\u000b\u0007\u0005mc'\u0001\u0004=e>|GOP\u0005\u0004\u0003?j\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002d\u0005\u0015$AB*ue&twMC\u0002\u0002`u\na!Z9vC2\u001cH\u0003BA\u001b\u0003WBq!!\u001c,\u0001\u0004\ty'A\u0001p!\ra\u0014\u0011O\u0005\u0004\u0003gj$aA!os\u0006A\u0001.Y:i\u0007>$W\rF\u0001i\u0011\u001595\u00011\u0001J\u0011\u0015i5\u00011\u0001J)\r)\u0015q\u0010\u0005\u0006)\u0012\u0001\r!\u0012\u000b\u0004\u000b\u0006\r\u0005BBA\"\u000b\u0001\u0007\u0001\fF\u0003F\u0003\u000f\u000bI\tC\u0003X\r\u0001\u0007\u0001\fC\u0003`\r\u0001\u0007\u0001,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001fS3!SAIW\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006}UBAAL\u0015\u0011\tI*a'\u0002\u0013Ut7\r[3dW\u0016$'bAAO{\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0016q\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#\u0007")
public class Vector2D {
    private final double x;
    private final double y;

    public static double $lessinit$greater$default$2() {
        return Vector2D$.MODULE$.$lessinit$greater$default$2();
    }

    public static double $lessinit$greater$default$1() {
        return Vector2D$.MODULE$.$lessinit$greater$default$1();
    }

    public static Vector2D create(Coordinate coordinate, Coordinate coordinate2) {
        return Vector2D$.MODULE$.create(coordinate, coordinate2);
    }

    public static Vector2D create(Coordinate coordinate) {
        return Vector2D$.MODULE$.create(coordinate);
    }

    public static Vector2D create(Vector2D vector2D) {
        return Vector2D$.MODULE$.create(vector2D);
    }

    public static Vector2D create(double d, double d2) {
        return Vector2D$.MODULE$.create(d, d2);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double getX() {
        return this.x();
    }

    public double getY() {
        return this.y();
    }

    public double getComponent(int index) {
        if (index == 0) {
            return this.x();
        }
        return this.y();
    }

    public Vector2D add(Vector2D v) {
        return Vector2D$.MODULE$.create(this.x() + v.x(), this.y() + v.y());
    }

    public Vector2D subtract(Vector2D v) {
        return Vector2D$.MODULE$.create(this.x() - v.x(), this.y() - v.y());
    }

    public Vector2D multiply(double d) {
        return Vector2D$.MODULE$.create(this.x() * d, this.y() * d);
    }

    public Vector2D divide(double d) {
        return Vector2D$.MODULE$.create(this.x() / d, this.y() / d);
    }

    public Vector2D negate() {
        return Vector2D$.MODULE$.create(-this.x(), -this.y());
    }

    public double length() {
        return Math.sqrt(this.x() * this.x() + this.y() * this.y());
    }

    public double lengthSquared() {
        return this.x() * this.x() + this.y() * this.y();
    }

    public Vector2D normalize() {
        double vlength = this.length();
        if (vlength > 0.0) {
            return this.divide(vlength);
        }
        return Vector2D$.MODULE$.create(0.0, 0.0);
    }

    public Vector2D average(Vector2D v) {
        return this.weightedSum(v, 0.5);
    }

    public Vector2D weightedSum(Vector2D v, double frac) {
        return Vector2D$.MODULE$.create(frac * this.x() + (1.0 - frac) * v.x(), frac * this.y() + (1.0 - frac) * v.y());
    }

    public double distance(Vector2D v) {
        double delx = v.x() - this.x();
        double dely = v.y() - this.y();
        return Math.sqrt(delx * delx + dely * dely);
    }

    public double dot(Vector2D v) {
        return this.x() * v.x() + this.y() * v.y();
    }

    public double angle() {
        return Math.atan2(this.y(), this.x());
    }

    public double angle(Vector2D v) {
        return Angle$.MODULE$.diff(v.angle(), this.angle());
    }

    public double angleTo(Vector2D v) {
        double a1 = this.angle();
        double a2 = v.angle();
        double angDel = a2 - a1;
        if (angDel <= -Math.PI) {
            return angDel + Angle$.MODULE$.PI_TIMES_2();
        }
        if (angDel > Math.PI) {
            return angDel - Angle$.MODULE$.PI_TIMES_2();
        }
        return angDel;
    }

    public Vector2D rotate(double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        return Vector2D$.MODULE$.create(this.x() * cos - this.y() * sin, this.x() * sin + this.y() * cos);
    }

    public Vector2D rotateByQuarterCircle(int numQuarters) {
        int nQuad = numQuarters % 4;
        if (numQuarters < 0 && nQuad != 0) {
            nQuad += 4;
        }
        int n = nQuad;
        switch (n) {
            case 0: {
                return Vector2D$.MODULE$.create(this.x(), this.y());
            }
            case 1: {
                return Vector2D$.MODULE$.create(-this.y(), this.x());
            }
            case 2: {
                return Vector2D$.MODULE$.create(-this.x(), -this.y());
            }
            case 3: {
                return Vector2D$.MODULE$.create(this.y(), -this.x());
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public boolean isParallel(Vector2D v) {
        return 0.0 == (double)CGAlgorithmsDD$.MODULE$.signOfDet2x2(this.x(), this.y(), v.x(), v.y());
    }

    public Coordinate translate(Coordinate coord) {
        return new Coordinate(this.x() + coord.x(), this.y() + coord.y());
    }

    public Coordinate toCoordinate() {
        return new Coordinate(this.x(), this.y());
    }

    public Vector2D clone() {
        return new Vector2D(this);
    }

    public String toString() {
        return new StringBuilder(4).append("[").append(this.x()).append(", ").append(this.y()).append("]").toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector2D)) {
            return false;
        }
        Vector2D v = (Vector2D)o;
        return this.x() == v.x() && this.y() == v.y();
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = 17;
        result = 37 * result + Coordinate$.MODULE$.hashCode(this.x());
        result = 37 * result + Coordinate$.MODULE$.hashCode(this.y());
        return (int)var1_1;
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D(Vector2D v) {
        this(v.x(), v.y());
    }

    public Vector2D(Coordinate from, Coordinate to) {
        this(to.x() - from.x(), to.y() - from.y());
    }

    public Vector2D(Coordinate v) {
        this(v.x(), v.y());
    }
}

