/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentNode;
import org.locationtech.jts.util.Assert$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001B\u000b\u0017\u0001}A\u0001B\n\u0001\u0003\u0002\u0004%\ta\n\u0005\tY\u0001\u0011\t\u0019!C\u0001[!A1\u0007\u0001B\u0001B\u0003&\u0001\u0006C\u00035\u0001\u0011\u0005Q\u0007C\u00049\u0001\t\u0007I\u0011B\u001d\t\r\u0015\u0003\u0001\u0015!\u0003;\u0011\u00151\u0005\u0001\"\u0001(\u0011\u00159\u0005\u0001\"\u0001I\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0011\u0015!\u0007\u0001\"\u0003f\u0011\u0015Y\u0007\u0001\"\u0003m\u0011\u0015q\u0007\u0001\"\u0003p\u0011\u0015a\b\u0001\"\u0001~\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013Aq!a\u0004\u0001\t\u0013\t\t\u0002C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !9\u0011q\u0006\u0001\u0005\u0002\u0005E\"aD*fO6,g\u000e\u001e(pI\u0016d\u0015n\u001d;\u000b\u0005]A\u0012A\u00028pI&twM\u0003\u0002\u001a5\u0005\u0019!\u000e^:\u000b\u0005ma\u0012\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g-\u0001\u0003fI\u001e,W#\u0001\u0015\u0011\u0005%RS\"\u0001\f\n\u0005-2\"A\u0005(pI\u0016$7+Z4nK:$8\u000b\u001e:j]\u001e\f\u0001\"\u001a3hK~#S-\u001d\u000b\u0003]E\u0002\"!I\u0018\n\u0005A\u0012#\u0001B+oSRDqA\r\u0002\u0002\u0002\u0003\u0007\u0001&A\u0002yIE\nQ!\u001a3hK\u0002\na\u0001P5oSRtDC\u0001\u001c8!\tI\u0003\u0001C\u0003'\t\u0001\u0007\u0001&A\u0004o_\u0012,W*\u00199\u0016\u0003i\u0002Ba\u000f!C\u00056\tAH\u0003\u0002>}\u00059Q.\u001e;bE2,'BA #\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0003r\u0012q\u0001\u0016:fK6\u000b\u0007\u000f\u0005\u0002*\u0007&\u0011AI\u0006\u0002\f'\u0016<W.\u001a8u\u001d>$W-\u0001\u0005o_\u0012,W*\u00199!\u0003\u001d9W\r^#eO\u0016\f1!\u00193e)\r\u0011\u0015*\u0015\u0005\u0006\u0015\"\u0001\raS\u0001\u0006S:$\b\u000b\u001e\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001db\tAaZ3p[&\u0011\u0001+\u0014\u0002\u000b\u0007>|'\u000fZ5oCR,\u0007\"\u0002*\t\u0001\u0004\u0019\u0016\u0001D:fO6,g\u000e^%oI\u0016D\bCA\u0011U\u0013\t)&EA\u0002J]R\f\u0001\"\u001b;fe\u0006$xN]\u000b\u00021B\u0019\u0011L\u0018\"\u000e\u0003iS!a\u0017/\u0002\tU$\u0018\u000e\u001c\u0006\u0002;\u0006!!.\u0019<b\u0013\ty&L\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u00031\tG\rZ#oIB|\u0017N\u001c;t)\u0005\u0011\u0015!E1eI\u000e{G\u000e\\1qg\u0016$gj\u001c3fgR\ta&A\u0011gS:$7i\u001c7mCB\u001cXm\u001d$s_6,\u00050[:uS:<g+\u001a:uS\u000e,7\u000f\u0006\u0002/M\")q\r\u0004a\u0001Q\u000612m\u001c7mCB\u001cX\r\u001a,feR,\u00070\u00138eKb,7\u000fE\u0002ZSNK!A\u001b.\u0003\t1K7\u000f^\u0001\u001fM&tGmQ8mY\u0006\u00048/Z:Ge>l\u0017J\\:feR,GMT8eKN$\"AL7\t\u000b\u001dl\u0001\u0019\u00015\u0002#\u0019Lg\u000eZ\"pY2\f\u0007o]3J]\u0012,\u0007\u0010\u0006\u0003qgV<\bCA\u0011r\u0013\t\u0011(EA\u0004C_>dW-\u00198\t\u000bQt\u0001\u0019\u0001\"\u0002\u0007\u0015L\u0007\u0007C\u0003w\u001d\u0001\u0007!)A\u0002fSFBQ\u0001\u001f\bA\u0002e\fAcY8mY\u0006\u00048/\u001a3WKJ$X\r_%oI\u0016D\bcA\u0011{'&\u00111P\t\u0002\u0006\u0003J\u0014\u0018-_\u0001\u000eC\u0012$7\u000b\u001d7ji\u0016#w-Z:\u0015\u00059r\bBB@\u0010\u0001\u0004\t\t!\u0001\u0005fI\u001e,G*[:u!\u0011I\u00161\u0001\u0015\n\u0007\u0005\u0015!L\u0001\u0006D_2dWm\u0019;j_:\fqb\u0019:fCR,7\u000b\u001d7ji\u0016#w-\u001a\u000b\u0006Q\u0005-\u0011Q\u0002\u0005\u0006iB\u0001\rA\u0011\u0005\u0006mB\u0001\rAQ\u0001\u0013GJ,\u0017\r^3Ta2LG/\u00123hKB#8\u000f\u0006\u0004\u0002\u0014\u0005U\u0011q\u0003\t\u0004Ci\\\u0005\"\u0002;\u0012\u0001\u0004\u0011\u0005\"\u0002<\u0012\u0001\u0004\u0011\u0015aE4fiN\u0003H.\u001b;D_>\u0014H-\u001b8bi\u0016\u001cXCAA\n\u0003I\tG\rZ#eO\u0016\u001cun\u001c:eS:\fG/Z:\u0015\u000fA\f\t#a\t\u0002&!)Ao\u0005a\u0001\u0005\")ao\u0005a\u0001\u0005\"9\u0011qE\nA\u0002\u0005%\u0012!C2p_J$G*[:u!\ra\u00151F\u0005\u0004\u0003[i%AD\"p_J$\u0017N\\1uK2K7\u000f^\u0001\u0006aJLg\u000e\u001e\u000b\u0004]\u0005M\u0002bBA\u001b)\u0001\u0007\u0011qG\u0001\u0004_V$\b\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005uB,\u0001\u0002j_&!\u0011\u0011IA\u001e\u0005-\u0001&/\u001b8u'R\u0014X-Y7")
public class SegmentNodeList {
    private NodedSegmentString edge;
    private final TreeMap<SegmentNode, SegmentNode> nodeMap;
    private volatile boolean bitmap$init$0;

    public NodedSegmentString edge() {
        return this.edge;
    }

    public void edge_$eq(NodedSegmentString x$1) {
        this.edge = x$1;
    }

    private TreeMap<SegmentNode, SegmentNode> nodeMap() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/SegmentNodeList.scala: 40");
        }
        return this.nodeMap;
    }

    public NodedSegmentString getEdge() {
        return this.edge();
    }

    /*
     * WARNING - void declaration
     */
    public SegmentNode add(Coordinate intPt, int segmentIndex) {
        void var3_3;
        SegmentNode eiNew = new SegmentNode(this.edge(), intPt, segmentIndex, this.edge().getSegmentOctant(segmentIndex));
        SegmentNode ei = (SegmentNode)this.nodeMap().get((Object)eiNew).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (ei != null) {
            Assert$.MODULE$.isTrue(ei.coord().equals2D(intPt), "Found equal nodes with different coordinates");
            return ei;
        }
        this.nodeMap().put((Object)eiNew, (Object)eiNew);
        return var3_3;
    }

    public Iterator<SegmentNode> iterator() {
        return CollectionConverters$.MODULE$.IteratorHasAsJava(this.nodeMap().values().iterator()).asJava();
    }

    private SegmentNode addEndpoints() {
        int maxSegIndex = this.edge().size() - 1;
        this.add(this.edge().getCoordinate(0), 0);
        return this.add(this.edge().getCoordinate(maxSegIndex), maxSegIndex);
    }

    private void addCollapsedNodes() {
        ArrayList<Object> collapsedVertexIndexes = new ArrayList<Object>();
        this.findCollapsesFromInsertedNodes(collapsedVertexIndexes);
        this.findCollapsesFromExistingVertices(collapsedVertexIndexes);
        Iterator<Object> it = collapsedVertexIndexes.iterator();
        while (it.hasNext()) {
            int vertexIndex = (Integer)it.next();
            this.add(this.edge().getCoordinate(vertexIndex), vertexIndex);
        }
    }

    private void findCollapsesFromExistingVertices(List<Object> collapsedVertexIndexes) {
        for (int i = 0; i < this.edge().size() - 2; ++i) {
            Coordinate p2;
            Coordinate p0 = this.edge().getCoordinate(i);
            Object object = p0.equals2D(p2 = this.edge().getCoordinate(i + 2)) ? BoxesRunTime.boxToBoolean((boolean)collapsedVertexIndexes.add(BoxesRunTime.boxToInteger((int)(i + 1)))) : BoxedUnit.UNIT;
        }
    }

    private void findCollapsesFromInsertedNodes(List<Object> collapsedVertexIndexes) {
        int[] collapsedVertexIndex = new int[1];
        Iterator<SegmentNode> it = this.iterator();
        SegmentNode eiPrev = it.next();
        while (it.hasNext()) {
            SegmentNode ei = it.next();
            boolean isCollapsed = this.findCollapseIndex(eiPrev, ei, collapsedVertexIndex);
            Object object = isCollapsed ? BoxesRunTime.boxToBoolean((boolean)collapsedVertexIndexes.add(BoxesRunTime.boxToInteger((int)collapsedVertexIndex[0]))) : BoxedUnit.UNIT;
            eiPrev = ei;
        }
    }

    private boolean findCollapseIndex(SegmentNode ei0, SegmentNode ei1, int[] collapsedVertexIndex) {
        if (!ei0.coord().equals2D(ei1.coord())) {
            return false;
        }
        int numVerticesBetween = ei1.segmentIndex() - ei0.segmentIndex();
        if (!ei1.isInterior()) {
            --numVerticesBetween;
        }
        if (numVerticesBetween == 1) {
            collapsedVertexIndex[0] = ei0.segmentIndex() + 1;
            return true;
        }
        return false;
    }

    public void addSplitEdges(Collection<NodedSegmentString> edgeList) {
        this.addEndpoints();
        this.addCollapsedNodes();
        Iterator<SegmentNode> it = this.iterator();
        SegmentNode eiPrev = it.next();
        while (it.hasNext()) {
            SegmentNode ei = it.next();
            NodedSegmentString newEdge = this.createSplitEdge(eiPrev, ei);
            edgeList.add(newEdge);
            eiPrev = ei;
        }
    }

    private NodedSegmentString createSplitEdge(SegmentNode ei0, SegmentNode ei1) {
        Coordinate[] pts = this.createSplitEdgePts(ei0, ei1);
        return new NodedSegmentString(pts, this.edge().getData());
    }

    private Coordinate[] createSplitEdgePts(SegmentNode ei0, SegmentNode ei1) {
        Coordinate[] pts;
        block3: {
            boolean useIntPt1;
            int npts = ei1.segmentIndex() - ei0.segmentIndex() + 2;
            if (npts == 2) {
                return (Coordinate[])((Object[])new Coordinate[]{new Coordinate(ei0.coord()), new Coordinate(ei1.coord())});
            }
            Coordinate lastSegStartPt = this.edge().getCoordinate(ei1.segmentIndex());
            boolean bl = useIntPt1 = ei1.isInterior() || !ei1.coord().equals2D(lastSegStartPt);
            if (!useIntPt1) {
                --npts;
            }
            pts = new Coordinate[npts];
            int ipt = 0;
            pts[++ipt - 1] = new Coordinate(ei0.coord());
            for (int i = ei0.segmentIndex() + 1; i <= ei1.segmentIndex(); ++i) {
                pts[++ipt - 1] = this.edge().getCoordinate(i);
            }
            if (!useIntPt1) break block3;
            pts[ipt] = new Coordinate(ei1.coord());
        }
        return pts;
    }

    public Coordinate[] getSplitCoordinates() {
        CoordinateList coordList = new CoordinateList((Coordinate[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Coordinate.class)));
        this.addEndpoints();
        Iterator<SegmentNode> it = this.iterator();
        SegmentNode eiPrev = it.next();
        while (it.hasNext()) {
            SegmentNode ei = it.next();
            this.addEdgeCoordinates(eiPrev, ei, coordList);
            eiPrev = ei;
        }
        return coordList.toCoordinateArray();
    }

    private boolean addEdgeCoordinates(SegmentNode ei0, SegmentNode ei1, CoordinateList coordList) {
        Coordinate[] pts = this.createSplitEdgePts(ei0, ei1);
        return coordList.add(pts, false);
    }

    public void print(PrintStream out) {
        out.println("Intersections:");
        Iterator<SegmentNode> it = this.iterator();
        while (it.hasNext()) {
            SegmentNode ei = it.next();
            ei.print(out);
        }
    }

    public SegmentNodeList(NodedSegmentString edge) {
        this.edge = edge;
        this.nodeMap = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.bitmap$init$0 = true;
    }
}

