/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snaprounder;

import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.snaprounder.HotPixel$;
import org.locationtech.jts.util.Assert$;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dv!\u0002\u001a4\u0011\u0003qd!\u0002!4\u0011\u0003\t\u0005\"\u0002%\u0002\t\u0003I\u0005b\u0002&\u0002\u0005\u0004%Ia\u0013\u0005\u0007\u001f\u0006\u0001\u000b\u0011\u0002'\u0007\t\u0001\u001b\u0004\u0001\u0015\u0005\t#\u0016\u0011\t\u0019!C\u0001%\"A\u0011,\u0002BA\u0002\u0013\u0005!\f\u0003\u0005a\u000b\t\u0005\t\u0015)\u0003T\u0011!\tWA!a\u0001\n\u0003Y\u0005\u0002\u00032\u0006\u0005\u0003\u0007I\u0011A2\t\u0011\u0015,!\u0011!Q!\n1C\u0001BZ\u0003\u0003\u0002\u0004%\ta\u001a\u0005\t]\u0016\u0011\t\u0019!C\u0001_\"A\u0011/\u0002B\u0001B\u0003&\u0001\u000eC\u0003I\u000b\u0011\u0005!\u000fC\u0004x\u000b\u0001\u0007I\u0011\u0002*\t\u000fa,\u0001\u0019!C\u0005s\"110\u0002Q!\nMCq\u0001`\u0003A\u0002\u0013%!\u000bC\u0004~\u000b\u0001\u0007I\u0011\u0002@\t\u000f\u0005\u0005Q\u0001)Q\u0005'\"A\u00111A\u0003C\u0002\u0013%!\u000bC\u0004\u0002\u0006\u0015\u0001\u000b\u0011B*\t\u0011\u0005\u001dQ\u00011A\u0005\n-C\u0011\"!\u0003\u0006\u0001\u0004%I!a\u0003\t\u000f\u0005=Q\u0001)Q\u0005\u0019\"A\u0011\u0011C\u0003A\u0002\u0013%1\nC\u0005\u0002\u0014\u0015\u0001\r\u0011\"\u0003\u0002\u0016!9\u0011\u0011D\u0003!B\u0013a\u0005\u0002CA\u000e\u000b\u0001\u0007I\u0011B&\t\u0013\u0005uQ\u00011A\u0005\n\u0005}\u0001bBA\u0012\u000b\u0001\u0006K\u0001\u0014\u0005\t\u0003K)\u0001\u0019!C\u0005\u0017\"I\u0011qE\u0003A\u0002\u0013%\u0011\u0011\u0006\u0005\b\u0003[)\u0001\u0015)\u0003M\u0011%\ty#\u0002b\u0001\n\u0013\t\t\u0004\u0003\u0005\u0002:\u0015\u0001\u000b\u0011BA\u001a\u0011%\tY$\u0002a\u0001\n\u0013\ti\u0004C\u0005\u0002F\u0015\u0001\r\u0011\"\u0003\u0002H!A\u00111J\u0003!B\u0013\ty\u0004\u0003\u0004\u0002N\u0015!\tA\u0015\u0005\b\u0003\u001f*A\u0011AA\u001f\u0011\u001d\t\t&\u0002C\u0005\u0003'Bq!a\u0016\u0006\t\u0013\tI\u0006C\u0004\u0002`\u0015!\t!!\u0019\t\u000f\u0005ET\u0001\"\u0003\u0002t!9\u0011QP\u0003\u0005\n\u0005}\u0004bBAC\u000b\u0011%\u0011q\u0011\u0005\b\u0003\u001b+A\u0011AAH\u0003!Au\u000e\u001e)jq\u0016d'B\u0001\u001b6\u0003-\u0019h.\u00199s_VtG-\u001a:\u000b\u0005Y:\u0014A\u00028pI&twM\u0003\u00029s\u0005\u0019!\u000e^:\u000b\u0005iZ\u0014\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u001f\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005}\nQ\"A\u001a\u0003\u0011!{G\u000fU5yK2\u001c\"!\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta(A\rT\u0003\u001a+u,\u0012(W?\u0016C\u0006+\u0011(T\u0013>suLR!D)>\u0013V#\u0001'\u0011\u0005\rk\u0015B\u0001(E\u0005\u0019!u.\u001e2mK\u0006Q2+\u0011$F?\u0016sekX#Y!\u0006s5+S(O?\u001a\u000b5\tV(SAM\u0011QAQ\u0001\u000b_JLw-\u001b8bYB#X#A*\u0011\u0005Q;V\"A+\u000b\u0005Y;\u0014\u0001B4f_6L!\u0001W+\u0003\u0015\r{wN\u001d3j]\u0006$X-\u0001\bpe&<\u0017N\\1m!R|F%Z9\u0015\u0005ms\u0006CA\"]\u0013\tiFI\u0001\u0003V]&$\bbB0\b\u0003\u0003\u0005\raU\u0001\u0004q\u0012\n\u0014aC8sS\u001eLg.\u00197Qi\u0002\n1b]2bY\u00164\u0015m\u0019;pe\u0006y1oY1mK\u001a\u000b7\r^8s?\u0012*\u0017\u000f\u0006\u0002\\I\"9qLCA\u0001\u0002\u0004a\u0015\u0001D:dC2,g)Y2u_J\u0004\u0013A\u00017j+\u0005A\u0007CA5m\u001b\u0005Q'BA68\u0003%\tGnZ8sSRDW.\u0003\u0002nU\nyA*\u001b8f\u0013:$XM]:fGR|'/\u0001\u0004mS~#S-\u001d\u000b\u00037BDqaX\u0007\u0002\u0002\u0003\u0007\u0001.A\u0002mS\u0002\"Ba\u001d;vmB\u0011q(\u0002\u0005\u0006#>\u0001\ra\u0015\u0005\u0006C>\u0001\r\u0001\u0014\u0005\u0006M>\u0001\r\u0001[\u0001\taB\u001a6-\u00197fI\u0006a\u0001\u000fM*dC2,Gm\u0018\u0013fcR\u00111L\u001f\u0005\b?F\t\t\u00111\u0001T\u0003%\u0001\bgU2bY\u0016$\u0007%\u0001\u0005qcM\u001b\u0017\r\\3e\u00031\u0001\u0018gU2bY\u0016$w\fJ3r)\tYv\u0010C\u0004`)\u0005\u0005\t\u0019A*\u0002\u0013A\f4kY1mK\u0012\u0004\u0013A\u00019u\u0003\r\u0001H\u000fI\u0001\u0005[&t\u00070\u0001\u0005nS:Dx\fJ3r)\rY\u0016Q\u0002\u0005\b?f\t\t\u00111\u0001M\u0003\u0015i\u0017N\u001c=!\u0003\u0011i\u0017\r\u001f=\u0002\u00115\f\u0007\u0010_0%KF$2aWA\f\u0011\u001dyF$!AA\u00021\u000bQ!\\1yq\u0002\nA!\\5os\u0006AQ.\u001b8z?\u0012*\u0017\u000fF\u0002\\\u0003CAqaX\u0010\u0002\u0002\u0003\u0007A*A\u0003nS:L\b%\u0001\u0003nCbL\u0018\u0001C7bqf|F%Z9\u0015\u0007m\u000bY\u0003C\u0004`E\u0005\u0005\t\u0019\u0001'\u0002\u000b5\f\u00070\u001f\u0011\u0002\r\r|'O\\3s+\t\t\u0019\u0004\u0005\u0003D\u0003k\u0019\u0016bAA\u001c\t\n)\u0011I\u001d:bs\u000691m\u001c:oKJ\u0004\u0013aB:bM\u0016,eN^\u000b\u0003\u0003\u007f\u00012\u0001VA!\u0013\r\t\u0019%\u0016\u0002\t\u000b:4X\r\\8qK\u0006Y1/\u00194f\u000b:4x\fJ3r)\rY\u0016\u0011\n\u0005\t?\u001e\n\t\u00111\u0001\u0002@\u0005A1/\u00194f\u000b:4\b%A\u0007hKR\u001cun\u001c:eS:\fG/Z\u0001\u0010O\u0016$8+\u00194f\u000b:4X\r\\8qK\u0006Y\u0011N\\5u\u0007>\u0014h.\u001a:t)\rY\u0016Q\u000b\u0005\u0007\u0003\u0007Y\u0003\u0019A*\u0002\u000bM\u001c\u0017\r\\3\u0015\u00071\u000bY\u0006\u0003\u0004\u0002^1\u0002\r\u0001T\u0001\u0004m\u0006d\u0017AC5oi\u0016\u00148/Z2ugR1\u00111MA5\u0003[\u00022aQA3\u0013\r\t9\u0007\u0012\u0002\b\u0005>|G.Z1o\u0011\u0019\tY'\fa\u0001'\u0006\u0011\u0001\u000f\r\u0005\u0007\u0003_j\u0003\u0019A*\u0002\u0005A\f\u0014AC2paf\u001c6-\u00197fIR)1,!\u001e\u0002z!1\u0011q\u000f\u0018A\u0002M\u000b\u0011\u0001\u001d\u0005\u0007\u0003wr\u0003\u0019A*\u0002\u000fA\u001c6-\u00197fI\u0006\u0001\u0012N\u001c;feN,7\r^:TG\u0006dW\r\u001a\u000b\u0007\u0003G\n\t)a!\t\r\u0005-t\u00061\u0001T\u0011\u0019\tyg\fa\u0001'\u0006I\u0012N\u001c;feN,7\r^:U_2,'/\u00198dKN\u000bX/\u0019:f)\u0019\t\u0019'!#\u0002\f\"1\u00111\u000e\u0019A\u0002MCa!a\u001c1\u0001\u0004\u0019\u0016AD1eINs\u0017\r\u001d9fI:{G-\u001a\u000b\u0007\u0003G\n\t*!(\t\u000f\u0005M\u0015\u00071\u0001\u0002\u0016\u000611/Z4TiJ\u0004B!a&\u0002\u001a6\tQ'C\u0002\u0002\u001cV\u0012!CT8eK\u0012\u001cVmZ7f]R\u001cFO]5oO\"9\u0011qT\u0019A\u0002\u0005\u0005\u0016\u0001C:fO&sG-\u001a=\u0011\u0007\r\u000b\u0019+C\u0002\u0002&\u0012\u00131!\u00138u\u0001")
public class HotPixel {
    private Coordinate originalPt;
    private double scaleFactor;
    private LineIntersector li;
    private Coordinate p0Scaled;
    private Coordinate p1Scaled;
    private final Coordinate pt;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;
    private final Coordinate[] corner;
    private Envelope safeEnv;
    private volatile int bitmap$init$0;

    public Coordinate originalPt() {
        return this.originalPt;
    }

    public void originalPt_$eq(Coordinate x$1) {
        this.originalPt = x$1;
    }

    public double scaleFactor() {
        return this.scaleFactor;
    }

    public void scaleFactor_$eq(double x$1) {
        this.scaleFactor = x$1;
    }

    public LineIntersector li() {
        return this.li;
    }

    public void li_$eq(LineIntersector x$1) {
        this.li = x$1;
    }

    private Coordinate p0Scaled() {
        if ((this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/HotPixel.scala: 56");
        }
        return this.p0Scaled;
    }

    private void p0Scaled_$eq(Coordinate x$1) {
        this.p0Scaled = x$1;
        this.bitmap$init$0 |= 1;
    }

    private Coordinate p1Scaled() {
        if ((this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/HotPixel.scala: 57");
        }
        return this.p1Scaled;
    }

    private void p1Scaled_$eq(Coordinate x$1) {
        this.p1Scaled = x$1;
        this.bitmap$init$0 |= 2;
    }

    private Coordinate pt() {
        if ((this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/HotPixel.scala: 65");
        }
        return this.pt;
    }

    private double minx() {
        if ((this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/HotPixel.scala: 67");
        }
        return this.minx;
    }

    private void minx_$eq(double x$1) {
        this.minx = x$1;
        this.bitmap$init$0 |= 8;
    }

    private double maxx() {
        if ((this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/HotPixel.scala: 68");
        }
        return this.maxx;
    }

    private void maxx_$eq(double x$1) {
        this.maxx = x$1;
        this.bitmap$init$0 |= 0x10;
    }

    private double miny() {
        if ((this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/HotPixel.scala: 69");
        }
        return this.miny;
    }

    private void miny_$eq(double x$1) {
        this.miny = x$1;
        this.bitmap$init$0 |= 0x20;
    }

    private double maxy() {
        if ((this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/HotPixel.scala: 70");
        }
        return this.maxy;
    }

    private void maxy_$eq(double x$1) {
        this.maxy = x$1;
        this.bitmap$init$0 |= 0x40;
    }

    private Coordinate[] corner() {
        if ((this.bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/HotPixel.scala: 76");
        }
        return this.corner;
    }

    private Envelope safeEnv() {
        if ((this.bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/HotPixel.scala: 77");
        }
        return this.safeEnv;
    }

    private void safeEnv_$eq(Envelope x$1) {
        this.safeEnv = x$1;
        this.bitmap$init$0 |= 0x100;
    }

    public Coordinate getCoordinate() {
        return this.originalPt();
    }

    public Envelope getSafeEnvelope() {
        block0: {
            if (this.safeEnv() != null) break block0;
            double safeTolerance = HotPixel$.MODULE$.org$locationtech$jts$noding$snaprounder$HotPixel$$SAFE_ENV_EXPANSION_FACTOR() / this.scaleFactor();
            this.safeEnv_$eq(new Envelope(this.originalPt().x() - safeTolerance, this.originalPt().x() + safeTolerance, this.originalPt().y() - safeTolerance, this.originalPt().y() + safeTolerance));
        }
        return this.safeEnv();
    }

    private void initCorners(Coordinate pt) {
        double tolerance = 0.5;
        this.minx_$eq(pt.x() - tolerance);
        this.maxx_$eq(pt.x() + tolerance);
        this.miny_$eq(pt.y() - tolerance);
        this.maxy_$eq(pt.y() + tolerance);
        this.corner()[0] = new Coordinate(this.maxx(), this.maxy());
        this.corner()[1] = new Coordinate(this.minx(), this.maxy());
        this.corner()[2] = new Coordinate(this.minx(), this.miny());
        this.corner()[3] = new Coordinate(this.maxx(), this.miny());
    }

    private double scale(double val) {
        return val * (double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.scaleFactor()));
    }

    public boolean intersects(Coordinate p0, Coordinate p1) {
        if (this.scaleFactor() == 1.0) {
            return this.intersectsScaled(p0, p1);
        }
        this.copyScaled(p0, this.p0Scaled());
        this.copyScaled(p1, this.p1Scaled());
        return this.intersectsScaled(this.p0Scaled(), this.p1Scaled());
    }

    private void copyScaled(Coordinate p, Coordinate pScaled) {
        pScaled.x_$eq(this.scale(p.x()));
        pScaled.y_$eq(this.scale(p.y()));
    }

    private boolean intersectsScaled(Coordinate p0, Coordinate p1) {
        boolean isOutsidePixelEnv;
        double segMinx = Math.min(p0.x(), p1.x());
        double segMaxx = Math.max(p0.x(), p1.x());
        double segMiny = Math.min(p0.y(), p1.y());
        double segMaxy = Math.max(p0.y(), p1.y());
        boolean bl = isOutsidePixelEnv = this.maxx() < segMinx || this.minx() > segMaxx || this.maxy() < segMiny || this.miny() > segMaxy;
        if (isOutsidePixelEnv) {
            return false;
        }
        boolean intersects = this.intersectsToleranceSquare(p0, p1);
        Assert$.MODULE$.isTrue(!isOutsidePixelEnv || !intersects, "Found bad envelope test");
        return intersects;
    }

    private boolean intersectsToleranceSquare(Coordinate p0, Coordinate p1) {
        boolean intersectsLeft = false;
        boolean intersectsBottom = false;
        this.li().computeIntersection(p0, p1, this.corner()[0], this.corner()[1]);
        if (this.li().isProperF()) {
            return true;
        }
        this.li().computeIntersection(p0, p1, this.corner()[1], this.corner()[2]);
        if (this.li().isProperF()) {
            return true;
        }
        if (this.li().hasIntersection()) {
            intersectsLeft = true;
        }
        this.li().computeIntersection(p0, p1, this.corner()[2], this.corner()[3]);
        if (this.li().isProperF()) {
            return true;
        }
        if (this.li().hasIntersection()) {
            intersectsBottom = true;
        }
        this.li().computeIntersection(p0, p1, this.corner()[3], this.corner()[0]);
        if (this.li().isProperF()) {
            return true;
        }
        if (intersectsLeft && intersectsBottom) {
            return true;
        }
        Coordinate coordinate = p0;
        Coordinate coordinate2 = this.pt();
        if (!(coordinate != null ? !((Object)coordinate).equals(coordinate2) : coordinate2 != null)) {
            return true;
        }
        Coordinate coordinate3 = p1;
        Coordinate coordinate4 = this.pt();
        return !(coordinate3 != null ? !((Object)coordinate3).equals(coordinate4) : coordinate4 != null);
    }

    public boolean addSnappedNode(NodedSegmentString segStr, int segIndex) {
        Coordinate p1;
        Coordinate p0 = segStr.getCoordinate(segIndex);
        if (this.intersects(p0, p1 = segStr.getCoordinate(segIndex + 1))) {
            segStr.addIntersection(this.getCoordinate(), segIndex);
            return true;
        }
        return false;
    }

    public HotPixel(Coordinate originalPt, double scaleFactor, LineIntersector li) {
        this.originalPt = originalPt;
        this.scaleFactor = scaleFactor;
        this.li = li;
        this.p0Scaled = null;
        this.bitmap$init$0 |= 1;
        this.p1Scaled = null;
        this.bitmap$init$0 |= 2;
        if (this.scaleFactor() <= 0.0) {
            throw new IllegalArgumentException("Scale factor must be non-zero");
        }
        if (this.scaleFactor() != 1.0) {
            this.originalPt_$eq(new Coordinate(this.scale(this.originalPt().x()), this.scale(this.originalPt().y())));
            this.p0Scaled_$eq(new Coordinate());
            this.p1Scaled_$eq(new Coordinate());
        }
        this.initCorners(this.originalPt());
        this.pt = this.originalPt();
        this.bitmap$init$0 |= 4;
        this.minx = 0.0;
        this.bitmap$init$0 |= 8;
        this.maxx = 0.0;
        this.bitmap$init$0 |= 0x10;
        this.miny = 0.0;
        this.bitmap$init$0 |= 0x20;
        this.maxy = 0.0;
        this.bitmap$init$0 |= 0x40;
        this.corner = new Coordinate[4];
        this.bitmap$init$0 |= 0x80;
        this.safeEnv = null;
        this.bitmap$init$0 |= 0x100;
    }
}

