/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snaprounder;

import java.util.Collection;
import java.util.List;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.noding.InteriorIntersectionFinderAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.NodedSegmentString$;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.snaprounder.HotPixel;
import org.locationtech.jts.noding.snaprounder.MCIndexPointSnapper;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\r\u001a\u0001\u0011B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\tu\u0001\u0011\t\u0011)A\u0005i!)1\b\u0001C\u0001y!9\u0001\t\u0001b\u0001\n\u0013\t\u0005B\u0002%\u0001A\u0003%!\tC\u0004J\u0001\t\u0007IQ\u0002&\t\r9\u0003\u0001\u0015!\u0004L\u0011\u001dy\u0005\u00011A\u0005\nACq\u0001\u0016\u0001A\u0002\u0013%Q\u000b\u0003\u0004\\\u0001\u0001\u0006K!\u0015\u0005\b9\u0002\u0001\r\u0011\"\u0003^\u0011\u001d\t\u0007\u00011A\u0005\n\tDa\u0001\u001a\u0001!B\u0013q\u0006bB3\u0001\u0001\u0004%IA\u001a\u0005\b_\u0002\u0001\r\u0011\"\u0003q\u0011\u0019\u0011\b\u0001)Q\u0005O\")1\u000f\u0001C!i\")\u0001\u0010\u0001C!s\")A\u0010\u0001C\u0005{\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\r\u0001\u0011%\u00111\u0004\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003W\u0011!#T\"J]\u0012,\u0007p\u00158baJ{WO\u001c3fe*\u0011!dG\u0001\fg:\f\u0007O]8v]\u0012,'O\u0003\u0002\u001d;\u00051an\u001c3j]\u001eT!AH\u0010\u0002\u0007)$8O\u0003\u0002!C\u0005aAn\\2bi&|g\u000e^3dQ*\t!%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001K-\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007c\u0001\u0017._5\t1$\u0003\u0002/7\t)aj\u001c3feB\u0011A\u0006M\u0005\u0003cm\u0011QbU3h[\u0016tGo\u0015;sS:<\u0017A\u00019n+\u0005!\u0004CA\u001b9\u001b\u00051$BA\u001c\u001e\u0003\u00119Wm\\7\n\u0005e2$A\u0004)sK\u000eL7/[8o\u001b>$W\r\\\u0001\u0004a6\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002>\u007fA\u0011a\bA\u0007\u00023!)!g\u0001a\u0001i\u0005\u0011A.[\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q)H\u0001\nC2<wN]5uQ6L!a\u0012#\u0003+I{'-^:u\u0019&tW-\u00138uKJ\u001cXm\u0019;pe\u0006\u0019A.\u001b\u0011\u0002\u0017M\u001c\u0017\r\\3GC\u000e$xN]\u000b\u0002\u0017B\u0011a\u0005T\u0005\u0003\u001b\u001e\u0012a\u0001R8vE2,\u0017\u0001D:dC2,g)Y2u_J\u0004\u0013!\u00028pI\u0016\u0014X#A)\u0011\u00051\u0012\u0016BA*\u001c\u00051i5)\u00138eKbtu\u000eZ3s\u0003%qw\u000eZ3s?\u0012*\u0017\u000f\u0006\u0002W3B\u0011aeV\u0005\u00031\u001e\u0012A!\u00168ji\"9!,CA\u0001\u0002\u0004\t\u0016a\u0001=%c\u00051an\u001c3fe\u0002\nA\u0002]8j]R\u001cf.\u00199qKJ,\u0012A\u0018\t\u0003}}K!\u0001Y\r\u0003'5\u001b\u0015J\u001c3fqB{\u0017N\u001c;T]\u0006\u0004\b/\u001a:\u0002!A|\u0017N\u001c;T]\u0006\u0004\b/\u001a:`I\u0015\fHC\u0001,d\u0011\u001dQF\"!AA\u0002y\u000bQ\u0002]8j]R\u001cf.\u00199qKJ\u0004\u0013a\u00048pI\u0016$7+Z4TiJLgnZ:\u0016\u0003\u001d\u00042\u0001[70\u001b\u0005I'B\u00016l\u0003\u0011)H/\u001b7\u000b\u00031\fAA[1wC&\u0011a.\u001b\u0002\u000b\u0007>dG.Z2uS>t\u0017a\u00058pI\u0016$7+Z4TiJLgnZ:`I\u0015\fHC\u0001,r\u0011\u001dQv\"!AA\u0002\u001d\f\u0001C\\8eK\u0012\u001cVmZ*ue&twm\u001d\u0011\u0002%\u001d,GOT8eK\u0012\u001cVOY:ue&twm]\u000b\u0002kB\u0019\u0001N^\u0018\n\u0005]L'\u0001\u0002'jgR\fAbY8naV$XMT8eKN$\"A\u0016>\t\u000bm\u0014\u0002\u0019A4\u0002'%t\u0007/\u001e;TK\u001elWM\u001c;TiJLgnZ:\u0002\u0013Mt\u0017\r\u001d*pk:$G\u0003\u0002,\u007f\u0003\u0003AQa`\nA\u0002\u001d\f!b]3h'R\u0014\u0018N\\4t\u0011\u0019\u00015\u00031\u0001\u0002\u0004A\u00191)!\u0002\n\u0007\u0005\u001dAIA\bMS:,\u0017J\u001c;feN,7\r^8s\u0003e1\u0017N\u001c3J]R,'/[8s\u0013:$XM]:fGRLwN\\:\u0015\r\u00055\u0011QCA\f!\u0011Ag/a\u0004\u0011\u0007U\n\t\"C\u0002\u0002\u0014Y\u0012!bQ8pe\u0012Lg.\u0019;f\u0011\u0015yH\u00031\u0001h\u0011\u0019\u0001E\u00031\u0001\u0002\u0004\u0005A2m\\7qkR,\u0017J\u001c;feN,7\r^5p]Ns\u0017\r]:\u0015\u0007Y\u000bi\u0002C\u0004\u0002 U\u0001\r!!\t\u0002\u000fMt\u0017\r\u001d)ugB!\u0001.\\A\b\u0003I\u0019w.\u001c9vi\u00164VM\u001d;fqNs\u0017\r]:\u0015\u0007Y\u000b9\u0003\u0003\u0004\u0002*Y\u0001\raZ\u0001\u0006K\u0012<Wm\u001d\u000b\u0004-\u00065\u0002BBA\u0018/\u0001\u0007q&A\u0001f\u0001")
public class MCIndexSnapRounder
implements Noder<SegmentString> {
    private final PrecisionModel pm;
    private final RobustLineIntersector li;
    private final double scaleFactor;
    private MCIndexNoder noder;
    private MCIndexPointSnapper pointSnapper;
    private Collection<SegmentString> nodedSegStrings;
    private volatile byte bitmap$init$0;

    public PrecisionModel pm() {
        return this.pm;
    }

    private RobustLineIntersector li() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/MCIndexSnapRounder.scala: 43");
        }
        return this.li;
    }

    private final double scaleFactor() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/MCIndexSnapRounder.scala: 45");
        }
        return this.scaleFactor;
    }

    private MCIndexNoder noder() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/MCIndexSnapRounder.scala: 46");
        }
        return this.noder;
    }

    private void noder_$eq(MCIndexNoder x$1) {
        this.noder = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    private MCIndexPointSnapper pointSnapper() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/MCIndexSnapRounder.scala: 47");
        }
        return this.pointSnapper;
    }

    private void pointSnapper_$eq(MCIndexPointSnapper x$1) {
        this.pointSnapper = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private Collection<SegmentString> nodedSegStrings() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/noding/snaprounder/MCIndexSnapRounder.scala: 48");
        }
        return this.nodedSegStrings;
    }

    private void nodedSegStrings_$eq(Collection<SegmentString> x$1) {
        this.nodedSegStrings = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    @Override
    public List<SegmentString> getNodedSubstrings() {
        return NodedSegmentString$.MODULE$.getNodedSubstrings(this.nodedSegStrings());
    }

    @Override
    public void computeNodes(Collection<SegmentString> inputSegmentStrings) {
        this.nodedSegStrings_$eq(inputSegmentStrings);
        this.noder_$eq(new MCIndexNoder());
        this.pointSnapper_$eq(new MCIndexPointSnapper(this.noder().getIndex()));
        this.snapRound(inputSegmentStrings, this.li());
    }

    private void snapRound(Collection<SegmentString> segStrings, LineIntersector li) {
        List<Coordinate> intersections = this.findInteriorIntersections(segStrings, li);
        this.computeIntersectionSnaps(intersections);
        this.computeVertexSnaps(segStrings);
    }

    private List<Coordinate> findInteriorIntersections(Collection<SegmentString> segStrings, LineIntersector li) {
        InteriorIntersectionFinderAdder intFinderAdder = new InteriorIntersectionFinderAdder(li);
        this.noder().setSegmentIntersector(intFinderAdder);
        this.noder().computeNodes(segStrings);
        return intFinderAdder.getInteriorIntersections();
    }

    private void computeIntersectionSnaps(Collection<Coordinate> snapPts) {
        for (Coordinate snapPt : snapPts) {
            HotPixel hotPixel = new HotPixel(snapPt, this.scaleFactor(), this.li());
            this.pointSnapper().snap(hotPixel);
        }
    }

    public void computeVertexSnaps(Collection<SegmentString> edges) {
        for (SegmentString edge0 : edges) {
            this.computeVertexSnaps(edge0);
        }
    }

    private void computeVertexSnaps(SegmentString e) {
        Coordinate[] pts0 = e.getCoordinates();
        for (int i = 0; i < pts0.length; ++i) {
            HotPixel hotPixel = new HotPixel(pts0[i], this.scaleFactor(), this.li());
            boolean isNodeAdded = this.pointSnapper().snap(hotPixel, e, i);
            if (!isNodeAdded) continue;
            ((NodedSegmentString)e).addIntersection(pts0[i], i);
        }
    }

    public MCIndexSnapRounder(PrecisionModel pm) {
        this.pm = pm;
        this.li = new RobustLineIntersector();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.li().setPrecisionModel(pm);
        this.scaleFactor = pm.getScale();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.noder = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.pointSnapper = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.nodedSegStrings = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

