/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation;

import java.io.Serializable;
import java.util.ArrayList;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.BoundaryNodeRule$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.Counter;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005}q!B\r\u001b\u0011\u0003\u0019c!B\u0013\u001b\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003\"B\u0018\u0002\t\u0003\u0001\u0004\"B\u0018\u0002\t\u0003Id\u0001B\u0013\u001b\u0001\rC\u0001\u0002N\u0003\u0003\u0002\u0004%\t\u0001\u0012\u0005\t\u000b\u0016\u0011\t\u0019!C\u0001\r\"AA*\u0002B\u0001B\u0003&\u0011\u0007\u0003\u0005=\u000b\t\u0005\r\u0011\"\u0001N\u0011!qUA!a\u0001\n\u0003y\u0005\u0002C)\u0006\u0005\u0003\u0005\u000b\u0015B\u001f\t\u000b5*A\u0011\u0001*\t\u000fY+!\u0019!C\u0005/\"11,\u0002Q\u0001\naCQ!L\u0003\u0005\u0002qCQaL\u0003\u0005\u0002\u0011CQAX\u0003\u0005\n}CQaY\u0003\u0005\n\u0011DqA[\u0003A\u0002\u0013%1\u000eC\u0004{\u000b\u0001\u0007I\u0011B>\t\ru,\u0001\u0015)\u0003m\u0011\u0015qX\u0001\"\u0003\u0000\u0011\u001d\tI!\u0002C\u0005\u0003\u0017Aq!!\u0005\u0006\t\u0013\t\u0019\"\u0001\u0006C_VtG-\u0019:z\u001fBT!a\u0007\u000f\u0002\u0013=\u0004XM]1uS>t'BA\u000f\u001f\u0003\rQGo\u001d\u0006\u0003?\u0001\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011!I\u0001\u0004_J<7\u0001\u0001\t\u0003I\u0005i\u0011A\u0007\u0002\u000b\u0005>,h\u000eZ1ss>\u00038CA\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aI\u0001\fO\u0016$(i\\;oI\u0006\u0014\u0018\u0010\u0006\u00022oA\u0011!'N\u0007\u0002g)\u0011A\u0007H\u0001\u0005O\u0016|W.\u0003\u00027g\tAq)Z8nKR\u0014\u0018\u0010C\u00039\u0007\u0001\u0007\u0011'A\u0001h)\r\t$h\u000f\u0005\u0006q\u0011\u0001\r!\r\u0005\u0006y\u0011\u0001\r!P\u0001\u0007E:\u0014V\u000f\\3\u0011\u0005y\nU\"A \u000b\u0005\u0001c\u0012!C1mO>\u0014\u0018\u000e\u001e5n\u0013\t\u0011uH\u0001\tC_VtG-\u0019:z\u001d>$WMU;mKN\u0011QaJ\u000b\u0002c\u0005Aq-Z8n?\u0012*\u0017\u000f\u0006\u0002H\u0015B\u0011\u0001\u0006S\u0005\u0003\u0013&\u0012A!\u00168ji\"91jBA\u0001\u0002\u0004\t\u0014a\u0001=%c\u0005)q-Z8nAU\tQ(\u0001\u0006c]J+H.Z0%KF$\"a\u0012)\t\u000f-S\u0011\u0011!a\u0001{\u00059!M\u001c*vY\u0016\u0004CcA*U+B\u0011A%\u0002\u0005\u0006i1\u0001\r!\r\u0005\u0006y1\u0001\r!P\u0001\tO\u0016|WNR1diV\t\u0001\f\u0005\u000233&\u0011!l\r\u0002\u0010\u000f\u0016|W.\u001a;ss\u001a\u000b7\r^8ss\u0006Iq-Z8n\r\u0006\u001cG\u000f\t\u000b\u0003'vCQ\u0001N\bA\u0002E\n!cZ3u\u000b6\u0004H/_'vYRL\u0007k\\5oiV\t\u0001\r\u0005\u00023C&\u0011!m\r\u0002\u000b\u001bVdG/\u001b)pS:$\u0018a\u00062pk:$\u0017M]=Nk2$\u0018\u000eT5oKN#(/\u001b8h)\t\tT\rC\u0003g%\u0001\u0007q-A\u0003n\u0019&tW\r\u0005\u00023Q&\u0011\u0011n\r\u0002\u0010\u001bVdG/\u001b'j]\u0016\u001cFO]5oO\u0006YQM\u001c3q_&tG/T1q+\u0005a\u0007\u0003B7si^l\u0011A\u001c\u0006\u0003_B\fq!\\;uC\ndWM\u0003\u0002rS\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Mt'a\u0002+sK\u0016l\u0015\r\u001d\t\u0003eUL!A^\u001a\u0003\u0015\r{wN\u001d3j]\u0006$X\r\u0005\u0002%q&\u0011\u0011P\u0007\u0002\b\u0007>,h\u000e^3s\u0003=)g\u000e\u001a9pS:$X*\u00199`I\u0015\fHCA$}\u0011\u001dYE#!AA\u00021\fA\"\u001a8ea>Lg\u000e^'ba\u0002\n!dY8naV$XMQ8v]\u0012\f'/_\"p_J$\u0017N\\1uKN$B!!\u0001\u0002\bA!\u0001&a\u0001u\u0013\r\t)!\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006MZ\u0001\raZ\u0001\fC\u0012$WI\u001c3q_&tG\u000fF\u0002H\u0003\u001bAa!a\u0004\u0018\u0001\u0004!\u0018A\u00019u\u0003I\u0011w.\u001e8eCJLH*\u001b8f'R\u0014\u0018N\\4\u0015\u0007E\n)\u0002C\u0004\u0002\u0018a\u0001\r!!\u0007\u0002\t1Lg.\u001a\t\u0004e\u0005m\u0011bAA\u000fg\tQA*\u001b8f'R\u0014\u0018N\\4")
public class BoundaryOp {
    private Geometry geom;
    private BoundaryNodeRule bnRule;
    private final GeometryFactory geomFact;
    private TreeMap<Coordinate, Counter> endpointMap;
    private volatile byte bitmap$init$0;

    public Geometry geom() {
        return this.geom;
    }

    public void geom_$eq(Geometry x$1) {
        this.geom = x$1;
    }

    public BoundaryNodeRule bnRule() {
        return this.bnRule;
    }

    public void bnRule_$eq(BoundaryNodeRule x$1) {
        this.bnRule = x$1;
    }

    private GeometryFactory geomFact() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/BoundaryOp.scala: 81");
        }
        return this.geomFact;
    }

    public Geometry getBoundary() {
        Geometry geometry;
        Geometry geometry2 = this.geom();
        if (geometry2 instanceof LineString) {
            LineString lineString = (LineString)geometry2;
            geometry = this.boundaryLineString(lineString);
        } else if (geometry2 instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry2;
            geometry = this.boundaryMultiLineString(multiLineString);
        } else {
            geometry = this.geom().getBoundary();
        }
        return geometry;
    }

    private MultiPoint getEmptyMultiPoint() {
        return this.geomFact().createMultiPoint();
    }

    private Geometry boundaryMultiLineString(MultiLineString mLine) {
        if (this.geom().isEmpty()) {
            return this.getEmptyMultiPoint();
        }
        Coordinate[] bdyPts = this.computeBoundaryCoordinates(mLine);
        if (bdyPts.length == 1) {
            return this.geomFact().createPoint(bdyPts[0]);
        }
        return this.geomFact().createMultiPointFromCoords(bdyPts);
    }

    private TreeMap<Coordinate, Counter> endpointMap() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/BoundaryOp.scala: 116");
        }
        return this.endpointMap;
    }

    private void endpointMap_$eq(TreeMap<Coordinate, Counter> x$1) {
        this.endpointMap = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private Coordinate[] computeBoundaryCoordinates(MultiLineString mLine) {
        ArrayList bdyPts = new ArrayList();
        this.endpointMap_$eq((TreeMap<Coordinate, Counter>)TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        int i = 0;
        while (i < mLine.getNumGeometries()) {
            LineString line = (LineString)mLine.getGeometryN(i);
            if (line.getNumPoints() == 0) continue;
            this.addEndpoint(line.getCoordinateN(0));
            this.addEndpoint(line.getCoordinateN(line.getNumPoints() - 1));
            ++i;
        }
        this.endpointMap().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Coordinate k = (Coordinate)tuple2._1();
            Counter v = (Counter)tuple2._2();
            int valence = v.count();
            BoxedUnit boxedUnit = this.bnRule().isInBoundary(valence) ? BoxesRunTime.boxToBoolean((boolean)bdyPts.add(k)) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        return CoordinateArrays$.MODULE$.toCoordinateArray(bdyPts);
    }

    private void addEndpoint(Coordinate pt) {
        BoxedUnit boxedUnit;
        Counter counter = (Counter)this.endpointMap().get((Object)pt).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (counter == null) {
            counter = new Counter();
            boxedUnit = this.endpointMap().put((Object)pt, (Object)counter);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Counter counter2 = counter;
        counter2.count_$eq(counter2.count() + 1);
    }

    private Geometry boundaryLineString(LineString line) {
        if (this.geom().isEmpty()) {
            return this.getEmptyMultiPoint();
        }
        if (line.isClosed()) {
            boolean closedEndpointOnBoundary = this.bnRule().isInBoundary(2);
            if (closedEndpointOnBoundary) {
                return line.getStartPoint();
            }
            return this.geomFact().createMultiPoint();
        }
        return this.geomFact().createMultiPoint((Point[])((Object[])new Point[]{line.getStartPoint(), line.getEndPoint()}));
    }

    public BoundaryOp(Geometry geom, BoundaryNodeRule bnRule) {
        this.geom = geom;
        this.bnRule = bnRule;
        this.geomFact = this.geom().getFactory();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.endpointMap = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public BoundaryOp(Geometry geom) {
        this(geom, BoundaryNodeRule$.MODULE$.MOD2_BOUNDARY_RULE());
    }
}

