/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.util.LinearComponentExtracter$;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;
import scala.;
import scala.$less$colon$less$;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.mutable.Map;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001du!B\u0014)\u0011\u0003\td!B\u001a)\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003ad\u0001B\u001f\u0002\tyB\u0001bP\u0002\u0003\u0002\u0004%\t\u0001\u0011\u0005\t\u000f\u000e\u0011\t\u0019!C\u0001\u0011\"Aaj\u0001B\u0001B\u0003&\u0011\tC\u0003<\u0007\u0011\u0005q\n\u0003\u0005T\u0007\u0001\u0007I\u0011\u0001\u0015U\u0011!A6\u00011A\u0005\u0002!J\u0006BB.\u0004A\u0003&Q\u000b\u0003\u0005]\u0007\u0001\u0007I\u0011\u0001\u0015^\u0011!\t7\u00011A\u0005\u0002!\u0012\u0007B\u00023\u0004A\u0003&a\fC\u0003f\u0007\u0011\u0005\u0001\tC\u0003g\u0007\u0011\u0005qM\u0002\u00034Q\u0001I\u0007\u0002\u00036\u0011\u0005\u0003\u0005\u000b\u0011B6\t\u000bm\u0002B\u0011\u00018\t\u000fE\u0004\u0002\u0019!C\u0005)\"9!\u000f\u0005a\u0001\n\u0013\u0019\bBB;\u0011A\u0003&Q\u000bC\u0004w!\u0001\u0007I\u0011\u0002!\t\u000f]\u0004\u0002\u0019!C\u0005q\"1!\u0010\u0005Q!\n\u0005CQa\u000f\t\u0005\u0002mDa!a\u0003\u0011\t\u0003!\u0006bBA\u0007!\u0011%\u0011q\u0002\u0005\u0007\u0003'\u0001B\u0011\u0001!\t\u000f\u0005-\u0001\u0003\"\u0001\u0002\u0016!9\u00111\u0002\t\u0005\u0002\u0005}\u0001bBA\u0006!\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003k\u0001B\u0011BA\u001c\u0011\u001d\tY\u0004\u0005C\u0005\u0003{Aq!!\u0011\u0011\t\u0013\t\u0019\u0005C\u0004\u0002HA!I!!\u0013\t\u000f\u00055\u0003\u0003\"\u0003\u0002P!9\u0011\u0011\r\t\u0005\n\u0005\r\u0004B\u00024\u0011\t\u0013\t9'\u0001\u0006JgNKW\u000e\u001d7f\u001fBT!!\u000b\u0016\u0002\u0013=\u0004XM]1uS>t'BA\u0016-\u0003\rQGo\u001d\u0006\u0003[9\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011aL\u0001\u0004_J<7\u0001\u0001\t\u0003e\u0005i\u0011\u0001\u000b\u0002\u000b\u0013N\u001c\u0016.\u001c9mK>\u00038CA\u00016!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\r\u0002\r\u000b:$\u0007o\\5oi&sgm\\\n\u0003\u0007U\n!\u0001\u001d;\u0016\u0003\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001\u0012\u0016\u0002\t\u001d,w.\\\u0005\u0003\r\u000e\u0013!bQ8pe\u0012Lg.\u0019;f\u0003\u0019\u0001Ho\u0018\u0013fcR\u0011\u0011\n\u0014\t\u0003m)K!aS\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b\u001b\u0016\t\t\u00111\u0001B\u0003\rAH%M\u0001\u0004aR\u0004CC\u0001)S!\t\t6!D\u0001\u0002\u0011\u0015yt\u00011\u0001B\u0003!I7o\u00117pg\u0016$W#A+\u0011\u0005Y2\u0016BA,8\u0005\u001d\u0011un\u001c7fC:\fA\"[:DY>\u001cX\rZ0%KF$\"!\u0013.\t\u000f5K\u0011\u0011!a\u0001+\u0006I\u0011n]\"m_N,G\rI\u0001\u0007I\u0016<'/Z3\u0016\u0003y\u0003\"AN0\n\u0005\u0001<$aA%oi\u0006QA-Z4sK\u0016|F%Z9\u0015\u0005%\u001b\u0007bB'\r\u0003\u0003\u0005\rAX\u0001\bI\u0016<'/Z3!\u000359W\r^\"p_J$\u0017N\\1uK\u0006Y\u0011\r\u001a3F]\u0012\u0004x.\u001b8u)\tI\u0005\u000eC\u0003T\u001f\u0001\u0007Qk\u0005\u0002\u0011k\u0005I\u0011N\u001c9vi\u001e+w.\u001c\t\u0003\u00052L!!\\\"\u0003\u0011\u001d+w.\\3uef$\"a\u001c9\u0011\u0005I\u0002\u0002\"\u00026\u0013\u0001\u0004Y\u0017aG5t\u00072|7/\u001a3F]\u0012\u0004x.\u001b8ug&s\u0017J\u001c;fe&|'/A\u0010jg\u000ecwn]3e\u000b:$\u0007o\\5oiNLe.\u00138uKJLwN]0%KF$\"!\u0013;\t\u000f5#\u0012\u0011!a\u0001+\u0006a\u0012n]\"m_N,G-\u00128ea>Lg\u000e^:J]&sG/\u001a:j_J\u0004\u0013!\u00058p]NKW\u000e\u001d7f\u0019>\u001c\u0017\r^5p]\u0006)bn\u001c8TS6\u0004H.\u001a'pG\u0006$\u0018n\u001c8`I\u0015\fHCA%z\u0011\u001diu#!AA\u0002\u0005\u000b!C\\8o'&l\u0007\u000f\\3M_\u000e\fG/[8oAQ\u0019q\u000e`?\t\u000b\u0011K\u0002\u0019A6\t\u000byL\u0002\u0019A@\u0002!\t|WO\u001c3beftu\u000eZ3Sk2,\u0007\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015!&A\u0005bY\u001e|'/\u001b;i[&!\u0011\u0011BA\u0002\u0005A\u0011u.\u001e8eCJLhj\u001c3f%VdW-\u0001\u0005jgNKW\u000e\u001d7f\u00035\u0019w.\u001c9vi\u0016\u001c\u0016.\u001c9mKR\u0019Q+!\u0005\t\u000b\u0011[\u0002\u0019A6\u0002)\u001d,GOT8o'&l\u0007\u000f\\3M_\u000e\fG/[8o)\r)\u0016q\u0003\u0005\u0007\tv\u0001\r!!\u0007\u0011\u0007\t\u000bY\"C\u0002\u0002\u001e\r\u0013!\u0002T5oKN#(/\u001b8h)\r)\u0016\u0011\u0005\u0005\u0007\tz\u0001\r!a\t\u0011\u0007\t\u000b)#C\u0002\u0002(\r\u0013q\"T;mi&d\u0015N\\3TiJLgn\u001a\u000b\u0004+\u0006-\u0002bBA\u0017?\u0001\u0007\u0011qF\u0001\u0003[B\u00042AQA\u0019\u0013\r\t\u0019d\u0011\u0002\u000b\u001bVdG/\u001b)pS:$\u0018AE5t'&l\u0007\u000f\\3Nk2$\u0018\u000eU8j]R$2!VA\u001d\u0011\u001d\ti\u0003\ta\u0001\u0003_\t\u0011#[:TS6\u0004H.\u001a)pYf<wN\\1m)\r)\u0016q\b\u0005\u0006\t\u0006\u0002\ra[\u0001\u001bSN\u001c\u0016.\u001c9mK\u001e+w.\\3uef\u001cu\u000e\u001c7fGRLwN\u001c\u000b\u0004+\u0006\u0015\u0003\"\u0002##\u0001\u0004Y\u0017AF5t'&l\u0007\u000f\\3MS:,\u0017M]$f_6,GO]=\u0015\u0007U\u000bY\u0005C\u0003EG\u0001\u00071.\u0001\u000eiCNtuN\\#oIB|\u0017N\u001c;J]R,'o]3di&|g\u000eF\u0002V\u0003#Bq!a\u0015%\u0001\u0004\t)&A\u0003he\u0006\u0004\b\u000e\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tYFK\u0001\nO\u0016|Wn\u001a:ba\"LA!a\u0018\u0002Z\tiq)Z8nKR\u0014\u0018p\u0012:ba\"\fQ\u0004[1t\u00072|7/\u001a3F]\u0012\u0004x.\u001b8u\u0013:$XM]:fGRLwN\u001c\u000b\u0004+\u0006\u0015\u0004bBA*K\u0001\u0007\u0011Q\u000b\u000b\b\u0013\u0006%\u0014\u0011QAC\u0011\u001d\tYG\na\u0001\u0003[\n\u0011\"\u001a8e!>Lg\u000e^:\u0011\u000f\u0005=\u0014\u0011P!\u0002~5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\n)(A\u0004nkR\f'\r\\3\u000b\u0007\u0005]t'\u0001\u0006d_2dWm\u0019;j_:LA!a\u001f\u0002r\t\u0019Q*\u00199\u0011\u0007\u0005}4A\u0004\u00023\u0001!1\u00111\u0011\u0014A\u0002\u0005\u000b\u0011\u0001\u001d\u0005\u0006'\u001a\u0002\r!\u0016")
public class IsSimpleOp {
    private final Geometry inputGeom;
    private boolean isClosedEndpointsInInterior;
    private Coordinate nonSimpleLocation;
    private volatile byte bitmap$init$0;

    private boolean isClosedEndpointsInInterior() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/IsSimpleOp.scala: 97");
        }
        return this.isClosedEndpointsInInterior;
    }

    private void isClosedEndpointsInInterior_$eq(boolean x$1) {
        this.isClosedEndpointsInInterior = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private Coordinate nonSimpleLocation() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/IsSimpleOp.scala: 98");
        }
        return this.nonSimpleLocation;
    }

    private void nonSimpleLocation_$eq(Coordinate x$1) {
        this.nonSimpleLocation = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public boolean isSimple() {
        this.nonSimpleLocation_$eq(null);
        return this.computeSimple(this.inputGeom);
    }

    private boolean computeSimple(Geometry geom) {
        this.nonSimpleLocation_$eq(null);
        if (geom.isEmpty()) {
            return true;
        }
        if (geom instanceof LineString) {
            return this.isSimpleLinearGeometry(geom);
        }
        if (geom instanceof MultiLineString) {
            return this.isSimpleLinearGeometry(geom);
        }
        if (geom instanceof MultiPoint) {
            return this.isSimpleMultiPoint((MultiPoint)geom);
        }
        if (geom instanceof Polygonal) {
            return this.isSimplePolygonal(geom);
        }
        if (geom instanceof GeometryCollection) {
            return this.isSimpleGeometryCollection(geom);
        }
        return true;
    }

    public Coordinate getNonSimpleLocation() {
        return this.nonSimpleLocation();
    }

    public boolean isSimple(LineString geom) {
        return this.isSimpleLinearGeometry(geom);
    }

    public boolean isSimple(MultiLineString geom) {
        return this.isSimpleLinearGeometry(geom);
    }

    public boolean isSimple(MultiPoint mp) {
        return this.isSimpleMultiPoint(mp);
    }

    private boolean isSimpleMultiPoint(MultiPoint mp) {
        if (mp.isEmpty()) {
            return true;
        }
        TreeSet<Coordinate> points = new TreeSet<Coordinate>();
        for (int i = 0; i < mp.getNumGeometries(); ++i) {
            Point pt = (Point)mp.getGeometryN(i);
            Coordinate p = pt.getCoordinate();
            if (points.contains(p)) {
                this.nonSimpleLocation_$eq(p);
                return false;
            }
            points.add(p);
        }
        return true;
    }

    private boolean isSimplePolygonal(Geometry geom) {
        ArrayList<Geometry> rings = LinearComponentExtracter$.MODULE$.getLines(geom);
        for (LinearRing linearRing : rings) {
            if (this.isSimpleLinearGeometry(linearRing)) continue;
            return false;
        }
        return true;
    }

    private boolean isSimpleGeometryCollection(Geometry geom) {
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry comp = geom.getGeometryN(i);
            if (this.computeSimple(comp)) continue;
            return false;
        }
        return true;
    }

    private boolean isSimpleLinearGeometry(Geometry geom) {
        if (geom.isEmpty()) {
            return true;
        }
        GeometryGraph graph = new GeometryGraph(0, geom);
        RobustLineIntersector li = new RobustLineIntersector();
        SegmentIntersector si = graph.computeSelfNodes(li, true);
        if (!si.hasIntersection()) {
            return true;
        }
        if (si.hasProperIntersection()) {
            this.nonSimpleLocation_$eq(si.getProperIntersectionPoint());
            return false;
        }
        if (this.hasNonEndpointIntersection(graph)) {
            return false;
        }
        return !this.isClosedEndpointsInInterior() || !this.hasClosedEndpointIntersection(graph);
    }

    private boolean hasNonEndpointIntersection(GeometryGraph graph) {
        Iterator<Edge> i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            int maxSegmentIndex = e.getMaximumSegmentIndex();
            Iterator<EdgeIntersection> eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = eiIt.next();
                if (ei.isEndPoint(maxSegmentIndex)) continue;
                this.nonSimpleLocation_$eq(ei.getCoordinate());
                return true;
            }
        }
        return false;
    }

    private boolean hasClosedEndpointIntersection(GeometryGraph graph) {
        TreeMap endPoints = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        Iterator<Edge> i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            boolean isClosed = e.isClosed();
            Coordinate p0 = e.getCoordinate(0);
            this.addEndpoint((Map<Coordinate, EndpointInfo>)endPoints, p0, isClosed);
            Coordinate p1 = e.getCoordinate(e.getNumPoints() - 1);
            this.addEndpoint((Map<Coordinate, EndpointInfo>)endPoints, p1, isClosed);
        }
        for (EndpointInfo eiInfo : endPoints.values()) {
            if (!eiInfo.isClosed() || eiInfo.degree() == 2) continue;
            this.nonSimpleLocation_$eq(eiInfo.getCoordinate());
            return true;
        }
        return false;
    }

    private void addEndpoint(Map<Coordinate, EndpointInfo> endPoints, Coordinate p, boolean isClosed) {
        BoxedUnit boxedUnit;
        EndpointInfo eiInfo = (EndpointInfo)endPoints.get((Object)p).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (eiInfo == null) {
            eiInfo = new EndpointInfo(p);
            boxedUnit = endPoints.put((Object)p, (Object)eiInfo);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        eiInfo.addEndpoint(isClosed);
    }

    public IsSimpleOp(Geometry inputGeom) {
        this.inputGeom = inputGeom;
        this.isClosedEndpointsInInterior = true;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.nonSimpleLocation = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public IsSimpleOp(Geometry geom, BoundaryNodeRule boundaryNodeRule) {
        this(geom);
        this.isClosedEndpointsInInterior_$eq(!boundaryNodeRule.isInBoundary(2));
    }

    public static class EndpointInfo {
        private Coordinate pt;
        private boolean isClosed;
        private int degree;
        private volatile byte bitmap$init$0;

        public Coordinate pt() {
            return this.pt;
        }

        public void pt_$eq(Coordinate x$1) {
            this.pt = x$1;
        }

        public boolean isClosed() {
            if ((byte)(this.bitmap$init$0 & 1) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/IsSimpleOp.scala: 77");
            }
            return this.isClosed;
        }

        public void isClosed_$eq(boolean x$1) {
            this.isClosed = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        }

        public int degree() {
            if ((byte)(this.bitmap$init$0 & 2) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/IsSimpleOp.scala: 78");
            }
            return this.degree;
        }

        public void degree_$eq(int x$1) {
            this.degree = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        }

        public Coordinate getCoordinate() {
            return this.pt();
        }

        public void addEndpoint(boolean isClosed) {
            this.degree_$eq(this.degree() + 1);
            this.isClosed_$eq(this.isClosed() | isClosed);
        }

        public EndpointInfo(Coordinate pt) {
            this.pt = pt;
            this.isClosed = false;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
            this.degree = 0;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        }
    }
}

