/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeList;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.noding.IntersectionAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.operation.buffer.BufferBuilder$;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.BufferSubgraph;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder;
import org.locationtech.jts.operation.buffer.OffsetCurveSetBuilder;
import org.locationtech.jts.operation.buffer.SubgraphDepthLocater;
import org.locationtech.jts.operation.overlay.OverlayNodeFactory;
import org.locationtech.jts.operation.overlay.PolygonBuilder;
import scala.Function1;
import scala.UninitializedFieldError;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005}u!\u0002\u0011\"\u0011\u0003ac!\u0002\u0018\"\u0011\u0003y\u0003\"\u0002\u001c\u0002\t\u00039\u0004\"\u0002\u001d\u0002\t\u0013Id\u0001\u0002\u0018\"\u0001\u0015C\u0001B\u0012\u0003\u0003\u0002\u0004%\ta\u0012\u0005\t\u0017\u0012\u0011\t\u0019!C\u0001\u0019\"A!\u000b\u0002B\u0001B\u0003&\u0001\nC\u00037\t\u0011\u00051\u000bC\u0004W\t\u0001\u0007I\u0011B,\t\u000fy#\u0001\u0019!C\u0005?\"1\u0011\r\u0002Q!\naCqA\u0019\u0003A\u0002\u0013%1\rC\u0004n\t\u0001\u0007I\u0011\u00028\t\rA$\u0001\u0015)\u0003e\u0011\u001d\tH\u00011A\u0005\nIDqA\u001e\u0003A\u0002\u0013%q\u000f\u0003\u0004z\t\u0001\u0006Ka\u001d\u0005\bu\u0012\u0001\r\u0011\"\u0003|\u0011!yH\u00011A\u0005\n\u0005\u0005\u0001bBA\u0003\t\u0001\u0006K\u0001 \u0005\n\u0003\u000f!!\u0019!C\u0005\u0003\u0013A\u0001\"!\u0005\u0005A\u0003%\u00111\u0002\u0005\b\u0003'!A\u0011AA\u000b\u0011\u001d\tY\u0002\u0002C\u0001\u0003;AaA\t\u0003\u0005\u0002\u0005\r\u0002bBA\u001d\t\u0011%\u00111\b\u0005\b\u0003\u0003\"A\u0011BA\"\u0011\u001d\tY\u0006\u0002C\t\u0003;Bq!!\u001b\u0005\t\u0013\tY\u0007C\u0004\u0002|\u0011!I!! \t\u000f\u0005UE\u0001\"\u0003\u0002\u0018\u0006i!)\u001e4gKJ\u0014U/\u001b7eKJT!AI\u0012\u0002\r\t,hMZ3s\u0015\t!S%A\u0005pa\u0016\u0014\u0018\r^5p]*\u0011aeJ\u0001\u0004UR\u001c(B\u0001\u0015*\u00031awnY1uS>tG/Z2i\u0015\u0005Q\u0013aA8sO\u000e\u0001\u0001CA\u0017\u0002\u001b\u0005\t#!\u0004\"vM\u001a,'OQ;jY\u0012,'o\u0005\u0002\u0002aA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0017\u0002\u0015\u0011,\u0007\u000f\u001e5EK2$\u0018\r\u0006\u0002;{A\u0011\u0011gO\u0005\u0003yI\u00121!\u00138u\u0011\u0015q4\u00011\u0001@\u0003\u0015a\u0017MY3m!\t\u00015)D\u0001B\u0015\t\u0011U%A\u0005hK>lwM]1qQ&\u0011A)\u0011\u0002\u0006\u0019\u0006\u0014W\r\\\n\u0003\tA\n\u0011BY;g!\u0006\u0014\u0018-\\:\u0016\u0003!\u0003\"!L%\n\u0005)\u000b#\u0001\u0005\"vM\u001a,'\u000fU1sC6,G/\u001a:t\u00035\u0011WO\u001a)be\u0006l7o\u0018\u0013fcR\u0011Q\n\u0015\t\u0003c9K!a\u0014\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b#\u001a\t\t\u00111\u0001I\u0003\rAH%M\u0001\u000bEV4\u0007+\u0019:b[N\u0004CC\u0001+V!\tiC\u0001C\u0003G\u0011\u0001\u0007\u0001*A\u000bx_J\\\u0017N\\4Qe\u0016\u001c\u0017n]5p]6{G-\u001a7\u0016\u0003a\u0003\"!\u0017/\u000e\u0003iS!aW\u0013\u0002\t\u001d,w.\\\u0005\u0003;j\u0013a\u0002\u0015:fG&\u001c\u0018n\u001c8N_\u0012,G.A\rx_J\\\u0017N\\4Qe\u0016\u001c\u0017n]5p]6{G-\u001a7`I\u0015\fHCA'a\u0011\u001d\t&\"!AA\u0002a\u000bac^8sW&tw\r\u0015:fG&\u001c\u0018n\u001c8N_\u0012,G\u000eI\u0001\ro>\u00148.\u001b8h\u001d>$WM]\u000b\u0002IB\u0019Q\r\u001b6\u000e\u0003\u0019T!aZ\u0013\u0002\r9|G-\u001b8h\u0013\tIgMA\u0003O_\u0012,'\u000f\u0005\u0002fW&\u0011AN\u001a\u0002\u000e'\u0016<W.\u001a8u'R\u0014\u0018N\\4\u0002!]|'o[5oO:{G-\u001a:`I\u0015\fHCA'p\u0011\u001d\tV\"!AA\u0002\u0011\fQb^8sW&twMT8eKJ\u0004\u0013\u0001C4f_64\u0015m\u0019;\u0016\u0003M\u0004\"!\u0017;\n\u0005UT&aD$f_6,GO]=GC\u000e$xN]=\u0002\u0019\u001d,w.\u001c$bGR|F%Z9\u0015\u00055C\bbB)\u0011\u0003\u0003\u0005\ra]\u0001\nO\u0016|WNR1di\u0002\nQa\u001a:ba\",\u0012\u0001 \t\u0003\u0001vL!A`!\u0003\u0017Ac\u0017M\\1s\u000fJ\f\u0007\u000f[\u0001\nOJ\f\u0007\u000f[0%KF$2!TA\u0002\u0011\u001d\t6#!AA\u0002q\faa\u001a:ba\"\u0004\u0013\u0001C3eO\u0016d\u0015n\u001d;\u0016\u0005\u0005-\u0001c\u0001!\u0002\u000e%\u0019\u0011qB!\u0003\u0011\u0015#w-\u001a'jgR\f\u0011\"\u001a3hK2K7\u000f\u001e\u0011\u00021M,GoV8sW&tw\r\u0015:fG&\u001c\u0018n\u001c8N_\u0012,G\u000eF\u0002N\u0003/Aa!!\u0007\u0018\u0001\u0004A\u0016A\u00019n\u0003!\u0019X\r\u001e(pI\u0016\u0014HcA'\u0002 !1\u0011\u0011\u0005\rA\u0002\u0011\fQA\\8eKJ$b!!\n\u0002,\u0005=\u0002cA-\u0002(%\u0019\u0011\u0011\u0006.\u0003\u0011\u001d+w.\\3uefDq!!\f\u001a\u0001\u0004\t)#A\u0001h\u0011\u001d\t\t$\u0007a\u0001\u0003g\t\u0001\u0002Z5ti\u0006t7-\u001a\t\u0004c\u0005U\u0012bAA\u001ce\t1Ai\\;cY\u0016\f\u0001bZ3u\u001d>$WM\u001d\u000b\u0004I\u0006u\u0002BBA 5\u0001\u0007\u0001,\u0001\bqe\u0016\u001c\u0017n]5p]6{G-\u001a7\u0002#\r|W\u000e];uK:{G-\u001a3FI\u001e,7\u000fF\u0003N\u0003\u000b\nI\u0006C\u0004\u0002Hm\u0001\r!!\u0013\u0002!\t,hMZ3s'\u0016<7\u000b\u001e:MSN$\b#BA&\u0003+RWBAA'\u0015\u0011\ty%!\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003'\nAA[1wC&!\u0011qKA'\u0005\u0011a\u0015n\u001d;\t\r\u0005}2\u00041\u0001Y\u0003AIgn]3siVs\u0017.];f\u000b\u0012<W\rF\u0002N\u0003?Bq!!\u0019\u001d\u0001\u0004\t\u0019'A\u0001f!\r\u0001\u0015QM\u0005\u0004\u0003O\n%\u0001B#eO\u0016\fqb\u0019:fCR,7+\u001e2he\u0006\u0004\bn\u001d\u000b\u0005\u0003[\nI\b\u0005\u0004\u0002L\u0005=\u00141O\u0005\u0005\u0003c\niEA\u0005BeJ\f\u0017\u0010T5tiB\u0019Q&!\u001e\n\u0007\u0005]\u0014E\u0001\bCk\u001a4WM]*vE\u001e\u0014\u0018\r\u001d5\t\u000bil\u0002\u0019\u0001?\u0002\u001d\t,\u0018\u000e\u001c3Tk\n<'/\u00199igR)Q*a \u0002\u0006\"9\u0011\u0011\u0011\u0010A\u0002\u0005\r\u0015\u0001D:vE\u001e\u0014\u0018\r\u001d5MSN$\bCBA&\u0003+\n\u0019\bC\u0004\u0002\bz\u0001\r!!#\u0002\u0017A|G.\u001f\"vS2$WM\u001d\t\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*\u0019\u0011qR\u0012\u0002\u000f=4XM\u001d7bs&!\u00111SAG\u00059\u0001v\u000e\\=h_:\u0014U/\u001b7eKJ\f\u0011d\u0019:fCR,W)\u001c9usJ+7/\u001e7u\u000f\u0016|W.\u001a;ssV\u0011\u0011\u0011\u0014\t\u00043\u0006m\u0015bAAO5\n9\u0001k\u001c7zO>t\u0007")
public class BufferBuilder {
    private BufferParameters bufParams;
    private PrecisionModel workingPrecisionModel;
    private Noder<SegmentString> workingNoder;
    private GeometryFactory geomFact;
    private PlanarGraph graph;
    private final EdgeList edgeList;
    private volatile byte bitmap$init$0;

    public BufferParameters bufParams() {
        return this.bufParams;
    }

    public void bufParams_$eq(BufferParameters x$1) {
        this.bufParams = x$1;
    }

    private PrecisionModel workingPrecisionModel() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferBuilder.scala: 76");
        }
        return this.workingPrecisionModel;
    }

    private void workingPrecisionModel_$eq(PrecisionModel x$1) {
        this.workingPrecisionModel = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private Noder<SegmentString> workingNoder() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferBuilder.scala: 77");
        }
        return this.workingNoder;
    }

    private void workingNoder_$eq(Noder<SegmentString> x$1) {
        this.workingNoder = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private GeometryFactory geomFact() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferBuilder.scala: 78");
        }
        return this.geomFact;
    }

    private void geomFact_$eq(GeometryFactory x$1) {
        this.geomFact = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    private PlanarGraph graph() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferBuilder.scala: 79");
        }
        return this.graph;
    }

    private void graph_$eq(PlanarGraph x$1) {
        this.graph = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private EdgeList edgeList() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferBuilder.scala: 80");
        }
        return this.edgeList;
    }

    public void setWorkingPrecisionModel(PrecisionModel pm) {
        this.workingPrecisionModel_$eq(pm);
    }

    public void setNoder(Noder<SegmentString> noder) {
        this.workingNoder_$eq(noder);
    }

    public Geometry buffer(Geometry g, double distance) {
        PrecisionModel precisionModel = this.workingPrecisionModel();
        if (precisionModel == null) {
            precisionModel = g.getPrecisionModel();
        }
        this.geomFact_$eq(g.getFactory());
        OffsetCurveBuilder curveBuilder = new OffsetCurveBuilder(precisionModel, this.bufParams());
        OffsetCurveSetBuilder curveSetBuilder = new OffsetCurveSetBuilder(g, distance, curveBuilder);
        List<SegmentString> bufferSegStrList = curveSetBuilder.getCurves();
        if (bufferSegStrList.size() <= 0) {
            return this.createEmptyResultGeometry();
        }
        this.computeNodedEdges(bufferSegStrList, precisionModel);
        this.graph_$eq(new PlanarGraph(new OverlayNodeFactory()));
        this.graph().addEdges(this.edgeList().getEdges());
        ArrayList<BufferSubgraph> subgraphList = this.createSubgraphs(this.graph());
        PolygonBuilder polyBuilder = new PolygonBuilder(this.geomFact());
        this.buildSubgraphs(subgraphList, polyBuilder);
        ArrayList<Polygon> resultPolyList = polyBuilder.getPolygons();
        if (resultPolyList.size() <= 0) {
            return this.createEmptyResultGeometry();
        }
        Geometry resultGeom = this.geomFact().buildGeometry(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(resultPolyList).asScala().map((Function1 & Serializable)x -> x)).asJava());
        return resultGeom;
    }

    /*
     * WARNING - void declaration
     */
    private Noder<SegmentString> getNoder(PrecisionModel precisionModel) {
        void var2_2;
        if (this.workingNoder() != null) {
            return this.workingNoder();
        }
        MCIndexNoder noder = new MCIndexNoder();
        RobustLineIntersector li = new RobustLineIntersector();
        li.setPrecisionModel(precisionModel);
        noder.setSegmentIntersector(new IntersectionAdder(li));
        return var2_2;
    }

    private void computeNodedEdges(List<SegmentString> bufferSegStrList, PrecisionModel precisionModel) {
        Noder<SegmentString> noder = this.getNoder(precisionModel);
        noder.computeNodes(bufferSegStrList);
        Collection<SegmentString> nodedSegStrings = noder.getNodedSubstrings();
        for (SegmentString segStr : nodedSegStrings) {
            Coordinate[] pts = segStr.getCoordinates();
            if (pts.length == 2 && pts[0].equals2D(pts[1])) continue;
            Label oldLabel = (Label)segStr.getData();
            Edge edge = new Edge(segStr.getCoordinates(), new Label(oldLabel));
            this.insertUniqueEdge(edge);
        }
    }

    public void insertUniqueEdge(Edge e) {
        Edge existingEdge = this.edgeList().findEqualEdge(e);
        if (existingEdge != null) {
            Label existingLabel = existingEdge.getLabel();
            Label labelToMerge = e.getLabel();
            if (!existingEdge.isPointwiseEqual(e)) {
                labelToMerge = new Label(e.getLabel());
                labelToMerge.flip();
            }
            existingLabel.merge(labelToMerge);
            int mergeDelta = BufferBuilder$.MODULE$.org$locationtech$jts$operation$buffer$BufferBuilder$$depthDelta(labelToMerge);
            int existingDelta = existingEdge.getDepthDelta();
            int newDelta = existingDelta + mergeDelta;
            existingEdge.setDepthDelta(newDelta);
        } else {
            this.edgeList().add(e);
            e.setDepthDelta(BufferBuilder$.MODULE$.org$locationtech$jts$operation$buffer$BufferBuilder$$depthDelta(e.getLabel()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<BufferSubgraph> createSubgraphs(PlanarGraph graph) {
        void var2_2;
        ArrayList<BufferSubgraph> subgraphList = new ArrayList<BufferSubgraph>();
        for (Node node : graph.getNodes()) {
            Object object;
            if (!node.isVisited()) {
                BufferSubgraph subgraph = new BufferSubgraph();
                subgraph.create(node);
                object = BoxesRunTime.boxToBoolean((boolean)subgraphList.add(subgraph));
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        Collections.sort(subgraphList, Collections.reverseOrder());
        return var2_2;
    }

    private void buildSubgraphs(List<BufferSubgraph> subgraphList, PolygonBuilder polyBuilder) {
        ArrayList<BufferSubgraph> processedGraphs = new ArrayList<BufferSubgraph>();
        for (BufferSubgraph subgraph : subgraphList) {
            Coordinate p = subgraph.getRightmostCoordinate();
            SubgraphDepthLocater locater = new SubgraphDepthLocater(processedGraphs);
            int outsideDepth = locater.getDepth(p);
            subgraph.computeDepth(outsideDepth);
            subgraph.findResultEdges();
            processedGraphs.add(subgraph);
            polyBuilder.add(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(subgraph.getDirectedEdges()).asScala().map((Function1 & Serializable)x -> x)).asJava(), subgraph.getNodes());
        }
    }

    /*
     * WARNING - void declaration
     */
    private Polygon createEmptyResultGeometry() {
        void var1_1;
        Polygon emptyGeom = this.geomFact().createPolygon();
        return var1_1;
    }

    public BufferBuilder(BufferParameters bufParams) {
        this.bufParams = bufParams;
        this.workingPrecisionModel = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.workingNoder = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.geomFact = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.graph = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.edgeList = new EdgeList();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

