/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import org.locationtech.jts.algorithm.Distance$;
import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.operation.buffer.BufferInputLineSimplifier$;
import scala.Array$;
import scala.UninitializedFieldError;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]r!\u0002\u0010 \u0011\u0003Qc!\u0002\u0017 \u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004\"\u0002\u001c\u0002\t\u00039\u0004b\u0002%\u0002\u0005\u0004%I!\u0013\u0005\u0007\u001b\u0006\u0001\u000b\u0011\u0002&\t\u000f9\u000b!\u0019!C\u0005\u0013\"1q*\u0001Q\u0001\n)3A\u0001L\u0010\u0001!\"A!\t\u0003BA\u0002\u0013\u0005\u0011\u000b\u0003\u0005S\u0011\t\u0005\r\u0011\"\u0001T\u0011!I\u0006B!A!B\u0013A\u0004\"\u0002\u001b\t\t\u0003Q\u0006b\u0002#\t\u0001\u0004%I!\u0018\u0005\b=\"\u0001\r\u0011\"\u0003`\u0011\u0019\t\u0007\u0002)Q\u0005\u000b\"9!\r\u0003a\u0001\n\u0013\u0019\u0007b\u00025\t\u0001\u0004%I!\u001b\u0005\u0007W\"\u0001\u000b\u0015\u00023\t\u000f1D\u0001\u0019!C\u0005\u0013\"9Q\u000e\u0003a\u0001\n\u0013q\u0007B\u00029\tA\u0003&!\nC\u00037\u0011\u0011\u0005\u0011\u000fC\u0003t\u0011\u0011%A\u000fC\u0003y\u0011\u0011%\u0011\u0010C\u0003}\u0011\u0011%\u0011\u000bC\u0003~\u0011\u0011%a\u0010C\u0004\u0002\u000e!!I!a\u0004\t\u000f\u0005}\u0001\u0002\"\u0003\u0002\"!9\u0011Q\u0006\u0005\u0005\n\u0005=\u0012!\u0007\"vM\u001a,'/\u00138qkRd\u0015N\\3TS6\u0004H.\u001b4jKJT!\u0001I\u0011\u0002\r\t,hMZ3s\u0015\t\u00113%A\u0005pa\u0016\u0014\u0018\r^5p]*\u0011A%J\u0001\u0004UR\u001c(B\u0001\u0014(\u00031awnY1uS>tG/Z2i\u0015\u0005A\u0013aA8sO\u000e\u0001\u0001CA\u0016\u0002\u001b\u0005y\"!\u0007\"vM\u001a,'/\u00138qkRd\u0015N\\3TS6\u0004H.\u001b4jKJ\u001c\"!\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!&\u0001\u0005tS6\u0004H.\u001b4z)\rA\u0014i\u0011\t\u0004_eZ\u0014B\u0001\u001e1\u0005\u0015\t%O]1z!\tat(D\u0001>\u0015\tq4%\u0001\u0003hK>l\u0017B\u0001!>\u0005)\u0019un\u001c:eS:\fG/\u001a\u0005\u0006\u0005\u000e\u0001\r\u0001O\u0001\nS:\u0004X\u000f\u001e'j]\u0016DQ\u0001R\u0002A\u0002\u0015\u000b1\u0002Z5ti\u0006t7-\u001a+pYB\u0011qFR\u0005\u0003\u000fB\u0012a\u0001R8vE2,\u0017A\u0002#F\u0019\u0016#V)F\u0001K!\ty3*\u0003\u0002Ma\t\u0019\u0011J\u001c;\u0002\u000f\u0011+E*\u0012+FA\u0005\u0001b*V'`!R\u001bv\fV(`\u0007\"+5iS\u0001\u0012\u001dVku\f\u0015+T?R{ul\u0011%F\u0007.\u00033C\u0001\u0005/+\u0005A\u0014!D5oaV$H*\u001b8f?\u0012*\u0017\u000f\u0006\u0002U/B\u0011q&V\u0005\u0003-B\u0012A!\u00168ji\"9\u0001LCA\u0001\u0002\u0004A\u0014a\u0001=%c\u0005Q\u0011N\u001c9vi2Kg.\u001a\u0011\u0015\u0005mc\u0006CA\u0016\t\u0011\u0015\u0011E\u00021\u00019+\u0005)\u0015a\u00043jgR\fgnY3U_2|F%Z9\u0015\u0005Q\u0003\u0007b\u0002-\u000f\u0003\u0003\u0005\r!R\u0001\rI&\u001cH/\u00198dKR{G\u000eI\u0001\nSN$U\r\\3uK\u0012,\u0012\u0001\u001a\t\u0004_e*\u0007CA\u0018g\u0013\t9\u0007G\u0001\u0003CsR,\u0017!D5t\t\u0016dW\r^3e?\u0012*\u0017\u000f\u0006\u0002UU\"9\u0001,EA\u0001\u0002\u0004!\u0017AC5t\t\u0016dW\r^3eA\u0005\u0001\u0012M\\4mK>\u0013\u0018.\u001a8uCRLwN\\\u0001\u0015C:<G.Z(sS\u0016tG/\u0019;j_:|F%Z9\u0015\u0005Q{\u0007b\u0002-\u0015\u0003\u0003\u0005\rAS\u0001\u0012C:<G.Z(sS\u0016tG/\u0019;j_:\u0004CC\u0001\u001ds\u0011\u0015!e\u00031\u0001F\u0003a!W\r\\3uKNC\u0017\r\u001c7po\u000e{gnY1wSRLWm]\u000b\u0002kB\u0011qF^\u0005\u0003oB\u0012qAQ8pY\u0016\fg.A\fgS:$g*\u001a=u\u001d>tG)\u001a7fi\u0016$\u0017J\u001c3fqR\u0011!J\u001f\u0005\u0006wb\u0001\rAS\u0001\u0006S:$W\r_\u0001\rG>dG.\u00199tK2Kg.Z\u0001\fSN$U\r\\3uC\ndW\r\u0006\u0005v\u007f\u0006\r\u0011qAA\u0006\u0011\u0019\t\tA\u0007a\u0001\u0015\u0006\u0011\u0011\u000e\r\u0005\u0007\u0003\u000bQ\u0002\u0019\u0001&\u0002\u0005%\f\u0004BBA\u00055\u0001\u0007!*\u0001\u0002je!)AI\u0007a\u0001\u000b\u0006\u0001\u0012n]*iC2dwn^*b[BdW\r\u001a\u000b\fk\u0006E\u0011QCA\r\u00037\ti\u0002\u0003\u0004\u0002\u0014m\u0001\raO\u0001\u0003aBBa!a\u0006\u001c\u0001\u0004Y\u0014A\u000193\u0011\u0019\t\ta\u0007a\u0001\u0015\"1\u0011\u0011B\u000eA\u0002)CQ\u0001R\u000eA\u0002\u0015\u000b\u0011\"[:TQ\u0006dGn\\<\u0015\u0013U\f\u0019#!\n\u0002*\u0005-\u0002BBA\n9\u0001\u00071\b\u0003\u0004\u0002(q\u0001\raO\u0001\u0003aFBa!a\u0006\u001d\u0001\u0004Y\u0004\"\u0002#\u001d\u0001\u0004)\u0015!C5t\u0007>t7-\u0019<f)\u001d)\u0018\u0011GA\u001a\u0003kAa!a\u0005\u001e\u0001\u0004Y\u0004BBA\u0014;\u0001\u00071\b\u0003\u0004\u0002\u0018u\u0001\ra\u000f")
public class BufferInputLineSimplifier {
    private Coordinate[] inputLine;
    private double distanceTol;
    private byte[] isDeleted;
    private int angleOrientation;
    private volatile byte bitmap$init$0;

    public Coordinate[] inputLine() {
        return this.inputLine;
    }

    public void inputLine_$eq(Coordinate[] x$1) {
        this.inputLine = x$1;
    }

    private double distanceTol() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferInputLineSimplifier.scala: 85");
        }
        return this.distanceTol;
    }

    private void distanceTol_$eq(double x$1) {
        this.distanceTol = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private byte[] isDeleted() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferInputLineSimplifier.scala: 86");
        }
        return this.isDeleted;
    }

    private void isDeleted_$eq(byte[] x$1) {
        this.isDeleted = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private int angleOrientation() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferInputLineSimplifier.scala: 87");
        }
        return this.angleOrientation;
    }

    private void angleOrientation_$eq(int x$1) {
        this.angleOrientation = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    public Coordinate[] simplify(double distanceTol) {
        this.distanceTol_$eq(Math.abs(distanceTol));
        if (distanceTol < 0.0) {
            this.angleOrientation_$eq(Orientation$.MODULE$.CLOCKWISE());
        }
        this.isDeleted_$eq(new byte[this.inputLine().length]);
        boolean isChanged = false;
        while (isChanged = this.deleteShallowConcavities()) {
        }
        return this.collapseLine();
    }

    private boolean deleteShallowConcavities() {
        int index = 1;
        int midIndex = this.findNextNonDeletedIndex(index);
        int lastIndex = this.findNextNonDeletedIndex(midIndex);
        boolean isChanged = false;
        while (lastIndex < this.inputLine().length) {
            boolean isMiddleVertexDeleted = false;
            if (this.isDeletable(index, midIndex, lastIndex, this.distanceTol())) {
                this.isDeleted()[midIndex] = (byte)BufferInputLineSimplifier$.MODULE$.org$locationtech$jts$operation$buffer$BufferInputLineSimplifier$$DELETE();
                isMiddleVertexDeleted = true;
                isChanged = true;
            }
            index = isMiddleVertexDeleted ? lastIndex : midIndex;
            midIndex = this.findNextNonDeletedIndex(index);
            lastIndex = this.findNextNonDeletedIndex(midIndex);
        }
        return isChanged;
    }

    /*
     * WARNING - void declaration
     */
    private int findNextNonDeletedIndex(int index) {
        void var2_2;
        int next = index + 1;
        while (next < this.inputLine().length && this.isDeleted()[next] == BufferInputLineSimplifier$.MODULE$.org$locationtech$jts$operation$buffer$BufferInputLineSimplifier$$DELETE()) {
            int cfr_ignored_0 = ++next - 1;
        }
        return (int)var2_2;
    }

    private Coordinate[] collapseLine() {
        CoordinateList coordList = new CoordinateList((Coordinate[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Coordinate.class)));
        for (int i = 0; i < this.inputLine().length; ++i) {
            Object object = this.isDeleted()[i] != BufferInputLineSimplifier$.MODULE$.org$locationtech$jts$operation$buffer$BufferInputLineSimplifier$$DELETE() ? BoxesRunTime.boxToBoolean((boolean)coordList.add(this.inputLine()[i])) : BoxedUnit.UNIT;
        }
        return coordList.toCoordinateArray();
    }

    private boolean isDeletable(int i0, int i1, int i2, double distanceTol) {
        Coordinate p2;
        Coordinate p1;
        Coordinate p0 = this.inputLine()[i0];
        if (!this.isConcave(p0, p1 = this.inputLine()[i1], p2 = this.inputLine()[i2])) {
            return false;
        }
        if (!this.isShallow(p0, p1, p2, distanceTol)) {
            return false;
        }
        return this.isShallowSampled(p0, p1, i0, i2, distanceTol);
    }

    private boolean isShallowSampled(Coordinate p0, Coordinate p2, int i0, int i2, double distanceTol) {
        int inc = (i2 - i0) / BufferInputLineSimplifier$.MODULE$.org$locationtech$jts$operation$buffer$BufferInputLineSimplifier$$NUM_PTS_TO_CHECK();
        if (inc <= 0) {
            inc = 1;
        }
        for (int i = i0; i < i2; i += inc) {
            if (this.isShallow(p0, p2, this.inputLine()[i], distanceTol)) continue;
            return false;
        }
        return true;
    }

    private boolean isShallow(Coordinate p0, Coordinate p1, Coordinate p2, double distanceTol) {
        double dist = Distance$.MODULE$.pointToSegment(p1, p0, p2);
        return dist < distanceTol;
    }

    private boolean isConcave(Coordinate p0, Coordinate p1, Coordinate p2) {
        int orientation = Orientation$.MODULE$.index(p0, p1, p2);
        boolean isConcave = orientation == this.angleOrientation();
        return isConcave;
    }

    public BufferInputLineSimplifier(Coordinate[] inputLine) {
        this.inputLine = inputLine;
        this.distanceTol = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.isDeleted = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.angleOrientation = Orientation$.MODULE$.COUNTERCLOCKWISE();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

