/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.PrecisionModel$;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.noding.ScaledNoder;
import org.locationtech.jts.noding.snaprounder.MCIndexSnapRounder;
import org.locationtech.jts.operation.buffer.BufferBuilder;
import org.locationtech.jts.operation.buffer.BufferOp$;
import org.locationtech.jts.operation.buffer.BufferParameters;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%u!\u0002\u0016,\u0011\u00031d!\u0002\u001d,\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%\ta\u0011\u0005\u0007\u000f\u0006\u0001\u000b\u0011\u0002#\t\u000f!\u000b!\u0019!C\u0001\u0007\"1\u0011*\u0001Q\u0001\n\u0011CqAS\u0001C\u0002\u0013\u00051\t\u0003\u0004L\u0003\u0001\u0006I\u0001\u0012\u0005\b\u0019\u0006\u0011\r\u0011\"\u0001D\u0011\u0019i\u0015\u0001)A\u0005\t\"9a*\u0001b\u0001\n\u0013\u0019\u0005BB(\u0002A\u0003%A\tC\u0003Q\u0003\u0011%\u0011\u000bC\u0003b\u0003\u0011\u0005!\rC\u0003b\u0003\u0011\u0005Q\rC\u0003b\u0003\u0011\u0005Q\u000eC\u0003b\u0003\u0011\u0005!\u000fC\u0004y\u0003E\u0005I\u0011A=\u0007\u000baZ\u0003!!\u0003\t\u0011Y\u001b\"\u0011!Q\u0001\n]C\u0011\"a\u0003\u0014\u0005\u0003\u0005\u000b\u0011\u00026\t\r\u0001\u001bB\u0011AA\u0007\u0011%\t)b\u0005b\u0001\n\u0013\t9\u0002C\u0004\u0002\u001aM\u0001\u000b\u0011B,\t\u0011y\u001b\u0002\u0019!C\u0005\u00037A\u0011\"!\b\u0014\u0001\u0004%I!a\b\t\u000f\u0005-2\u0003)Q\u0005%\"I\u0011QF\nA\u0002\u0013%\u0011q\u0003\u0005\n\u0003_\u0019\u0002\u0019!C\u0005\u0003cAq!!\u000e\u0014A\u0003&q\u000bC\u0005\u00028M\u0001\r\u0011\"\u0003\u0002:!I\u00111K\nA\u0002\u0013%\u0011Q\u000b\u0005\t\u00033\u001a\u0002\u0015)\u0003\u0002<!9\u00111L\n\u0005\u0002\u0005u\u0003bBA1'\u0011\u0005\u00111\r\u0005\b\u0003O\u001aB\u0011AA5\u0011\u001d\tig\u0005C\u0005\u0003_Bq!!\u001d\u0014\t\u0013\ty\u0007C\u0004\u0002tM!I!a\u001c\t\u000f\u0005E4\u0003\"\u0003\u0002v!9\u00111P\n\u0005\n\u0005u\u0014\u0001\u0003\"vM\u001a,'o\u00149\u000b\u00051j\u0013A\u00022vM\u001a,'O\u0003\u0002/_\u0005Iq\u000e]3sCRLwN\u001c\u0006\u0003aE\n1A\u001b;t\u0015\t\u00114'\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u00015\u0003\ry'oZ\u0002\u0001!\t9\u0014!D\u0001,\u0005!\u0011UO\u001a4fe>\u00038CA\u0001;!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AN\u0001\n\u0007\u0006\u0003vLU(V\u001d\u0012+\u0012\u0001\u0012\t\u0003w\u0015K!A\u0012\u001f\u0003\u0007%sG/\u0001\u0006D\u0003B{&kT+O\t\u0002\n\u0001bQ!Q?\n+F\u000bV\u0001\n\u0007\u0006\u0003vLQ+U)\u0002\n\u0001bQ!Q?\u001ac\u0015\tV\u0001\n\u0007\u0006\u0003vL\u0012'B)\u0002\n!bQ!Q?N\u000bV+\u0011*F\u0003-\u0019\u0015\tU0T#V\u000b%+\u0012\u0011\u0002)5\u000b\u0005l\u0018)S\u000b\u000eK5+S(O?\u0012Ku)\u0013+T\u0003Ui\u0015\tW0Q%\u0016\u001b\u0015jU%P\u001d~#\u0015jR%U'\u0002\nA\u0003\u001d:fG&\u001c\u0018n\u001c8TG\u0006dWMR1di>\u0014H\u0003\u0002*V;~\u0003\"aO*\n\u0005Qc$A\u0002#pk\ndW\rC\u0003W\u001b\u0001\u0007q+A\u0001h!\tA6,D\u0001Z\u0015\tQv&\u0001\u0003hK>l\u0017B\u0001/Z\u0005!9Um\\7fiJL\b\"\u00020\u000e\u0001\u0004\u0011\u0016\u0001\u00033jgR\fgnY3\t\u000b\u0001l\u0001\u0019\u0001#\u0002%5\f\u0007\u0010\u0015:fG&\u001c\u0018n\u001c8ES\u001eLGo]\u0001\tEV4g-\u001a:PaR\u0019qk\u00193\t\u000bYs\u0001\u0019A,\t\u000bys\u0001\u0019\u0001*\u0015\t]3w\r\u001b\u0005\u0006->\u0001\ra\u0016\u0005\u0006=>\u0001\rA\u0015\u0005\u0006S>\u0001\rA[\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0005]Z\u0017B\u00017,\u0005A\u0011UO\u001a4feB\u000b'/Y7fi\u0016\u00148\u000f\u0006\u0003X]>\u0004\b\"\u0002,\u0011\u0001\u00049\u0006\"\u00020\u0011\u0001\u0004\u0011\u0006\"B9\u0011\u0001\u0004!\u0015\u0001E9vC\u0012\u0014\u0018M\u001c;TK\u001elWM\u001c;t)\u001596\u000f^;w\u0011\u00151\u0016\u00031\u0001X\u0011\u0015q\u0016\u00031\u0001S\u0011\u0015\t\u0018\u00031\u0001E\u0011\u00159\u0018\u00031\u0001E\u0003-)g\u000eZ\"baN#\u0018\u0010\\3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005Q(F\u00016|W\u0005a\bcA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rA(\u0001\u0006b]:|G/\u0019;j_:L1!a\u0002\u007f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\n\u0003'i\n\u0011BY;g!\u0006\u0014\u0018-\\:\u0015\r\u0005=\u0011\u0011CA\n!\t94\u0003C\u0003W-\u0001\u0007q\u000b\u0003\u0005\u0002\fY\u0001\n\u00111\u0001k\u0003\u001d\t'oZ$f_6,\u0012aV\u0001\tCJ<w)Z8nAU\t!+\u0001\u0007eSN$\u0018M\\2f?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0005\u001d\u0002cA\u001e\u0002$%\u0019\u0011Q\u0005\u001f\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003SQ\u0012\u0011!a\u0001%\u0006\u0019\u0001\u0010J\u0019\u0002\u0013\u0011L7\u000f^1oG\u0016\u0004\u0013A\u0004:fgVdGoR3p[\u0016$(/_\u0001\u0013e\u0016\u001cX\u000f\u001c;HK>lW\r\u001e:z?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0005M\u0002\u0002CA\u0015;\u0005\u0005\t\u0019A,\u0002\u001fI,7/\u001e7u\u000f\u0016|W.\u001a;ss\u0002\nQb]1wK\u0016C8-\u001a9uS>tWCAA\u001e!\u0011\ti$!\u0014\u000f\t\u0005}\u0012\u0011\n\b\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI\u001b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0014bAA&y\u00059\u0001/Y2lC\u001e,\u0017\u0002BA(\u0003#\u0012\u0001CU;oi&lW-\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005-C(A\ttCZ,W\t_2faRLwN\\0%KF$B!!\t\u0002X!I\u0011\u0011\u0006\u0011\u0002\u0002\u0003\u0007\u00111H\u0001\u000fg\u00064X-\u0012=dKB$\u0018n\u001c8!\u00039\u0019X\r^#oI\u000e\u000b\u0007o\u0015;zY\u0016$B!!\t\u0002`!)qO\ta\u0001\t\u0006\u00192/\u001a;Rk\u0006$'/\u00198u'\u0016<W.\u001a8ugR!\u0011\u0011EA3\u0011\u0015\t8\u00051\u0001E\u0003E9W\r\u001e*fgVdGoR3p[\u0016$(/\u001f\u000b\u0004/\u0006-\u0004\"\u00020%\u0001\u0004\u0011\u0016aD2p[B,H/Z$f_6,GO]=\u0015\u0005\u0005\u0005\u0012A\u00062vM\u001a,'OU3ek\u000e,G\r\u0015:fG&\u001c\u0018n\u001c8\u0002/\t,hMZ3s\u001fJLw-\u001b8bYB\u0013XmY5tS>tG\u0003BA\u0011\u0003oBa!!\u001f)\u0001\u0004!\u0015a\u00049sK\u000eL7/[8o\t&<\u0017\u000e^:\u0002)\t,hMZ3s\r&DX\r\u001a)sK\u000eL7/[8o)\u0011\t\t#a \t\u000f\u0005\u0005\u0015\u00061\u0001\u0002\u0004\u00069a-\u001b=fIBk\u0005c\u0001-\u0002\u0006&\u0019\u0011qQ-\u0003\u001dA\u0013XmY5tS>tWj\u001c3fY\u0002")
public class BufferOp {
    private final BufferParameters bufParams;
    private final Geometry argGeom;
    private double distance;
    private Geometry resultGeometry;
    private RuntimeException saveException;
    private volatile byte bitmap$init$0;

    public static BufferParameters $lessinit$greater$default$2() {
        return BufferOp$.MODULE$.$lessinit$greater$default$2();
    }

    public static Geometry bufferOp(Geometry geometry, double d, int n, int n2) {
        return BufferOp$.MODULE$.bufferOp(geometry, d, n, n2);
    }

    public static Geometry bufferOp(Geometry geometry, double d, int n) {
        return BufferOp$.MODULE$.bufferOp(geometry, d, n);
    }

    public static Geometry bufferOp(Geometry geometry, double d, BufferParameters bufferParameters) {
        return BufferOp$.MODULE$.bufferOp(geometry, d, bufferParameters);
    }

    public static Geometry bufferOp(Geometry geometry, double d) {
        return BufferOp$.MODULE$.bufferOp(geometry, d);
    }

    public static int CAP_SQUARE() {
        return BufferOp$.MODULE$.CAP_SQUARE();
    }

    public static int CAP_FLAT() {
        return BufferOp$.MODULE$.CAP_FLAT();
    }

    public static int CAP_BUTT() {
        return BufferOp$.MODULE$.CAP_BUTT();
    }

    public static int CAP_ROUND() {
        return BufferOp$.MODULE$.CAP_ROUND();
    }

    private Geometry argGeom() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferOp.scala: 205");
        }
        return this.argGeom;
    }

    private double distance() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferOp.scala: 206");
        }
        return this.distance;
    }

    private void distance_$eq(double x$1) {
        this.distance = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private Geometry resultGeometry() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferOp.scala: 207");
        }
        return this.resultGeometry;
    }

    private void resultGeometry_$eq(Geometry x$1) {
        this.resultGeometry = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    private RuntimeException saveException() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferOp.scala: 208");
        }
        return this.saveException;
    }

    private void saveException_$eq(RuntimeException x$1) {
        this.saveException = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    public void setEndCapStyle(int endCapStyle) {
        this.bufParams.setEndCapStyle(endCapStyle);
    }

    public void setQuadrantSegments(int quadrantSegments) {
        this.bufParams.setQuadrantSegments(quadrantSegments);
    }

    public Geometry getResultGeometry(double distance) {
        this.distance_$eq(distance);
        this.computeGeometry();
        return this.resultGeometry();
    }

    private void computeGeometry() {
        this.bufferOriginalPrecision();
        if (this.resultGeometry() != null) {
            return;
        }
        PrecisionModel argPM = this.argGeom().getFactory().getPrecisionModel();
        if (argPM.getType() == PrecisionModel$.MODULE$.FIXED()) {
            this.bufferFixedPrecision(argPM);
        } else {
            this.bufferReducedPrecision();
        }
    }

    private void bufferReducedPrecision() {
        int precDigits = BufferOp$.MODULE$.org$locationtech$jts$operation$buffer$BufferOp$$MAX_PRECISION_DIGITS();
        while (precDigits >= 0) {
            try {
                this.bufferReducedPrecision(precDigits);
            }
            catch (TopologyException ex) {
                this.saveException_$eq(ex);
            }
            if (this.resultGeometry() != null) {
                return;
            }
            int cfr_ignored_0 = --precDigits + 1;
        }
        throw this.saveException();
    }

    private void bufferOriginalPrecision() {
        try {
            BufferBuilder bufBuilder = new BufferBuilder(this.bufParams);
            this.resultGeometry_$eq(bufBuilder.buffer(this.argGeom(), this.distance()));
        }
        catch (RuntimeException ex) {
            this.saveException_$eq(ex);
        }
    }

    private void bufferReducedPrecision(int precisionDigits) {
        double sizeBasedScaleFactor = BufferOp$.MODULE$.org$locationtech$jts$operation$buffer$BufferOp$$precisionScaleFactor(this.argGeom(), this.distance(), precisionDigits);
        PrecisionModel fixedPM = new PrecisionModel(sizeBasedScaleFactor);
        this.bufferFixedPrecision(fixedPM);
    }

    private void bufferFixedPrecision(PrecisionModel fixedPM) {
        ScaledNoder noder = new ScaledNoder(new MCIndexSnapRounder(new PrecisionModel(1.0)), fixedPM.getScale());
        BufferBuilder bufBuilder = new BufferBuilder(this.bufParams);
        bufBuilder.setWorkingPrecisionModel(fixedPM);
        bufBuilder.setNoder(noder);
        this.resultGeometry_$eq(bufBuilder.buffer(this.argGeom(), this.distance()));
    }

    public BufferOp(Geometry g, BufferParameters bufParams) {
        this.bufParams = bufParams;
        this.argGeom = g;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.distance = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.resultGeometry = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.saveException = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

