/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.Position$;
import org.locationtech.jts.operation.buffer.RightmostEdgeFinder;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001\u0002\u000f\u001e\u0001!BQ!\u000f\u0001\u0005\u0002iBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004A\u0001\u0001\u0006I!\u0010\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0011\u0019y\u0005\u0001)A\u0005\u0007\"9\u0001\u000b\u0001b\u0001\n\u0013\t\u0006B\u0002,\u0001A\u0003%!\u000bC\u0004X\u0001\u0001\u0007I\u0011\u0002-\t\u000f}\u0003\u0001\u0019!C\u0005A\"1a\r\u0001Q!\neCqa\u001a\u0001A\u0002\u0013%\u0001\u000eC\u0004m\u0001\u0001\u0007I\u0011B7\t\r=\u0004\u0001\u0015)\u0003j\u0011\u0015\u0001\b\u0001\"\u0001C\u0011\u0015\t\b\u0001\"\u0001R\u0011\u0015\u0011\b\u0001\"\u0001i\u0011\u0015\u0019\b\u0001\"\u0001Y\u0011\u0015!\b\u0001\"\u0001v\u0011\u0015A\b\u0001\"\u0003z\u0011\u0015a\b\u0001\"\u0003~\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u001c\u0001!I!!\b\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u00111\u0006\u0001\u0005\n\u00055\u0002bBA\u001a\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003k\u0001A\u0011IA\u001c\u00059\u0011UO\u001a4feN+(m\u001a:ba\"T!AH\u0010\u0002\r\t,hMZ3s\u0015\t\u0001\u0013%A\u0005pa\u0016\u0014\u0018\r^5p]*\u0011!eI\u0001\u0004UR\u001c(B\u0001\u0013&\u00031awnY1uS>tG/Z2i\u0015\u00051\u0013aA8sO\u000e\u00011c\u0001\u0001*_A\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\u00042\u0001M\u001b8\u001b\u0005\t$B\u0001\u001a4\u0003\u0011a\u0017M\\4\u000b\u0003Q\nAA[1wC&\u0011a'\r\u0002\u000b\u0007>l\u0007/\u0019:bE2,\u0007C\u0001\u001d\u0001\u001b\u0005i\u0012A\u0002\u001fj]&$h\bF\u00018\u0003\u00191\u0017N\u001c3feV\tQ\b\u0005\u00029}%\u0011q(\b\u0002\u0014%&<\u0007\u000e^7pgR,EmZ3GS:$WM]\u0001\bM&tG-\u001a:!\u0003-!\u0017N]#eO\u0016d\u0015n\u001d;\u0016\u0003\r\u00032\u0001R$J\u001b\u0005)%B\u0001$4\u0003\u0011)H/\u001b7\n\u0005!+%!C!se\u0006LH*[:u!\tQU*D\u0001L\u0015\ta\u0015%A\u0005hK>lwM]1qQ&\u0011aj\u0013\u0002\r\t&\u0014Xm\u0019;fI\u0016#w-Z\u0001\rI&\u0014X\tZ4f\u0019&\u001cH\u000fI\u0001\u0006]>$Wm]\u000b\u0002%B\u0019AiR*\u0011\u0005)#\u0016BA+L\u0005\u0011qu\u000eZ3\u0002\r9|G-Z:!\u00039\u0011\u0018n\u001a5u\u001b>\u001cHoQ8pe\u0012,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039\u0006\nAaZ3p[&\u0011al\u0017\u0002\u000b\u0007>|'\u000fZ5oCR,\u0017A\u0005:jO\"$Xj\\:u\u0007>|'\u000fZ0%KF$\"!\u00193\u0011\u0005)\u0012\u0017BA2,\u0005\u0011)f.\u001b;\t\u000f\u0015L\u0011\u0011!a\u00013\u0006\u0019\u0001\u0010J\u0019\u0002\u001fILw\r\u001b;N_N$8i\\8sI\u0002\n1!\u001a8w+\u0005I\u0007C\u0001.k\u0013\tY7L\u0001\u0005F]Z,Gn\u001c9f\u0003\u001d)gN^0%KF$\"!\u00198\t\u000f\u0015d\u0011\u0011!a\u0001S\u0006!QM\u001c<!\u0003A9W\r\u001e#je\u0016\u001cG/\u001a3FI\u001e,7/\u0001\u0005hKRtu\u000eZ3t\u0003-9W\r^#om\u0016dw\u000e]3\u0002-\u001d,GOU5hQRlwn\u001d;D_>\u0014H-\u001b8bi\u0016\faa\u0019:fCR,GCA1w\u0011\u00159(\u00031\u0001T\u0003\u0011qw\u000eZ3\u0002\u0019\u0005$GMU3bG\"\f'\r\\3\u0015\u0005\u0005T\b\"B>\u0014\u0001\u0004\u0019\u0016!C:uCJ$hj\u001c3f\u0003\r\tG\r\u001a\u000b\u0004Cz|\b\"B<\u0015\u0001\u0004\u0019\u0006bBA\u0001)\u0001\u0007\u00111A\u0001\n]>$Wm\u0015;bG.\u0004B\u0001RA\u0003'&\u0019\u0011qA#\u0003\u000bM#\u0018mY6\u0002#\rdW-\u0019:WSNLG/\u001a3FI\u001e,7\u000fF\u0001b\u00031\u0019w.\u001c9vi\u0016$U\r\u001d;i)\r\t\u0017\u0011\u0003\u0005\b\u0003'1\u0002\u0019AA\u000b\u00031yW\u000f^:jI\u0016$U\r\u001d;i!\rQ\u0013qC\u0005\u0004\u00033Y#aA%oi\u0006i1m\\7qkR,G)\u001a9uQN$2!YA\u0010\u0011\u0019\t\tc\u0006a\u0001\u0013\u0006I1\u000f^1si\u0016#w-Z\u0001\u0011G>l\u0007/\u001e;f\u001d>$W\rR3qi\"$2!YA\u0014\u0011\u0019\tI\u0003\u0007a\u0001'\u0006\ta.A\u0007d_BL8+_7EKB$\bn\u001d\u000b\u0004C\u0006=\u0002BBA\u00193\u0001\u0007\u0011*\u0001\u0002eK\u0006ya-\u001b8e%\u0016\u001cX\u000f\u001c;FI\u001e,7/A\u0005d_6\u0004\u0018M]3U_R!\u0011QCA\u001d\u0011\u0019\tYd\u0007a\u0001o\u0005\tq\u000e")
public class BufferSubgraph
implements Comparable<BufferSubgraph> {
    private final RightmostEdgeFinder finder = new RightmostEdgeFinder();
    private final ArrayList<DirectedEdge> dirEdgeList;
    private final ArrayList<Node> nodes;
    private Coordinate rightMostCoord = null;
    private Envelope env = null;
    private volatile byte bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);

    private RightmostEdgeFinder finder() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferSubgraph.scala: 39");
        }
        return this.finder;
    }

    private ArrayList<DirectedEdge> dirEdgeList() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferSubgraph.scala: 40");
        }
        return this.dirEdgeList;
    }

    private ArrayList<Node> nodes() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferSubgraph.scala: 41");
        }
        return this.nodes;
    }

    private Coordinate rightMostCoord() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferSubgraph.scala: 42");
        }
        return this.rightMostCoord;
    }

    private void rightMostCoord_$eq(Coordinate x$1) {
        this.rightMostCoord = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private Envelope env() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/BufferSubgraph.scala: 43");
        }
        return this.env;
    }

    private void env_$eq(Envelope x$1) {
        this.env = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    public ArrayList<DirectedEdge> getDirectedEdges() {
        return this.dirEdgeList();
    }

    public ArrayList<Node> getNodes() {
        return this.nodes();
    }

    public Envelope getEnvelope() {
        block2: {
            if (this.env() != null) break block2;
            Envelope edgeEnv = new Envelope();
            for (DirectedEdge dirEdge : this.dirEdgeList()) {
                Coordinate[] pts = dirEdge.getEdge().getCoordinates();
                for (int i = 0; i < pts.length - 1; ++i) {
                    edgeEnv.expandToInclude(pts[i]);
                }
            }
            this.env_$eq(edgeEnv);
        }
        return this.env();
    }

    public Coordinate getRightmostCoordinate() {
        return this.rightMostCoord();
    }

    public void create(Node node) {
        this.addReachable(node);
        this.finder().findEdge(this.dirEdgeList());
        this.rightMostCoord_$eq(this.finder().getCoordinate());
    }

    private void addReachable(Node startNode) {
        Stack<Node> nodeStack = new Stack<Node>();
        nodeStack.add(startNode);
        while (!nodeStack.empty()) {
            Node node = (Node)nodeStack.pop();
            this.add(node, nodeStack);
        }
    }

    private void add(Node node, Stack<Node> nodeStack) {
        node.setVisited(true);
        this.nodes().add(node);
        Iterator<EdgeEnd> i = ((DirectedEdgeStar)node.getEdges()).iterator();
        while (i.hasNext()) {
            DirectedEdge de = (DirectedEdge)i.next();
            this.dirEdgeList().add(de);
            DirectedEdge sym = de.getSym();
            Node symNode = sym.getNode();
            Object object = !symNode.isVisited() ? nodeStack.push(symNode) : BoxedUnit.UNIT;
        }
    }

    private void clearVisitedEdges() {
        for (DirectedEdge de : this.dirEdgeList()) {
            de.setVisited(false);
        }
    }

    public void computeDepth(int outsideDepth) {
        this.clearVisitedEdges();
        DirectedEdge de = this.finder().getEdge();
        de.setEdgeDepths(Position$.MODULE$.RIGHT(), outsideDepth);
        this.copySymDepths(de);
        this.computeDepths(de);
    }

    private void computeDepths(DirectedEdge startEdge) {
        HashSet<Node> nodesVisited = new HashSet<Node>();
        LinkedList<Node> nodeQueue = new LinkedList<Node>();
        Node startNode = startEdge.getNode();
        nodeQueue.addLast(startNode);
        nodesVisited.add(startNode);
        startEdge.setVisited(true);
        while (!nodeQueue.isEmpty()) {
            Node n = (Node)nodeQueue.removeFirst();
            nodesVisited.add(n);
            this.computeNodeDepth(n);
            Iterator<EdgeEnd> i = ((DirectedEdgeStar)n.getEdges()).iterator();
            while (i.hasNext()) {
                Object object;
                DirectedEdge de = (DirectedEdge)i.next();
                DirectedEdge sym = de.getSym();
                if (!sym.isVisited()) {
                    Node adjNode = sym.getNode();
                    if (!nodesVisited.contains(adjNode)) {
                        nodeQueue.addLast(adjNode);
                        object = BoxesRunTime.boxToBoolean((boolean)nodesVisited.add(adjNode));
                        continue;
                    }
                    object = BoxedUnit.UNIT;
                    continue;
                }
                object = BoxedUnit.UNIT;
            }
        }
    }

    private void computeNodeDepth(Node n) {
        DirectedEdge startEdge = null;
        Iterator<EdgeEnd> i = ((DirectedEdgeStar)n.getEdges()).iterator();
        boolean loopBreak = false;
        while (i.hasNext() && !loopBreak) {
            DirectedEdge de = (DirectedEdge)i.next();
            if (!de.isVisited() && !de.getSym().isVisited()) continue;
            startEdge = de;
            loopBreak = true;
        }
        if (startEdge == null) {
            throw new TopologyException(new StringBuilder(41).append("unable to find edge to compute depths at ").append(n.getCoordinate()).toString());
        }
        ((DirectedEdgeStar)n.getEdges()).computeDepths(startEdge);
        i = ((DirectedEdgeStar)n.getEdges()).iterator();
        while (i.hasNext()) {
            DirectedEdge de = (DirectedEdge)i.next();
            de.setVisited(true);
            this.copySymDepths(de);
        }
    }

    private void copySymDepths(DirectedEdge de) {
        DirectedEdge sym = de.getSym();
        sym.setDepth(Position$.MODULE$.LEFT(), de.getDepth(Position$.MODULE$.RIGHT()));
        sym.setDepth(Position$.MODULE$.RIGHT(), de.getDepth(Position$.MODULE$.LEFT()));
    }

    public void findResultEdges() {
        for (DirectedEdge de : this.dirEdgeList()) {
            if (de.getDepth(Position$.MODULE$.RIGHT()) < 1 || de.getDepth(Position$.MODULE$.LEFT()) > 0 || de.isInteriorAreaEdge()) continue;
            de.setInResult(true);
        }
    }

    @Override
    public int compareTo(BufferSubgraph o) {
        BufferSubgraph graph = o;
        if (this.rightMostCoord().x() < graph.rightMostCoord().x()) {
            return -1;
        }
        if (this.rightMostCoord().x() > graph.rightMostCoord().x()) {
            return 1;
        }
        return 0;
    }

    public BufferSubgraph() {
        this.dirEdgeList = new ArrayList();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.nodes = new ArrayList();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

