/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays$;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geomgraph.Position$;
import org.locationtech.jts.operation.buffer.BufferInputLineSimplifier$;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.BufferParameters$;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder$;
import org.locationtech.jts.operation.buffer.OffsetSegmentGenerator;
import scala.MatchError;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rs!B\u000e\u001d\u0011\u00039c!B\u0015\u001d\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004\"B\u001a\u0002\t\u0013!d\u0001B\u0015\u001d\u0001\u0001C\u0001\"\u0011\u0003\u0003\u0002\u0004%\tA\u0011\u0005\t\r\u0012\u0011\t\u0019!C\u0001\u000f\"AQ\n\u0002B\u0001B\u0003&1\t\u0003\u0005O\t\t\u0005\r\u0011\"\u0001P\u0011!\u0019FA!a\u0001\n\u0003!\u0006\u0002\u0003,\u0005\u0005\u0003\u0005\u000b\u0015\u0002)\t\u000bE\"A\u0011A,\t\u000fm#\u0001\u0019!C\u00059\"9\u0001\r\u0002a\u0001\n\u0013\t\u0007BB2\u0005A\u0003&Q\fC\u0003e\t\u0011\u0005q\nC\u0003f\t\u0011\u0005a\rC\u0003k\t\u0011\u00051\u000eC\u0003q\t\u0011\u0005\u0011\u000fC\u0003z\t\u0011\u0005!\u0010C\u0003~\t\u0011%a\u0010C\u0004\u0002\b\u0011!I!!\u0003\t\u000f\u0005=A\u0001\"\u0003\u0002\u0012!9\u00111\u0004\u0003\u0005\n\u0005u\u0001bBA\u0012\t\u0011%\u0011Q\u0005\u0005\b\u0003_!A\u0011BA\u0019\u0011\u001d\tI\u0004\u0002C\u0005\u0003w\t!c\u00144gg\u0016$8)\u001e:wK\n+\u0018\u000e\u001c3fe*\u0011QDH\u0001\u0007EV4g-\u001a:\u000b\u0005}\u0001\u0013!C8qKJ\fG/[8o\u0015\t\t#%A\u0002kiNT!a\t\u0013\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0001\"\u0001K\u0001\u000e\u0003q\u0011!c\u00144gg\u0016$8)\u001e:wK\n+\u0018\u000e\u001c3feN\u0011\u0011a\u000b\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0013aD2paf\u001cun\u001c:eS:\fG/Z:\u0015\u0005Ur\u0004c\u0001\u00177q%\u0011q'\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0001\nAaZ3p[&\u0011QH\u000f\u0002\u000b\u0007>|'\u000fZ5oCR,\u0007\"B \u0004\u0001\u0004)\u0014a\u00019ugN\u0011AaK\u0001\u000faJ,7-[:j_:lu\u000eZ3m+\u0005\u0019\u0005CA\u001dE\u0013\t)%H\u0001\bQe\u0016\u001c\u0017n]5p]6{G-\u001a7\u0002%A\u0014XmY5tS>tWj\u001c3fY~#S-\u001d\u000b\u0003\u0011.\u0003\"\u0001L%\n\u0005)k#\u0001B+oSRDq\u0001\u0014\u0004\u0002\u0002\u0003\u00071)A\u0002yIE\nq\u0002\u001d:fG&\u001c\u0018n\u001c8N_\u0012,G\u000eI\u0001\nEV4\u0007+\u0019:b[N,\u0012\u0001\u0015\t\u0003QEK!A\u0015\u000f\u0003!\t+hMZ3s!\u0006\u0014\u0018-\\3uKJ\u001c\u0018!\u00042vMB\u000b'/Y7t?\u0012*\u0017\u000f\u0006\u0002I+\"9A*CA\u0001\u0002\u0004\u0001\u0016A\u00032vMB\u000b'/Y7tAQ\u0019\u0001,\u0017.\u0011\u0005!\"\u0001\"B!\f\u0001\u0004\u0019\u0005\"\u0002(\f\u0001\u0004\u0001\u0016\u0001\u00033jgR\fgnY3\u0016\u0003u\u0003\"\u0001\f0\n\u0005}k#A\u0002#pk\ndW-\u0001\u0007eSN$\u0018M\\2f?\u0012*\u0017\u000f\u0006\u0002IE\"9A*DA\u0001\u0002\u0004i\u0016!\u00033jgR\fgnY3!\u0003M9W\r\u001e\"vM\u001a,'\u000fU1sC6,G/\u001a:t\u000319W\r\u001e'j]\u0016\u001cUO\u001d<f)\r)t-\u001b\u0005\u0006QB\u0001\r!N\u0001\tS:\u0004X\u000f\u001e)ug\")1\f\u0005a\u0001;\u0006\t\u0012n\u001d'j]\u0016|eMZ:fi\u0016k\u0007\u000f^=\u0015\u00051|\u0007C\u0001\u0017n\u0013\tqWFA\u0004C_>dW-\u00198\t\u000bm\u000b\u0002\u0019A/\u0002\u0019\u001d,GOU5oO\u000e+(O^3\u0015\tU\u00128\u000f\u001f\u0005\u0006QJ\u0001\r!\u000e\u0005\u0006iJ\u0001\r!^\u0001\u0005g&$W\r\u0005\u0002-m&\u0011q/\f\u0002\u0004\u0013:$\b\"B.\u0013\u0001\u0004i\u0016AD4fi>3gm]3u\u0007V\u0014h/\u001a\u000b\u0004kmd\b\"\u00025\u0014\u0001\u0004)\u0004\"B.\u0014\u0001\u0004i\u0016!C4fiN+wmR3o)\ry\u0018Q\u0001\t\u0004Q\u0005\u0005\u0011bAA\u00029\t1rJ\u001a4tKR\u001cVmZ7f]R<UM\\3sCR|'\u000fC\u0003\\)\u0001\u0007Q,A\ttS6\u0004H.\u001b4z)>dWM]1oG\u0016$2!XA\u0006\u0011\u0019\ti!\u0006a\u0001;\u0006Y!-\u001e4ESN$\u0018M\\2f\u0003E\u0019w.\u001c9vi\u0016\u0004v.\u001b8u\u0007V\u0014h/\u001a\u000b\u0006\u0011\u0006M\u0011q\u0003\u0005\u0007\u0003+1\u0002\u0019\u0001\u001d\u0002\u0005A$\bBBA\r-\u0001\u0007q0\u0001\u0004tK\u001e<UM\\\u0001\u0017G>l\u0007/\u001e;f\u0019&tWMQ;gM\u0016\u00148)\u001e:wKR)\u0001*a\b\u0002\"!)\u0001n\u0006a\u0001k!1\u0011\u0011D\fA\u0002}\fQdY8naV$XmU5oO2,7+\u001b3fI\n+hMZ3s\u0007V\u0014h/\u001a\u000b\b\u0011\u0006\u001d\u0012\u0011FA\u0017\u0011\u0015A\u0007\u00041\u00016\u0011\u0019\tY\u0003\u0007a\u0001Y\u0006Y\u0011n\u001d*jO\"$8+\u001b3f\u0011\u0019\tI\u0002\u0007a\u0001\u007f\u0006\u00112m\\7qkR,wJ\u001a4tKR\u001cUO\u001d<f)\u001dA\u00151GA\u001b\u0003oAQ\u0001[\rA\u0002UBa!a\u000b\u001a\u0001\u0004a\u0007BBA\r3\u0001\u0007q0\u0001\fd_6\u0004X\u000f^3SS:<')\u001e4gKJ\u001cUO\u001d<f)\u001dA\u0015QHA \u0003\u0003BQ\u0001\u001b\u000eA\u0002UBQ\u0001\u001e\u000eA\u0002UDa!!\u0007\u001b\u0001\u0004y\b")
public class OffsetCurveBuilder {
    private PrecisionModel precisionModel;
    private BufferParameters bufParams;
    private double distance;
    private volatile boolean bitmap$init$0;

    public PrecisionModel precisionModel() {
        return this.precisionModel;
    }

    public void precisionModel_$eq(PrecisionModel x$1) {
        this.precisionModel = x$1;
    }

    public BufferParameters bufParams() {
        return this.bufParams;
    }

    public void bufParams_$eq(BufferParameters x$1) {
        this.bufParams = x$1;
    }

    private double distance() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetCurveBuilder.scala: 56");
        }
        return this.distance;
    }

    private void distance_$eq(double x$1) {
        this.distance = x$1;
        this.bitmap$init$0 = true;
    }

    public BufferParameters getBufferParameters() {
        return this.bufParams();
    }

    public Coordinate[] getLineCurve(Coordinate[] inputPts, double distance) {
        this.distance_$eq(distance);
        if (this.isLineOffsetEmpty(distance)) {
            return null;
        }
        double posDistance = Math.abs(distance);
        OffsetSegmentGenerator segGen = this.getSegGen(posDistance);
        if (inputPts.length <= 1) {
            this.computePointCurve(inputPts[0], segGen);
        } else if (this.bufParams().isSingleSided()) {
            boolean isRightSide = distance < 0.0;
            this.computeSingleSidedBufferCurve(inputPts, isRightSide, segGen);
        } else {
            this.computeLineBufferCurve(inputPts, segGen);
        }
        Coordinate[] lineCoord = segGen.getCoordinates();
        return lineCoord;
    }

    public boolean isLineOffsetEmpty(double distance) {
        if (distance == 0.0) {
            return true;
        }
        return distance < 0.0 && !this.bufParams().isSingleSided();
    }

    public Coordinate[] getRingCurve(Coordinate[] inputPts, int side, double distance) {
        this.distance_$eq(distance);
        if (inputPts.length <= 2) {
            return this.getLineCurve(inputPts, distance);
        }
        if (distance == 0.0) {
            return OffsetCurveBuilder$.MODULE$.org$locationtech$jts$operation$buffer$OffsetCurveBuilder$$copyCoordinates(inputPts);
        }
        OffsetSegmentGenerator segGen = this.getSegGen(distance);
        this.computeRingBufferCurve(inputPts, side, segGen);
        return segGen.getCoordinates();
    }

    public Coordinate[] getOffsetCurve(Coordinate[] inputPts, double distance) {
        Coordinate[] curvePts;
        block3: {
            this.distance_$eq(distance);
            if (distance == 0.0) {
                return null;
            }
            boolean isRightSide = distance < 0.0;
            double posDistance = Math.abs(distance);
            OffsetSegmentGenerator segGen = this.getSegGen(posDistance);
            if (inputPts.length <= 1) {
                this.computePointCurve(inputPts[0], segGen);
            } else {
                this.computeOffsetCurve(inputPts, isRightSide, segGen);
            }
            curvePts = segGen.getCoordinates();
            if (!isRightSide) break block3;
            CoordinateArrays$.MODULE$.reverse(curvePts);
        }
        return curvePts;
    }

    private OffsetSegmentGenerator getSegGen(double distance) {
        return new OffsetSegmentGenerator(this.precisionModel(), this.bufParams(), distance);
    }

    private double simplifyTolerance(double bufDistance) {
        return bufDistance * this.bufParams().getSimplifyFactor();
    }

    private void computePointCurve(Coordinate pt, OffsetSegmentGenerator segGen) {
        int n = this.bufParams().getEndCapStyle();
        if (BufferParameters$.MODULE$.CAP_ROUND() == n) {
            segGen.createCircle(pt);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BufferParameters$.MODULE$.CAP_SQUARE() == n) {
            segGen.createSquare(pt);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
    }

    private void computeLineBufferCurve(Coordinate[] inputPts, OffsetSegmentGenerator segGen) {
        int i;
        double distTol = this.simplifyTolerance(this.distance());
        Coordinate[] simp1 = BufferInputLineSimplifier$.MODULE$.simplify(inputPts, distTol);
        int n1 = simp1.length - 1;
        segGen.initSideSegments(simp1[0], simp1[1], Position$.MODULE$.LEFT());
        for (i = 2; i <= n1; ++i) {
            segGen.addNextSegment(simp1[i], true);
        }
        segGen.addLastSegment();
        segGen.addLineEndCap(simp1[n1 - 1], simp1[n1]);
        Coordinate[] simp2 = BufferInputLineSimplifier$.MODULE$.simplify(inputPts, -distTol);
        int n2 = simp2.length - 1;
        segGen.initSideSegments(simp2[n2], simp2[n2 - 1], Position$.MODULE$.LEFT());
        for (i = n2 - 2; i >= 0; --i) {
            segGen.addNextSegment(simp2[i], true);
        }
        segGen.addLastSegment();
        segGen.addLineEndCap(simp2[1], simp2[0]);
        segGen.closeRing();
    }

    private void computeSingleSidedBufferCurve(Coordinate[] inputPts, boolean isRightSide, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance());
        if (isRightSide) {
            segGen.addSegments(inputPts, true);
            Coordinate[] simp2 = BufferInputLineSimplifier$.MODULE$.simplify(inputPts, -distTol);
            int n2 = simp2.length - 1;
            segGen.initSideSegments(simp2[n2], simp2[n2 - 1], Position$.MODULE$.LEFT());
            segGen.addFirstSegment();
            for (int i = n2 - 2; i >= 0; --i) {
                segGen.addNextSegment(simp2[i], true);
            }
        } else {
            segGen.addSegments(inputPts, false);
            Coordinate[] simp1 = BufferInputLineSimplifier$.MODULE$.simplify(inputPts, distTol);
            int n1 = simp1.length - 1;
            segGen.initSideSegments(simp1[0], simp1[1], Position$.MODULE$.LEFT());
            segGen.addFirstSegment();
            for (int i = 2; i <= n1; ++i) {
                segGen.addNextSegment(simp1[i], true);
            }
        }
        segGen.addLastSegment();
        segGen.closeRing();
    }

    private void computeOffsetCurve(Coordinate[] inputPts, boolean isRightSide, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance());
        if (isRightSide) {
            Coordinate[] simp2 = BufferInputLineSimplifier$.MODULE$.simplify(inputPts, -distTol);
            int n2 = simp2.length - 1;
            segGen.initSideSegments(simp2[n2], simp2[n2 - 1], Position$.MODULE$.LEFT());
            segGen.addFirstSegment();
            for (int i = n2 - 2; i >= 0; --i) {
                segGen.addNextSegment(simp2[i], true);
            }
        } else {
            Coordinate[] simp1 = BufferInputLineSimplifier$.MODULE$.simplify(inputPts, distTol);
            int n1 = simp1.length - 1;
            segGen.initSideSegments(simp1[0], simp1[1], Position$.MODULE$.LEFT());
            segGen.addFirstSegment();
            for (int i = 2; i <= n1; ++i) {
                segGen.addNextSegment(simp1[i], true);
            }
        }
        segGen.addLastSegment();
    }

    private void computeRingBufferCurve(Coordinate[] inputPts, int side, OffsetSegmentGenerator segGen) {
        double distTol = this.simplifyTolerance(this.distance());
        if (side == Position$.MODULE$.RIGHT()) {
            distTol = -distTol;
        }
        Coordinate[] simp = BufferInputLineSimplifier$.MODULE$.simplify(inputPts, distTol);
        int n = simp.length - 1;
        segGen.initSideSegments(simp[n - 1], simp[0], side);
        for (int i = 1; i <= n; ++i) {
            boolean addStartPoint = i != 1;
            segGen.addNextSegment(simp[i], addStartPoint);
        }
        segGen.closeRing();
    }

    public OffsetCurveBuilder(PrecisionModel precisionModel, BufferParameters bufParams) {
        this.precisionModel = precisionModel;
        this.bufParams = bufParams;
        this.distance = 0.0;
        this.bitmap$init$0 = true;
    }
}

