/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.Distance$;
import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.LinearRing$;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Position$;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001\u0002\r\u001a\u0001\u0011B\u0001b\u000b\u0001\u0003\u0002\u0004%\t\u0001\f\u0005\tg\u0001\u0011\t\u0019!C\u0001i!A!\b\u0001B\u0001B\u0003&Q\u0006\u0003\u0005<\u0001\t\u0005\r\u0011\"\u0001=\u0011!\u0001\u0005A!a\u0001\n\u0003\t\u0005\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0015B\u001f\t\u0011\u0011\u0003!\u00111A\u0005\u0002\u0015C\u0001B\u0013\u0001\u0003\u0002\u0004%\ta\u0013\u0005\t\u001b\u0002\u0011\t\u0011)Q\u0005\r\")a\n\u0001C\u0001\u001f\"9A\u000b\u0001b\u0001\n\u0013)\u0006B\u00023\u0001A\u0003%a\u000bC\u0003f\u0001\u0011\u0005a\rC\u0003k\u0001\u0011%1\u000eC\u0003|\u0001\u0011%A\u0010\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\tY\u0002\u0001C\u0005\u0003;Aq!!\u000b\u0001\t\u0013\tY\u0003C\u0004\u00026\u0001!I!a\u000e\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA6\u0001\u0011%\u0011Q\u000e\u0002\u0016\u001f\u001a47/\u001a;DkJ4XmU3u\u0005VLG\u000eZ3s\u0015\tQ2$\u0001\u0004ck\u001a4WM\u001d\u0006\u00039u\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\u000b\u0005yy\u0012a\u00016ug*\u0011\u0001%I\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002E\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0002\u0013%t\u0007/\u001e;HK>lW#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005Aj\u0012\u0001B4f_6L!AM\u0018\u0003\u0011\u001d+w.\\3uef\fQ\"\u001b8qkR<Um\\7`I\u0015\fHCA\u001b9!\t1c'\u0003\u00028O\t!QK\\5u\u0011\u001dI$!!AA\u00025\n1\u0001\u001f\u00132\u0003)Ig\u000e];u\u000f\u0016|W\u000eI\u0001\tI&\u001cH/\u00198dKV\tQ\b\u0005\u0002'}%\u0011qh\n\u0002\u0007\t>,(\r\\3\u0002\u0019\u0011L7\u000f^1oG\u0016|F%Z9\u0015\u0005U\u0012\u0005bB\u001d\u0006\u0003\u0003\u0005\r!P\u0001\nI&\u001cH/\u00198dK\u0002\nAbY;sm\u0016\u0014U/\u001b7eKJ,\u0012A\u0012\t\u0003\u000f\"k\u0011!G\u0005\u0003\u0013f\u0011!c\u00144gg\u0016$8)\u001e:wK\n+\u0018\u000e\u001c3fe\u0006\u00012-\u001e:wK\n+\u0018\u000e\u001c3fe~#S-\u001d\u000b\u0003k1Cq!\u000f\u0005\u0002\u0002\u0003\u0007a)A\u0007dkJ4XMQ;jY\u0012,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tA\u000b&k\u0015\t\u0003\u000f\u0002AQa\u000b\u0006A\u00025BQa\u000f\u0006A\u0002uBQ\u0001\u0012\u0006A\u0002\u0019\u000b\u0011bY;sm\u0016d\u0015n\u001d;\u0016\u0003Y\u00032a\u0016/_\u001b\u0005A&BA-[\u0003\u0011)H/\u001b7\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0017\u0002\n\u0003J\u0014\u0018-\u001f'jgR\u0004\"a\u00182\u000e\u0003\u0001T!!Y\u000f\u0002\r9|G-\u001b8h\u0013\t\u0019\u0007MA\u0007TK\u001elWM\u001c;TiJLgnZ\u0001\u000bGV\u0014h/\u001a'jgR\u0004\u0013!C4fi\u000e+(O^3t+\u00059\u0007cA,i=&\u0011\u0011\u000e\u0017\u0002\u0005\u0019&\u001cH/\u0001\u0005bI\u0012\u001cUO\u001d<f)\u0011)D\u000e^=\t\u000b5t\u0001\u0019\u00018\u0002\u000b\r|wN\u001d3\u0011\u0007\u0019z\u0017/\u0003\u0002qO\t)\u0011I\u001d:bsB\u0011aF]\u0005\u0003g>\u0012!bQ8pe\u0012Lg.\u0019;f\u0011\u0015)h\u00021\u0001w\u0003\u001daWM\u001a;M_\u000e\u0004\"AJ<\n\u0005a<#aA%oi\")!P\u0004a\u0001m\u0006A!/[4ii2{7-A\u0002bI\u0012$\"!N?\t\u000by|\u0001\u0019A\u0017\u0002\u0003\u001d\fQ\"\u00193e\u0007>dG.Z2uS>tGcA\u001b\u0002\u0004!9\u0011Q\u0001\tA\u0002\u0005\u001d\u0011AA4d!\rq\u0013\u0011B\u0005\u0004\u0003\u0017y#AE$f_6,GO]=D_2dWm\u0019;j_:\f\u0001\"\u00193e!>Lg\u000e\u001e\u000b\u0004k\u0005E\u0001bBA\n#\u0001\u0007\u0011QC\u0001\u0002aB\u0019a&a\u0006\n\u0007\u0005eqFA\u0003Q_&tG/A\u0007bI\u0012d\u0015N\\3TiJLgn\u001a\u000b\u0004k\u0005}\u0001bBA\u0011%\u0001\u0007\u00111E\u0001\u0005Y&tW\rE\u0002/\u0003KI1!a\n0\u0005)a\u0015N\\3TiJLgnZ\u0001\u000bC\u0012$\u0007k\u001c7zO>tGcA\u001b\u0002.!9\u00111C\nA\u0002\u0005=\u0002c\u0001\u0018\u00022%\u0019\u00111G\u0018\u0003\u000fA{G._4p]\u0006\u0001\u0012\r\u001a3SS:<'i\u001c;i'&$Wm\u001d\u000b\u0006k\u0005e\u00121\b\u0005\u0006[R\u0001\rA\u001c\u0005\u0006wQ\u0001\r!P\u0001\fC\u0012$'+\u001b8h'&$W\rF\u00066\u0003\u0003\n\u0019%a\u0012\u0002L\u0005=\u0003\"B7\u0016\u0001\u0004q\u0007BBA#+\u0001\u0007Q(\u0001\bpM\u001a\u001cX\r\u001e#jgR\fgnY3\t\r\u0005%S\u00031\u0001w\u0003\u001d\u0019\u0018\u000eZ3Be\u001eDa!!\u0014\u0016\u0001\u00041\u0018!C2x\u0019\u00164G\u000fT8d\u0011\u0019\t\t&\u0006a\u0001m\u0006Q1m\u001e*jO\"$Hj\\2\u0002%%\u001cXI]8eK\u0012\u001cu.\u001c9mKR,G.\u001f\u000b\u0007\u0003/\ni&a\u001a\u0011\u0007\u0019\nI&C\u0002\u0002\\\u001d\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002`Y\u0001\r!!\u0019\u0002\tILgn\u001a\t\u0004]\u0005\r\u0014bAA3_\tQA*\u001b8fCJ\u0014\u0016N\\4\t\r\u0005%d\u00031\u0001>\u00039\u0011WO\u001a4fe\u0012K7\u000f^1oG\u0016\f!$[:Ue&\fgn\u001a7f\u000bJ|G-\u001a3D_6\u0004H.\u001a;fYf$b!a\u0016\u0002p\u0005M\u0004BBA9/\u0001\u0007a.A\u0007ue&\fgn\u001a7f\u0007>|'\u000f\u001a\u0005\u0007\u0003S:\u0002\u0019A\u001f")
public class OffsetCurveSetBuilder {
    private Geometry inputGeom;
    private double distance;
    private OffsetCurveBuilder curveBuilder;
    private final ArrayList<SegmentString> curveList;
    private volatile boolean bitmap$init$0;

    public Geometry inputGeom() {
        return this.inputGeom;
    }

    public void inputGeom_$eq(Geometry x$1) {
        this.inputGeom = x$1;
    }

    public double distance() {
        return this.distance;
    }

    public void distance_$eq(double x$1) {
        this.distance = x$1;
    }

    public OffsetCurveBuilder curveBuilder() {
        return this.curveBuilder;
    }

    public void curveBuilder_$eq(OffsetCurveBuilder x$1) {
        this.curveBuilder = x$1;
    }

    private ArrayList<SegmentString> curveList() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetCurveSetBuilder.scala: 46");
        }
        return this.curveList;
    }

    public List<SegmentString> getCurves() {
        this.add(this.inputGeom());
        return this.curveList();
    }

    private void addCurve(Coordinate[] coord, int leftLoc, int rightLoc) {
        if (coord == null || coord.length < 2) {
            return;
        }
        NodedSegmentString e = new NodedSegmentString(coord, new Label(0, Location$.MODULE$.BOUNDARY(), leftLoc, rightLoc));
        this.curveList().add(e);
    }

    private void add(Geometry g) {
        if (g.isEmpty()) {
            return;
        }
        if (g instanceof Polygon) {
            this.addPolygon((Polygon)g);
        } else {
            Geometry geometry = g;
            if (geometry instanceof LineString) {
                LineString lineString = (LineString)geometry;
                this.addLineString(lineString);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Geometry geometry2 = g;
                if (geometry2 instanceof Point) {
                    Point point = (Point)geometry2;
                    this.addPoint(point);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (geometry2 instanceof MultiPoint) {
                    MultiPoint multiPoint = (MultiPoint)geometry2;
                    this.addCollection(multiPoint);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (geometry2 instanceof MultiLineString) {
                    MultiLineString multiLineString = (MultiLineString)geometry2;
                    this.addCollection(multiLineString);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (geometry2 instanceof MultiPolygon) {
                    MultiPolygon multiPolygon = (MultiPolygon)geometry2;
                    this.addCollection(multiPolygon);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (geometry2 instanceof GeometryCollection) {
                    GeometryCollection geometryCollection = (GeometryCollection)geometry2;
                    this.addCollection(geometryCollection);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new UnsupportedOperationException(g.getClass().getName());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void addCollection(GeometryCollection gc) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            this.add(g);
        }
    }

    private void addPoint(Point p) {
        if (this.distance() <= 0.0) {
            return;
        }
        Coordinate[] coord = p.getCoordinates();
        Coordinate[] curve = this.curveBuilder().getLineCurve(coord, this.distance());
        this.addCurve(curve, Location$.MODULE$.EXTERIOR(), Location$.MODULE$.INTERIOR());
    }

    private void addLineString(LineString line) {
        if (this.curveBuilder().isLineOffsetEmpty(this.distance())) {
            return;
        }
        Coordinate[] coord = CoordinateArrays$.MODULE$.removeRepeatedPoints(line.getCoordinates());
        if (CoordinateArrays$.MODULE$.isRing(coord) && !this.curveBuilder().getBufferParameters().isSingleSided()) {
            this.addRingBothSides(coord, this.distance());
        } else {
            Coordinate[] curve = this.curveBuilder().getLineCurve(coord, this.distance());
            this.addCurve(curve, Location$.MODULE$.EXTERIOR(), Location$.MODULE$.INTERIOR());
        }
    }

    private void addPolygon(Polygon p) {
        double offsetDistance = this.distance();
        int offsetSide = Position$.MODULE$.LEFT();
        if (this.distance() < 0.0) {
            offsetDistance = -this.distance();
            offsetSide = Position$.MODULE$.RIGHT();
        }
        LinearRing shell = p.getExteriorRing();
        Coordinate[] shellCoord = CoordinateArrays$.MODULE$.removeRepeatedPoints(shell.getCoordinates());
        if (this.distance() < 0.0 && this.isErodedCompletely(shell, this.distance())) {
            return;
        }
        if (this.distance() <= 0.0 && shellCoord.length < 3) {
            return;
        }
        this.addRingSide(shellCoord, offsetDistance, offsetSide, Location$.MODULE$.EXTERIOR(), Location$.MODULE$.INTERIOR());
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            LinearRing hole = p.getInteriorRingN(i);
            Coordinate[] holeCoord = CoordinateArrays$.MODULE$.removeRepeatedPoints(hole.getCoordinates());
            if (this.distance() > 0.0 && this.isErodedCompletely(hole, -this.distance())) continue;
            this.addRingSide(holeCoord, offsetDistance, Position$.MODULE$.opposite(offsetSide), Location$.MODULE$.INTERIOR(), Location$.MODULE$.EXTERIOR());
        }
    }

    private void addRingBothSides(Coordinate[] coord, double distance) {
        this.addRingSide(coord, distance, Position$.MODULE$.LEFT(), Location$.MODULE$.EXTERIOR(), Location$.MODULE$.INTERIOR());
        this.addRingSide(coord, distance, Position$.MODULE$.RIGHT(), Location$.MODULE$.INTERIOR(), Location$.MODULE$.EXTERIOR());
    }

    private void addRingSide(Coordinate[] coord, double offsetDistance, int sideArg, int cwLeftLoc, int cwRightLoc) {
        int side = sideArg;
        if (offsetDistance == 0.0 && coord.length < LinearRing$.MODULE$.MINIMUM_VALID_SIZE()) {
            return;
        }
        int leftLoc = cwLeftLoc;
        int rightLoc = cwRightLoc;
        if (coord.length >= LinearRing$.MODULE$.MINIMUM_VALID_SIZE() && Orientation$.MODULE$.isCCW(coord)) {
            leftLoc = cwRightLoc;
            rightLoc = cwLeftLoc;
            side = Position$.MODULE$.opposite(side);
        }
        Coordinate[] curve = this.curveBuilder().getRingCurve(coord, side, offsetDistance);
        this.addCurve(curve, leftLoc, rightLoc);
    }

    private boolean isErodedCompletely(LinearRing ring, double bufferDistance) {
        Coordinate[] ringCoord = ring.getCoordinates();
        if (ringCoord.length < 4) {
            return bufferDistance < 0.0;
        }
        if (ringCoord.length == 4) {
            return this.isTriangleErodedCompletely(ringCoord, bufferDistance);
        }
        Envelope env = ring.getEnvelopeInternal();
        double envMinDimension = Math.min(env.getHeight(), env.getWidth());
        return bufferDistance < 0.0 && (double)2 * Math.abs(bufferDistance) > envMinDimension;
    }

    private boolean isTriangleErodedCompletely(Coordinate[] triangleCoord, double bufferDistance) {
        Triangle tri = new Triangle(triangleCoord[0], triangleCoord[1], triangleCoord[2]);
        Coordinate inCentre = tri.inCentre();
        double distToCentre = Distance$.MODULE$.pointToSegment(inCentre, tri.p0(), tri.p1());
        return distToCentre < Math.abs(bufferDistance);
    }

    public OffsetCurveSetBuilder(Geometry inputGeom, double distance, OffsetCurveBuilder curveBuilder) {
        this.inputGeom = inputGeom;
        this.distance = distance;
        this.curveBuilder = curveBuilder;
        this.curveList = new ArrayList();
        this.bitmap$init$0 = true;
    }
}

