/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import org.locationtech.jts.algorithm.Angle$;
import org.locationtech.jts.algorithm.Intersection$;
import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geomgraph.Position$;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.BufferParameters$;
import org.locationtech.jts.operation.buffer.OffsetSegmentGenerator$;
import org.locationtech.jts.operation.buffer.OffsetSegmentString;
import scala.MatchError;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t}t!\u0002'N\u0011\u0003Af!\u0002.N\u0011\u0003Y\u0006\"\u00022\u0002\t\u0003\u0019\u0007b\u00023\u0002\u0005\u0004%I!\u001a\u0005\u0007S\u0006\u0001\u000b\u0011\u00024\t\u000f)\f!\u0019!C\u0005K\"11.\u0001Q\u0001\n\u0019Dq\u0001\\\u0001C\u0002\u0013%Q\r\u0003\u0004n\u0003\u0001\u0006IA\u001a\u0005\b]\u0006\u0011\r\u0011\"\u0003p\u0011\u0019\u0019\u0018\u0001)A\u0005a\u001a!!,\u0014\u0001u\u0011!)8B!a\u0001\n\u00031\b\u0002C?\f\u0005\u0003\u0007I\u0011\u0001@\t\u0013\u0005%1B!A!B\u00139\bBCA\u0006\u0017\t\u0005\r\u0011\"\u0001\u0002\u000e!Q\u0011QC\u0006\u0003\u0002\u0004%\t!a\u0006\t\u0015\u0005m1B!A!B\u0013\ty\u0001C\u0005\u0002\u001e-\u0011\t\u0019!C\u0001K\"Q\u0011qD\u0006\u0003\u0002\u0004%\t!!\t\t\u0013\u0005\u00152B!A!B\u00131\u0007B\u00022\f\t\u0003\t9\u0003C\u0005\u00022-\u0011\r\u0011\"\u0003\u00024!A\u0011\u0011I\u0006!\u0002\u0013\t)\u0004\u0003\u0005\u0002D-\u0011\r\u0011\"\u0003f\u0011\u001d\t)e\u0003Q\u0001\n\u0019D\u0001\"a\u0012\f\u0001\u0004%Ia\u001c\u0005\n\u0003\u0013Z\u0001\u0019!C\u0005\u0003\u0017Bq!a\u0014\fA\u0003&\u0001\u000fC\u0005\u0002R-\u0001\r\u0011\"\u0003\u0002T!I\u00111L\u0006A\u0002\u0013%\u0011Q\f\u0005\t\u0003CZ\u0001\u0015)\u0003\u0002V!I\u00111M\u0006A\u0002\u0013%\u0011Q\r\u0005\n\u0003[Z\u0001\u0019!C\u0005\u0003_B\u0001\"a\u001d\fA\u0003&\u0011q\r\u0005\n\u0003kZ\u0001\u0019!C\u0005\u0003KB\u0011\"a\u001e\f\u0001\u0004%I!!\u001f\t\u0011\u0005u4\u0002)Q\u0005\u0003OB\u0011\"a \f\u0001\u0004%I!!\u001a\t\u0013\u0005\u00055\u00021A\u0005\n\u0005\r\u0005\u0002CAD\u0017\u0001\u0006K!a\u001a\t\u0013\u0005%5B1A\u0005\n\u0005-\u0005\u0002CAJ\u0017\u0001\u0006I!!$\t\u0013\u0005U5B1A\u0005\n\u0005-\u0005\u0002CAL\u0017\u0001\u0006I!!$\t\u0013\u0005e5B1A\u0005\n\u0005-\u0005\u0002CAN\u0017\u0001\u0006I!!$\t\u0013\u0005u5B1A\u0005\n\u0005-\u0005\u0002CAP\u0017\u0001\u0006I!!$\t\u0011\u0005\u00056\u00021A\u0005\n=D\u0011\"a)\f\u0001\u0004%I!!*\t\u000f\u0005%6\u0002)Q\u0005a\"I\u00111V\u0006A\u0002\u0013%\u0011Q\u0016\u0005\n\u0003k[\u0001\u0019!C\u0005\u0003oC\u0001\"a/\fA\u0003&\u0011q\u0016\u0005\b\u0003{[A\u0011AAW\u0011\u001d\tyl\u0003C\u0005\u0003\u0003Dq!!2\f\t\u0003\t9\rC\u0004\u0002P.!\t!!5\t\u000f\u0005e7\u0002\"\u0001\u0002\\\"9\u0011Q\\\u0006\u0005\u0002\u0005}\u0007bBAu\u0017\u0011\u0005\u00111\u001c\u0005\b\u0003W\\A\u0011AAn\u0011\u001d\tio\u0003C\u0001\u0003_Dq!!?\f\t\u0013\tY\u0010C\u0004\u0002\u0000.!IA!\u0001\t\u000f\t%1\u0002\"\u0003\u0003\f!9!\u0011C\u0006\u0005\n\tM\u0001b\u0002B\u0011\u0017\u0011\u0005!1\u0005\u0005\b\u0005[YA\u0011\u0002B\u0018\u0011\u001d\u0011Id\u0003C\u0005\u0005wAqAa\u0012\f\t\u0013\u0011I\u0005C\u0004\u0003P-!IA!\u0015\t\u000f\t\u00054\u0002\"\u0003\u0003d!9!1O\u0006\u0005\u0002\tU\u0004b\u0002B=\u0017\u0011\u0005!1P\u0001\u0017\u001f\u001a47/\u001a;TK\u001elWM\u001c;HK:,'/\u0019;pe*\u0011ajT\u0001\u0007EV4g-\u001a:\u000b\u0005A\u000b\u0016!C8qKJ\fG/[8o\u0015\t\u00116+A\u0002kiNT!\u0001V+\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003Y\u000b1a\u001c:h\u0007\u0001\u0001\"!W\u0001\u000e\u00035\u0013ac\u00144gg\u0016$8+Z4nK:$x)\u001a8fe\u0006$xN]\n\u0003\u0003q\u0003\"!\u00181\u000e\u0003yS\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001Y\u0003\u0001zeIR*F)~\u001bViR'F\u001dR{6+\u0012)B%\u0006#\u0016j\u0014(`\r\u0006\u001bEk\u0014*\u0016\u0003\u0019\u0004\"!X4\n\u0005!t&A\u0002#pk\ndW-A\u0011P\r\u001a\u001bV\tV0T\u000b\u001ekUI\u0014+`'\u0016\u0003\u0016IU!U\u0013>suLR!D)>\u0013\u0006%A\u0014J\u001dNKE)R0U+JsuLV#S)\u0016Cvl\u0015(B!~#\u0015j\u0015+B\u001d\u000e+uLR!D)>\u0013\u0016\u0001K%O'&#Ui\u0018+V%:{f+\u0012*U\u000bb{6KT!Q?\u0012K5\u000bV!O\u0007\u0016{f)Q\"U\u001fJ\u0003\u0013!I\"V%Z+uLV#S)\u0016Cvl\u0015(B!~#\u0015j\u0015+B\u001d\u000e+uLR!D)>\u0013\u0016AI\"V%Z+uLV#S)\u0016Cvl\u0015(B!~#\u0015j\u0015+B\u001d\u000e+uLR!D)>\u0013\u0006%\u0001\u000eN\u0003b{6\tT(T\u0013:;ulU#H?2+ej\u0018$B\u0007R{%+F\u0001q!\ti\u0016/\u0003\u0002s=\n\u0019\u0011J\u001c;\u000275\u000b\u0005lX\"M\u001fNKejR0T\u000b\u001e{F*\u0012(`\r\u0006\u001bEk\u0014*!'\tYA,\u0001\bqe\u0016\u001c\u0017n]5p]6{G-\u001a7\u0016\u0003]\u0004\"\u0001_>\u000e\u0003eT!A_)\u0002\t\u001d,w.\\\u0005\u0003yf\u0014a\u0002\u0015:fG&\u001c\u0018n\u001c8N_\u0012,G.\u0001\nqe\u0016\u001c\u0017n]5p]6{G-\u001a7`I\u0015\fHcA@\u0002\u0006A\u0019Q,!\u0001\n\u0007\u0005\raL\u0001\u0003V]&$\b\u0002CA\u0004\u001b\u0005\u0005\t\u0019A<\u0002\u0007a$\u0013'A\bqe\u0016\u001c\u0017n]5p]6{G-\u001a7!\u0003%\u0011WO\u001a)be\u0006l7/\u0006\u0002\u0002\u0010A\u0019\u0011,!\u0005\n\u0007\u0005MQJ\u0001\tCk\u001a4WM\u001d)be\u0006lW\r^3sg\u0006i!-\u001e4QCJ\fWn]0%KF$2a`A\r\u0011%\t9\u0001EA\u0001\u0002\u0004\ty!\u0001\u0006ck\u001a\u0004\u0016M]1ng\u0002\n\u0001\u0002Z5ti\u0006t7-Z\u0001\rI&\u001cH/\u00198dK~#S-\u001d\u000b\u0004\u007f\u0006\r\u0002\u0002CA\u0004'\u0005\u0005\t\u0019\u00014\u0002\u0013\u0011L7\u000f^1oG\u0016\u0004C\u0003CA\u0015\u0003W\ti#a\f\u0011\u0005e[\u0001\"B;\u0016\u0001\u00049\bbBA\u0006+\u0001\u0007\u0011q\u0002\u0005\u0007\u0003;)\u0002\u0019\u00014\u0002\u00051LWCAA\u001b!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001e#\u0006I\u0011\r\\4pe&$\b.\\\u0005\u0005\u0003\u007f\tIDA\u000bS_\n,8\u000f\u001e'j]\u0016Le\u000e^3sg\u0016\u001cGo\u001c:\u0002\u00071L\u0007%\u0001\ngS2dW\r^!oO2,\u0017+^1oiVl\u0017a\u00054jY2,G/\u00118hY\u0016\fV/\u00198uk6\u0004\u0013AF2m_NLgnZ*fO2+gn\u001a;i\r\u0006\u001cGo\u001c:\u00025\rdwn]5oON+w\rT3oORDg)Y2u_J|F%Z9\u0015\u0007}\fi\u0005\u0003\u0005\u0002\bm\t\t\u00111\u0001q\u0003]\u0019Gn\\:j]\u001e\u001cVm\u001a'f]\u001e$\bNR1di>\u0014\b%A\u0004tK\u001ed\u0015n\u001d;\u0016\u0005\u0005U\u0003cA-\u0002X%\u0019\u0011\u0011L'\u0003'=3gm]3u'\u0016<W.\u001a8u'R\u0014\u0018N\\4\u0002\u0017M,w\rT5ti~#S-\u001d\u000b\u0004\u007f\u0006}\u0003\"CA\u0004=\u0005\u0005\t\u0019AA+\u0003!\u0019Xm\u001a'jgR\u0004\u0013AA:1+\t\t9\u0007E\u0002y\u0003SJ1!a\u001bz\u0005)\u0019un\u001c:eS:\fG/Z\u0001\u0007gBzF%Z9\u0015\u0007}\f\t\bC\u0005\u0002\b\u0005\n\t\u00111\u0001\u0002h\u0005\u00191\u000f\r\u0011\u0002\u0005M\f\u0014AB:2?\u0012*\u0017\u000fF\u0002\u0000\u0003wB\u0011\"a\u0002%\u0003\u0003\u0005\r!a\u001a\u0002\u0007M\f\u0004%\u0001\u0002te\u000511OM0%KF$2a`AC\u0011%\t9aJA\u0001\u0002\u0004\t9'A\u0002te\u0001\nAa]3haU\u0011\u0011Q\u0012\t\u0004q\u0006=\u0015bAAIs\nYA*\u001b8f'\u0016<W.\u001a8u\u0003\u0015\u0019Xm\u001a\u0019!\u0003\u0011\u0019XmZ\u0019\u0002\u000bM,w-\r\u0011\u0002\u000f=4gm]3ua\u0005AqN\u001a4tKR\u0004\u0004%A\u0004pM\u001a\u001cX\r^\u0019\u0002\u0011=4gm]3uc\u0001\nAa]5eK\u0006A1/\u001b3f?\u0012*\u0017\u000fF\u0002\u0000\u0003OC\u0001\"a\u00023\u0003\u0003\u0005\r\u0001]\u0001\u0006g&$W\rI\u0001\u0017m\"\f7OT1se><8i\u001c8dCZ,\u0017I\\4mKV\u0011\u0011q\u0016\t\u0004;\u0006E\u0016bAAZ=\n9!i\\8mK\u0006t\u0017A\u0007<iCNt\u0015M\u001d:po\u000e{gnY1wK\u0006sw\r\\3`I\u0015\fHcA@\u0002:\"I\u0011qA\u001b\u0002\u0002\u0003\u0007\u0011qV\u0001\u0018m\"\f7OT1se><8i\u001c8dCZ,\u0017I\\4mK\u0002\nQ\u0003[1t\u001d\u0006\u0014(o\\<D_:\u001c\u0017M^3B]\u001edW-\u0001\u0003j]&$HcA@\u0002D\"1\u0011Q\u0004\u001dA\u0002\u0019\f\u0001#\u001b8jiNKG-Z*fO6,g\u000e^:\u0015\u000f}\fI-a3\u0002N\"9\u0011QO\u001dA\u0002\u0005\u001d\u0004bBA@s\u0001\u0007\u0011q\r\u0005\u0007\u0003CK\u0004\u0019\u00019\u0002\u001d\u001d,GoQ8pe\u0012Lg.\u0019;fgV\u0011\u00111\u001b\t\u0006;\u0006U\u0017qM\u0005\u0004\u0003/t&!B!se\u0006L\u0018!C2m_N,'+\u001b8h)\u0005y\u0018aC1eIN+w-\\3oiN$Ra`Aq\u0003KDq!a9=\u0001\u0004\t\u0019.\u0001\u0002qi\"9\u0011q\u001d\u001fA\u0002\u0005=\u0016!C5t\r>\u0014x/\u0019:e\u0003=\tG\r\u001a$jeN$8+Z4nK:$\u0018AD1eI2\u000b7\u000f^*fO6,g\u000e^\u0001\u000fC\u0012$g*\u001a=u'\u0016<W.\u001a8u)\u0015y\u0018\u0011_A{\u0011\u001d\t\u0019p\u0010a\u0001\u0003O\n\u0011\u0001\u001d\u0005\b\u0003o|\u0004\u0019AAX\u00035\tG\rZ*uCJ$\bk\\5oi\u0006a\u0011\r\u001a3D_2d\u0017N\\3beR\u0019q0!@\t\u000f\u0005]\b\t1\u0001\u00020\u0006q\u0011\r\u001a3PkR\u001c\u0018\u000eZ3UkJtG#B@\u0003\u0004\t\u001d\u0001B\u0002B\u0003\u0003\u0002\u0007\u0001/A\u0006pe&,g\u000e^1uS>t\u0007bBA|\u0003\u0002\u0007\u0011qV\u0001\u000eC\u0012$\u0017J\\:jI\u0016$VO\u001d8\u0015\u000b}\u0014iAa\u0004\t\r\t\u0015!\t1\u0001q\u0011\u001d\t9P\u0011a\u0001\u0003_\u000bAcY8naV$Xm\u00144gg\u0016$8+Z4nK:$H#C@\u0003\u0016\te!1\u0004B\u000f\u0011\u001d\u00119b\u0011a\u0001\u0003\u001b\u000b1a]3h\u0011\u0019\t\tk\u0011a\u0001a\"1\u0011QD\"A\u0002\u0019DqAa\bD\u0001\u0004\ti)\u0001\u0004pM\u001a\u001cX\r^\u0001\u000eC\u0012$G*\u001b8f\u000b:$7)\u00199\u0015\u000b}\u0014)C!\u000b\t\u000f\t\u001dB\t1\u0001\u0002h\u0005\u0011\u0001\u000f\r\u0005\b\u0005W!\u0005\u0019AA4\u0003\t\u0001\u0018'\u0001\u0007bI\u0012l\u0015\u000e\u001e:f\u0015>Lg\u000eF\u0005\u0000\u0005c\u0011\u0019D!\u000e\u00038!9\u00111_#A\u0002\u0005\u001d\u0004bBAM\u000b\u0002\u0007\u0011Q\u0012\u0005\b\u0003;+\u0005\u0019AAG\u0011\u0019\ti\"\u0012a\u0001M\u0006\u0019\u0012\r\u001a3MS6LG/\u001a3NSR\u0014XMS8j]RIqP!\u0010\u0003@\t\u0005#1\t\u0005\b\u000333\u0005\u0019AAG\u0011\u001d\tiJ\u0012a\u0001\u0003\u001bCa!!\bG\u0001\u00041\u0007B\u0002B#\r\u0002\u0007a-\u0001\u0006nSR\u0014X\rT5nSR\fA\"\u00193e\u0005\u00164X\r\u001c&pS:$Ra B&\u0005\u001bBq!!'H\u0001\u0004\ti\tC\u0004\u0002\u001e\u001e\u0003\r!!$\u0002\u001f\u0005$GmQ8s]\u0016\u0014h)\u001b7mKR$2b B*\u0005+\u00129F!\u0017\u0003^!9\u00111\u001f%A\u0002\u0005\u001d\u0004b\u0002B\u0014\u0011\u0002\u0007\u0011q\r\u0005\b\u0005WA\u0005\u0019AA4\u0011\u0019\u0011Y\u0006\u0013a\u0001a\u0006IA-\u001b:fGRLwN\u001c\u0005\u0007\u0005?B\u0005\u0019\u00014\u0002\rI\fG-[;t\u0003E\tG\r\u001a#je\u0016\u001cG/\u001a3GS2dW\r\u001e\u000b\f\u007f\n\u0015$q\rB6\u0005_\u0012\t\bC\u0004\u0002t&\u0003\r!a\u001a\t\r\t%\u0014\n1\u0001g\u0003)\u0019H/\u0019:u\u0003:<G.\u001a\u0005\u0007\u0005[J\u0005\u0019\u00014\u0002\u0011\u0015tG-\u00118hY\u0016DaAa\u0017J\u0001\u0004\u0001\bB\u0002B0\u0013\u0002\u0007a-\u0001\u0007de\u0016\fG/Z\"je\u000edW\rF\u0002\u0000\u0005oBq!a=K\u0001\u0004\t9'\u0001\u0007de\u0016\fG/Z*rk\u0006\u0014X\rF\u0002\u0000\u0005{Bq!a=L\u0001\u0004\t9\u0007")
public class OffsetSegmentGenerator {
    private PrecisionModel precisionModel;
    private BufferParameters bufParams;
    private double distance;
    private final RobustLineIntersector li;
    private final double filletAngleQuantum;
    private int closingSegLengthFactor;
    private OffsetSegmentString segList;
    private Coordinate s0;
    private Coordinate s1;
    private Coordinate s2;
    private final LineSegment seg0;
    private final LineSegment seg1;
    private final LineSegment offset0;
    private final LineSegment offset1;
    private int side;
    private boolean vhasNarrowConcaveAngle;
    private volatile int bitmap$init$0;

    public PrecisionModel precisionModel() {
        return this.precisionModel;
    }

    public void precisionModel_$eq(PrecisionModel x$1) {
        this.precisionModel = x$1;
    }

    public BufferParameters bufParams() {
        return this.bufParams;
    }

    public void bufParams_$eq(BufferParameters x$1) {
        this.bufParams = x$1;
    }

    public double distance() {
        return this.distance;
    }

    public void distance_$eq(double x$1) {
        this.distance = x$1;
    }

    private RobustLineIntersector li() {
        if ((this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 67");
        }
        return this.li;
    }

    private double filletAngleQuantum() {
        if ((this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 72");
        }
        return this.filletAngleQuantum;
    }

    private int closingSegLengthFactor() {
        if ((this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 73");
        }
        return this.closingSegLengthFactor;
    }

    private void closingSegLengthFactor_$eq(int x$1) {
        this.closingSegLengthFactor = x$1;
        this.bitmap$init$0 |= 4;
    }

    private OffsetSegmentString segList() {
        if ((this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 100");
        }
        return this.segList;
    }

    private void segList_$eq(OffsetSegmentString x$1) {
        this.segList = x$1;
        this.bitmap$init$0 |= 8;
    }

    private Coordinate s0() {
        if ((this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 101");
        }
        return this.s0;
    }

    private void s0_$eq(Coordinate x$1) {
        this.s0 = x$1;
        this.bitmap$init$0 |= 0x10;
    }

    private Coordinate s1() {
        if ((this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 102");
        }
        return this.s1;
    }

    private void s1_$eq(Coordinate x$1) {
        this.s1 = x$1;
        this.bitmap$init$0 |= 0x20;
    }

    private Coordinate s2() {
        if ((this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 103");
        }
        return this.s2;
    }

    private void s2_$eq(Coordinate x$1) {
        this.s2 = x$1;
        this.bitmap$init$0 |= 0x40;
    }

    private LineSegment seg0() {
        if ((this.bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 104");
        }
        return this.seg0;
    }

    private LineSegment seg1() {
        if ((this.bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 105");
        }
        return this.seg1;
    }

    private LineSegment offset0() {
        if ((this.bitmap$init$0 & 0x200) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 106");
        }
        return this.offset0;
    }

    private LineSegment offset1() {
        if ((this.bitmap$init$0 & 0x400) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 107");
        }
        return this.offset1;
    }

    private int side() {
        if ((this.bitmap$init$0 & 0x800) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 108");
        }
        return this.side;
    }

    private void side_$eq(int x$1) {
        this.side = x$1;
        this.bitmap$init$0 |= 0x800;
    }

    private boolean vhasNarrowConcaveAngle() {
        if ((this.bitmap$init$0 & 0x1000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/OffsetSegmentGenerator.scala: 109");
        }
        return this.vhasNarrowConcaveAngle;
    }

    private void vhasNarrowConcaveAngle_$eq(boolean x$1) {
        this.vhasNarrowConcaveAngle = x$1;
        this.bitmap$init$0 |= 0x1000;
    }

    public boolean hasNarrowConcaveAngle() {
        return this.vhasNarrowConcaveAngle();
    }

    private void init(double distance) {
        this.distance_$eq(distance);
        this.segList_$eq(new OffsetSegmentString());
        this.segList().setPrecisionModel(this.precisionModel());
        this.segList().setMinimumVertexDistance(distance * OffsetSegmentGenerator$.MODULE$.org$locationtech$jts$operation$buffer$OffsetSegmentGenerator$$CURVE_VERTEX_SNAP_DISTANCE_FACTOR());
    }

    public void initSideSegments(Coordinate s1, Coordinate s2, int side) {
        this.s1_$eq(s1);
        this.s2_$eq(s2);
        this.side_$eq(side);
        this.seg1().setCoordinates(s1, s2);
        this.computeOffsetSegment(this.seg1(), side, this.distance(), this.offset1());
    }

    /*
     * WARNING - void declaration
     */
    public Coordinate[] getCoordinates() {
        void var1_1;
        Coordinate[] pts = this.segList().getCoordinates();
        return var1_1;
    }

    public void closeRing() {
        this.segList().closeRing();
    }

    public void addSegments(Coordinate[] pt, boolean isForward) {
        this.segList().addPts(pt, isForward);
    }

    public void addFirstSegment() {
        this.segList().addPt(this.offset1().p0());
    }

    public void addLastSegment() {
        this.segList().addPt(this.offset1().p1());
    }

    public void addNextSegment(Coordinate p, boolean addStartPoint) {
        boolean outsideTurn;
        this.s0_$eq(this.s1());
        this.s1_$eq(this.s2());
        this.s2_$eq(p);
        this.seg0().setCoordinates(this.s0(), this.s1());
        this.computeOffsetSegment(this.seg0(), this.side(), this.distance(), this.offset0());
        this.seg1().setCoordinates(this.s1(), this.s2());
        this.computeOffsetSegment(this.seg1(), this.side(), this.distance(), this.offset1());
        Coordinate coordinate = this.s1();
        Coordinate coordinate2 = this.s2();
        if (!(coordinate != null ? !((Object)coordinate).equals(coordinate2) : coordinate2 != null)) {
            return;
        }
        int orientation = Orientation$.MODULE$.index(this.s0(), this.s1(), this.s2());
        boolean bl = outsideTurn = orientation == Orientation$.MODULE$.CLOCKWISE() && this.side() == Position$.MODULE$.LEFT() || orientation == Orientation$.MODULE$.COUNTERCLOCKWISE() && this.side() == Position$.MODULE$.RIGHT();
        if (orientation == 0) {
            this.addCollinear(addStartPoint);
        } else if (outsideTurn) {
            this.addOutsideTurn(orientation, addStartPoint);
        } else {
            this.addInsideTurn(orientation, addStartPoint);
        }
    }

    private void addCollinear(boolean addStartPoint) {
        block3: {
            this.li().computeIntersection(this.s0(), this.s1(), this.s1(), this.s2());
            int numInt = this.li().getIntersectionNum();
            if (numInt < 2) break block3;
            if (this.bufParams().getJoinStyle() == BufferParameters$.MODULE$.JOIN_BEVEL() || this.bufParams().getJoinStyle() == BufferParameters$.MODULE$.JOIN_MITRE()) {
                if (addStartPoint) {
                    this.segList().addPt(this.offset0().p1());
                }
                this.segList().addPt(this.offset1().p0());
            } else {
                this.addCornerFillet(this.s1(), this.offset0().p1(), this.offset1().p0(), Orientation$.MODULE$.CLOCKWISE(), this.distance());
            }
        }
    }

    private void addOutsideTurn(int orientation, boolean addStartPoint) {
        if (this.offset0().p1().distance(this.offset1().p0()) < this.distance() * OffsetSegmentGenerator$.MODULE$.org$locationtech$jts$operation$buffer$OffsetSegmentGenerator$$OFFSET_SEGMENT_SEPARATION_FACTOR()) {
            this.segList().addPt(this.offset0().p1());
            return;
        }
        if (this.bufParams().getJoinStyle() == BufferParameters$.MODULE$.JOIN_MITRE()) {
            this.addMitreJoin(this.s1(), this.offset0(), this.offset1(), this.distance());
        } else if (this.bufParams().getJoinStyle() == BufferParameters$.MODULE$.JOIN_BEVEL()) {
            this.addBevelJoin(this.offset0(), this.offset1());
        } else {
            if (addStartPoint) {
                this.segList().addPt(this.offset0().p1());
            }
            this.addCornerFillet(this.s1(), this.offset0().p1(), this.offset1().p0(), orientation, this.distance());
            this.segList().addPt(this.offset1().p0());
        }
    }

    private void addInsideTurn(int orientation, boolean addStartPoint) {
        this.li().computeIntersection(this.offset0().p0(), this.offset0().p1(), this.offset1().p0(), this.offset1().p1());
        if (this.li().hasIntersection()) {
            this.segList().addPt(this.li().getIntersection(0));
        } else {
            this.vhasNarrowConcaveAngle_$eq(true);
            if (this.offset0().p1().distance(this.offset1().p0()) < this.distance() * OffsetSegmentGenerator$.MODULE$.org$locationtech$jts$operation$buffer$OffsetSegmentGenerator$$INSIDE_TURN_VERTEX_SNAP_DISTANCE_FACTOR()) {
                this.segList().addPt(this.offset0().p1());
            } else {
                this.segList().addPt(this.offset0().p1());
                if (this.closingSegLengthFactor() > 0) {
                    Coordinate mid0 = new Coordinate(((double)this.closingSegLengthFactor() * this.offset0().p1().x() + this.s1().x()) / (double)(this.closingSegLengthFactor() + 1), ((double)this.closingSegLengthFactor() * this.offset0().p1().y() + this.s1().y()) / (double)(this.closingSegLengthFactor() + 1));
                    this.segList().addPt(mid0);
                    Coordinate mid1 = new Coordinate(((double)this.closingSegLengthFactor() * this.offset1().p0().x() + this.s1().x()) / (double)(this.closingSegLengthFactor() + 1), ((double)this.closingSegLengthFactor() * this.offset1().p0().y() + this.s1().y()) / (double)(this.closingSegLengthFactor() + 1));
                    this.segList().addPt(mid1);
                } else {
                    this.segList().addPt(this.s1());
                }
                this.segList().addPt(this.offset1().p0());
            }
        }
    }

    private void computeOffsetSegment(LineSegment seg, int side, double distance, LineSegment offset) {
        int sideSign = side == Position$.MODULE$.LEFT() ? 1 : -1;
        double dx = seg.p1().x() - seg.p0().x();
        double dy = seg.p1().y() - seg.p0().y();
        double len = Math.sqrt(dx * dx + dy * dy);
        double ux = (double)sideSign * distance * dx / len;
        double uy = (double)sideSign * distance * dy / len;
        offset.p0().x_$eq(seg.p0().x() - uy);
        offset.p0().y_$eq(seg.p0().y() + ux);
        offset.p1().x_$eq(seg.p1().x() - uy);
        offset.p1().y_$eq(seg.p1().y() + ux);
    }

    public void addLineEndCap(Coordinate p0, Coordinate p1) {
        LineSegment seg = new LineSegment(p0, p1);
        LineSegment offsetL = new LineSegment();
        this.computeOffsetSegment(seg, Position$.MODULE$.LEFT(), this.distance(), offsetL);
        LineSegment offsetR = new LineSegment();
        this.computeOffsetSegment(seg, Position$.MODULE$.RIGHT(), this.distance(), offsetR);
        double dx = p1.x() - p0.x();
        double dy = p1.y() - p0.y();
        double angle = Math.atan2(dy, dx);
        int n = this.bufParams().getEndCapStyle();
        if (BufferParameters$.MODULE$.CAP_ROUND() == n) {
            this.segList().addPt(offsetL.p1());
            this.addDirectedFillet(p1, angle + 1.5707963267948966, angle - 1.5707963267948966, Orientation$.MODULE$.CLOCKWISE(), this.distance());
            this.segList().addPt(offsetR.p1());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BufferParameters$.MODULE$.CAP_FLAT() == n) {
            this.segList().addPt(offsetL.p1());
            this.segList().addPt(offsetR.p1());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BufferParameters$.MODULE$.CAP_SQUARE() == n) {
            Coordinate squareCapSideOffset = new Coordinate();
            squareCapSideOffset.x_$eq(Math.abs(this.distance()) * Math.cos(angle));
            squareCapSideOffset.y_$eq(Math.abs(this.distance()) * Math.sin(angle));
            Coordinate squareCapLOffset = new Coordinate(offsetL.p1().x() + squareCapSideOffset.x(), offsetL.p1().y() + squareCapSideOffset.y());
            Coordinate squareCapROffset = new Coordinate(offsetR.p1().x() + squareCapSideOffset.x(), offsetR.p1().y() + squareCapSideOffset.y());
            this.segList().addPt(squareCapLOffset);
            this.segList().addPt(squareCapROffset);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
    }

    private void addMitreJoin(Coordinate p, LineSegment offset0, LineSegment offset1, double distance) {
        Coordinate intPt = Intersection$.MODULE$.intersection(offset0.p0(), offset0.p1(), offset1.p0(), offset1.p1());
        if (intPt != null) {
            double mitreRatio;
            double d = mitreRatio = distance <= 0.0 ? 1.0 : intPt.distance(p) / Math.abs(distance);
            if (mitreRatio <= this.bufParams().getMitreLimit()) {
                this.segList().addPt(intPt);
                return;
            }
        }
        this.addLimitedMitreJoin(offset0, offset1, distance, this.bufParams().getMitreLimit());
    }

    private void addLimitedMitreJoin(LineSegment offset0, LineSegment offset1, double distance, double mitreLimit) {
        Coordinate basePt = this.seg0().p1();
        double ang0 = Angle$.MODULE$.angle(basePt, this.seg0().p0());
        double angDiff = Angle$.MODULE$.angleBetweenOriented(this.seg0().p0(), basePt, this.seg1().p1());
        double angDiffHalf = angDiff / (double)2;
        double midAng = Angle$.MODULE$.normalize(ang0 + angDiffHalf);
        double mitreMidAng = Angle$.MODULE$.normalize(midAng + Math.PI);
        double mitreDist = mitreLimit * distance;
        double bevelDelta = mitreDist * Math.abs(Math.sin(angDiffHalf));
        double bevelHalfLen = distance - bevelDelta;
        double bevelMidX = basePt.x() + mitreDist * Math.cos(mitreMidAng);
        double bevelMidY = basePt.y() + mitreDist * Math.sin(mitreMidAng);
        Coordinate bevelMidPt = new Coordinate(bevelMidX, bevelMidY);
        LineSegment mitreMidLine = new LineSegment(basePt, bevelMidPt);
        Coordinate bevelEndLeft = mitreMidLine.pointAlongOffset(1.0, bevelHalfLen);
        Coordinate bevelEndRight = mitreMidLine.pointAlongOffset(1.0, -bevelHalfLen);
        if (this.side() == Position$.MODULE$.LEFT()) {
            this.segList().addPt(bevelEndLeft);
            this.segList().addPt(bevelEndRight);
        } else {
            this.segList().addPt(bevelEndRight);
            this.segList().addPt(bevelEndLeft);
        }
    }

    private void addBevelJoin(LineSegment offset0, LineSegment offset1) {
        this.segList().addPt(offset0.p1());
        this.segList().addPt(offset1.p0());
    }

    private void addCornerFillet(Coordinate p, Coordinate p0, Coordinate p1, int direction, double radius) {
        double dx0 = p0.x() - p.x();
        double dy0 = p0.y() - p.y();
        double startAngle = Math.atan2(dy0, dx0);
        double dx1 = p1.x() - p.x();
        double dy1 = p1.y() - p.y();
        double endAngle = Math.atan2(dy1, dx1);
        if (direction == Orientation$.MODULE$.CLOCKWISE()) {
            if (startAngle <= endAngle) {
                startAngle += Math.PI * 2;
            } else if (startAngle >= endAngle) {
                startAngle -= Math.PI * 2;
            }
        }
        this.segList().addPt(p0);
        this.addDirectedFillet(p, startAngle, endAngle, direction, radius);
        this.segList().addPt(p1);
    }

    private void addDirectedFillet(Coordinate p, double startAngle, double endAngle, int direction, double radius) {
        int directionFactor = direction == Orientation$.MODULE$.CLOCKWISE() ? -1 : 1;
        double totalAngle = Math.abs(startAngle - endAngle);
        int nSegs = (int)(totalAngle / this.filletAngleQuantum() + 0.5);
        if (nSegs < 1) {
            return;
        }
        double angleInc = totalAngle / (double)nSegs;
        Coordinate pt = new Coordinate();
        for (int i = 0; i < nSegs; ++i) {
            double angle = startAngle + (double)(directionFactor * i) * angleInc;
            pt.x_$eq(p.x() + radius * Math.cos(angle));
            pt.y_$eq(p.y() + radius * Math.sin(angle));
            this.segList().addPt(pt);
        }
    }

    public void createCircle(Coordinate p) {
        Coordinate pt = new Coordinate(p.x() + this.distance(), p.y());
        this.segList().addPt(pt);
        this.addDirectedFillet(p, 0.0, Math.PI * 2, -1, this.distance());
        this.segList().closeRing();
    }

    public void createSquare(Coordinate p) {
        this.segList().addPt(new Coordinate(p.x() + this.distance(), p.y() + this.distance()));
        this.segList().addPt(new Coordinate(p.x() + this.distance(), p.y() - this.distance()));
        this.segList().addPt(new Coordinate(p.x() - this.distance(), p.y() - this.distance()));
        this.segList().addPt(new Coordinate(p.x() - this.distance(), p.y() + this.distance()));
        this.segList().closeRing();
    }

    public OffsetSegmentGenerator(PrecisionModel precisionModel, BufferParameters bufParams, double distance) {
        this.precisionModel = precisionModel;
        this.bufParams = bufParams;
        this.distance = distance;
        this.li = new RobustLineIntersector();
        this.bitmap$init$0 |= 1;
        this.filletAngleQuantum = 1.5707963267948966 / (double)this.bufParams().getQuadrantSegments();
        this.bitmap$init$0 |= 2;
        this.closingSegLengthFactor = 1;
        this.bitmap$init$0 |= 4;
        if (this.bufParams().getQuadrantSegments() >= 8 && this.bufParams().getJoinStyle() == BufferParameters$.MODULE$.JOIN_ROUND()) {
            this.closingSegLengthFactor_$eq(OffsetSegmentGenerator$.MODULE$.org$locationtech$jts$operation$buffer$OffsetSegmentGenerator$$MAX_CLOSING_SEG_LEN_FACTOR());
        }
        this.init(this.distance());
        this.segList = null;
        this.bitmap$init$0 |= 8;
        this.s0 = null;
        this.bitmap$init$0 |= 0x10;
        this.s1 = null;
        this.bitmap$init$0 |= 0x20;
        this.s2 = null;
        this.bitmap$init$0 |= 0x40;
        this.seg0 = new LineSegment();
        this.bitmap$init$0 |= 0x80;
        this.seg1 = new LineSegment();
        this.bitmap$init$0 |= 0x100;
        this.offset0 = new LineSegment();
        this.bitmap$init$0 |= 0x200;
        this.offset1 = new LineSegment();
        this.bitmap$init$0 |= 0x400;
        this.side = 0;
        this.bitmap$init$0 |= 0x800;
        this.vhasNarrowConcaveAngle = false;
        this.bitmap$init$0 |= 0x1000;
    }
}

