/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.Position$;
import org.locationtech.jts.operation.buffer.BufferSubgraph;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]s!B\r\u001b\u0011\u0003)c!B\u0014\u001b\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001d!B\u0019\u0002\u0001i\u0011\u0004\u0002C\u001f\u0004\u0005\u000b\u0007I\u0011\u0001 \t\u0011\u0015\u001b!\u0011!Q\u0001\n}B\u0001BR\u0002\u0003\u0002\u0004%\ta\u0012\u0005\t\u0017\u000e\u0011\t\u0019!C\u0001\u0019\"A!k\u0001B\u0001B\u0003&\u0001\nC\u00030\u0007\u0011\u00051\u000bC\u0004W\u0007\t\u0007I\u0011\u0001 \t\r]\u001b\u0001\u0015!\u0003@\u0011\u0015A6\u0001\"\u0011Z\u0011\u0015a6\u0001\"\u0011^\r\u00119#\u0004A5\t\u0011)t!\u00111A\u0005\u0002-D\u0001\"\u001e\b\u0003\u0002\u0004%\tA\u001e\u0005\tq:\u0011\t\u0011)Q\u0005Y\")qF\u0004C\u0001s\"9QH\u0004b\u0001\n\u0013q\u0004BB#\u000fA\u0003%q\bC\u0003}\u001d\u0011\u0005Q\u0010C\u0004\u0002\b9!I!!\u0003\t\u000f\u0005\u001da\u0002\"\u0003\u0002.!9\u0011q\u0001\b\u0005\n\u00055\u0013\u0001F*vE\u001e\u0014\u0018\r\u001d5EKB$\b\u000eT8dCR,'O\u0003\u0002\u001c9\u00051!-\u001e4gKJT!!\b\u0010\u0002\u0013=\u0004XM]1uS>t'BA\u0010!\u0003\rQGo\u001d\u0006\u0003C\t\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011aI\u0001\u0004_J<7\u0001\u0001\t\u0003M\u0005i\u0011A\u0007\u0002\u0015'V\u0014wM]1qQ\u0012+\u0007\u000f\u001e5M_\u000e\fG/\u001a:\u0014\u0005\u0005I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002K\taA)\u001a9uQN+w-\\3oiN\u00191!K\u001a\u0011\u0007QJ4(D\u00016\u0015\t1t'\u0001\u0003mC:<'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012!bQ8na\u0006\u0014\u0018M\u00197f!\ta4!D\u0001\u0002\u0003\r\u0019XmZ\u000b\u0002\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!IH\u0001\u0005O\u0016|W.\u0003\u0002E\u0003\nYA*\u001b8f'\u0016<W.\u001a8u\u0003\u0011\u0019Xm\u001a\u0011\u0002\u00131,g\r\u001e#faRDW#\u0001%\u0011\u0005)J\u0015B\u0001&,\u0005\rIe\u000e^\u0001\u000eY\u00164G\u000fR3qi\"|F%Z9\u0015\u00055\u0003\u0006C\u0001\u0016O\u0013\ty5F\u0001\u0003V]&$\bbB)\b\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\n\u0014A\u00037fMR$U\r\u001d;iAQ\u00191\bV+\t\u000buJ\u0001\u0019A \t\u000b\u0019K\u0001\u0019\u0001%\u0002\u0013U\u0004x/\u0019:e'\u0016<\u0017AC;qo\u0006\u0014HmU3hA\u0005I1m\\7qCJ,Gk\u001c\u000b\u0003\u0011jCQa\u0017\u0007A\u0002m\nQa\u001c;iKJ\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002=B\u0011qL\u001a\b\u0003A\u0012\u0004\"!Y\u0016\u000e\u0003\tT!a\u0019\u0013\u0002\rq\u0012xn\u001c;?\u0013\t)7&\u0001\u0004Qe\u0016$WMZ\u0005\u0003O\"\u0014aa\u0015;sS:<'BA3,'\tq\u0011&A\u0005tk\n<'/\u00199igV\tA\u000eE\u0002naJl\u0011A\u001c\u0006\u0003_^\nA!\u001e;jY&\u0011\u0011O\u001c\u0002\u000b\u0007>dG.Z2uS>t\u0007C\u0001\u0014t\u0013\t!(D\u0001\bCk\u001a4WM]*vE\u001e\u0014\u0018\r\u001d5\u0002\u001bM,(m\u001a:ba\"\u001cx\fJ3r)\tiu\u000fC\u0004R!\u0005\u0005\t\u0019\u00017\u0002\u0015M,(m\u001a:ba\"\u001c\b\u0005\u0006\u0002{wB\u0011aE\u0004\u0005\u0006UJ\u0001\r\u0001\\\u0001\tO\u0016$H)\u001a9uQR\u0011\u0001J \u0005\u0007\u007fV\u0001\r!!\u0001\u0002\u0003A\u00042\u0001QA\u0002\u0013\r\t)!\u0011\u0002\u000b\u0007>|'\u000fZ5oCR,\u0017a\u00054j]\u0012\u001cF/\u00192cK\u0012\u001cVmZ7f]R\u001cH\u0003BA\u0006\u0003S\u0001R!\\A\u0007\u0003#I1!a\u0004o\u0005\u0011a\u0015n\u001d;\u0011\u0007\u0005M1AD\u0002\u0002\u0016\u0001qA!a\u0006\u0002(9!\u0011\u0011DA\u0013\u001d\u0011\tY\"a\t\u000f\t\u0005u\u0011\u0011\u0005\b\u0004C\u0006}\u0011\"A\u0012\n\u0005\u0005\u0012\u0013BA\u0010!\u0013\tib$\u0003\u0002\u001c9!9\u00111\u0006\fA\u0002\u0005\u0005\u0011!E:uC\n\u0014\u0017N\\4SCfdUM\u001a;QiR9Q*a\f\u00022\u0005\r\u0003bBA\u0016/\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003g9\u0002\u0019AA\u001b\u0003!!\u0017N]#eO\u0016\u001c\b#B7\u0002\u000e\u0005]\u0002\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005ub$A\u0005hK>lwM]1qQ&!\u0011\u0011IA\u001e\u00051!\u0015N]3di\u0016$W\tZ4f\u0011\u001d\t)e\u0006a\u0001\u0003\u000f\nqb\u001d;bE\n,GmU3h[\u0016tGo\u001d\t\u0006[\u00065\u0011\u0011\n\t\u0004\u0003\u0017\u001aaB\u0001\u0014\u0001)\u001di\u0015qJA)\u0003+Bq!a\u000b\u0019\u0001\u0004\t\t\u0001C\u0004\u0002Ta\u0001\r!a\u000e\u0002\u000f\u0011L'/\u00123hK\"9\u0011Q\t\rA\u0002\u0005-\u0001")
public class SubgraphDepthLocater {
    private Collection<BufferSubgraph> subgraphs;
    private final LineSegment seg;
    private volatile boolean bitmap$init$0;

    public Collection<BufferSubgraph> subgraphs() {
        return this.subgraphs;
    }

    public void subgraphs_$eq(Collection<BufferSubgraph> x$1) {
        this.subgraphs = x$1;
    }

    private LineSegment seg() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/SubgraphDepthLocater.scala: 109");
        }
        return this.seg;
    }

    public int getDepth(Coordinate p) {
        List<DepthSegment> stabbedSegments = this.findStabbedSegments(p);
        if (stabbedSegments.size() == 0) {
            return 0;
        }
        DepthSegment ds = Collections.min(stabbedSegments);
        return ds.leftDepth();
    }

    /*
     * WARNING - void declaration
     */
    private List<DepthSegment> findStabbedSegments(Coordinate stabbingRayLeftPt) {
        void var2_2;
        ArrayList<DepthSegment> stabbedSegments = new ArrayList<DepthSegment>();
        for (BufferSubgraph bsg : this.subgraphs()) {
            Envelope env = bsg.getEnvelope();
            if (stabbingRayLeftPt.y() < env.getMinY() || stabbingRayLeftPt.y() > env.getMaxY()) continue;
            this.findStabbedSegments(stabbingRayLeftPt, bsg.getDirectedEdges(), stabbedSegments);
        }
        return var2_2;
    }

    private void findStabbedSegments(Coordinate stabbingRayLeftPt, List<DirectedEdge> dirEdges, List<DepthSegment> stabbedSegments) {
        for (DirectedEdge de : dirEdges) {
            if (!de.isForward()) continue;
            this.findStabbedSegments(stabbingRayLeftPt, de, stabbedSegments);
        }
    }

    private void findStabbedSegments(Coordinate stabbingRayLeftPt, DirectedEdge dirEdge, List<DepthSegment> stabbedSegments) {
        Coordinate[] pts = dirEdge.getEdge().getCoordinates();
        for (int i = 0; i < pts.length - 1; ++i) {
            Object object;
            double maxx;
            this.seg().p0_$eq(pts[i]);
            this.seg().p1_$eq(pts[i + 1]);
            if (this.seg().p0().y() > this.seg().p1().y()) {
                this.seg().reverse();
            }
            if ((maxx = Math.max(this.seg().p0().x(), this.seg().p1().x())) >= stabbingRayLeftPt.x()) {
                if (!this.seg().isHorizontal()) {
                    if (!(stabbingRayLeftPt.y() < this.seg().p0().y()) && !(stabbingRayLeftPt.y() > this.seg().p1().y())) {
                        if (Orientation$.MODULE$.index(this.seg().p0(), this.seg().p1(), stabbingRayLeftPt) != Orientation$.MODULE$.RIGHT()) {
                            int depth = dirEdge.getDepth(Position$.MODULE$.LEFT());
                            if (!this.seg().p0().equals(pts[i])) {
                                depth = dirEdge.getDepth(Position$.MODULE$.RIGHT());
                            }
                            DepthSegment ds = new DepthSegment(this.seg(), depth);
                            object = BoxesRunTime.boxToBoolean((boolean)stabbedSegments.add(ds));
                            continue;
                        }
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    object = BoxedUnit.UNIT;
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
    }

    public SubgraphDepthLocater(Collection<BufferSubgraph> subgraphs) {
        this.subgraphs = subgraphs;
        this.seg = new LineSegment();
        this.bitmap$init$0 = true;
    }

    public static class DepthSegment
    implements Comparable<DepthSegment> {
        private final LineSegment seg;
        private int leftDepth;
        private final LineSegment upwardSeg;
        private volatile boolean bitmap$init$0;

        public LineSegment seg() {
            return this.seg;
        }

        public int leftDepth() {
            return this.leftDepth;
        }

        public void leftDepth_$eq(int x$1) {
            this.leftDepth = x$1;
        }

        public LineSegment upwardSeg() {
            if (!this.bitmap$init$0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/SubgraphDepthLocater.scala: 40");
            }
            return this.upwardSeg;
        }

        @Override
        public int compareTo(DepthSegment other) {
            if (this.upwardSeg().minX() >= other.upwardSeg().maxX()) {
                return 1;
            }
            if (this.upwardSeg().maxX() <= other.upwardSeg().minX()) {
                return -1;
            }
            int orientIndex = this.upwardSeg().orientationIndex(other.upwardSeg());
            if (orientIndex != 0) {
                return orientIndex;
            }
            orientIndex = -1 * other.upwardSeg().orientationIndex(this.upwardSeg());
            if (orientIndex != 0) {
                return orientIndex;
            }
            return this.upwardSeg().compareTo(other.upwardSeg());
        }

        public String toString() {
            return this.upwardSeg().toString();
        }

        public DepthSegment(LineSegment seg, int leftDepth) {
            this.seg = seg;
            this.leftDepth = leftDepth;
            this.upwardSeg = new LineSegment(seg);
            this.bitmap$init$0 = true;
        }
    }
}

