/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.buffer.VariableBuffer;
import scala.UninitializedFieldError;

public final class VariableBuffer$ {
    public static final VariableBuffer$ MODULE$ = new VariableBuffer$();
    private static final double SNAP_TRIG_TOL = 1.0E-6;
    private static volatile boolean bitmap$init$0 = true;

    public Geometry buffer(Geometry line, double startDistance, double endDistance) {
        double[] distance = this.interpolate((LineString)line, startDistance, endDistance);
        VariableBuffer vb = new VariableBuffer(line, distance);
        return vb.getResult();
    }

    public Geometry buffer(Geometry line, double startDistance, double midDistance, double endDistance) {
        double[] distance = this.interpolate((LineString)line, startDistance, midDistance, endDistance);
        VariableBuffer vb = new VariableBuffer(line, distance);
        return vb.getResult();
    }

    public Geometry buffer(Geometry line, double[] distance) {
        VariableBuffer vb = new VariableBuffer(line, distance);
        return vb.getResult();
    }

    private double[] interpolate(LineString line, double startValueArg, double endValueArg) {
        double startValue = Math.abs(startValueArg);
        double endValue = Math.abs(endValueArg);
        double[] values = new double[line.getNumPoints()];
        values[0] = startValue;
        values[values.length - 1] = endValue;
        double totalLen = line.getLength();
        Coordinate[] pts = line.getCoordinates();
        double currLen = 0.0;
        for (int i = 1; i < values.length - 1; ++i) {
            double segLen = pts[i].distance(pts[i - 1]);
            double lenFrac = (currLen += segLen) / totalLen;
            double delta = lenFrac * (endValue - startValue);
            values[i] = startValue + delta;
        }
        return values;
    }

    private double[] interpolate(LineString line, double startValueArg, double midValueArg, double endValueArg) {
        int i;
        double startValue = Math.abs(startValueArg);
        double midValue = Math.abs(midValueArg);
        double endValue = Math.abs(endValueArg);
        double[] values = new double[line.getNumPoints()];
        values[0] = startValue;
        values[values.length - 1] = endValue;
        Coordinate[] pts = line.getCoordinates();
        double lineLen = line.getLength();
        int midIndex = this.indexAtLength(pts, lineLen / (double)2);
        double delMidStart = midValue - startValue;
        double delEndMid = endValue - midValue;
        double lenSM = this.length(pts, 0, midIndex);
        double currLen = 0.0;
        for (i = 1; i <= midIndex; ++i) {
            double val;
            double segLen = pts[i].distance(pts[i - 1]);
            double lenFrac = (currLen += segLen) / lenSM;
            values[i] = val = startValue + lenFrac * delMidStart;
        }
        double lenME = this.length(pts, midIndex, pts.length - 1);
        currLen = 0.0;
        for (i = midIndex + 1; i < values.length - 1; ++i) {
            double val;
            double segLen = pts[i].distance(pts[i - 1]);
            double lenFrac = (currLen += segLen) / lenME;
            values[i] = val = midValue + lenFrac * delEndMid;
        }
        return values;
    }

    private int indexAtLength(Coordinate[] pts, double targetLen) {
        double len = 0.0;
        for (int i = 1; i < pts.length; ++i) {
            if (!((len += pts[i].distance(pts[i - 1])) > targetLen)) continue;
            return i;
        }
        return pts.length - 1;
    }

    private double length(Coordinate[] pts, int i1, int i2) {
        double len = 0.0;
        for (int i = i1 + 1; i <= i2; ++i) {
            len += pts[i].distance(pts[i - 1]);
        }
        return len;
    }

    public LineSegment org$locationtech$jts$operation$buffer$VariableBuffer$$outerTangent(Coordinate c1, double r1, Coordinate c2, double r2) {
        if (r1 > r2) {
            LineSegment seg = this.org$locationtech$jts$operation$buffer$VariableBuffer$$outerTangent(c2, r2, c1, r1);
            return new LineSegment(seg.p1(), seg.p0());
        }
        double x1 = c1.getX();
        double y1 = c1.getY();
        double x2 = c2.getX();
        double y2 = c2.getY();
        double a3 = -Math.atan2(y2 - y1, x2 - x1);
        double dr = r2 - r1;
        double d = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        double a2 = Math.asin(dr / d);
        if (Double.isNaN(a2)) {
            return null;
        }
        double a1 = a3 - a2;
        double aa = 1.5707963267948966 - a1;
        double x3 = x1 + r1 * Math.cos(aa);
        double y3 = y1 + r1 * Math.sin(aa);
        double x4 = x2 + r2 * Math.cos(aa);
        double y4 = y2 + r2 * Math.sin(aa);
        return new LineSegment(x3, y3, x4, y4);
    }

    public Coordinate org$locationtech$jts$operation$buffer$VariableBuffer$$projectPolar(Coordinate p, double r, double ang) {
        double x = p.getX() + r * this.snapTrig(Math.cos(ang));
        double y = p.getY() + r * this.snapTrig(Math.sin(ang));
        return new Coordinate(x, y);
    }

    private double SNAP_TRIG_TOL() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/VariableBuffer.scala: 255");
        }
        return SNAP_TRIG_TOL;
    }

    private double snapTrig(double x) {
        if (x > 1.0 - this.SNAP_TRIG_TOL()) {
            return 1.0;
        }
        if (x < (double)-1 + this.SNAP_TRIG_TOL()) {
            return -1.0;
        }
        if (Math.abs(x) < this.SNAP_TRIG_TOL()) {
            return 0.0;
        }
        return x;
    }

    private VariableBuffer$() {
    }
}

