/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import org.locationtech.jts.algorithm.Angle$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFactory$;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.buffer.BufferParameters$;
import org.locationtech.jts.operation.buffer.VariableBuffer$;
import scala.Array$;
import scala.UninitializedFieldError;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]v!\u0002\u0012$\u0011\u0003qc!\u0002\u0019$\u0011\u0003\t\u0004\"\u0002\u001d\u0002\t\u0003I\u0004\"\u0002\u0013\u0002\t\u0003Q\u0004\"\u0002\u0013\u0002\t\u0003Q\u0005\"\u0002\u0013\u0002\t\u0003\u0001\u0006\"B,\u0002\t\u0013A\u0006\"B,\u0002\t\u0013\t\u0007\"B4\u0002\t\u0013A\u0007\"\u0002;\u0002\t\u0013)\b\"B>\u0002\t\u0013a\bbBA\t\u0003\u0011%\u00111\u0003\u0005\n\u0003C\t!\u0019!C\u0005\u0003GAq!!\n\u0002A\u0003%Q\tC\u0004\u0002(\u0005!I!!\u000b\u0007\u000bA\u001a\u0003!a\f\t\u0015\u0005ErB!b\u0001\n\u0003\t\u0019\u0004C\u0005\u00026=\u0011\t\u0011)A\u0005w!I1k\u0004BA\u0002\u0013\u0005\u0011q\u0007\u0005\u000b\u0003sy!\u00111A\u0005\u0002\u0005m\u0002\"CA$\u001f\t\u0005\t\u0015)\u0003U\u0011\u0019At\u0002\"\u0001\u0002J!A!i\u0004b\u0001\n\u0013\t\t\u0006C\u0004\u0002T=\u0001\u000b\u0011\u0002.\t\u0013\u0005UsB1A\u0005\n\u0005]\u0003\u0002CA0\u001f\u0001\u0006I!!\u0017\t\u0013\u0005\u0005tB1A\u0005\n\u0005\r\u0004bBA3\u001f\u0001\u0006I!\u001b\u0005\b\u0003OzA\u0011AA\u001a\u0011\u001d\tIg\u0004C\u0005\u0003WBq!a!\u0010\t\u0013\t)\tC\u0004\u0002\u0010>!I!!%\t\u000f\u0005%v\u0002\"\u0003\u0002,\"9\u0011\u0011W\b\u0005\n\u0005M\u0016A\u0004,be&\f'\r\\3Ck\u001a4WM\u001d\u0006\u0003I\u0015\naAY;gM\u0016\u0014(B\u0001\u0014(\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002)S\u0005\u0019!\u000e^:\u000b\u0005)Z\u0013\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005=\nQ\"A\u0012\u0003\u001dY\u000b'/[1cY\u0016\u0014UO\u001a4feN\u0011\u0011A\r\t\u0003gYj\u0011\u0001\u000e\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\u000e\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005qC\u0003B\u001eB\u0007\"\u0003\"\u0001P \u000e\u0003uR!AP\u0014\u0002\t\u001d,w.\\\u0005\u0003\u0001v\u0012\u0001bR3p[\u0016$(/\u001f\u0005\u0006\u0005\u000e\u0001\raO\u0001\u0005Y&tW\rC\u0003E\u0007\u0001\u0007Q)A\u0007ti\u0006\u0014H\u000fR5ti\u0006t7-\u001a\t\u0003g\u0019K!a\u0012\u001b\u0003\r\u0011{WO\u00197f\u0011\u0015I5\u00011\u0001F\u0003-)g\u000e\u001a#jgR\fgnY3\u0015\u000bmZE*T(\t\u000b\t#\u0001\u0019A\u001e\t\u000b\u0011#\u0001\u0019A#\t\u000b9#\u0001\u0019A#\u0002\u00175LG\rR5ti\u0006t7-\u001a\u0005\u0006\u0013\u0012\u0001\r!\u0012\u000b\u0004wE\u0013\u0006\"\u0002\"\u0006\u0001\u0004Y\u0004\"B*\u0006\u0001\u0004!\u0016\u0001\u00033jgR\fgnY3\u0011\u0007M*V)\u0003\u0002Wi\t)\u0011I\u001d:bs\u0006Y\u0011N\u001c;feB|G.\u0019;f)\u0011!\u0016,X0\t\u000b\t3\u0001\u0019\u0001.\u0011\u0005qZ\u0016B\u0001/>\u0005)a\u0015N\\3TiJLgn\u001a\u0005\u0006=\u001a\u0001\r!R\u0001\u000egR\f'\u000f\u001e,bYV,\u0017I]4\t\u000b\u00014\u0001\u0019A#\u0002\u0017\u0015tGMV1mk\u0016\f%o\u001a\u000b\u0006)\n\u001cGM\u001a\u0005\u0006\u0005\u001e\u0001\rA\u0017\u0005\u0006=\u001e\u0001\r!\u0012\u0005\u0006K\u001e\u0001\r!R\u0001\f[&$g+\u00197vK\u0006\u0013x\rC\u0003a\u000f\u0001\u0007Q)A\u0007j]\u0012,\u00070\u0011;MK:<G\u000f\u001b\u000b\u0004S2\u0014\bCA\u001ak\u0013\tYGGA\u0002J]RDQ!\u001c\u0005A\u00029\f1\u0001\u001d;t!\r\u0019Tk\u001c\t\u0003yAL!!]\u001f\u0003\u0015\r{wN\u001d3j]\u0006$X\rC\u0003t\u0011\u0001\u0007Q)A\u0005uCJ<W\r\u001e'f]\u00061A.\u001a8hi\"$B!\u0012<xs\")Q.\u0003a\u0001]\")\u00010\u0003a\u0001S\u0006\u0011\u0011.\r\u0005\u0006u&\u0001\r![\u0001\u0003SJ\nAb\\;uKJ$\u0016M\\4f]R$\u0012\"`A\u0001\u0003\u000b\tI!!\u0004\u0011\u0005qr\u0018BA@>\u0005-a\u0015N\\3TK\u001elWM\u001c;\t\r\u0005\r!\u00021\u0001p\u0003\t\u0019\u0017\u0007\u0003\u0004\u0002\b)\u0001\r!R\u0001\u0003eFBa!a\u0003\u000b\u0001\u0004y\u0017AA23\u0011\u0019\tyA\u0003a\u0001\u000b\u0006\u0011!OM\u0001\raJ|'.Z2u!>d\u0017M\u001d\u000b\b_\u0006U\u0011\u0011DA\u000f\u0011\u0019\t9b\u0003a\u0001_\u0006\t\u0001\u000f\u0003\u0004\u0002\u001c-\u0001\r!R\u0001\u0002e\"1\u0011qD\u0006A\u0002\u0015\u000b1!\u00198h\u00035\u0019f*\u0011)`)JKui\u0018+P\u0019V\tQ)\u0001\bT\u001d\u0006\u0003v\f\u0016*J\u000f~#v\n\u0014\u0011\u0002\u0011Mt\u0017\r\u001d+sS\u001e$2!RA\u0016\u0011\u0019\tiC\u0004a\u0001\u000b\u0006\t\u0001p\u0005\u0002\u0010e\u00059A.\u001b8f\u0003J<W#A\u001e\u0002\u00111Lg.Z!sO\u0002*\u0012\u0001V\u0001\rI&\u001cH/\u00198dK~#S-\u001d\u000b\u0005\u0003{\t\u0019\u0005E\u00024\u0003\u007fI1!!\u00115\u0005\u0011)f.\u001b;\t\u0011\u0005\u00153#!AA\u0002Q\u000b1\u0001\u001f\u00132\u0003%!\u0017n\u001d;b]\u000e,\u0007\u0005\u0006\u0004\u0002L\u00055\u0013q\n\t\u0003_=Aa!!\r\u0016\u0001\u0004Y\u0004\"B*\u0016\u0001\u0004!V#\u0001.\u0002\u000b1Lg.\u001a\u0011\u0002\u0017\u001d,w.\u001c$bGR|'/_\u000b\u0003\u00033\u00022\u0001PA.\u0013\r\ti&\u0010\u0002\u0010\u000f\u0016|W.\u001a;ss\u001a\u000b7\r^8ss\u0006aq-Z8n\r\u0006\u001cGo\u001c:zA\u0005a\u0011/^1ee\u0006tGoU3hgV\t\u0011.A\u0007rk\u0006$'/\u00198u'\u0016<7\u000fI\u0001\nO\u0016$(+Z:vYR\fQb]3h[\u0016tGOQ;gM\u0016\u0014HCCA7\u0003g\n9(a\u001f\u0002\u0000A\u0019A(a\u001c\n\u0007\u0005ETHA\u0004Q_2Lxm\u001c8\t\r\u0005UT\u00041\u0001p\u0003\t\u0001\b\u0007\u0003\u0004\u0002zu\u0001\ra\\\u0001\u0003aFBa!! \u001e\u0001\u0004)\u0015!\u00023jgR\u0004\u0004BBAA;\u0001\u0007Q)A\u0003eSN$\u0018'\u0001\u0004dSJ\u001cG.\u001a\u000b\u0007\u0003[\n9)a#\t\r\u0005%e\u00041\u0001p\u0003\u0019\u0019WM\u001c;fe\"1\u0011Q\u0012\u0010A\u0002\u0015\u000baA]1eSV\u001c\u0018AB1eI\u000e\u000b\u0007\u000f\u0006\u0007\u0002>\u0005M\u0015QSAL\u00037\u000by\n\u0003\u0004\u0002\u0018}\u0001\ra\u001c\u0005\u0007\u00037y\u0002\u0019A#\t\r\u0005eu\u00041\u0001p\u0003\t!\u0018\u0007\u0003\u0004\u0002\u001e~\u0001\ra\\\u0001\u0003iJBq!!) \u0001\u0004\t\u0019+\u0001\u0004d_>\u0014Hm\u001d\t\u0004y\u0005\u0015\u0016bAAT{\tq1i\\8sI&t\u0017\r^3MSN$\u0018\u0001C2ba\u0006sw\r\\3\u0015\u0007\u0015\u000bi\u000b\u0003\u0004\u00020\u0002\u0002\r![\u0001\u0006S:$W\r_\u0001\u000eG\u0006\u0004\u0018I\\4mK&sG-\u001a=\u0015\u0007%\f)\f\u0003\u0004\u0002 \u0005\u0002\r!\u0012")
public class VariableBuffer {
    private final Geometry lineArg;
    private double[] distance;
    private final LineString line;
    private final GeometryFactory geomFactory;
    private final int quadrantSegs;
    private volatile byte bitmap$init$0;

    public static Geometry buffer(Geometry geometry, double[] dArray) {
        return VariableBuffer$.MODULE$.buffer(geometry, dArray);
    }

    public static Geometry buffer(Geometry geometry, double d, double d2, double d3) {
        return VariableBuffer$.MODULE$.buffer(geometry, d, d2, d3);
    }

    public static Geometry buffer(Geometry geometry, double d, double d2) {
        return VariableBuffer$.MODULE$.buffer(geometry, d, d2);
    }

    public Geometry lineArg() {
        return this.lineArg;
    }

    public double[] distance() {
        return this.distance;
    }

    public void distance_$eq(double[] x$1) {
        this.distance = x$1;
    }

    private LineString line() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/VariableBuffer.scala: 280");
        }
        return this.line;
    }

    private GeometryFactory geomFactory() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/VariableBuffer.scala: 281");
        }
        return this.geomFactory;
    }

    private int quadrantSegs() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/VariableBuffer.scala: 282");
        }
        return this.quadrantSegs;
    }

    public Geometry getResult() {
        ArrayList<Polygon> parts = new ArrayList<Polygon>();
        Coordinate[] pts = this.line().getCoordinates();
        int i = 1;
        while (i < pts.length) {
            Polygon poly;
            double dist0 = this.distance()[i - 1];
            double dist1 = this.distance()[i];
            Object object = dist0 > 0.0 || dist1 > 0.0 ? ((poly = this.segmentBuffer(pts[i - 1], pts[i], dist0, dist1)) != null ? BoxesRunTime.boxToBoolean((boolean)parts.add(poly)) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
            int cfr_ignored_0 = ++i - 1;
        }
        GeometryCollection partsGeom = this.geomFactory().createGeometryCollection(GeometryFactory$.MODULE$.toGeometryArray(parts));
        Geometry buffer = partsGeom.union();
        if (buffer.isEmpty()) {
            return this.geomFactory().createPolygon();
        }
        return buffer;
    }

    private Polygon segmentBuffer(Coordinate p0, Coordinate p1, double dist0, double dist1) {
        if (dist0 > dist1) {
            return this.segmentBuffer(p1, p0, dist1, dist0);
        }
        LineSegment tangent = VariableBuffer$.MODULE$.org$locationtech$jts$operation$buffer$VariableBuffer$$outerTangent(p0, dist0, p1, dist1);
        if (tangent == null) {
            Coordinate center = p0;
            double dist = dist0;
            if (dist1 > dist0) {
                center = p1;
                dist = dist1;
            }
            return this.circle(center, dist);
        }
        Coordinate t0 = tangent.getCoordinate(0);
        Coordinate t1 = tangent.getCoordinate(1);
        LineSegment seg = new LineSegment(p0, p1);
        Coordinate tr0 = seg.reflect(t0);
        Coordinate tr1 = seg.reflect(t1);
        CoordinateList coords = new CoordinateList((Coordinate[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Coordinate.class)));
        coords.add(t0);
        coords.add(t1);
        this.addCap(p1, dist1, t1, tr1, coords);
        coords.add(tr1);
        coords.add(tr0);
        this.addCap(p0, dist0, tr0, t0, coords);
        coords.add(t0);
        Coordinate[] pts = coords.toCoordinateArray();
        Polygon polygon = this.geomFactory().createPolygon(pts);
        return polygon;
    }

    private Polygon circle(Coordinate center, double radius) {
        if (radius <= 0.0) {
            return null;
        }
        int nPts = 4 * this.quadrantSegs();
        Coordinate[] pts = new Coordinate[nPts + 1];
        double angInc = 1.5707963267948966 / (double)this.quadrantSegs();
        for (int i = 0; i < nPts; ++i) {
            pts[i] = VariableBuffer$.MODULE$.org$locationtech$jts$operation$buffer$VariableBuffer$$projectPolar(center, radius, (double)i * angInc);
        }
        pts[pts.length - 1] = pts[0].copy();
        return this.geomFactory().createPolygon(pts);
    }

    private void addCap(Coordinate p, double r, Coordinate t1, Coordinate t2, CoordinateList coords) {
        double angEnd;
        double angStart = Angle$.MODULE$.angle(p, t1);
        if (angStart < (angEnd = Angle$.MODULE$.angle(p, t2))) {
            angStart += Math.PI * 2;
        }
        int indexStart = this.capAngleIndex(angStart);
        int indexEnd = this.capAngleIndex(angEnd);
        for (int i = indexStart; i > indexEnd; --i) {
            double ang = this.capAngle(i);
            coords.add(VariableBuffer$.MODULE$.org$locationtech$jts$operation$buffer$VariableBuffer$$projectPolar(p, r, ang));
        }
    }

    private double capAngle(int index) {
        double capSegAng = 1.5707963267948966 / (double)this.quadrantSegs();
        return (double)index * capSegAng;
    }

    private int capAngleIndex(double ang) {
        double capSegAng = 1.5707963267948966 / (double)this.quadrantSegs();
        int index = (int)(ang / capSegAng);
        return index;
    }

    public VariableBuffer(Geometry lineArg, double[] distance) {
        this.lineArg = lineArg;
        this.distance = distance;
        if (this.distance().length != lineArg.getNumPoints()) {
            throw new IllegalArgumentException("Number of distances is not equal to number of vertices");
        }
        this.line = (LineString)lineArg;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.geomFactory = this.line().getFactory();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.quadrantSegs = BufferParameters$.MODULE$.DEFAULT_QUADRANT_SEGMENTS();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

