/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer.validate;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.buffer.validate.DistanceToPointFinder$;
import org.locationtech.jts.operation.buffer.validate.PointPairDistance;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]r!\u0002\u0014(\u0011\u0003!d!\u0002\u001c(\u0011\u00039\u0004\"\u0002 \u0002\t\u0003yd\u0001\u0002!\u0002\u0001\u0005C\u0001\"R\u0002\u0003\u0002\u0004%\t\u0001\u0013\u0005\t\u0019\u000e\u0011\t\u0019!C\u0001\u001b\"A1k\u0001B\u0001B\u0003&\u0011\nC\u0003?\u0007\u0011\u0005A\u000bC\u0004Y\u0007\t\u0007I\u0011B-\t\ru\u001b\u0001\u0015!\u0003[\u0011\u001dq6A1A\u0005\neCaaX\u0002!\u0002\u0013Q\u0006\"\u00021\u0004\t\u0003\n\u0007\"B4\u0004\t\u0003If\u0001\u00025\u0002\u0001%D\u0001\"\u0012\b\u0003\u0002\u0004%\t\u0001\u0013\u0005\t\u0019:\u0011\t\u0019!C\u0001[\"A1K\u0004B\u0001B\u0003&\u0011\nC\u0003?\u001d\u0011\u0005q\u000eC\u0004Y\u001d\t\u0007I\u0011B-\t\rus\u0001\u0015!\u0003[\u0011\u001dqfB1A\u0005\neCaa\u0018\b!\u0002\u0013Q\u0006\"\u00021\u000f\t\u0003\u0012\b\"B?\u000f\t\u0003r\bBBA\u0003\u001d\u0011\u0005c\u0010C\u0003h\u001d\u0011\u0005\u0011LB\u00037O\u0001\t9\u0001C\u0005\u0002\nm\u0011\t\u0019!C\u0001\u0011\"Q\u00111B\u000e\u0003\u0002\u0004%\t!!\u0004\t\u0013\u0005E1D!A!B\u0013I\u0005B\u0002 \u001c\t\u0003\t\u0019\u0002C\u0004Y7\t\u0007I\u0011B-\t\ru[\u0002\u0015!\u0003[\u0011\u001d\tIb\u0007C\u0001\u00037Aa!a\n\u001c\t\u0003I\u0006bBA\u00157\u0011%\u00111\u0006\u0005\b\u0003cYB\u0011BA\u001a\u0003\u0001\u0012UO\u001a4fe\u000e+(O^3NCbLW.^7ESN$\u0018M\\2f\r&tG-\u001a:\u000b\u0005!J\u0013\u0001\u0003<bY&$\u0017\r^3\u000b\u0005)Z\u0013A\u00022vM\u001a,'O\u0003\u0002-[\u0005Iq\u000e]3sCRLwN\u001c\u0006\u0003]=\n1A\u001b;t\u0015\t\u0001\u0014'\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u00013\u0003\ry'oZ\u0002\u0001!\t)\u0014!D\u0001(\u0005\u0001\u0012UO\u001a4fe\u000e+(O^3NCbLW.^7ESN$\u0018M\\2f\r&tG-\u001a:\u0014\u0005\u0005A\u0004CA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002i\t1R*\u0019=Q_&tG\u000fR5ti\u0006t7-\u001a$jYR,'oE\u0002\u0004q\t\u0003\"a\u0011$\u000e\u0003\u0011S!!R\u0017\u0002\t\u001d,w.\\\u0005\u0003\u000f\u0012\u0013\u0001cQ8pe\u0012Lg.\u0019;f\r&dG/\u001a:\u0016\u0003%\u0003\"a\u0011&\n\u0005-#%\u0001C$f_6,GO]=\u0002\u0011\u001d,w.\\0%KF$\"AT)\u0011\u0005ez\u0015B\u0001);\u0005\u0011)f.\u001b;\t\u000fI+\u0011\u0011!a\u0001\u0013\u0006\u0019\u0001\u0010J\u0019\u0002\u000b\u001d,w.\u001c\u0011\u0015\u0005U;\u0006C\u0001,\u0004\u001b\u0005\t\u0001\"B#\b\u0001\u0004I\u0015!C7bqB#H)[:u+\u0005Q\u0006CA\u001b\\\u0013\tavEA\tQ_&tG\u000fU1je\u0012K7\u000f^1oG\u0016\f!\"\\1y!R$\u0015n\u001d;!\u0003%i\u0017N\u001c)u\t&\u001cH/\u0001\u0006nS:\u0004F\u000fR5ti\u0002\naAZ5mi\u0016\u0014HC\u0001(c\u0011\u0015\u0019G\u00021\u0001e\u0003\t\u0001H\u000f\u0005\u0002DK&\u0011a\r\u0012\u0002\u000b\u0007>|'\u000fZ5oCR,\u0017aE4fi6\u000b\u0007\u0010U8j]R$\u0015n\u001d;b]\u000e,'!G'bq6KG\r]8j]R$\u0015n\u001d;b]\u000e,g)\u001b7uKJ\u001c2A\u0004\u001dk!\t\u00195.\u0003\u0002m\t\nA2i\\8sI&t\u0017\r^3TKF,XM\\2f\r&dG/\u001a:\u0015\u00059s\u0007b\u0002*\u0011\u0003\u0003\u0005\r!\u0013\u000b\u0003aF\u0004\"A\u0016\b\t\u000b\u0015\u0013\u0002\u0019A%\u0015\u00079\u001b\b\u0010C\u0003u/\u0001\u0007Q/A\u0002tKF\u0004\"a\u0011<\n\u0005]$%AE\"p_J$\u0017N\\1uKN+\u0017/^3oG\u0016DQ!_\fA\u0002i\fQ!\u001b8eKb\u0004\"!O>\n\u0005qT$aA%oi\u0006\t\u0012n]$f_6,GO]=DQ\u0006tw-\u001a3\u0016\u0003}\u00042!OA\u0001\u0013\r\t\u0019A\u000f\u0002\b\u0005>|G.Z1o\u0003\u0019I7\u000fR8oKN\u00111\u0004O\u0001\nS:\u0004X\u000f^$f_6\fQ\"\u001b8qkR<Um\\7`I\u0015\fHc\u0001(\u0002\u0010!9!+HA\u0001\u0002\u0004I\u0015AC5oaV$x)Z8nAQ!\u0011QCA\f!\t)4\u0004\u0003\u0004\u0002\n}\u0001\r!S\u0001\rM&tG\rR5ti\u0006t7-\u001a\u000b\u0005\u0003;\t\u0019\u0003E\u0002:\u0003?I1!!\t;\u0005\u0019!u.\u001e2mK\"1\u0011Q\u0005\u0012A\u0002%\u000b1BY;gM\u0016\u00148)\u001e:wK\u0006\tr-\u001a;ESN$\u0018M\\2f!>Lg\u000e^:\u00021\r|W\u000e];uK6\u000b\u0007PV3si\u0016DH)[:uC:\u001cW\rF\u0002O\u0003[Aa!a\f%\u0001\u0004I\u0015!B2veZ,\u0017AG2p[B,H/Z'bq6KG\r]8j]R$\u0015n\u001d;b]\u000e,Gc\u0001(\u00026!1\u0011qF\u0013A\u0002%\u0003")
public class BufferCurveMaximumDistanceFinder {
    private Geometry inputGeom;
    private final PointPairDistance maxPtDist;
    private volatile boolean bitmap$init$0;

    public Geometry inputGeom() {
        return this.inputGeom;
    }

    public void inputGeom_$eq(Geometry x$1) {
        this.inputGeom = x$1;
    }

    private PointPairDistance maxPtDist() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferCurveMaximumDistanceFinder.scala: 84");
        }
        return this.maxPtDist;
    }

    public double findDistance(Geometry bufferCurve) {
        this.computeMaxVertexDistance(bufferCurve);
        this.computeMaxMidpointDistance(bufferCurve);
        return this.maxPtDist().getDistance();
    }

    public PointPairDistance getDistancePoints() {
        return this.maxPtDist();
    }

    private void computeMaxVertexDistance(Geometry curve) {
        MaxPointDistanceFilter distFilter = new MaxPointDistanceFilter(this.inputGeom());
        curve.applyF(distFilter);
        this.maxPtDist().setMaximum(distFilter.getMaxPointDistance());
    }

    private void computeMaxMidpointDistance(Geometry curve) {
        MaxMidpointDistanceFilter distFilter = new MaxMidpointDistanceFilter(this.inputGeom());
        curve.applyF(distFilter);
        this.maxPtDist().setMaximum(distFilter.getMaxPointDistance());
    }

    public BufferCurveMaximumDistanceFinder(Geometry inputGeom) {
        this.inputGeom = inputGeom;
        this.maxPtDist = new PointPairDistance();
        this.bitmap$init$0 = true;
    }

    public static class MaxMidpointDistanceFilter
    implements CoordinateSequenceFilter {
        private Geometry geom;
        private final PointPairDistance maxPtDist;
        private final PointPairDistance minPtDist;
        private volatile byte bitmap$init$0;

        public Geometry geom() {
            return this.geom;
        }

        public void geom_$eq(Geometry x$1) {
            this.geom = x$1;
        }

        private PointPairDistance maxPtDist() {
            if ((byte)(this.bitmap$init$0 & 1) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferCurveMaximumDistanceFinder.scala: 61");
            }
            return this.maxPtDist;
        }

        private PointPairDistance minPtDist() {
            if ((byte)(this.bitmap$init$0 & 2) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferCurveMaximumDistanceFinder.scala: 62");
            }
            return this.minPtDist;
        }

        @Override
        public void filter(CoordinateSequence seq, int index) {
            if (index == 0) {
                return;
            }
            Coordinate p0 = seq.getCoordinate(index - 1);
            Coordinate p1 = seq.getCoordinate(index);
            Coordinate midPt = new Coordinate((p0.x() + p1.x()) / (double)2, (p0.y() + p1.y()) / (double)2);
            this.minPtDist().initialize();
            DistanceToPointFinder$.MODULE$.computeDistance(this.geom(), midPt, this.minPtDist());
            this.maxPtDist().setMaximum(this.minPtDist());
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist();
        }

        public MaxMidpointDistanceFilter(Geometry geom) {
            this.geom = geom;
            this.maxPtDist = new PointPairDistance();
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
            this.minPtDist = new PointPairDistance();
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        }
    }

    public static class MaxPointDistanceFilter
    implements CoordinateFilter {
        private Geometry geom;
        private final PointPairDistance maxPtDist;
        private final PointPairDistance minPtDist;
        private volatile byte bitmap$init$0;

        public Geometry geom() {
            return this.geom;
        }

        public void geom_$eq(Geometry x$1) {
            this.geom = x$1;
        }

        private PointPairDistance maxPtDist() {
            if ((byte)(this.bitmap$init$0 & 1) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferCurveMaximumDistanceFinder.scala: 48");
            }
            return this.maxPtDist;
        }

        private PointPairDistance minPtDist() {
            if ((byte)(this.bitmap$init$0 & 2) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferCurveMaximumDistanceFinder.scala: 49");
            }
            return this.minPtDist;
        }

        @Override
        public void filter(Coordinate pt) {
            this.minPtDist().initialize();
            DistanceToPointFinder$.MODULE$.computeDistance(this.geom(), pt, this.minPtDist());
            this.maxPtDist().setMaximum(this.minPtDist());
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist();
        }

        public MaxPointDistanceFilter(Geometry geom) {
            this.geom = geom;
            this.maxPtDist = new PointPairDistance();
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
            this.minPtDist = new PointPairDistance();
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        }
    }
}

