/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer.validate;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.distance.DiscreteHausdorffDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.geom.util.PolygonExtracter$;
import org.locationtech.jts.operation.buffer.validate.BufferDistanceValidator$;
import org.locationtech.jts.operation.distance.DistanceOp;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]u!B\u001a5\u0011\u0003\te!B\"5\u0011\u0003!\u0005\"B&\u0002\t\u0003a\u0005bB'\u0002\u0005\u0004%IA\u0014\u0005\u0007%\u0006\u0001\u000b\u0011B(\t\u000fM\u000b!\u0019!C\u0005)\"1\u0001,\u0001Q\u0001\nU3Aa\u0011\u001b\u00013\"A!l\u0002BA\u0002\u0013\u00051\f\u0003\u0005c\u000f\t\u0005\r\u0011\"\u0001d\u0011!IwA!A!B\u0013a\u0006\u0002\u00036\b\u0005\u0003\u0007I\u0011\u0001+\t\u0011-<!\u00111A\u0005\u00021D\u0001B\\\u0004\u0003\u0002\u0003\u0006K!\u0016\u0005\t_\u001e\u0011\t\u0019!C\u00017\"A\u0001o\u0002BA\u0002\u0013\u0005\u0011\u000f\u0003\u0005t\u000f\t\u0005\t\u0015)\u0003]\u0011\u0015Yu\u0001\"\u0001u\u0011\u001dIx\u00011A\u0005\nQCqA_\u0004A\u0002\u0013%1\u0010\u0003\u0004~\u000f\u0001\u0006K!\u0016\u0005\b}\u001e\u0001\r\u0011\"\u0003U\u0011!yx\u00011A\u0005\n\u0005\u0005\u0001bBA\u0003\u000f\u0001\u0006K!\u0016\u0005\t\u0003\u000f9\u0001\u0019!C\u0005)\"I\u0011\u0011B\u0004A\u0002\u0013%\u00111\u0002\u0005\b\u0003\u001f9\u0001\u0015)\u0003V\u0011!\t\tb\u0002a\u0001\n\u0013!\u0006\"CA\n\u000f\u0001\u0007I\u0011BA\u000b\u0011\u001d\tIb\u0002Q!\nUC\u0001\"a\u0007\b\u0001\u0004%IA\u0014\u0005\n\u0003;9\u0001\u0019!C\u0005\u0003?Aq!a\t\bA\u0003&q\nC\u0005\u0002&\u001d\u0001\r\u0011\"\u0003\u0002(!I\u0011qH\u0004A\u0002\u0013%\u0011\u0011\t\u0005\t\u0003\u000b:\u0001\u0015)\u0003\u0002*!I\u0011qI\u0004A\u0002\u0013%\u0011\u0011\n\u0005\n\u0003#:\u0001\u0019!C\u0005\u0003'B\u0001\"a\u0016\bA\u0003&\u00111\n\u0005\t\u00033:\u0001\u0019!C\u00057\"I\u00111L\u0004A\u0002\u0013%\u0011Q\f\u0005\b\u0003C:\u0001\u0015)\u0003]\u0011\u0019\t\u0019g\u0002C\u0001\u001d\"9\u0011QM\u0004\u0005\u0002\u0005\u001d\u0002bBA4\u000f\u0011\u0005\u0011\u0011\n\u0005\u0007\u0003S:A\u0011A.\t\u000f\u0005-t\u0001\"\u0003\u0002n!9\u0011qN\u0004\u0005\n\u00055\u0004bBA9\u000f\u0011%\u00111\u000f\u0005\b\u0003s:A\u0011BA>\u0011\u001d\tIi\u0002C\u0005\u0003\u0017\u000bqCQ;gM\u0016\u0014H)[:uC:\u001cWMV1mS\u0012\fGo\u001c:\u000b\u0005U2\u0014\u0001\u0003<bY&$\u0017\r^3\u000b\u0005]B\u0014A\u00022vM\u001a,'O\u0003\u0002:u\u0005Iq\u000e]3sCRLwN\u001c\u0006\u0003wq\n1A\u001b;t\u0015\tid(\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001@\u0003\ry'oZ\u0002\u0001!\t\u0011\u0015!D\u00015\u0005]\u0011UO\u001a4fe\u0012K7\u000f^1oG\u00164\u0016\r\\5eCR|'o\u0005\u0002\u0002\u000bB\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A!\u0002\u000fY+%KQ(T\u000bV\tq\n\u0005\u0002G!&\u0011\u0011k\u0012\u0002\b\u0005>|G.Z1o\u0003!1VI\u0015\"P'\u0016\u0003\u0013AF'B1~#\u0015j\u0015+B\u001d\u000e+u\fR%G\r~3%+Q\"\u0016\u0003U\u0003\"A\u0012,\n\u0005];%A\u0002#pk\ndW-A\fN\u0003b{F)S*U\u0003:\u001bUi\u0018#J\r\u001a{fIU!DAM\u0011q!R\u0001\u0006S:\u0004X\u000f^\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011qLO\u0001\u0005O\u0016|W.\u0003\u0002b=\nAq)Z8nKR\u0014\u00180A\u0005j]B,Ho\u0018\u0013fcR\u0011Am\u001a\t\u0003\r\u0016L!AZ$\u0003\tUs\u0017\u000e\u001e\u0005\bQ&\t\t\u00111\u0001]\u0003\rAH%M\u0001\u0007S:\u0004X\u000f\u001e\u0011\u0002\u0017\t,h\rR5ti\u0006t7-Z\u0001\u0010EV4G)[:uC:\u001cWm\u0018\u0013fcR\u0011A-\u001c\u0005\bQ2\t\t\u00111\u0001V\u00031\u0011WO\u001a#jgR\fgnY3!\u0003\u0019\u0011Xm];mi\u0006Q!/Z:vYR|F%Z9\u0015\u0005\u0011\u0014\bb\u00025\u0010\u0003\u0003\u0005\r\u0001X\u0001\be\u0016\u001cX\u000f\u001c;!)\u0011)ho\u001e=\u0011\u0005\t;\u0001\"\u0002.\u0012\u0001\u0004a\u0006\"\u00026\u0012\u0001\u0004)\u0006\"B8\u0012\u0001\u0004a\u0016\u0001E7j]Z\u000bG.\u001b3ESN$\u0018M\\2f\u0003Qi\u0017N\u001c,bY&$G)[:uC:\u001cWm\u0018\u0013fcR\u0011A\r \u0005\bQN\t\t\u00111\u0001V\u0003Ei\u0017N\u001c,bY&$G)[:uC:\u001cW\rI\u0001\u0011[\u0006Dh+\u00197jI\u0012K7\u000f^1oG\u0016\fA#\\1y-\u0006d\u0017\u000e\u001a#jgR\fgnY3`I\u0015\fHc\u00013\u0002\u0004!9\u0001NFA\u0001\u0002\u0004)\u0016!E7bqZ\u000bG.\u001b3ESN$\u0018M\\2fA\u0005\u0001R.\u001b8ESN$\u0018M\\2f\r>,h\u000eZ\u0001\u0015[&tG)[:uC:\u001cWMR8v]\u0012|F%Z9\u0015\u0007\u0011\fi\u0001C\u0004i3\u0005\u0005\t\u0019A+\u0002#5Lg\u000eR5ti\u0006t7-\u001a$pk:$\u0007%\u0001\tnCb$\u0015n\u001d;b]\u000e,gi\\;oI\u0006!R.\u0019=ESN$\u0018M\\2f\r>,h\u000eZ0%KF$2\u0001ZA\f\u0011\u001dAG$!AA\u0002U\u000b\u0011#\\1y\t&\u001cH/\u00198dK\u001a{WO\u001c3!\u0003!1\u0018n\u001d,bY&$\u0017\u0001\u0004<jgZ\u000bG.\u001b3`I\u0015\fHc\u00013\u0002\"!9\u0001nHA\u0001\u0002\u0004y\u0015!\u0003<jgZ\u000bG.\u001b3!\u0003\u0019)'O]'tOV\u0011\u0011\u0011\u0006\t\u0005\u0003W\tID\u0004\u0003\u0002.\u0005U\u0002cAA\u0018\u000f6\u0011\u0011\u0011\u0007\u0006\u0004\u0003g\u0001\u0015A\u0002\u001fs_>$h(C\u0002\u00028\u001d\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u001e\u0003{\u0011aa\u0015;sS:<'bAA\u001c\u000f\u0006QQM\u001d:Ng\u001e|F%Z9\u0015\u0007\u0011\f\u0019\u0005\u0003\u0005iE\u0005\u0005\t\u0019AA\u0015\u0003\u001d)'O]'tO\u0002\nQ\"\u001a:s_JdunY1uS>tWCAA&!\ri\u0016QJ\u0005\u0004\u0003\u001fr&AC\"p_J$\u0017N\\1uK\u0006\tRM\u001d:pe2{7-\u0019;j_:|F%Z9\u0015\u0007\u0011\f)\u0006\u0003\u0005iK\u0005\u0005\t\u0019AA&\u00039)'O]8s\u0019>\u001c\u0017\r^5p]\u0002\na\"\u001a:s_JLe\u000eZ5dCR|'/\u0001\nfeJ|'/\u00138eS\u000e\fGo\u001c:`I\u0015\fHc\u00013\u0002`!9\u0001\u000eKA\u0001\u0002\u0004a\u0016aD3se>\u0014\u0018J\u001c3jG\u0006$xN\u001d\u0011\u0002\u000f%\u001ch+\u00197jI\u0006yq-\u001a;FeJ|'/T3tg\u0006<W-\u0001\thKR,%O]8s\u0019>\u001c\u0017\r^5p]\u0006\tr-\u001a;FeJ|'/\u00138eS\u000e\fGo\u001c:\u0002%\rDWmY6Q_NLG/\u001b<f-\u0006d\u0017\u000e\u001a\u000b\u0002I\u0006\u00112\r[3dW:+w-\u0019;jm\u00164\u0016\r\\5e\u0003=9W\r\u001e)pYf<wN\u001c'j]\u0016\u001cHc\u0001/\u0002v!1\u0011q\u000f\u0019A\u0002q\u000b\u0011aZ\u0001\u0015G\",7m['j]&lW/\u001c#jgR\fgnY3\u0015\u000f\u0011\fi(!!\u0002\u0006\"1\u0011qP\u0019A\u0002q\u000b!aZ\u0019\t\r\u0005\r\u0015\u00071\u0001]\u0003\t9'\u0007\u0003\u0004\u0002\bF\u0002\r!V\u0001\b[&tG)[:u\u0003Q\u0019\u0007.Z2l\u001b\u0006D\u0018.\\;n\t&\u001cH/\u00198dKR9A-!$\u0002\u0010\u0006M\u0005\"\u0002.3\u0001\u0004a\u0006BBAIe\u0001\u0007A,\u0001\u0005ck\u001a\u001cUO\u001d<f\u0011\u0019\t)J\ra\u0001+\u00069Q.\u0019=ESN$\b")
public class BufferDistanceValidator {
    private Geometry input;
    private double bufDistance;
    private Geometry result;
    private double minValidDistance;
    private double maxValidDistance;
    private double minDistanceFound;
    private double maxDistanceFound;
    private boolean visValid;
    private String errMsg;
    private Coordinate errorLocation;
    private Geometry errorIndicator;
    private volatile byte bitmap$init$0;

    public Geometry input() {
        return this.input;
    }

    public void input_$eq(Geometry x$1) {
        this.input = x$1;
    }

    public double bufDistance() {
        return this.bufDistance;
    }

    public void bufDistance_$eq(double x$1) {
        this.bufDistance = x$1;
    }

    public Geometry result() {
        return this.result;
    }

    public void result_$eq(Geometry x$1) {
        this.result = x$1;
    }

    private double minValidDistance() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferDistanceValidator.scala: 61");
        }
        return this.minValidDistance;
    }

    private void minValidDistance_$eq(double x$1) {
        this.minValidDistance = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private double maxValidDistance() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferDistanceValidator.scala: 62");
        }
        return this.maxValidDistance;
    }

    private void maxValidDistance_$eq(double x$1) {
        this.maxValidDistance = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private double minDistanceFound() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferDistanceValidator.scala: 63");
        }
        return this.minDistanceFound;
    }

    private void minDistanceFound_$eq(double x$1) {
        this.minDistanceFound = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    private double maxDistanceFound() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferDistanceValidator.scala: 64");
        }
        return this.maxDistanceFound;
    }

    private void maxDistanceFound_$eq(double x$1) {
        this.maxDistanceFound = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private boolean visValid() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferDistanceValidator.scala: 65");
        }
        return this.visValid;
    }

    private void visValid_$eq(boolean x$1) {
        this.visValid = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    private String errMsg() {
        if ((byte)(this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferDistanceValidator.scala: 66");
        }
        return this.errMsg;
    }

    private void errMsg_$eq(String x$1) {
        this.errMsg = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
    }

    private Coordinate errorLocation() {
        if ((byte)(this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferDistanceValidator.scala: 67");
        }
        return this.errorLocation;
    }

    private void errorLocation_$eq(Coordinate x$1) {
        this.errorLocation = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x40);
    }

    private Geometry errorIndicator() {
        if ((byte)(this.bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferDistanceValidator.scala: 68");
        }
        return this.errorIndicator;
    }

    private void errorIndicator_$eq(Geometry x$1) {
        this.errorIndicator = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x80);
    }

    public boolean isValid() {
        block3: {
            double posDistance = Math.abs(this.bufDistance());
            double distDelta = BufferDistanceValidator$.MODULE$.org$locationtech$jts$operation$buffer$validate$BufferDistanceValidator$$MAX_DISTANCE_DIFF_FRAC() * posDistance;
            this.minValidDistance_$eq(posDistance - distDelta);
            this.maxValidDistance_$eq(posDistance + distDelta);
            if (this.input().isEmpty() || this.result().isEmpty()) {
                return true;
            }
            if (this.bufDistance() > 0.0) {
                this.checkPositiveValid();
            } else {
                this.checkNegativeValid();
            }
            if (!BufferDistanceValidator$.MODULE$.org$locationtech$jts$operation$buffer$validate$BufferDistanceValidator$$VERBOSE()) break block3;
            System.out.println(new StringBuilder(36).append("Min Dist= ").append(this.minDistanceFound()).append("  err= ").append(1.0 - this.minDistanceFound() / this.bufDistance()).append("  Max Dist= ").append(this.maxDistanceFound()).append("  err= ").append(this.maxDistanceFound() / this.bufDistance() - 1.0).toString());
        }
        return this.visValid();
    }

    public String getErrorMessage() {
        return this.errMsg();
    }

    public Coordinate getErrorLocation() {
        return this.errorLocation();
    }

    public Geometry getErrorIndicator() {
        return this.errorIndicator();
    }

    private void checkPositiveValid() {
        Geometry bufCurve = this.result().getBoundary();
        this.checkMinimumDistance(this.input(), bufCurve, this.minValidDistance());
        if (!this.visValid()) {
            return;
        }
        this.checkMaximumDistance(this.input(), bufCurve, this.maxValidDistance());
    }

    private void checkNegativeValid() {
        if (!(this.input() instanceof Polygon || this.input() instanceof MultiPolygon || this.input() instanceof GeometryCollection)) {
            return;
        }
        Geometry inputCurve = this.getPolygonLines(this.input());
        this.checkMinimumDistance(inputCurve, this.result(), this.minValidDistance());
        if (!this.visValid()) {
            return;
        }
        this.checkMaximumDistance(inputCurve, this.result(), this.maxValidDistance());
    }

    private Geometry getPolygonLines(Geometry g) {
        ArrayList<Geometry> lines = new ArrayList<Geometry>();
        LinearComponentExtracter lineExtracter = new LinearComponentExtracter(lines);
        List<Geometry> polys = PolygonExtracter$.MODULE$.getPolygons(g);
        for (Polygon polygon : polys) {
            polygon.applyF(lineExtracter);
        }
        return g.getFactory().buildGeometry(lines);
    }

    private void checkMinimumDistance(Geometry g1, Geometry g2, double minDist) {
        block0: {
            DistanceOp distOp = new DistanceOp(g1, g2, minDist);
            this.minDistanceFound_$eq(distOp.distance());
            if (!(this.minDistanceFound() < minDist)) break block0;
            this.visValid_$eq(false);
            Coordinate[] pts = distOp.nearestPoints();
            this.errorLocation_$eq(distOp.nearestPoints()[1]);
            this.errorIndicator_$eq(g1.getFactory().createLineString(pts));
            this.errMsg_$eq(new StringBuilder(61).append("Distance between buffer curve and input is too small (").append(this.minDistanceFound()).append(" at ").append(pts[0].toString()).append(" ").append(pts[1].toString()).append(" )").toString());
        }
    }

    private void checkMaximumDistance(Geometry input, Geometry bufCurve, double maxDist) {
        block0: {
            DiscreteHausdorffDistance haus = new DiscreteHausdorffDistance(bufCurve, input);
            haus.setDensifyFraction(0.25);
            this.maxDistanceFound_$eq(haus.orientedDistance());
            if (!(this.maxDistanceFound() > maxDist)) break block0;
            this.visValid_$eq(false);
            Coordinate[] pts = haus.getCoordinates();
            this.errorLocation_$eq(pts[1]);
            this.errorIndicator_$eq(input.getFactory().createLineString(pts));
            this.errMsg_$eq(new StringBuilder(60).append("Distance between buffer curve and input is too large (").append(this.maxDistanceFound()).append(" at ").append(pts[0].toString()).append(" ").append(pts[1].toString()).append(")").toString());
        }
    }

    public BufferDistanceValidator(Geometry input, double bufDistance, Geometry result) {
        this.input = input;
        this.bufDistance = bufDistance;
        this.result = result;
        this.minValidDistance = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.maxValidDistance = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.minDistanceFound = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.maxDistanceFound = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.visValid = true;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        this.errMsg = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
        this.errorLocation = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x40);
        this.errorIndicator = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x80);
    }
}

