/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer.validate;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.buffer.validate.BufferDistanceValidator;
import org.locationtech.jts.operation.buffer.validate.BufferResultValidator$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005es!\u0002\u0016,\u0011\u0003Ad!\u0002\u001e,\u0011\u0003Y\u0004\"\u0002\"\u0002\t\u0003\u0019\u0005b\u0002#\u0002\u0005\u0004%I!\u0012\u0005\u0007\u0013\u0006\u0001\u000b\u0011\u0002$\t\u000f)\u000b!\u0019!C\u0005\u0017\"1q*\u0001Q\u0001\n1CQ\u0001U\u0001\u0005\u0002ECQAX\u0001\u0005\u0002}3AAO\u0016\u0001]\"Aq.\u0003BA\u0002\u0013\u0005\u0001\u000f\u0003\u0005r\u0013\t\u0005\r\u0011\"\u0001s\u0011!A\u0018B!A!B\u0013!\u0006\u0002C.\n\u0005\u0003\u0007I\u0011A&\t\u0011eL!\u00111A\u0005\u0002iD\u0001\u0002`\u0005\u0003\u0002\u0003\u0006K\u0001\u0014\u0005\t;&\u0011\t\u0019!C\u0001a\"AQ0\u0003BA\u0002\u0013\u0005a\u0010C\u0005\u0002\u0002%\u0011\t\u0011)Q\u0005)\"1!)\u0003C\u0001\u0003\u0007A\u0001\"!\u0004\n\u0001\u0004%I!\u0012\u0005\n\u0003\u001fI\u0001\u0019!C\u0005\u0003#Aq!!\u0006\nA\u0003&a\tC\u0005\u0002\u0018%\u0001\r\u0011\"\u0003\u0002\u001a!I\u00111D\u0005A\u0002\u0013%\u0011Q\u0004\u0005\b\u0003CI\u0001\u0015)\u0003a\u0011%\t\u0019#\u0003a\u0001\n\u0013\t)\u0003C\u0005\u0002.%\u0001\r\u0011\"\u0003\u00020!A\u00111G\u0005!B\u0013\t9\u0003\u0003\u0005\u00026%\u0001\r\u0011\"\u0003q\u0011%\t9$\u0003a\u0001\n\u0013\tI\u0004C\u0004\u0002>%\u0001\u000b\u0015\u0002+\t\u000bAKA\u0011A#\t\u000f\u0005}\u0012\u0002\"\u0001\u0002\u001a!9\u0011\u0011I\u0005\u0005\u0002\u0005\u0015\u0002BBA\"\u0013\u0011\u0005\u0001\u000fC\u0004\u0002F%!I!a\u0012\t\u000f\u00055\u0013\u0002\"\u0003\u0002P!9\u0011\u0011K\u0005\u0005\n\u0005=\u0003bBA*\u0013\u0011%\u0011q\n\u0005\b\u0003+JA\u0011BA(\u0011\u001d\t9&\u0003C\u0005\u0003\u001f\nQCQ;gM\u0016\u0014(+Z:vYR4\u0016\r\\5eCR|'O\u0003\u0002-[\u0005Aa/\u00197jI\u0006$XM\u0003\u0002/_\u00051!-\u001e4gKJT!\u0001M\u0019\u0002\u0013=\u0004XM]1uS>t'B\u0001\u001a4\u0003\rQGo\u001d\u0006\u0003iU\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011AN\u0001\u0004_J<7\u0001\u0001\t\u0003s\u0005i\u0011a\u000b\u0002\u0016\u0005V4g-\u001a:SKN,H\u000e\u001e,bY&$\u0017\r^8s'\t\tA\b\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teH\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\nqAV#S\u0005>\u001bV)F\u0001G!\tit)\u0003\u0002I}\t9!i\\8mK\u0006t\u0017\u0001\u0003,F%\n{5+\u0012\u0011\u0002#5\u000b\u0005lX#O-~#\u0015J\u0012$`\rJ\u000b5)F\u0001M!\tiT*\u0003\u0002O}\t1Ai\\;cY\u0016\f!#T!Y?\u0016sek\u0018#J\r\u001a{fIU!DA\u00059\u0011n\u001d,bY&$G\u0003\u0002$S5rCQaU\u0004A\u0002Q\u000b\u0011a\u001a\t\u0003+bk\u0011A\u0016\u0006\u0003/F\nAaZ3p[&\u0011\u0011L\u0016\u0002\t\u000f\u0016|W.\u001a;ss\")1l\u0002a\u0001\u0019\u0006AA-[:uC:\u001cW\rC\u0003^\u000f\u0001\u0007A+\u0001\u0004sKN,H\u000e^\u0001\u000bSN4\u0016\r\\5e\u001bN<G\u0003\u00021lY6\u0004\"!\u00195\u000f\u0005\t4\u0007CA2?\u001b\u0005!'BA38\u0003\u0019a$o\\8u}%\u0011qMP\u0001\u0007!J,G-\u001a4\n\u0005%T'AB*ue&twM\u0003\u0002h}!)1\u000b\u0003a\u0001)\")1\f\u0003a\u0001\u0019\")Q\f\u0003a\u0001)N\u0011\u0011\u0002P\u0001\u0006S:\u0004X\u000f^\u000b\u0002)\u0006I\u0011N\u001c9vi~#S-\u001d\u000b\u0003gZ\u0004\"!\u0010;\n\u0005Ut$\u0001B+oSRDqa^\u0006\u0002\u0002\u0003\u0007A+A\u0002yIE\na!\u001b8qkR\u0004\u0013\u0001\u00043jgR\fgnY3`I\u0015\fHCA:|\u0011\u001d9h\"!AA\u00021\u000b\u0011\u0002Z5ti\u0006t7-\u001a\u0011\u0002\u0015I,7/\u001e7u?\u0012*\u0017\u000f\u0006\u0002t\u007f\"9q/EA\u0001\u0002\u0004!\u0016a\u0002:fgVdG\u000f\t\u000b\t\u0003\u000b\t9!!\u0003\u0002\fA\u0011\u0011(\u0003\u0005\u0006_N\u0001\r\u0001\u0016\u0005\u00067N\u0001\r\u0001\u0014\u0005\u0006;N\u0001\r\u0001V\u0001\tm&\u001ch+\u00197jI\u0006aa/[:WC2LGm\u0018\u0013fcR\u00191/a\u0005\t\u000f],\u0012\u0011!a\u0001\r\u0006Ia/[:WC2LG\rI\u0001\tKJ\u0014xN]'tOV\t\u0001-\u0001\u0007feJ|'/T:h?\u0012*\u0017\u000fF\u0002t\u0003?Aqa\u001e\r\u0002\u0002\u0003\u0007\u0001-A\u0005feJ|'/T:hA\u0005iQM\u001d:pe2{7-\u0019;j_:,\"!a\n\u0011\u0007U\u000bI#C\u0002\u0002,Y\u0013!bQ8pe\u0012Lg.\u0019;f\u0003E)'O]8s\u0019>\u001c\u0017\r^5p]~#S-\u001d\u000b\u0004g\u0006E\u0002\u0002C<\u001c\u0003\u0003\u0005\r!a\n\u0002\u001d\u0015\u0014(o\u001c:M_\u000e\fG/[8oA\u0005qQM\u001d:pe&sG-[2bi>\u0014\u0018AE3se>\u0014\u0018J\u001c3jG\u0006$xN]0%KF$2a]A\u001e\u0011\u001d9h$!AA\u0002Q\u000bq\"\u001a:s_JLe\u000eZ5dCR|'\u000fI\u0001\u0010O\u0016$XI\u001d:pe6+7o]1hK\u0006\u0001r-\u001a;FeJ|'\u000fT8dCRLwN\\\u0001\u0012O\u0016$XI\u001d:pe&sG-[2bi>\u0014\u0018A\u0002:fa>\u0014H\u000fF\u0002t\u0003\u0013Ba!a\u0013%\u0001\u0004\u0001\u0017!C2iK\u000e\\g*Y7f\u00039\u0019\u0007.Z2l!>d\u0017pZ8oC2$\u0012a]\u0001\u0013G\",7m[#ya\u0016\u001cG/\u001a3F[B$\u00180A\u0007dQ\u0016\u001c7.\u00128wK2|\u0007/Z\u0001\nG\",7m[!sK\u0006\fQb\u00195fG.$\u0015n\u001d;b]\u000e,\u0007")
public class BufferResultValidator {
    private Geometry input;
    private double distance;
    private Geometry result;
    private boolean visValid;
    private String errorMsg;
    private Coordinate errorLocation;
    private Geometry errorIndicator;
    private volatile byte bitmap$init$0;

    public static String isValidMsg(Geometry geometry, double d, Geometry geometry2) {
        return BufferResultValidator$.MODULE$.isValidMsg(geometry, d, geometry2);
    }

    public Geometry input() {
        return this.input;
    }

    public void input_$eq(Geometry x$1) {
        this.input = x$1;
    }

    public double distance() {
        return this.distance;
    }

    public void distance_$eq(double x$1) {
        this.distance = x$1;
    }

    public Geometry result() {
        return this.result;
    }

    public void result_$eq(Geometry x$1) {
        this.result = x$1;
    }

    private boolean visValid() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferResultValidator.scala: 77");
        }
        return this.visValid;
    }

    private void visValid_$eq(boolean x$1) {
        this.visValid = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private String errorMsg() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferResultValidator.scala: 78");
        }
        return this.errorMsg;
    }

    private void errorMsg_$eq(String x$1) {
        this.errorMsg = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private Coordinate errorLocation() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferResultValidator.scala: 79");
        }
        return this.errorLocation;
    }

    private void errorLocation_$eq(Coordinate x$1) {
        this.errorLocation = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    private Geometry errorIndicator() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/buffer/validate/BufferResultValidator.scala: 80");
        }
        return this.errorIndicator;
    }

    private void errorIndicator_$eq(Geometry x$1) {
        this.errorIndicator = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    public boolean isValid() {
        this.checkPolygonal();
        if (!this.visValid()) {
            return this.visValid();
        }
        this.checkExpectedEmpty();
        if (!this.visValid()) {
            return this.visValid();
        }
        this.checkEnvelope();
        if (!this.visValid()) {
            return this.visValid();
        }
        this.checkArea();
        if (!this.visValid()) {
            return this.visValid();
        }
        this.checkDistance();
        return this.visValid();
    }

    public String getErrorMessage() {
        return this.errorMsg();
    }

    public Coordinate getErrorLocation() {
        return this.errorLocation();
    }

    public Geometry getErrorIndicator() {
        return this.errorIndicator();
    }

    private void report(String checkName) {
        if (!BufferResultValidator$.MODULE$.org$locationtech$jts$operation$buffer$validate$BufferResultValidator$$VERBOSE()) {
            return;
        }
        System.out.println(new StringBuilder(8).append("Check ").append(checkName).append(": ").append((Object)(this.visValid() ? "passed" : "FAILED")).toString());
    }

    private void checkPolygonal() {
        if (!(this.result() instanceof Polygon) && !(this.result() instanceof MultiPolygon)) {
            this.visValid_$eq(false);
        }
        this.errorMsg_$eq("Result is not polygonal");
        this.errorIndicator_$eq(this.result());
        this.report("Polygonal");
    }

    private void checkExpectedEmpty() {
        if (this.input().getDimension() >= 2) {
            return;
        }
        if (this.distance() > 0.0) {
            return;
        }
        if (!this.result().isEmpty()) {
            this.visValid_$eq(false);
            this.errorMsg_$eq("Result is non-empty");
            this.errorIndicator_$eq(this.result());
        }
        this.report("ExpectedEmpty");
    }

    private void checkEnvelope() {
        if (this.distance() < 0.0) {
            return;
        }
        double padding = this.distance() * BufferResultValidator$.MODULE$.org$locationtech$jts$operation$buffer$validate$BufferResultValidator$$MAX_ENV_DIFF_FRAC();
        if (padding == 0.0) {
            padding = 0.001;
        }
        Envelope expectedEnv = new Envelope(this.input().getEnvelopeInternal());
        expectedEnv.expandBy(this.distance());
        Envelope bufEnv = new Envelope(this.result().getEnvelopeInternal());
        bufEnv.expandBy(padding);
        if (!bufEnv.contains(expectedEnv)) {
            this.visValid_$eq(false);
            this.errorMsg_$eq("Buffer envelope is incorrect");
            this.errorIndicator_$eq(this.input().getFactory().toGeometry(bufEnv));
        }
        this.report("Envelope");
    }

    private void checkArea() {
        double inputArea = this.input().getArea();
        double resultArea = this.result().getArea();
        if (this.distance() > 0.0 && inputArea > resultArea) {
            this.visValid_$eq(false);
            this.errorMsg_$eq("Area of positive buffer is smaller than input");
            this.errorIndicator_$eq(this.result());
        }
        if (this.distance() < 0.0 && inputArea < resultArea) {
            this.visValid_$eq(false);
            this.errorMsg_$eq("Area of negative buffer is larger than input");
            this.errorIndicator_$eq(this.result());
        }
        this.report("Area");
    }

    private void checkDistance() {
        BufferDistanceValidator distValid = new BufferDistanceValidator(this.input(), this.distance(), this.result());
        if (!distValid.isValid()) {
            this.visValid_$eq(false);
            this.errorMsg_$eq(distValid.getErrorMessage());
            this.errorLocation_$eq(distValid.getErrorLocation());
            this.errorIndicator_$eq(distValid.getErrorIndicator());
        }
        this.report("Distance");
    }

    public BufferResultValidator(Geometry input, double distance, Geometry result) {
        this.input = input;
        this.distance = distance;
        this.result = result;
        this.visValid = true;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.errorMsg = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.errorLocation = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.errorIndicator = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

