/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.Distance$;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.algorithm.PointLocator$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LinearComponentExtracter$;
import org.locationtech.jts.geom.util.PointExtracter$;
import org.locationtech.jts.geom.util.PolygonExtracter$;
import org.locationtech.jts.operation.distance.ConnectedElementLocationFilter$;
import org.locationtech.jts.operation.distance.DistanceOp$;
import org.locationtech.jts.operation.distance.GeometryLocation;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ux!B\u0017/\u0011\u0003Id!B\u001e/\u0011\u0003a\u0004\"B\"\u0002\t\u0003!\u0005\"B\u0018\u0002\t\u0003)\u0005\"B*\u0002\t\u0003!\u0006\"B.\u0002\t\u0003a\u0006\"B3\u0002\t\u00031g\u0001B\u001e/\u0001%D\u0001BS\u0004\u0003\u0006\u0004%\tA\u001b\u0005\tW\u001e\u0011\t\u0011)A\u0005\u0017\"A!k\u0002BC\u0002\u0013\u0005!\u000e\u0003\u0005m\u000f\t\u0005\t\u0015!\u0003L\u0011!iwA!b\u0001\n\u0003q\u0007\u0002C8\b\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b\r;A\u0011\u00019\t\u000fU<!\u0019!C\u0001m\"1\u0001p\u0002Q\u0001\n]DqAT\u0004C\u0002\u0013%a\u000f\u0003\u0004z\u000f\u0001\u0006Ia\u001e\u0005\bu\u001e\u0011\r\u0011\"\u0003|\u0011\u001d\t)a\u0002Q\u0001\nqD\u0011\"a\u0002\b\u0001\u0004%I!!\u0003\t\u0013\u0005Mq\u00011A\u0005\n\u0005U\u0001\u0002CA\u0011\u000f\u0001\u0006K!a\u0003\t\u0011\u0005\rr\u00011A\u0005\n9D\u0011\"!\n\b\u0001\u0004%I!a\n\t\u000f\u0005-r\u0001)Q\u0005\r\"11i\u0002C\u0001\u0003[AQaL\u0004\u0005\u00029DaaW\u0004\u0005\u0002\u0005M\u0002BB3\b\t\u0003\t\u0019\u0004C\u0004\u00026\u001d!\t!!\u0003\t\u000f\u0005]r\u0001\"\u0001\u0002\n!9\u0011\u0011H\u0004\u0005\n\u0005m\u0002bBA#\u000f\u0011%\u0011q\t\u0005\b\u0003\u0013:A\u0011BA$\u0011\u001d\tIe\u0002C\u0005\u0003\u0017Bq!!\u0013\b\t\u0013\tY\u0006C\u0004\u0002J\u001d!I!!'\t\u000f\u0005-v\u0001\"\u0003\u0002H!9\u0011QV\u0004\u0005\n\u0005=\u0006bBA_\u000f\u0011%\u0011q\u0018\u0005\b\u0003\u0017<A\u0011BAg\u0011\u001d\t)e\u0002C\u0005\u00033Dq!!\u0012\b\t\u0013\tY/\u0001\u0006ESN$\u0018M\\2f\u001fBT!a\f\u0019\u0002\u0011\u0011L7\u000f^1oG\u0016T!!\r\u001a\u0002\u0013=\u0004XM]1uS>t'BA\u001a5\u0003\rQGo\u001d\u0006\u0003kY\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011aN\u0001\u0004_J<7\u0001\u0001\t\u0003u\u0005i\u0011A\f\u0002\u000b\t&\u001cH/\u00198dK>\u00038CA\u0001>!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u000f\u000b\u0004\r&\u000b\u0006C\u0001 H\u0013\tAuH\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\u0015\u000e\u0001\raS\u0001\u0003OB\u0002\"\u0001T(\u000e\u00035S!A\u0014\u001a\u0002\t\u001d,w.\\\u0005\u0003!6\u0013\u0001bR3p[\u0016$(/\u001f\u0005\u0006%\u000e\u0001\raS\u0001\u0003OF\n\u0001#[:XSRD\u0017N\u001c#jgR\fgnY3\u0015\tUC\u0016L\u0017\t\u0003}YK!aV \u0003\u000f\t{w\u000e\\3b]\")!\n\u0002a\u0001\u0017\")!\u000b\u0002a\u0001\u0017\")q\u0006\u0002a\u0001\r\u0006ia.Z1sKN$\bk\\5oiN$2!X2e!\rqd\fY\u0005\u0003?~\u0012Q!\u0011:sCf\u0004\"\u0001T1\n\u0005\tl%AC\"p_J$\u0017N\\1uK\")!*\u0002a\u0001\u0017\")!+\u0002a\u0001\u0017\u0006i1\r\\8tKN$\bk\\5oiN$2!X4i\u0011\u0015Qe\u00011\u0001L\u0011\u0015\u0011f\u00011\u0001L'\t9Q(F\u0001L\u0003\r9\u0007\u0007I\u0001\u0004OF\u0002\u0013!\u0005;fe6Lg.\u0019;f\t&\u001cH/\u00198dKV\ta)\u0001\nuKJl\u0017N\\1uK\u0012K7\u000f^1oG\u0016\u0004C\u0003B9sgR\u0004\"AO\u0004\t\u000b)s\u0001\u0019A&\t\u000bIs\u0001\u0019A&\t\u000b5t\u0001\u0019\u0001$\u0002\u0019\t\f7/Z$f_6,GO]=\u0016\u0003]\u00042A\u00100L\u00035\u0011\u0017m]3HK>lW\r\u001e:zA\u0005)q-Z8nA\u0005I\u0001\u000f\u001e'pG\u0006$xN]\u000b\u0002yB\u0019Q0!\u0001\u000e\u0003yT!a \u001a\u0002\u0013\u0005dwm\u001c:ji\"l\u0017bAA\u0002}\na\u0001k\\5oi2{7-\u0019;pe\u0006Q\u0001\u000f\u001e'pG\u0006$xN\u001d\u0011\u0002'5Lg\u000eR5ti\u0006t7-\u001a'pG\u0006$\u0018n\u001c8\u0016\u0005\u0005-\u0001\u0003\u0002 _\u0003\u001b\u00012AOA\b\u0013\r\t\tB\f\u0002\u0011\u000f\u0016|W.\u001a;ss2{7-\u0019;j_:\fq#\\5o\t&\u001cH/\u00198dK2{7-\u0019;j_:|F%Z9\u0015\t\u0005]\u0011Q\u0004\t\u0004}\u0005e\u0011bAA\u000e\u007f\t!QK\\5u\u0011%\tyBFA\u0001\u0002\u0004\tY!A\u0002yIE\nA#\\5o\t&\u001cH/\u00198dK2{7-\u0019;j_:\u0004\u0013aC7j]\u0012K7\u000f^1oG\u0016\fq\"\\5o\t&\u001cH/\u00198dK~#S-\u001d\u000b\u0005\u0003/\tI\u0003\u0003\u0005\u0002 e\t\t\u00111\u0001G\u00031i\u0017N\u001c#jgR\fgnY3!)\u0015\t\u0018qFA\u0019\u0011\u0015Q5\u00041\u0001L\u0011\u0015\u00116\u00041\u0001L+\u0005i\u0016\u0001\u00058fCJ,7\u000f\u001e'pG\u0006$\u0018n\u001c8t\u0003A\u0019Gn\\:fgRdunY1uS>t7/A\tva\u0012\fG/Z'j]\u0012K7\u000f^1oG\u0016$b!a\u0006\u0002>\u0005\u0005\u0003bBA C\u0001\u0007\u00111B\u0001\bY>\u001cw)Z8n\u0011\u0019\t\u0019%\ta\u0001+\u0006!a\r\\5q\u0003I\u0019w.\u001c9vi\u0016l\u0015N\u001c#jgR\fgnY3\u0015\u0005\u0005]\u0011AG2p[B,H/Z\"p]R\f\u0017N\\7f]R$\u0015n\u001d;b]\u000e,GCBA\f\u0003\u001b\n9\u0006C\u0004\u0002P\u0011\u0002\r!!\u0015\u0002\u001bA|G._$f_6Le\u000eZ3y!\rq\u00141K\u0005\u0004\u0003+z$aA%oi\"9\u0011\u0011\f\u0013A\u0002\u0005-\u0011!\u00037pGB#\bk\u001c7z)!\t9\"!\u0018\u0002\n\u0006]\u0005bBA0K\u0001\u0007\u0011\u0011M\u0001\u0005Y>\u001c7\u000f\r\u0003\u0002d\u0005]\u0004CBA3\u0003_\n\u0019(\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003\u0011)H/\u001b7\u000b\u0005\u00055\u0014\u0001\u00026bm\u0006LA!!\u001d\u0002h\t!A*[:u!\u0011\t)(a\u001e\r\u0001\u0011a\u0011\u0011PA/\u0003\u0003\u0005\tQ!\u0001\u0002|\t\u0019q\fJ\u0019\u0012\t\u0005u\u00141\u0011\t\u0004}\u0005}\u0014bAAA\u007f\t9aj\u001c;iS:<\u0007c\u0001 \u0002\u0006&\u0019\u0011qQ \u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\f\u0016\u0002\r!!$\u0002\u000bA|G._:1\t\u0005=\u00151\u0013\t\u0007\u0003K\ny'!%\u0011\t\u0005U\u00141\u0013\u0003\r\u0003+\u000bI)!A\u0001\u0002\u000b\u0005\u00111\u0010\u0002\u0004?\u0012\u0012\u0004bBA-K\u0001\u0007\u00111\u0002\u000b\t\u0003/\tY*a(\u0002*\"9\u0011Q\u0014\u0014A\u0002\u00055\u0011!\u00029u\u0019>\u001c\u0007bBAQM\u0001\u0007\u00111U\u0001\u0005a>d\u0017\u0010E\u0002M\u0003KK1!a*N\u0005\u001d\u0001v\u000e\\=h_:Dq!!\u0017'\u0001\u0004\tY!\u0001\u000bd_6\u0004X\u000f^3GC\u000e,G\u000fR5ti\u0006t7-Z\u0001\u0018G>l\u0007/\u001e;f\u001b&tG)[:uC:\u001cW\rT5oKN$\u0002\"a\u0006\u00022\u0006]\u00161\u0018\u0005\b\u0003gC\u0003\u0019AA[\u0003\u0019a\u0017N\\3taA)\u0011QMA8\u0017\"9\u0011\u0011\u0018\u0015A\u0002\u0005U\u0016A\u00027j]\u0016\u001c\u0018\u0007C\u0004\u0002@!\u0002\r!a\u0003\u00021\r|W\u000e];uK6Kg\u000eR5ti\u0006t7-\u001a)pS:$8\u000f\u0006\u0005\u0002\u0018\u0005\u0005\u0017QYAe\u0011\u001d\t\u0019-\u000ba\u0001\u0003k\u000bq\u0001]8j]R\u001c\b\u0007C\u0004\u0002H&\u0002\r!!.\u0002\u000fA|\u0017N\u001c;tc!9\u0011qH\u0015A\u0002\u0005-\u0011!H2p[B,H/Z'j]\u0012K7\u000f^1oG\u0016d\u0015N\\3t!>Lg\u000e^:\u0015\u0011\u0005]\u0011qZAj\u0003/Dq!!5+\u0001\u0004\t),A\u0003mS:,7\u000fC\u0004\u0002V*\u0002\r!!.\u0002\rA|\u0017N\u001c;t\u0011\u001d\tyD\u000ba\u0001\u0003\u0017!\u0002\"a\u0006\u0002\\\u0006\u0015\u0018\u0011\u001e\u0005\b\u0003;\\\u0003\u0019AAp\u0003\u0015a\u0017N\\31!\ra\u0015\u0011]\u0005\u0004\u0003Gl%A\u0003'j]\u0016\u001cFO]5oO\"9\u0011q]\u0016A\u0002\u0005}\u0017!\u00027j]\u0016\f\u0004bBA W\u0001\u0007\u00111\u0002\u000b\t\u0003/\ti/!=\u0002|\"9\u0011q\u001e\u0017A\u0002\u0005}\u0017\u0001\u00027j]\u0016Dq!a=-\u0001\u0004\t)0\u0001\u0002qiB\u0019A*a>\n\u0007\u0005eXJA\u0003Q_&tG\u000fC\u0004\u0002@1\u0002\r!a\u0003")
public class DistanceOp {
    private final Geometry g0;
    private final Geometry g1;
    private final double terminateDistance;
    private final Geometry[] baseGeometry;
    private final Geometry[] geom;
    private final PointLocator ptLocator;
    private GeometryLocation[] minDistanceLocation;
    private double minDistance;
    private volatile byte bitmap$init$0;

    public static boolean isWithinDistance(Geometry geometry, Geometry geometry2, double d) {
        return DistanceOp$.MODULE$.isWithinDistance(geometry, geometry2, d);
    }

    public Geometry g0() {
        return this.g0;
    }

    public Geometry g1() {
        return this.g1;
    }

    public double terminateDistance() {
        return this.terminateDistance;
    }

    public Geometry[] baseGeometry() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/distance/DistanceOp.scala: 127");
        }
        return this.baseGeometry;
    }

    private Geometry[] geom() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/distance/DistanceOp.scala: 131");
        }
        return this.geom;
    }

    private PointLocator ptLocator() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/distance/DistanceOp.scala: 133");
        }
        return this.ptLocator;
    }

    private GeometryLocation[] minDistanceLocation() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/distance/DistanceOp.scala: 134");
        }
        return this.minDistanceLocation;
    }

    private void minDistanceLocation_$eq(GeometryLocation[] x$1) {
        this.minDistanceLocation = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private double minDistance() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/distance/DistanceOp.scala: 135");
        }
        return this.minDistance;
    }

    private void minDistance_$eq(double x$1) {
        this.minDistance = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    public double distance() {
        if (this.geom()[0] == null || this.geom()[1] == null) {
            throw new IllegalArgumentException("null geometries are not supported");
        }
        if (this.geom()[0].isEmpty() || this.geom()[1].isEmpty()) {
            return 0.0;
        }
        this.computeMinDistance();
        return this.minDistance();
    }

    /*
     * WARNING - void declaration
     */
    public Coordinate[] nearestPoints() {
        void var1_1;
        this.computeMinDistance();
        Coordinate[] nearestPts = (Coordinate[])((Object[])new Coordinate[]{this.minDistanceLocation()[0].getCoordinate(), this.minDistanceLocation()[1].getCoordinate()});
        return var1_1;
    }

    public Coordinate[] closestPoints() {
        return this.nearestPoints();
    }

    public GeometryLocation[] nearestLocations() {
        this.computeMinDistance();
        return this.minDistanceLocation();
    }

    public GeometryLocation[] closestLocations() {
        return this.nearestLocations();
    }

    private void updateMinDistance(GeometryLocation[] locGeom, boolean flip) {
        if (locGeom[0] == null) {
            return;
        }
        if (flip) {
            this.minDistanceLocation()[0] = locGeom[1];
            this.minDistanceLocation()[1] = locGeom[0];
        } else {
            this.minDistanceLocation()[0] = locGeom[0];
            this.minDistanceLocation()[1] = locGeom[1];
        }
    }

    private void computeMinDistance() {
        if (this.minDistanceLocation() != null) {
            return;
        }
        this.minDistanceLocation_$eq(new GeometryLocation[2]);
        this.computeContainmentDistance();
        if (this.minDistance() <= this.terminateDistance()) {
            return;
        }
        this.computeFacetDistance();
    }

    private void computeContainmentDistance() {
        GeometryLocation[] locPtPoly = new GeometryLocation[2];
        this.computeContainmentDistance(0, locPtPoly);
        if (this.minDistance() <= this.terminateDistance()) {
            return;
        }
        this.computeContainmentDistance(1, locPtPoly);
    }

    private void computeContainmentDistance(int polyGeomIndex, GeometryLocation[] locPtPoly) {
        Geometry polyGeom = this.geom()[polyGeomIndex];
        if (polyGeom.getDimension() < 2) {
            return;
        }
        int locationsIndex = 1 - polyGeomIndex;
        List<Geometry> polys = PolygonExtracter$.MODULE$.getPolygons(polyGeom);
        if (polys.size() > 0) {
            ArrayList<GeometryLocation> insideLocs = ConnectedElementLocationFilter$.MODULE$.getLocations(this.geom()[locationsIndex]);
            this.computeContainmentDistance(insideLocs, polys, locPtPoly);
            if (this.minDistance() <= this.terminateDistance()) {
                this.minDistanceLocation()[locationsIndex] = locPtPoly[0];
                this.minDistanceLocation()[polyGeomIndex] = locPtPoly[1];
                return;
            }
        }
    }

    private void computeContainmentDistance(List<?> locs, List<?> polys, GeometryLocation[] locPtPoly) {
        for (int i = 0; i < locs.size(); ++i) {
            GeometryLocation loc = (GeometryLocation)locs.get(i);
            for (int j = 0; j < polys.size(); ++j) {
                this.computeContainmentDistance(loc, (Polygon)polys.get(j), locPtPoly);
                if (!(this.minDistance() <= this.terminateDistance())) continue;
                return;
            }
        }
    }

    private void computeContainmentDistance(GeometryLocation ptLoc, Polygon poly, GeometryLocation[] locPtPoly) {
        Coordinate pt = ptLoc.getCoordinate();
        if (Location$.MODULE$.EXTERIOR() != this.ptLocator().locate(pt, poly)) {
            this.minDistance_$eq(0.0);
            locPtPoly[0] = ptLoc;
            locPtPoly[1] = new GeometryLocation(poly, pt);
            return;
        }
    }

    private void computeFacetDistance() {
        GeometryLocation[] locGeom = new GeometryLocation[2];
        ArrayList<Geometry> lines0 = LinearComponentExtracter$.MODULE$.getLines(this.geom()[0]);
        ArrayList<Geometry> lines1 = LinearComponentExtracter$.MODULE$.getLines(this.geom()[1]);
        List<Geometry> pts0 = PointExtracter$.MODULE$.getPoints(this.geom()[0]);
        List<Geometry> pts1 = PointExtracter$.MODULE$.getPoints(this.geom()[1]);
        this.computeMinDistanceLines(lines0, lines1, locGeom);
        this.updateMinDistance(locGeom, false);
        if (this.minDistance() <= this.terminateDistance()) {
            return;
        }
        locGeom[0] = null;
        locGeom[1] = null;
        this.computeMinDistanceLinesPoints(lines0, pts1, locGeom);
        this.updateMinDistance(locGeom, false);
        if (this.minDistance() <= this.terminateDistance()) {
            return;
        }
        locGeom[0] = null;
        locGeom[1] = null;
        this.computeMinDistanceLinesPoints(lines1, pts0, locGeom);
        this.updateMinDistance(locGeom, true);
        if (this.minDistance() <= this.terminateDistance()) {
            return;
        }
        locGeom[0] = null;
        locGeom[1] = null;
        this.computeMinDistancePoints(pts0, pts1, locGeom);
        this.updateMinDistance(locGeom, false);
    }

    private void computeMinDistanceLines(List<Geometry> lines0, List<Geometry> lines1, GeometryLocation[] locGeom) {
        int i = 0;
        while (i < lines0.size()) {
            LineString line0 = (LineString)lines0.get(i);
            int j = 0;
            while (j < lines1.size()) {
                LineString line1 = (LineString)lines1.get(j);
                this.computeMinDistance(line0, line1, locGeom);
                if (this.minDistance() <= this.terminateDistance()) {
                    return;
                }
                int cfr_ignored_0 = ++j - 1;
            }
            int cfr_ignored_1 = ++i - 1;
        }
    }

    private void computeMinDistancePoints(List<Geometry> points0, List<Geometry> points1, GeometryLocation[] locGeom) {
        int i = 0;
        while (i < points0.size()) {
            Point pt0 = (Point)points0.get(i);
            int j = 0;
            while (j < points1.size()) {
                Point pt1 = (Point)points1.get(j);
                double dist = pt0.getCoordinate().distance(pt1.getCoordinate());
                if (dist < this.minDistance()) {
                    this.minDistance_$eq(dist);
                    locGeom[0] = new GeometryLocation(pt0, 0, pt0.getCoordinate());
                    locGeom[1] = new GeometryLocation(pt1, 0, pt1.getCoordinate());
                }
                if (this.minDistance() <= this.terminateDistance()) {
                    return;
                }
                int cfr_ignored_0 = ++j - 1;
            }
            int cfr_ignored_1 = ++i - 1;
        }
    }

    private void computeMinDistanceLinesPoints(List<Geometry> lines, List<Geometry> points, GeometryLocation[] locGeom) {
        int i = 0;
        while (i < lines.size()) {
            LineString line = (LineString)lines.get(i);
            int j = 0;
            while (j < points.size()) {
                Point pt = (Point)points.get(j);
                this.computeMinDistance(line, pt, locGeom);
                if (this.minDistance() <= this.terminateDistance()) {
                    return;
                }
                int cfr_ignored_0 = ++j - 1;
            }
            int cfr_ignored_1 = ++i - 1;
        }
    }

    private void computeMinDistance(LineString line0, LineString line1, GeometryLocation[] locGeom) {
        if (line0.getEnvelopeInternal().distance(line1.getEnvelopeInternal()) > this.minDistance()) {
            return;
        }
        Coordinate[] coord0 = line0.getCoordinates();
        Coordinate[] coord1 = line1.getCoordinates();
        for (int i = 0; i < coord0.length - 1; ++i) {
            Envelope segEnv0 = new Envelope(coord0[i], coord0[i + 1]);
            if (!(segEnv0.distance(line1.getEnvelopeInternal()) <= this.minDistance())) continue;
            for (int j = 0; j < coord1.length - 1; ++j) {
                Envelope segEnv1 = new Envelope(coord1[j], coord1[j + 1]);
                if (!(segEnv0.distance(segEnv1) <= this.minDistance())) continue;
                double dist = Distance$.MODULE$.segmentToSegment(coord0[i], coord0[i + 1], coord1[j], coord1[j + 1]);
                if (dist < this.minDistance()) {
                    this.minDistance_$eq(dist);
                    LineSegment seg0 = new LineSegment(coord0[i], coord0[i + 1]);
                    LineSegment seg1 = new LineSegment(coord1[j], coord1[j + 1]);
                    Coordinate[] closestPt = seg0.closestPoints(seg1);
                    locGeom[0] = new GeometryLocation(line0, i, closestPt[0]);
                    locGeom[1] = new GeometryLocation(line1, j, closestPt[1]);
                }
                if (!(this.minDistance() <= this.terminateDistance())) continue;
                return;
            }
        }
    }

    private void computeMinDistance(LineString line, Point pt, GeometryLocation[] locGeom) {
        if (line.getEnvelopeInternal().distance(pt.getEnvelopeInternal()) > this.minDistance()) {
            return;
        }
        Coordinate[] coord0 = line.getCoordinates();
        Coordinate coord = pt.getCoordinate();
        for (int i = 0; i < coord0.length - 1; ++i) {
            double dist = Distance$.MODULE$.pointToSegment(coord, coord0[i], coord0[i + 1]);
            if (dist < this.minDistance()) {
                this.minDistance_$eq(dist);
                LineSegment seg = new LineSegment(coord0[i], coord0[i + 1]);
                Coordinate segClosestPoint = seg.closestPoint(coord);
                locGeom[0] = new GeometryLocation(line, i, segClosestPoint);
                locGeom[1] = new GeometryLocation(pt, 0, coord);
            }
            if (!(this.minDistance() <= this.terminateDistance())) continue;
            return;
        }
    }

    public DistanceOp(Geometry g0, Geometry g1, double terminateDistance) {
        this.g0 = g0;
        this.g1 = g1;
        this.terminateDistance = terminateDistance;
        this.baseGeometry = new Geometry[2];
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.baseGeometry()[0] = g0;
        this.baseGeometry()[1] = g1;
        this.geom = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.ptLocator = new PointLocator(PointLocator$.MODULE$.$lessinit$greater$default$1());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.minDistanceLocation = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.minDistance = Double.MAX_VALUE;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    public DistanceOp(Geometry g0, Geometry g1) {
        this(g0, g1, 0.0);
    }
}

