/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import org.locationtech.jts.algorithm.Distance$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.operation.distance.GeometryLocation;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\f\u0019\u0001\rB\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005Y!A!\u0007\u0001BC\u0002\u0013\u00051\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00035\u0011!A\u0004A!b\u0001\n\u0003I\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011y\u0002!Q1A\u0005\u0002eB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006\u0001\u0002!\t!\u0011\u0005\u0006\u0001\u0002!\t\u0001\u0013\u0005\u0006\u0001\u0002!\t\u0001\u0014\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\u0006)\u0002!\t!\u000f\u0005\u0006+\u0002!\tA\u0016\u0005\u00069\u0002!\t!\u0018\u0005\u00063\u0001!\t!\u0019\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006a\u0002!I!\u001d\u0005\u0006k\u0002!IA\u001e\u0005\b\u0003#\u0001A\u0011BA\n\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!!\f\u0001\t\u0003\nyCA\u0007GC\u000e,GoU3rk\u0016t7-\u001a\u0006\u00033i\t\u0001\u0002Z5ti\u0006t7-\u001a\u0006\u00037q\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\u000b\u0005uq\u0012a\u00016ug*\u0011q\u0004I\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002C\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\n\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0002\t\u001d,w.\\\u000b\u0002YA\u0011QfL\u0007\u0002])\u0011!\u0006H\u0005\u0003a9\u0012\u0001bR3p[\u0016$(/_\u0001\u0006O\u0016|W\u000eI\u0001\u0004aR\u001cX#\u0001\u001b\u0011\u00055*\u0014B\u0001\u001c/\u0005I\u0019un\u001c:eS:\fG/Z*fcV,gnY3\u0002\tA$8\u000fI\u0001\u0006gR\f'\u000f^\u000b\u0002uA\u0011QeO\u0005\u0003y\u0019\u00121!\u00138u\u0003\u0019\u0019H/\u0019:uA\u0005\u0019QM\u001c3\u0002\t\u0015tG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\t#UIR$\u0011\u0005\r\u0003Q\"\u0001\r\t\u000b)J\u0001\u0019\u0001\u0017\t\u000bIJ\u0001\u0019\u0001\u001b\t\u000baJ\u0001\u0019\u0001\u001e\t\u000byJ\u0001\u0019\u0001\u001e\u0015\t\tK%j\u0013\u0005\u0006e)\u0001\r\u0001\u000e\u0005\u0006q)\u0001\rA\u000f\u0005\u0006})\u0001\rA\u000f\u000b\u0004\u00056s\u0005\"\u0002\u001a\f\u0001\u0004!\u0004\"\u0002\u001d\f\u0001\u0004Q\u0014aC4fi\u0016sg/\u001a7pa\u0016,\u0012!\u0015\t\u0003[IK!a\u0015\u0018\u0003\u0011\u0015sg/\u001a7pa\u0016\fAa]5{K\u0006iq-\u001a;D_>\u0014H-\u001b8bi\u0016$\"a\u0016.\u0011\u00055B\u0016BA-/\u0005)\u0019un\u001c:eS:\fG/\u001a\u0005\u00067:\u0001\rAO\u0001\u0006S:$W\r_\u0001\bSN\u0004v.\u001b8u+\u0005q\u0006CA\u0013`\u0013\t\u0001gEA\u0004C_>dW-\u00198\u0015\u0005\t,\u0007CA\u0013d\u0013\t!gE\u0001\u0004E_V\u0014G.\u001a\u0005\u0006MB\u0001\rAQ\u0001\tM\u0006\u001cW\r^*fc\u0006\u0001b.Z1sKN$Hj\\2bi&|gn\u001d\u000b\u0003S>\u00042!\n6m\u0013\tYgEA\u0003BeJ\f\u0017\u0010\u0005\u0002D[&\u0011a\u000e\u0007\u0002\u0011\u000f\u0016|W.\u001a;ss2{7-\u0019;j_:DQAZ\tA\u0002\t\u000bqcY8naV$X\rR5ti\u0006t7-\u001a'j]\u0016d\u0015N\\3\u0015\u0007\t\u00148\u000fC\u0003g%\u0001\u0007!\tC\u0003u%\u0001\u0007\u0011.\u0001\u0003m_\u000e\u001c\u0018AH;qI\u0006$XMT3be\u0016\u001cH\u000fT8dCRLwN\\:MS:,G*\u001b8f)99(\u0010 @\u0002\u0002\u0005\r\u0011qAA\u0006\u0003\u001f\u0001\"!\n=\n\u0005e4#\u0001B+oSRDQa_\nA\u0002i\n\u0011!\u001b\u0005\u0006{N\u0001\raV\u0001\u0003aBBQa`\nA\u0002]\u000b!\u0001]\u0019\t\u000b\u0019\u001c\u0002\u0019\u0001\"\t\r\u0005\u00151\u00031\u0001;\u0003\u0005Q\u0007BBA\u0005'\u0001\u0007q+\u0001\u0002ra!1\u0011QB\nA\u0002]\u000b!!]\u0019\t\u000bQ\u001c\u0002\u0019A5\u00021\r|W\u000e];uK\u0012K7\u000f^1oG\u0016\u0004v.\u001b8u\u0019&tW\rF\u0004c\u0003+\tI\"a\u0007\t\r\u0005]A\u00031\u0001X\u0003\t\u0001H\u000fC\u0003g)\u0001\u0007!\tC\u0003u)\u0001\u0007\u0011.A\u0010va\u0012\fG/\u001a(fCJ,7\u000f\u001e'pG\u0006$\u0018n\u001c8t!>Lg\u000e\u001e'j]\u0016$Rb^A\u0011\u0003G\t)#a\n\u0002*\u0005-\u0002BBA\f+\u0001\u0007q\u000bC\u0003g+\u0001\u0007!\tC\u0003|+\u0001\u0007!\b\u0003\u0004\u0002\nU\u0001\ra\u0016\u0005\u0007\u0003\u001b)\u0002\u0019A,\t\u000bQ,\u0002\u0019A5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\r\u0011\t\u0005M\u0012\u0011\t\b\u0005\u0003k\ti\u0004E\u0002\u00028\u0019j!!!\u000f\u000b\u0007\u0005m\"%\u0001\u0004=e>|GOP\u0005\u0004\u0003\u007f1\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002D\u0005\u0015#AB*ue&twMC\u0002\u0002@\u0019\u0002")
public class FacetSequence {
    private final Geometry geom;
    private final CoordinateSequence pts;
    private final int start;
    private final int end;

    public Geometry geom() {
        return this.geom;
    }

    public CoordinateSequence pts() {
        return this.pts;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    /*
     * WARNING - void declaration
     */
    public Envelope getEnvelope() {
        void var1_1;
        Envelope env = new Envelope();
        for (int i = this.start(); i < this.end(); ++i) {
            env.expandToInclude(this.pts().getX(i), this.pts().getY(i));
        }
        return var1_1;
    }

    public int size() {
        return this.end() - this.start();
    }

    public Coordinate getCoordinate(int index) {
        return this.pts().getCoordinate(this.start() + index);
    }

    public boolean isPoint() {
        return this.end() - this.start() == 1;
    }

    public double distance(FacetSequence facetSeq) {
        boolean visPoint = this.isPoint();
        boolean isPointOther = facetSeq.isPoint();
        double distance = 0.0;
        if (visPoint && isPointOther) {
            Coordinate pt = this.pts().getCoordinate(this.start());
            Coordinate seqPt = facetSeq.pts().getCoordinate(facetSeq.start());
            distance = pt.distance(seqPt);
        } else if (this.isPoint()) {
            Coordinate pt = this.pts().getCoordinate(this.start());
            distance = this.computeDistancePointLine(pt, facetSeq, null);
        } else if (isPointOther) {
            Coordinate seqPt = facetSeq.pts().getCoordinate(facetSeq.start());
            distance = this.computeDistancePointLine(seqPt, this, null);
        } else {
            distance = this.computeDistanceLineLine(facetSeq, null);
        }
        return distance;
    }

    public GeometryLocation[] nearestLocations(FacetSequence facetSeq) {
        Double d;
        boolean visPoint = this.isPoint();
        boolean isPointOther = facetSeq.isPoint();
        GeometryLocation[] locs = new GeometryLocation[2];
        if (visPoint && isPointOther) {
            Coordinate pt = this.pts().getCoordinate(this.start());
            Coordinate seqPt = facetSeq.pts().getCoordinate(facetSeq.start());
            locs[0] = new GeometryLocation(this.geom(), this.start(), new Coordinate(pt));
            locs[1] = new GeometryLocation(facetSeq.geom(), facetSeq.start(), new Coordinate(seqPt));
            d = BoxedUnit.UNIT;
        } else if (visPoint) {
            Coordinate pt = this.pts().getCoordinate(this.start());
            d = BoxesRunTime.boxToDouble((double)this.computeDistancePointLine(pt, facetSeq, locs));
        } else if (isPointOther) {
            Coordinate seqPt = facetSeq.pts().getCoordinate(facetSeq.start());
            this.computeDistancePointLine(seqPt, this, locs);
            GeometryLocation tmp = locs[0];
            locs[0] = locs[1];
            locs[1] = tmp;
            d = BoxedUnit.UNIT;
        } else {
            d = BoxesRunTime.boxToDouble((double)this.computeDistanceLineLine(facetSeq, locs));
        }
        return locs;
    }

    /*
     * WARNING - void declaration
     */
    private double computeDistanceLineLine(FacetSequence facetSeq, GeometryLocation[] locs) {
        void var3_3;
        double minDistance = Double.MAX_VALUE;
        for (int i = this.start(); i < this.end() - 1; ++i) {
            Coordinate p0 = this.pts().getCoordinate(i);
            Coordinate p1 = this.pts().getCoordinate(i + 1);
            for (int j = facetSeq.start(); j < facetSeq.end() - 1; ++j) {
                Coordinate q1;
                Coordinate q0 = facetSeq.pts().getCoordinate(j);
                double dist = Distance$.MODULE$.segmentToSegment(p0, p1, q0, q1 = facetSeq.pts().getCoordinate(j + 1));
                if (!(dist < minDistance)) continue;
                minDistance = dist;
                if (locs != null) {
                    this.updateNearestLocationsLineLine(i, p0, p1, facetSeq, j, q0, q1, locs);
                }
                if (!(minDistance <= 0.0)) continue;
                return minDistance;
            }
        }
        return (double)var3_3;
    }

    private void updateNearestLocationsLineLine(int i, Coordinate p0, Coordinate p1, FacetSequence facetSeq, int j, Coordinate q0, Coordinate q1, GeometryLocation[] locs) {
        LineSegment seg0 = new LineSegment(p0, p1);
        LineSegment seg1 = new LineSegment(q0, q1);
        Coordinate[] closestPt = seg0.closestPoints(seg1);
        locs[0] = new GeometryLocation(this.geom(), i, new Coordinate(closestPt[0]));
        locs[1] = new GeometryLocation(facetSeq.geom(), j, new Coordinate(closestPt[1]));
    }

    private double computeDistancePointLine(Coordinate pt, FacetSequence facetSeq, GeometryLocation[] locs) {
        double minDistance = Double.MAX_VALUE;
        for (int i = facetSeq.start(); i < facetSeq.end() - 1; ++i) {
            Coordinate q1;
            Coordinate q0 = facetSeq.pts().getCoordinate(i);
            double dist = Distance$.MODULE$.pointToSegment(pt, q0, q1 = facetSeq.pts().getCoordinate(i + 1));
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            if (locs != null) {
                this.updateNearestLocationsPointLine(pt, facetSeq, i, q0, q1, locs);
            }
            if (!(minDistance <= 0.0)) continue;
            return minDistance;
        }
        return minDistance;
    }

    private void updateNearestLocationsPointLine(Coordinate pt, FacetSequence facetSeq, int i, Coordinate q0, Coordinate q1, GeometryLocation[] locs) {
        locs[0] = new GeometryLocation(this.geom(), this.start(), new Coordinate(pt));
        LineSegment seg = new LineSegment(q0, q1);
        Coordinate segClosestPoint = seg.closestPoint(pt);
        locs[1] = new GeometryLocation(facetSeq.geom(), i, new Coordinate(segClosestPoint));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LINESTRING ( ");
        Coordinate p = new Coordinate();
        for (int i = this.start(); i < this.end(); ++i) {
            Object object = i > this.start() ? buf.append(", ") : BoxedUnit.UNIT;
            this.pts().getCoordinate(i, p);
            buf.append(new StringBuilder(1).append(p.x()).append(" ").append(p.y()).toString());
        }
        buf.append(" )");
        return buf.toString();
    }

    public FacetSequence(Geometry geom, CoordinateSequence pts, int start, int end) {
        this.geom = geom;
        this.pts = pts;
        this.start = start;
        this.end = end;
    }

    public FacetSequence(CoordinateSequence pts, int start, int end) {
        this(null, pts, start, end);
    }

    public FacetSequence(CoordinateSequence pts, int start) {
        this(null, pts, start, start + 1);
    }
}

