/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.operation.overlay.OverlayOp;
import org.locationtech.jts.operation.overlay.OverlayOp$;
import org.locationtech.jts.util.Assert$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0004%\t!\u000b\u0005\t]\u0001\u0011\t\u0019!C\u0001_!AQ\u0007\u0001B\u0001B\u0003&!\u0006\u0003\u00057\u0001\t\u0005\r\u0011\"\u00018\u0011!q\u0004A!a\u0001\n\u0003y\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u001d\t\u0011\t\u0003!\u00111A\u0005\u0002\rC\u0001B\u0013\u0001\u0003\u0002\u0004%\ta\u0013\u0005\t\u001b\u0002\u0011\t\u0011)Q\u0005\t\")a\n\u0001C\u0001\u001f\"9A\u000b\u0001b\u0001\n\u0013)\u0006B\u00023\u0001A\u0003%a\u000bC\u0004f\u0001\t\u0007I\u0011\u00024\t\r-\u0004\u0001\u0015!\u0003h\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u0015)\b\u0001\"\u0003w\u0011\u0015A\b\u0001\"\u0003z\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001bAq!!\u0006\u0001\t\u0013\t9BA\u0006MS:,')^5mI\u0016\u0014(BA\f\u0019\u0003\u001dyg/\u001a:mCfT!!\u0007\u000e\u0002\u0013=\u0004XM]1uS>t'BA\u000e\u001d\u0003\rQGo\u001d\u0006\u0003;y\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aH\u0001\u0004_J<7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017AA8q+\u0005Q\u0003CA\u0016-\u001b\u00051\u0012BA\u0017\u0017\u0005%ye/\u001a:mCf|\u0005/\u0001\u0004pa~#S-\u001d\u000b\u0003aM\u0002\"aI\u0019\n\u0005I\"#\u0001B+oSRDq\u0001\u000e\u0002\u0002\u0002\u0003\u0007!&A\u0002yIE\n1a\u001c9!\u0003=9Wm\\7fiJLh)Y2u_JLX#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0005mR\u0012\u0001B4f_6L!!\u0010\u001e\u0003\u001f\u001d+w.\\3uef4\u0015m\u0019;pef\f1cZ3p[\u0016$(/\u001f$bGR|'/_0%KF$\"\u0001\r!\t\u000fQ*\u0011\u0011!a\u0001q\u0005\u0001r-Z8nKR\u0014\u0018PR1di>\u0014\u0018\u0010I\u0001\naRdunY1u_J,\u0012\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fj\t\u0011\"\u00197h_JLG\u000f[7\n\u0005%3%\u0001\u0004)pS:$Hj\\2bi>\u0014\u0018!\u00049u\u0019>\u001c\u0017\r^8s?\u0012*\u0017\u000f\u0006\u00021\u0019\"9A\u0007CA\u0001\u0002\u0004!\u0015A\u00039u\u0019>\u001c\u0017\r^8sA\u00051A(\u001b8jiz\"B\u0001U)S'B\u00111\u0006\u0001\u0005\u0006Q)\u0001\rA\u000b\u0005\u0006m)\u0001\r\u0001\u000f\u0005\u0006\u0005*\u0001\r\u0001R\u0001\u000eY&tW-\u00123hKNd\u0015n\u001d;\u0016\u0003Y\u00032a\u0016/_\u001b\u0005A&BA-[\u0003\u0011)H/\u001b7\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0017\u0002\n\u0003J\u0014\u0018-\u001f'jgR\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019\u000e\u0002\u0013\u001d,w.\\4sCBD\u0017BA2a\u0005\u0011)EmZ3\u0002\u001d1Lg.Z#eO\u0016\u001cH*[:uA\u0005q!/Z:vYRd\u0015N\\3MSN$X#A4\u0011\u0007]c\u0006\u000e\u0005\u0002:S&\u0011!N\u000f\u0002\u000b\u0019&tWm\u0015;sS:<\u0017a\u0004:fgVdG\u000fT5oK2K7\u000f\u001e\u0011\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0005\u001dt\u0007\"B8\u0010\u0001\u0004\u0001\u0018AB8q\u0007>$W\r\u0005\u0002$c&\u0011!\u000f\n\u0002\u0004\u0013:$\u0018\u0001\u00064j]\u0012\u001cuN^3sK\u0012d\u0015N\\3FI\u001e,7\u000fF\u00011\u00031\u0019w\u000e\u001c7fGRd\u0015N\\3t)\t\u0001t\u000fC\u0003p#\u0001\u0007\u0001/A\bd_2dWm\u0019;MS:,W\tZ4f)\u0015\u0001$p`A\u0001\u0011\u0015Y(\u00031\u0001}\u0003\t!W\r\u0005\u0002`{&\u0011a\u0010\u0019\u0002\r\t&\u0014Xm\u0019;fI\u0016#w-\u001a\u0005\u0006_J\u0001\r\u0001\u001d\u0005\b\u0003\u0007\u0011\u0002\u0019AA\u0003\u0003\u0015)GmZ3t!\u00119\u0016q\u00010\n\u0007\u0005%\u0001L\u0001\u0003MSN$\u0018\u0001G2pY2,7\r\u001e\"pk:$\u0017M]=U_V\u001c\u0007.\u00123hKR9\u0001'a\u0004\u0002\u0012\u0005M\u0001\"B>\u0014\u0001\u0004a\b\"B8\u0014\u0001\u0004\u0001\bbBA\u0002'\u0001\u0007\u0011QA\u0001\u000bEVLG\u000e\u001a'j]\u0016\u001cHc\u0001\u0019\u0002\u001a!)q\u000e\u0006a\u0001a\u0002")
public class LineBuilder {
    private OverlayOp op;
    private GeometryFactory geometryFactory;
    private PointLocator ptLocator;
    private final ArrayList<Edge> lineEdgesList;
    private final ArrayList<LineString> resultLineList;
    private volatile byte bitmap$init$0;

    public OverlayOp op() {
        return this.op;
    }

    public void op_$eq(OverlayOp x$1) {
        this.op = x$1;
    }

    public GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    public void geometryFactory_$eq(GeometryFactory x$1) {
        this.geometryFactory = x$1;
    }

    public PointLocator ptLocator() {
        return this.ptLocator;
    }

    public void ptLocator_$eq(PointLocator x$1) {
        this.ptLocator = x$1;
    }

    private ArrayList<Edge> lineEdgesList() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/overlay/LineBuilder.scala: 40");
        }
        return this.lineEdgesList;
    }

    private ArrayList<LineString> resultLineList() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/overlay/LineBuilder.scala: 41");
        }
        return this.resultLineList;
    }

    public ArrayList<LineString> build(int opCode) {
        this.findCoveredLineEdges();
        this.collectLines(opCode);
        this.buildLines(opCode);
        return this.resultLineList();
    }

    private void findCoveredLineEdges() {
        for (Node node : this.op().getGraph().getNodes()) {
            ((DirectedEdgeStar)node.getEdges()).findCoveredLineEdges();
        }
        for (DirectedEdge directedEdge : this.op().getGraph().getEdgeEnds()) {
            Edge e = directedEdge.getEdge();
            if (!directedEdge.isLineEdge() || e.isCoveredSet()) continue;
            boolean isCovered = this.op().isCoveredByA(directedEdge.getCoordinate());
            e.setCovered(isCovered);
        }
    }

    private void collectLines(int opCode) {
        for (DirectedEdge directedEdge : this.op().getGraph().getEdgeEnds()) {
            this.collectLineEdge(directedEdge, opCode, this.lineEdgesList());
            this.collectBoundaryTouchEdge(directedEdge, opCode, this.lineEdgesList());
        }
    }

    private void collectLineEdge(DirectedEdge de, int opCode, List<Edge> edges) {
        block0: {
            Label label = de.getLabel();
            Edge e = de.getEdge();
            if (!de.isLineEdge() || de.isVisited() || !OverlayOp$.MODULE$.isResultOfOp(label, opCode) || e.isCovered()) break block0;
            edges.add(e);
            de.setVisitedEdge(true);
        }
    }

    private void collectBoundaryTouchEdge(DirectedEdge de, int opCode, List<Edge> edges) {
        block4: {
            Label label = de.getLabel();
            if (de.isLineEdge()) {
                return;
            }
            if (de.isVisited()) {
                return;
            }
            if (de.isInteriorAreaEdge()) {
                return;
            }
            if (de.getEdge().isInResult()) {
                return;
            }
            Assert$.MODULE$.isTrue(!de.isInResult() && !de.getSym().isInResult() || !de.getEdge().isInResult());
            if (!OverlayOp$.MODULE$.isResultOfOp(label, opCode) || opCode != OverlayOp$.MODULE$.INTERSECTION()) break block4;
            edges.add(de.getEdge());
            de.setVisitedEdge(true);
        }
    }

    private void buildLines(int opCode) {
        for (Edge e : this.lineEdgesList()) {
            LineString line = this.geometryFactory().createLineString(e.getCoordinates());
            this.resultLineList().add(line);
            e.setInResult(true);
        }
    }

    public LineBuilder(OverlayOp op, GeometryFactory geometryFactory, PointLocator ptLocator) {
        this.op = op;
        this.geometryFactory = geometryFactory;
        this.ptLocator = ptLocator;
        this.lineEdgesList = new ArrayList();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.resultLineList = new ArrayList();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

