/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeRing;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.geomgraph.PlanarGraph$;
import org.locationtech.jts.operation.overlay.MaximalEdgeRing;
import org.locationtech.jts.operation.overlay.MinimalEdgeRing;
import org.locationtech.jts.operation.overlay.PolygonBuilder$;
import org.locationtech.jts.util.Assert$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\rt!B\u000b\u0017\u0011\u0003\tc!B\u0012\u0017\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003\"B\u0017\u0002\t\u0013qc\u0001B\u0012\u0017\u00015C\u0001B\u0014\u0003\u0003\u0002\u0004%\ta\u0014\u0005\t-\u0012\u0011\t\u0019!C\u0001/\"AQ\f\u0002B\u0001B\u0003&\u0001\u000bC\u0003,\t\u0011\u0005a\fC\u00049\t\t\u0007I\u0011B1\t\r\u0015$\u0001\u0015!\u0003c\u0011\u00151G\u0001\"\u0001h\u0011\u00151G\u0001\"\u0001n\u0011\u0015aH\u0001\"\u0001~\u0011\u001d\t)\u0001\u0002C\u0005\u0003\u000fAq!a\u0005\u0005\t\u0013\t)\u0002C\u0004\u0002&\u0011!I!a\n\t\u000f\u0005UB\u0001\"\u0003\u00028!9\u0011q\b\u0003\u0005\n\u0005\u0005\u0003bBA&\t\u0011%\u0011Q\n\u0005\b\u0003;\"A\u0011BA0\u00039\u0001v\u000e\\=h_:\u0014U/\u001b7eKJT!a\u0006\r\u0002\u000f=4XM\u001d7bs*\u0011\u0011DG\u0001\n_B,'/\u0019;j_:T!a\u0007\u000f\u0002\u0007)$8O\u0003\u0002\u001e=\u0005aAn\\2bi&|g\u000e^3dQ*\tq$A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002#\u00035\taC\u0001\bQ_2Lxm\u001c8Ck&dG-\u001a:\u0014\u0005\u0005)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002C\u00051b-\u001b8e\u000b\u0012<WMU5oO\u000e{g\u000e^1j]&tw\rF\u00020k]\u0002\"\u0001M\u001a\u000e\u0003ER!A\r\u000e\u0002\u0013\u001d,w.\\4sCBD\u0017B\u0001\u001b2\u0005!)EmZ3SS:<\u0007\"\u0002\u001c\u0004\u0001\u0004y\u0013A\u0002;fgR,%\u000fC\u00039\u0007\u0001\u0007\u0011(A\u0005tQ\u0016dG\u000eT5tiB\u0012!\b\u0012\t\u0004w\u0001\u0013U\"\u0001\u001f\u000b\u0005ur\u0014\u0001B;uS2T\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002By\t!A*[:u!\t\u0019E\t\u0004\u0001\u0005\u0013\u0015;\u0014\u0011!A\u0001\u0006\u00031%aA0%cE\u0011qI\u0013\t\u0003M!K!!S\u0014\u0003\u000f9{G\u000f[5oOB\u0011aeS\u0005\u0003\u0019\u001e\u00121!\u00118z'\t!Q%A\bhK>lW\r\u001e:z\r\u0006\u001cGo\u001c:z+\u0005\u0001\u0006CA)U\u001b\u0005\u0011&BA*\u001b\u0003\u00119Wm\\7\n\u0005U\u0013&aD$f_6,GO]=GC\u000e$xN]=\u0002'\u001d,w.\\3uef4\u0015m\u0019;pef|F%Z9\u0015\u0005a[\u0006C\u0001\u0014Z\u0013\tQvE\u0001\u0003V]&$\bb\u0002/\u0007\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\n\u0014\u0001E4f_6,GO]=GC\u000e$xN]=!)\ty\u0006\r\u0005\u0002#\t!)a\n\u0003a\u0001!V\t!\rE\u0002<G>J!\u0001\u001a\u001f\u0003\u0013\u0005\u0013(/Y=MSN$\u0018AC:iK2dG*[:uA\u0005\u0019\u0011\r\u001a3\u0015\u0005aC\u0007\"B5\f\u0001\u0004Q\u0017!B4sCBD\u0007C\u0001\u0019l\u0013\ta\u0017GA\u0006QY\u0006t\u0017M]$sCBDGc\u0001-om\")q\u000e\u0004a\u0001a\u0006AA-\u001b:FI\u001e,7\u000fE\u0002<cNL!A\u001d\u001f\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u00021i&\u0011Q/\r\u0002\b\u000b\u0012<W-\u00128e\u0011\u00159H\u00021\u0001y\u0003\u0015qw\u000eZ3t!\rY\u0014/\u001f\t\u0003aiL!a_\u0019\u0003\t9{G-Z\u0001\fO\u0016$\bk\u001c7zO>t7/F\u0001\u007f!\rY4m \t\u0004#\u0006\u0005\u0011bAA\u0002%\n9\u0001k\u001c7zO>t\u0017!\u00062vS2$W*\u0019=j[\u0006dW\tZ4f%&twm\u001d\u000b\u0005\u0003\u0013\t\t\u0002\u0005\u0003<G\u0006-\u0001c\u0001\u0012\u0002\u000e%\u0019\u0011q\u0002\f\u0003\u001f5\u000b\u00070[7bY\u0016#w-\u001a*j]\u001eDQa\u001c\bA\u0002A\fQCY;jY\u0012l\u0015N\\5nC2,EmZ3SS:<7\u000fF\u0004c\u0003/\ti\"!\t\t\u000f\u0005eq\u00021\u0001\u0002\u001c\u0005aQ.\u0019=FI\u001e,'+\u001b8hgB!1\bQA\u0006\u0011\u0019At\u00021\u0001\u0002 A\u00191\bQ\u0018\t\u000f\u0005\rr\u00021\u0001\u0002 \u0005aaM]3f\u0011>dW\rT5ti\u0006Ia-\u001b8e'\",G\u000e\u001c\u000b\u0005\u0003S\ty\u0003E\u0002#\u0003WI1!!\f\u0017\u0005=i\u0015N\\5nC2,EmZ3SS:<\u0007bBA\u0019!\u0001\u0007\u00111G\u0001\r[&tW\tZ4f%&twm\u001d\t\u0005w\u0001\u000bI#A\tqY\u0006\u001cW\rU8ms\u001e|g\u000eS8mKN$R\u0001WA\u001d\u0003{Aa!a\u000f\u0012\u0001\u0004y\u0013!B:iK2d\u0007bBA\u0019#\u0001\u0007\u00111G\u0001\u0013g>\u0014Ho\u00155fY2\u001c\u0018I\u001c3I_2,7\u000fF\u0004Y\u0003\u0007\n9%!\u0013\t\u000f\u0005\u0015#\u00031\u0001\u0002 \u0005IQ\rZ4f%&twm\u001d\u0005\u0007qI\u0001\r!a\b\t\u000f\u0005\r\"\u00031\u0001\u0002 \u0005q\u0001\u000f\\1dK\u001a\u0013X-\u001a%pY\u0016\u001cH#\u0002-\u0002P\u0005m\u0003B\u0002\u001d\u0014\u0001\u0004\t\t\u0006\r\u0003\u0002T\u0005]\u0003\u0003B\u001eA\u0003+\u00022aQA,\t-\tI&a\u0014\u0002\u0002\u0003\u0005)\u0011\u0001$\u0003\u0007}##\u0007C\u0004\u0002$M\u0001\r!a\b\u0002\u001f\r|W\u000e];uKB{G._4p]N$2A`A1\u0011\u0019AD\u00031\u0001\u0002 \u0001")
public class PolygonBuilder {
    private GeometryFactory geometryFactory;
    private final ArrayList<EdgeRing> shellList;
    private volatile boolean bitmap$init$0;

    public GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    public void geometryFactory_$eq(GeometryFactory x$1) {
        this.geometryFactory = x$1;
    }

    private ArrayList<EdgeRing> shellList() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/overlay/PolygonBuilder.scala: 91");
        }
        return this.shellList;
    }

    public void add(PlanarGraph graph) {
        this.add(graph.getEdgeEnds(), graph.getNodes());
    }

    public void add(Collection<EdgeEnd> dirEdges, Collection<Node> nodes) {
        PlanarGraph$.MODULE$.linkResultDirectedEdges(nodes);
        ArrayList<MaximalEdgeRing> maxEdgeRings = this.buildMaximalEdgeRings(dirEdges);
        ArrayList<EdgeRing> freeHoleList = new ArrayList<EdgeRing>();
        ArrayList<EdgeRing> edgeRings = this.buildMinimalEdgeRings(maxEdgeRings, this.shellList(), freeHoleList);
        this.sortShellsAndHoles(edgeRings, this.shellList(), freeHoleList);
        this.placeFreeHoles(this.shellList(), freeHoleList);
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<Polygon> getPolygons() {
        void var1_1;
        ArrayList<Polygon> resultPolyList = this.computePolygons(this.shellList());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<MaximalEdgeRing> buildMaximalEdgeRings(Collection<EdgeEnd> dirEdges) {
        void var2_2;
        ArrayList<MaximalEdgeRing> maxEdgeRings = new ArrayList<MaximalEdgeRing>();
        for (DirectedEdge directedEdge : dirEdges) {
            if (!directedEdge.isInResult() || !directedEdge.getLabel().isArea() || directedEdge.getEdgeRing() != null) continue;
            MaximalEdgeRing er = new MaximalEdgeRing(directedEdge, this.geometryFactory());
            maxEdgeRings.add(er);
            er.setInResult();
        }
        return var2_2;
    }

    private ArrayList<EdgeRing> buildMinimalEdgeRings(List<MaximalEdgeRing> maxEdgeRings, List<EdgeRing> shellList, List<EdgeRing> freeHoleList) {
        ArrayList<EdgeRing> edgeRings = new ArrayList<EdgeRing>();
        for (MaximalEdgeRing er : maxEdgeRings) {
            boolean bl;
            if (er.getMaxNodeDegree() > 2) {
                er.linkDirectedEdgesForMinimalEdgeRings();
                ArrayList<MinimalEdgeRing> minEdgeRings = er.buildMinimalRings();
                MinimalEdgeRing shell = this.findShell(minEdgeRings);
                if (shell != null) {
                    this.placePolygonHoles(shell, minEdgeRings);
                    bl = shellList.add(shell);
                    continue;
                }
                bl = freeHoleList.addAll(minEdgeRings);
                continue;
            }
            bl = edgeRings.add(er);
        }
        return edgeRings;
    }

    /*
     * WARNING - void declaration
     */
    private MinimalEdgeRing findShell(List<MinimalEdgeRing> minEdgeRings) {
        void var3_3;
        int shellCount = 0;
        MinimalEdgeRing shell = null;
        for (MinimalEdgeRing er : minEdgeRings) {
            if (er.isHole()) continue;
            shell = er;
            ++shellCount;
        }
        Assert$.MODULE$.isTrue(shellCount <= 1, "found two shells in MinimalEdgeRing list");
        return var3_3;
    }

    private void placePolygonHoles(EdgeRing shell, List<MinimalEdgeRing> minEdgeRings) {
        for (MinimalEdgeRing er : minEdgeRings) {
            if (!er.isHole()) continue;
            er.setShell(shell);
        }
    }

    private void sortShellsAndHoles(List<EdgeRing> edgeRings, List<EdgeRing> shellList, List<EdgeRing> freeHoleList) {
        for (EdgeRing er : edgeRings) {
            boolean bl = er.isHole() ? freeHoleList.add(er) : shellList.add(er);
        }
    }

    private void placeFreeHoles(List<?> shellList, List<EdgeRing> freeHoleList) {
        for (EdgeRing hole : freeHoleList) {
            if (hole.getShell() != null) continue;
            EdgeRing shell = PolygonBuilder$.MODULE$.org$locationtech$jts$operation$overlay$PolygonBuilder$$findEdgeRingContaining(hole, shellList);
            if (shell == null) {
                throw new TopologyException("unable to assign hole to a shell", hole.getCoordinate(0));
            }
            hole.setShell(shell);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<Polygon> computePolygons(List<EdgeRing> shellList) {
        void var2_2;
        ArrayList<Polygon> resultPolyList = new ArrayList<Polygon>();
        for (EdgeRing er : shellList) {
            Polygon poly = er.toPolygon(this.geometryFactory());
            resultPolyList.add(poly);
        }
        return var2_2;
    }

    public PolygonBuilder(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.shellList = new ArrayList();
        this.bitmap$init$0 = true;
    }
}

