/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.snap;

import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.PrecisionModel$;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;
import scala.UninitializedFieldError;

public final class GeometrySnapper$ {
    public static final GeometrySnapper$ MODULE$ = new GeometrySnapper$();
    private static final double SNAP_PRECISION_FACTOR = 1.0E-9;
    private static volatile boolean bitmap$init$0 = true;

    private double SNAP_PRECISION_FACTOR() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/overlay/snap/GeometrySnapper.scala: 52");
        }
        return SNAP_PRECISION_FACTOR;
    }

    /*
     * WARNING - void declaration
     */
    public double computeOverlaySnapTolerance(Geometry g) {
        void var2_2;
        block0: {
            double fixedSnapTol;
            double snapTolerance = this.computeSizeBasedSnapTolerance(g);
            PrecisionModel pm = g.getPrecisionModel();
            if (pm.getType() != PrecisionModel$.MODULE$.FIXED() || !((fixedSnapTol = 1.0 / pm.getScale() * (double)2 / 1.415) > snapTolerance)) break block0;
            snapTolerance = fixedSnapTol;
        }
        return (double)var2_2;
    }

    public double computeSizeBasedSnapTolerance(Geometry g) {
        Envelope env = g.getEnvelopeInternal();
        double minDimension = Math.min(env.getHeight(), env.getWidth());
        double snapTol = minDimension * this.SNAP_PRECISION_FACTOR();
        return snapTol;
    }

    public double computeOverlaySnapTolerance(Geometry g0, Geometry g1) {
        return Math.min(this.computeOverlaySnapTolerance(g0), this.computeOverlaySnapTolerance(g1));
    }

    public Geometry[] snap(Geometry g0, Geometry g1, double snapTolerance) {
        Geometry[] snapGeom = new Geometry[2];
        GeometrySnapper snapper0 = new GeometrySnapper(g0);
        snapGeom[0] = snapper0.snapTo(g1, snapTolerance);
        GeometrySnapper snapper1 = new GeometrySnapper(g1);
        snapGeom[1] = snapper1.snapTo(snapGeom[0], snapTolerance);
        return snapGeom;
    }

    public Geometry snapToSelf(Geometry geom, double snapTolerance, boolean cleanResult) {
        GeometrySnapper snapper0 = new GeometrySnapper(geom);
        return snapper0.snapToSelf(snapTolerance, cleanResult);
    }

    private GeometrySnapper$() {
    }
}

