/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.snap;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.operation.overlay.snap.LineStringSnapper;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000553A\u0001C\u0005\u0001-!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011!q\u0003A!A!\u0002\u0013y\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0004\"\u0002\u001a\u0001\t\u0003I\u0004\"\u0002\u001f\u0001\t#j\u0004\"\u0002%\u0001\t\u0013I%aD*oCB$&/\u00198tM>\u0014X.\u001a:\u000b\u0005)Y\u0011\u0001B:oCBT!\u0001D\u0007\u0002\u000f=4XM\u001d7bs*\u0011abD\u0001\n_B,'/\u0019;j_:T!\u0001E\t\u0002\u0007)$8O\u0003\u0002\u0013'\u0005aAn\\2bi&|g\u000e^3dQ*\tA#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\u0005kRLGN\u0003\u0002\u001d\u001f\u0005!q-Z8n\u0013\tq\u0012DA\nHK>lW\r\u001e:z)J\fgn\u001d4pe6,'/A\u0007t]\u0006\u0004Hk\u001c7fe\u0006t7-\u001a\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\t>,(\r\\3\u0002\u000fMt\u0017\r\u001d)ugB\u0019\u0011\u0005\u000b\u0016\n\u0005%\u0012#!B!se\u0006L\bCA\u0016-\u001b\u0005Y\u0012BA\u0017\u001c\u0005)\u0019un\u001c:eS:\fG/Z\u0001\u000bSN\u001cV\r\u001c4T]\u0006\u0004\bCA\u00111\u0013\t\t$EA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0011!dg\u000e\u001d\u0011\u0005U\u0002Q\"A\u0005\t\u000b}!\u0001\u0019\u0001\u0011\t\u000b\u0019\"\u0001\u0019A\u0014\t\u000b9\"\u0001\u0019A\u0018\u0015\u0007QR4\bC\u0003 \u000b\u0001\u0007\u0001\u0005C\u0003'\u000b\u0001\u0007q%\u0001\u000bue\u0006t7OZ8s[\u000e{wN\u001d3j]\u0006$Xm\u001d\u000b\u0004}\u0005\u001b\u0005CA\u0016@\u0013\t\u00015D\u0001\nD_>\u0014H-\u001b8bi\u0016\u001cV-];f]\u000e,\u0007\"\u0002\"\u0007\u0001\u0004q\u0014AB2p_J$7\u000fC\u0003E\r\u0001\u0007Q)\u0001\u0004qCJ,g\u000e\u001e\t\u0003W\u0019K!aR\u000e\u0003\u0011\u001d+w.\\3uef\f\u0001b\u001d8ba2Kg.\u001a\u000b\u0004O)c\u0005\"B&\b\u0001\u00049\u0013AB:sGB#8\u000fC\u0003'\u000f\u0001\u0007q\u0005")
public class SnapTransformer
extends GeometryTransformer {
    private final double snapTolerance;
    private final Coordinate[] snapPts;
    private final boolean isSelfSnap;

    @Override
    public CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
        Coordinate[] srcPts = coords.toCoordinateArray();
        Coordinate[] newPts = this.snapLine(srcPts, this.snapPts);
        return this.factory().getCoordinateSequenceFactory().create(newPts);
    }

    private Coordinate[] snapLine(Coordinate[] srcPts, Coordinate[] snapPts) {
        LineStringSnapper snapper = new LineStringSnapper(srcPts, this.snapTolerance);
        snapper.setAllowSnappingToSourceVertices(this.isSelfSnap);
        return snapper.snapTo(snapPts);
    }

    public SnapTransformer(double snapTolerance, Coordinate[] snapPts, boolean isSelfSnap) {
        this.snapTolerance = snapTolerance;
        this.snapPts = snapPts;
        this.isSelfSnap = isSelfSnap;
    }

    public SnapTransformer(double snapTolerance, Coordinate[] snapPts) {
        this(snapTolerance, snapPts, false);
    }
}

