/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.predicate;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0015<Q\u0001E\t\t\u0002q1QAH\t\t\u0002}AQAJ\u0001\u0005\u0002\u001dBQ\u0001K\u0001\u0005\u0002%2AAH\t\u0001u!Aa\u0006\u0002BC\u0002\u0013\u00051\b\u0003\u0005=\t\t\u0005\t\u0015!\u00030\u0011\u00151C\u0001\"\u0001>\u0011\u001d\u0001EA1A\u0005\n\u0005Ca!\u0012\u0003!\u0002\u0013\u0011\u0005\"\u0002\u0015\u0005\t\u00031\u0005\"\u0002%\u0005\t\u0013I\u0005\"B&\u0005\t\u0013a\u0005\"B&\u0005\t\u0013\u0011\u0006\"\u0002-\u0005\t\u0013I\u0006\"B0\u0005\t\u0013\u0001\u0017!\u0005*fGR\fgn\u001a7f\u0007>tG/Y5og*\u0011!cE\u0001\naJ,G-[2bi\u0016T!\u0001F\u000b\u0002\u0013=\u0004XM]1uS>t'B\u0001\f\u0018\u0003\rQGo\u001d\u0006\u00031e\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011AG\u0001\u0004_J<7\u0001\u0001\t\u0003;\u0005i\u0011!\u0005\u0002\u0012%\u0016\u001cG/\u00198hY\u0016\u001cuN\u001c;bS:\u001c8CA\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001H\u0001\tG>tG/Y5ogR\u0019!&L\u001b\u0011\u0005\u0005Z\u0013B\u0001\u0017#\u0005\u001d\u0011un\u001c7fC:DQAL\u0002A\u0002=\n\u0011B]3di\u0006tw\r\\3\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I*\u0012\u0001B4f_6L!\u0001N\u0019\u0003\u000fA{G._4p]\")ag\u0001a\u0001o\u0005\t!\r\u0005\u00021q%\u0011\u0011(\r\u0002\t\u000f\u0016|W.\u001a;ssN\u0011A\u0001I\u000b\u0002_\u0005Q!/Z2uC:<G.\u001a\u0011\u0015\u0005yz\u0004CA\u000f\u0005\u0011\u0015qs\u00011\u00010\u0003\u001d\u0011Xm\u0019;F]Z,\u0012A\u0011\t\u0003a\rK!\u0001R\u0019\u0003\u0011\u0015sg/\u001a7pa\u0016\f\u0001B]3di\u0016sg\u000f\t\u000b\u0003U\u001dCQA\r\u0006A\u0002]\nQ#[:D_:$\u0018-\u001b8fI&s'i\\;oI\u0006\u0014\u0018\u0010\u0006\u0002+\u0015\")!g\u0003a\u0001o\u0005Q\u0012n\u001d)pS:$8i\u001c8uC&tW\rZ%o\u0005>,h\u000eZ1ssR\u0011!&\u0014\u0005\u0006\u001d2\u0001\raT\u0001\u0006a>Lg\u000e\u001e\t\u0003aAK!!U\u0019\u0003\u000bA{\u0017N\u001c;\u0015\u0005)\u001a\u0006\"\u0002+\u000e\u0001\u0004)\u0016A\u00019u!\t\u0001d+\u0003\u0002Xc\tQ1i\\8sI&t\u0017\r^3\u0002?%\u001cH*\u001b8f'R\u0014\u0018N\\4D_:$\u0018-\u001b8fI&s'i\\;oI\u0006\u0014\u0018\u0010\u0006\u0002+5\")1L\u0004a\u00019\u0006!A.\u001b8f!\t\u0001T,\u0003\u0002_c\tQA*\u001b8f'R\u0014\u0018N\\4\u0002A%\u001cH*\u001b8f'\u0016<W.\u001a8u\u0007>tG/Y5oK\u0012LeNQ8v]\u0012\f'/\u001f\u000b\u0004U\u0005\u001c\u0007\"\u00022\u0010\u0001\u0004)\u0016A\u000191\u0011\u0015!w\u00021\u0001V\u0003\t\u0001\u0018\u0007")
public class RectangleContains {
    private final Polygon rectangle;
    private final Envelope rectEnv;
    private volatile boolean bitmap$init$0;

    public Polygon rectangle() {
        return this.rectangle;
    }

    private Envelope rectEnv() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/predicate/RectangleContains.scala: 64");
        }
        return this.rectEnv;
    }

    public boolean contains(Geometry geom) {
        if (!this.rectEnv().contains(geom.getEnvelopeInternal())) {
            return false;
        }
        return !this.isContainedInBoundary(geom);
    }

    private boolean isContainedInBoundary(Geometry geom) {
        if (geom instanceof Polygon) {
            return false;
        }
        if (geom instanceof Point) {
            return this.isPointContainedInBoundary((Point)geom);
        }
        if (geom instanceof LineString) {
            return this.isLineStringContainedInBoundary((LineString)geom);
        }
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry comp = geom.getGeometryN(i);
            if (this.isContainedInBoundary(comp)) continue;
            return false;
        }
        return true;
    }

    private boolean isPointContainedInBoundary(Point point) {
        return this.isPointContainedInBoundary(point.getCoordinate());
    }

    private boolean isPointContainedInBoundary(Coordinate pt) {
        return pt.x() == this.rectEnv().getMinX() || pt.x() == this.rectEnv().getMaxX() || pt.y() == this.rectEnv().getMinY() || pt.y() == this.rectEnv().getMaxY();
    }

    private boolean isLineStringContainedInBoundary(LineString line) {
        CoordinateSequence seq = line.getCoordinateSequence();
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        for (int i = 0; i < seq.size() - 1; ++i) {
            seq.getCoordinate(i, p0);
            seq.getCoordinate(i + 1, p1);
            if (this.isLineSegmentContainedInBoundary(p0, p1)) continue;
            return false;
        }
        return true;
    }

    private boolean isLineSegmentContainedInBoundary(Coordinate p0, Coordinate p1) {
        Coordinate coordinate = p0;
        Coordinate coordinate2 = p1;
        if (!(coordinate != null ? !((Object)coordinate).equals(coordinate2) : coordinate2 != null)) {
            return this.isPointContainedInBoundary(p0);
        }
        if (p0.x() == p1.x()) {
            if (p0.x() == this.rectEnv().getMinX() || p0.x() == this.rectEnv().getMaxX()) {
                return true;
            }
            if (p0.y() == p1.y() && (p0.y() == this.rectEnv().getMinY() || p0.y() == this.rectEnv().getMaxY())) {
                return true;
            }
        }
        return false;
    }

    public RectangleContains(Polygon rectangle) {
        this.rectangle = rectangle;
        this.rectEnv = rectangle.getEnvelopeInternal();
        this.bitmap$init$0 = true;
    }
}

