/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.EdgeIntersectionList;
import org.locationtech.jts.geomgraph.Label;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005I3AAB\u0004\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)Q\u0004\u0001C\u0001k!1\u0001\t\u0001C\u0001\u000f\u0005Caa\u0013\u0001\u0005\u0002\u001da%AD#eO\u0016,e\u000e\u001a\"vS2$WM\u001d\u0006\u0003\u0011%\taA]3mCR,'B\u0001\u0006\f\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002\r\u001b\u0005\u0019!\u000e^:\u000b\u00059y\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u000f\u0005y1m\\7qkR,W\tZ4f\u000b:$7\u000f\u0006\u0002 [A\u0019\u0001%J\u0014\u000e\u0003\u0005R!AI\u0012\u0002\tU$\u0018\u000e\u001c\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013EA\u0005BeJ\f\u0017\u0010T5tiB\u0011\u0001fK\u0007\u0002S)\u0011!fC\u0001\nO\u0016|Wn\u001a:ba\"L!\u0001L\u0015\u0003\u000f\u0015#w-Z#oI\")aF\u0001a\u0001_\u0005)Q\rZ4fgB\u0019\u0001\u0005\r\u001a\n\u0005E\n#\u0001C%uKJ\fGo\u001c:\u0011\u0005!\u001a\u0014B\u0001\u001b*\u0005\u0011)EmZ3\u0015\u0007YJ4\b\u0005\u0002\u0015o%\u0011\u0001(\u0006\u0002\u0005+:LG\u000fC\u0003;\u0007\u0001\u0007!'\u0001\u0003fI\u001e,\u0007\"\u0002\u001f\u0004\u0001\u0004i\u0014!\u00017\u0011\u0007\u0001rt%\u0003\u0002@C\t!A*[:u\u0003Q\u0019'/Z1uK\u0016#w-Z#oI\u001a{'\u000f\u0015:fmR)aGQ\"E\u0013\")!\b\u0002a\u0001e!)A\b\u0002a\u0001{!)Q\t\u0002a\u0001\r\u00061Q-[\"veJ\u0004\"\u0001K$\n\u0005!K#\u0001E#eO\u0016Le\u000e^3sg\u0016\u001cG/[8o\u0011\u0015QE\u00011\u0001G\u0003\u0019)\u0017\u000e\u0015:fm\u0006!2M]3bi\u0016,EmZ3F]\u00124uN\u001d(fqR$RAN'O\u001fBCQAO\u0003A\u0002IBQ\u0001P\u0003A\u0002uBQ!R\u0003A\u0002\u0019CQ!U\u0003A\u0002\u0019\u000ba!Z5OKb$\b")
public class EdgeEndBuilder {
    /*
     * WARNING - void declaration
     */
    public ArrayList<EdgeEnd> computeEdgeEnds(Iterator<Edge> edges) {
        void var2_2;
        ArrayList<EdgeEnd> l = new ArrayList<EdgeEnd>();
        Iterator<Edge> i = edges;
        while (i.hasNext()) {
            Edge e = i.next();
            this.computeEdgeEnds(e, l);
        }
        return var2_2;
    }

    public void computeEdgeEnds(Edge edge, List<EdgeEnd> l) {
        EdgeIntersectionList eiList = edge.getEdgeIntersectionList();
        eiList.addEndpoints();
        Iterator<EdgeIntersection> it = eiList.iterator();
        EdgeIntersection eiPrev = null;
        EdgeIntersection eiCurr = null;
        if (!it.hasNext()) {
            return;
        }
        EdgeIntersection eiNext = it.next();
        do {
            eiPrev = eiCurr;
            eiCurr = eiNext;
            eiNext = null;
            if (it.hasNext()) {
                eiNext = it.next();
            }
            if (eiCurr == null) continue;
            this.createEdgeEndForPrev(edge, l, eiCurr, eiPrev);
            this.createEdgeEndForNext(edge, l, eiCurr, eiNext);
        } while (eiCurr != null);
    }

    public void createEdgeEndForPrev(Edge edge, List<EdgeEnd> l, EdgeIntersection eiCurr, EdgeIntersection eiPrev) {
        int iPrev = eiCurr.segmentIndex();
        if (eiCurr.dist() == 0.0) {
            if (iPrev == 0) {
                return;
            }
            --iPrev;
        }
        Coordinate pPrev = edge.getCoordinate(iPrev);
        if (eiPrev != null && eiPrev.segmentIndex() >= iPrev) {
            pPrev = eiPrev.coord();
        }
        Label label = new Label(edge.getLabel());
        label.flip();
        EdgeEnd e = new EdgeEnd(edge, eiCurr.coord(), pPrev, label);
        l.add(e);
    }

    public void createEdgeEndForNext(Edge edge, List<EdgeEnd> l, EdgeIntersection eiCurr, EdgeIntersection eiNext) {
        int iNext = eiCurr.segmentIndex() + 1;
        if (iNext >= edge.getNumPoints() && eiNext == null) {
            return;
        }
        Coordinate pNext = edge.getCoordinate(iNext);
        if (eiNext != null && eiNext.segmentIndex() == eiCurr.segmentIndex()) {
            pNext = eiNext.coord();
        }
        EdgeEnd e = new EdgeEnd(edge, eiCurr.coord(), pNext, new Label(edge.getLabel()));
        l.add(e);
    }
}

