/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.algorithm.PointLocator$;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.NodeMap;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;
import org.locationtech.jts.operation.relate.EdgeEndBuilder;
import org.locationtech.jts.operation.relate.RelateNode;
import org.locationtech.jts.operation.relate.RelateNodeFactory;
import org.locationtech.jts.util.Assert$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d\u0001B\r\u001b\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0004%\t!\f\u0005\to\u0001\u0011\t\u0019!C\u0001q!Aa\b\u0001B\u0001B\u0003&a\u0006C\u0003@\u0001\u0011\u0005\u0001\tC\u0004E\u0001\t\u0007I\u0011B#\t\r1\u0003\u0001\u0015!\u0003G\u0011\u001di\u0005A1A\u0005\n9CaA\u0015\u0001!\u0002\u0013y\u0005bB*\u0001\u0005\u0004%I\u0001\u0016\u0005\u00071\u0002\u0001\u000b\u0011B+\t\u000fe\u0003!\u0019!C\u00055\"1a\r\u0001Q\u0001\nmCQa\u001a\u0001\u0005\u0002!DQa\u001c\u0001\u0005\nADQ!\u001f\u0001\u0005\niDq!a\u0003\u0001\t\u0013\ti\u0001C\u0004\u0002\u001a\u0001!I!a\u0007\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"!9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\u0002bBA\u0015\u0001\u0011%\u00111\u0006\u0005\b\u0003_\u0001A\u0011BA\u0019\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!a\u0014\u0001\t\u0013\t9\u0003C\u0004\u0002R\u0001!I!a\u0015\u0003\u001dI+G.\u0019;f\u0007>l\u0007/\u001e;fe*\u00111\u0004H\u0001\u0007e\u0016d\u0017\r^3\u000b\u0005uq\u0012!C8qKJ\fG/[8o\u0015\ty\u0002%A\u0002kiNT!!\t\u0012\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g\u0003\r\t'oZ\u000b\u0002]A\u0019qeL\u0019\n\u0005AB#!B!se\u0006L\bC\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u001f\u0003%9Wm\\7he\u0006\u0004\b.\u0003\u00027g\tiq)Z8nKR\u0014\u0018p\u0012:ba\"\fq!\u0019:h?\u0012*\u0017\u000f\u0006\u0002:yA\u0011qEO\u0005\u0003w!\u0012A!\u00168ji\"9QHAA\u0001\u0002\u0004q\u0013a\u0001=%c\u0005!\u0011M]4!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011i\u0011\t\u0003\u0005\u0002i\u0011A\u0007\u0005\u0006Y\u0011\u0001\rAL\u0001\u0003Y&,\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013z\t\u0011\"\u00197h_JLG\u000f[7\n\u0005-C%!\u0006*pEV\u001cH\u000fT5oK&sG/\u001a:tK\u000e$xN]\u0001\u0004Y&\u0004\u0013!\u00039u\u0019>\u001c\u0017\r^8s+\u0005y\u0005CA$Q\u0013\t\t\u0006J\u0001\u0007Q_&tG\u000fT8dCR|'/\u0001\u0006qi2{7-\u0019;pe\u0002\nQA\\8eKN,\u0012!\u0016\t\u0003eYK!aV\u001a\u0003\u000f9{G-Z'ba\u00061an\u001c3fg\u0002\nQ\"[:pY\u0006$X\rZ#eO\u0016\u001cX#A.\u0011\u0007q\u000b7-D\u0001^\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003Ev\u0013\u0011\"\u0011:sCfd\u0015n\u001d;\u0011\u0005I\"\u0017BA34\u0005\u0011)EmZ3\u0002\u001d%\u001cx\u000e\\1uK\u0012,EmZ3tA\u0005I1m\\7qkR,\u0017*T\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011ANH\u0001\u0005O\u0016|W.\u0003\u0002oW\n\u0011\u0012J\u001c;feN,7\r^5p]6\u000bGO]5y\u00039Ign]3si\u0016#w-Z#oIN$\"!O9\t\u000bIt\u0001\u0019A:\u0002\u0005\u0015,\u0007c\u0001/um&\u0011Q/\u0018\u0002\u0005\u0019&\u001cH\u000f\u0005\u00023o&\u0011\u0001p\r\u0002\b\u000b\u0012<W-\u00128e\u0003m\u0019w.\u001c9vi\u0016\u0004&o\u001c9fe&sG/\u001a:tK\u000e$\u0018n\u001c8J\u001bR!\u0011h_A\u0004\u0011\u0015ax\u00021\u0001~\u0003-Ig\u000e^3sg\u0016\u001cGo\u001c:\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\taM\u0001\u0006S:$W\r_\u0005\u0004\u0003\u000by(AE*fO6,g\u000e^%oi\u0016\u00148/Z2u_JDa!!\u0003\u0010\u0001\u0004I\u0017AA5n\u0003I\u0019w\u000e]=O_\u0012,7/\u00118e\u0019\u0006\u0014W\r\\:\u0015\u0007e\ny\u0001C\u0004\u0002\u0012A\u0001\r!a\u0005\u0002\u0011\u0005\u0014x-\u00138eKb\u00042aJA\u000b\u0013\r\t9\u0002\u000b\u0002\u0004\u0013:$\u0018\u0001G2p[B,H/Z%oi\u0016\u00148/Z2uS>tgj\u001c3fgR\u0019\u0011(!\b\t\u000f\u0005E\u0011\u00031\u0001\u0002\u0014\u0005\t2m\\7qkR,G)[:k_&tG/S'\u0015\u0007e\n\u0019\u0003\u0003\u0004\u0002\nI\u0001\r![\u0001\u000fY\u0006\u0014W\r\u001c(pI\u0016,EmZ3t)\u0005I\u0014\u0001C;qI\u0006$X-S'\u0015\u0007e\ni\u0003\u0003\u0004\u0002\nQ\u0001\r![\u0001\u0013Y\u0006\u0014W\r\\%t_2\fG/\u001a3FI\u001e,7\u000fF\u0003:\u0003g\t9\u0004C\u0004\u00026U\u0001\r!a\u0005\u0002\u0013QD\u0017n]%oI\u0016D\bbBA\u001d+\u0001\u0007\u00111C\u0001\fi\u0006\u0014x-\u001a;J]\u0012,\u00070A\tmC\n,G.S:pY\u0006$X\rZ#eO\u0016$r!OA \u0003\u0007\n)\u0005\u0003\u0004\u0002BY\u0001\raY\u0001\u0002K\"9\u0011\u0011\b\fA\u0002\u0005M\u0001bBA$-\u0001\u0007\u0011\u0011J\u0001\u0007i\u0006\u0014x-\u001a;\u0011\u0007)\fY%C\u0002\u0002N-\u0014\u0001bR3p[\u0016$(/_\u0001\u0013Y\u0006\u0014W\r\\%t_2\fG/\u001a3O_\u0012,7/A\tmC\n,G.S:pY\u0006$X\r\u001a(pI\u0016$R!OA+\u0003?Bq!a\u0016\u0019\u0001\u0004\tI&A\u0001o!\r\u0011\u00141L\u0005\u0004\u0003;\u001a$\u0001\u0002(pI\u0016Dq!!\u000f\u0019\u0001\u0004\t\u0019\u0002")
public class RelateComputer {
    private GeometryGraph[] arg;
    private final RobustLineIntersector li;
    private final PointLocator ptLocator;
    private final NodeMap nodes;
    private final ArrayList<Edge> isolatedEdges;
    private volatile byte bitmap$init$0;

    public GeometryGraph[] arg() {
        return this.arg;
    }

    public void arg_$eq(GeometryGraph[] x$1) {
        this.arg = x$1;
    }

    private RobustLineIntersector li() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/relate/RelateComputer.scala: 49");
        }
        return this.li;
    }

    private PointLocator ptLocator() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/relate/RelateComputer.scala: 50");
        }
        return this.ptLocator;
    }

    private NodeMap nodes() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/relate/RelateComputer.scala: 51");
        }
        return this.nodes;
    }

    private ArrayList<Edge> isolatedEdges() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/relate/RelateComputer.scala: 54");
        }
        return this.isolatedEdges;
    }

    /*
     * WARNING - void declaration
     */
    public IntersectionMatrix computeIM() {
        void var1_1;
        IntersectionMatrix im = new IntersectionMatrix();
        im.set(Location$.MODULE$.EXTERIOR(), Location$.MODULE$.EXTERIOR(), 2);
        if (!this.arg()[0].getGeometry().getEnvelopeInternal().intersects(this.arg()[1].getGeometry().getEnvelopeInternal())) {
            this.computeDisjointIM(im);
            return im;
        }
        this.arg()[0].computeSelfNodes(this.li(), false);
        this.arg()[1].computeSelfNodes(this.li(), false);
        SegmentIntersector intersector = this.arg()[0].computeEdgeIntersections(this.arg()[1], this.li(), false);
        this.computeIntersectionNodes(0);
        this.computeIntersectionNodes(1);
        this.copyNodesAndLabels(0);
        this.copyNodesAndLabels(1);
        this.labelIsolatedNodes();
        this.computeProperIntersectionIM(intersector, im);
        EdgeEndBuilder eeBuilder = new EdgeEndBuilder();
        ArrayList<EdgeEnd> ee0 = eeBuilder.computeEdgeEnds(this.arg()[0].getEdgeIterator());
        this.insertEdgeEnds(ee0);
        ArrayList<EdgeEnd> ee1 = eeBuilder.computeEdgeEnds(this.arg()[1].getEdgeIterator());
        this.insertEdgeEnds(ee1);
        this.labelNodeEdges();
        this.labelIsolatedEdges(0, 1);
        this.labelIsolatedEdges(1, 0);
        this.updateIM(im);
        return var1_1;
    }

    private void insertEdgeEnds(List<EdgeEnd> ee) {
        for (EdgeEnd e : ee) {
            this.nodes().add(e);
        }
    }

    private void computeProperIntersectionIM(SegmentIntersector intersector, IntersectionMatrix im) {
        block3: {
            boolean hasProperInterior;
            int dimB;
            int dimA;
            block5: {
                boolean hasProper;
                block4: {
                    block2: {
                        dimA = this.arg()[0].getGeometry().getDimension();
                        dimB = this.arg()[1].getGeometry().getDimension();
                        hasProper = intersector.hasProperIntersection();
                        hasProperInterior = intersector.hasProperInteriorIntersection();
                        if (dimA != 2 || dimB != 2) break block2;
                        if (!hasProper) break block3;
                        im.setAtLeast("212101212");
                        break block3;
                    }
                    if (dimA != 2 || dimB != 1) break block4;
                    if (hasProper) {
                        im.setAtLeast("FFF0FFFF2");
                    }
                    if (!hasProperInterior) break block3;
                    im.setAtLeast("1FFFFF1FF");
                    break block3;
                }
                if (dimA != 1 || dimB != 2) break block5;
                if (hasProper) {
                    im.setAtLeast("F0FFFFFF2");
                }
                if (!hasProperInterior) break block3;
                im.setAtLeast("1F1FFFFFF");
                break block3;
            }
            if (dimA != 1 || dimB != 1 || !hasProperInterior) break block3;
            im.setAtLeast("0FFFFFFFF");
        }
    }

    private void copyNodesAndLabels(int argIndex) {
        Iterator<Node> i = this.arg()[argIndex].getNodeIterator();
        while (i.hasNext()) {
            Node graphNode = i.next();
            Node newNode = this.nodes().addNode(graphNode.getCoordinate());
            newNode.setLabel(argIndex, graphNode.getLabel().getLocation(argIndex));
        }
    }

    private void computeIntersectionNodes(int argIndex) {
        Iterator<Edge> i = this.arg()[argIndex].getEdgeIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            int eLoc = e.getLabel().getLocation(argIndex);
            Iterator<EdgeIntersection> eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = eiIt.next();
                RelateNode n = (RelateNode)this.nodes().addNode(ei.coord());
                if (eLoc == Location$.MODULE$.BOUNDARY()) {
                    n.setLabelBoundary(argIndex);
                    continue;
                }
                if (!n.getLabel().isNull(argIndex)) continue;
                n.setLabel(argIndex, Location$.MODULE$.INTERIOR());
            }
        }
    }

    private void computeDisjointIM(IntersectionMatrix im) {
        block1: {
            Geometry gb;
            Geometry ga = this.arg()[0].getGeometry();
            if (!ga.isEmpty()) {
                im.set(Location$.MODULE$.INTERIOR(), Location$.MODULE$.EXTERIOR(), ga.getDimension());
                im.set(Location$.MODULE$.BOUNDARY(), Location$.MODULE$.EXTERIOR(), ga.getBoundaryDimension());
            }
            if ((gb = this.arg()[1].getGeometry()).isEmpty()) break block1;
            im.set(Location$.MODULE$.EXTERIOR(), Location$.MODULE$.INTERIOR(), gb.getDimension());
            im.set(Location$.MODULE$.EXTERIOR(), Location$.MODULE$.BOUNDARY(), gb.getBoundaryDimension());
        }
    }

    private void labelNodeEdges() {
        Iterator<Node> ni = this.nodes().iterator();
        while (ni.hasNext()) {
            RelateNode node = (RelateNode)ni.next();
            node.getEdges().computeLabelling(this.arg());
        }
    }

    private void updateIM(IntersectionMatrix im) {
        for (Edge e : this.isolatedEdges()) {
            e.updateIM(im);
        }
        Iterator<Node> ni = this.nodes().iterator();
        while (ni.hasNext()) {
            RelateNode node = (RelateNode)ni.next();
            node.updateIM(im);
            node.updateIMFromEdges(im);
        }
    }

    private void labelIsolatedEdges(int thisIndex, int targetIndex) {
        Iterator<Edge> ei = this.arg()[thisIndex].getEdgeIterator();
        while (ei.hasNext()) {
            Object object;
            Edge e = ei.next();
            if (e.isIsolated()) {
                this.labelIsolatedEdge(e, targetIndex, this.arg()[targetIndex].getGeometry());
                object = BoxesRunTime.boxToBoolean((boolean)this.isolatedEdges().add(e));
                continue;
            }
            object = BoxedUnit.UNIT;
        }
    }

    private void labelIsolatedEdge(Edge e, int targetIndex, Geometry target) {
        if (target.getDimension() > 0) {
            int loc = this.ptLocator().locate(e.getCoordinate(), target);
            e.getLabel().setAllLocations(targetIndex, loc);
        } else {
            e.getLabel().setAllLocations(targetIndex, Location$.MODULE$.EXTERIOR());
        }
    }

    private void labelIsolatedNodes() {
        Iterator<Node> ni = this.nodes().iterator();
        while (ni.hasNext()) {
            Node n = ni.next();
            Label label = n.getLabel();
            Assert$.MODULE$.isTrue(label.getGeometryCount() > 0, "node with empty label found");
            if (!n.isIsolated()) continue;
            if (label.isNull(0)) {
                this.labelIsolatedNode(n, 0);
                continue;
            }
            this.labelIsolatedNode(n, 1);
        }
    }

    private void labelIsolatedNode(Node n, int targetIndex) {
        int loc = this.ptLocator().locate(n.getCoordinate(), this.arg()[targetIndex].getGeometry());
        n.getLabel().setAllLocations(targetIndex, loc);
    }

    public RelateComputer(GeometryGraph[] arg) {
        this.arg = arg;
        this.li = new RobustLineIntersector();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.ptLocator = new PointLocator(PointLocator$.MODULE$.$lessinit$greater$default$1());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.nodes = new NodeMap(new RelateNodeFactory());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.isolatedEdges = new ArrayList();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

