/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.NodeMap;
import org.locationtech.jts.operation.relate.EdgeEndBuilder;
import org.locationtech.jts.operation.relate.RelateNode;
import org.locationtech.jts.operation.relate.RelateNodeFactory;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005}3A!\u0003\u0006\u0001+!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003B\u0002\u0015\u0001A\u0003%!\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u00037\u0001\u0011\u0005q\u0007C\u0003A\u0001\u0011\u0005\u0011\tC\u0003I\u0001\u0011\u0005\u0011\nC\u0003M\u0001\u0011\u0005QJA\bSK2\fG/\u001a(pI\u0016<%/\u00199i\u0015\tYA\"\u0001\u0004sK2\fG/\u001a\u0006\u0003\u001b9\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\u000b\u0005=\u0001\u0012a\u00016ug*\u0011\u0011CE\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005Q\u0011!\u00028pI\u0016\u001cX#\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015r\u0011!C4f_6<'/\u00199i\u0013\t9CEA\u0004O_\u0012,W*\u00199\u0002\r9|G-Z:!\u0003=9W\r\u001e(pI\u0016LE/\u001a:bi>\u0014X#A\u0016\u0011\u00071\n4'D\u0001.\u0015\tqs&\u0001\u0003vi&d'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012\u0001\"\u0013;fe\u0006$xN\u001d\t\u0003GQJ!!\u000e\u0013\u0003\t9{G-Z\u0001\u0006EVLG\u000e\u001a\u000b\u0003qm\u0002\"aF\u001d\n\u0005iB\"\u0001B+oSRDQ\u0001P\u0003A\u0002u\n\u0011bZ3p[\u001e\u0013\u0018\r\u001d5\u0011\u0005\rr\u0014BA %\u000559Um\\7fiJLxI]1qQ\u0006A2m\\7qkR,\u0017J\u001c;feN,7\r^5p]:{G-Z:\u0015\u0007a\u00125\tC\u0003=\r\u0001\u0007Q\bC\u0003E\r\u0001\u0007Q)\u0001\u0005be\u001eLe\u000eZ3y!\t9b)\u0003\u0002H1\t\u0019\u0011J\u001c;\u0002%\r|\u0007/\u001f(pI\u0016\u001c\u0018I\u001c3MC\n,Gn\u001d\u000b\u0004q)[\u0005\"\u0002\u001f\b\u0001\u0004i\u0004\"\u0002#\b\u0001\u0004)\u0015AD5og\u0016\u0014H/\u00123hK\u0016sGm\u001d\u000b\u0003q9CQa\u0014\u0005A\u0002A\u000b!!Z31\u0005E3\u0006c\u0001\u0017S)&\u00111+\f\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002V-2\u0001A!C,O\u0003\u0003\u0005\tQ!\u0001Y\u0005\ryF%M\t\u00033r\u0003\"a\u0006.\n\u0005mC\"a\u0002(pi\"Lgn\u001a\t\u0003/uK!A\u0018\r\u0003\u0007\u0005s\u0017\u0010")
public class RelateNodeGraph {
    private final NodeMap nodes = new NodeMap(new RelateNodeFactory());
    private volatile boolean bitmap$init$0 = true;

    private NodeMap nodes() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/relate/RelateNodeGraph.scala: 48");
        }
        return this.nodes;
    }

    public Iterator<Node> getNodeIterator() {
        return this.nodes().iterator();
    }

    public void build(GeometryGraph geomGraph) {
        this.computeIntersectionNodes(geomGraph, 0);
        this.copyNodesAndLabels(geomGraph, 0);
        EdgeEndBuilder eeBuilder = new EdgeEndBuilder();
        ArrayList<EdgeEnd> eeList = eeBuilder.computeEdgeEnds(geomGraph.getEdgeIterator());
        this.insertEdgeEnds(eeList);
    }

    public void computeIntersectionNodes(GeometryGraph geomGraph, int argIndex) {
        Iterator<Edge> edgeIt = geomGraph.getEdgeIterator();
        while (edgeIt.hasNext()) {
            Edge e = edgeIt.next();
            int eLoc = e.getLabel().getLocation(argIndex);
            Iterator<EdgeIntersection> eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = eiIt.next();
                RelateNode n = (RelateNode)this.nodes().addNode(ei.coord());
                if (eLoc == Location$.MODULE$.BOUNDARY()) {
                    n.setLabelBoundary(argIndex);
                    continue;
                }
                if (!n.getLabel().isNull(argIndex)) continue;
                n.setLabel(argIndex, Location$.MODULE$.INTERIOR());
            }
        }
    }

    public void copyNodesAndLabels(GeometryGraph geomGraph, int argIndex) {
        Iterator<Node> nodeIt = geomGraph.getNodeIterator();
        while (nodeIt.hasNext()) {
            Node graphNode = nodeIt.next();
            Node newNode = this.nodes().addNode(graphNode.getCoordinate());
            newNode.setLabel(argIndex, graphNode.getLabel().getLocation(argIndex));
        }
    }

    public void insertEdgeEnds(List<?> ee) {
        for (EdgeEnd e : ee) {
            this.nodes().add(e);
        }
    }
}

