/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.operation.union.OverlapUnion;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class OverlapUnion$ {
    public static final OverlapUnion$ MODULE$ = new OverlapUnion$();

    public Geometry union(Geometry g0, Geometry g1) {
        OverlapUnion union = new OverlapUnion(g0, g1);
        return union.union();
    }

    public Envelope org$locationtech$jts$operation$union$OverlapUnion$$overlapEnvelope(Geometry g0, Geometry g1) {
        Envelope g0Env = g0.getEnvelopeInternal();
        Envelope g1Env = g1.getEnvelopeInternal();
        Envelope overlapEnv = g0Env.intersection(g1Env);
        return overlapEnv;
    }

    public Geometry org$locationtech$jts$operation$union$OverlapUnion$$unionBuffer(Geometry g0, Geometry g1) {
        GeometryFactory factory = g0.getFactory();
        GeometryCollection gColl = factory.createGeometryCollection((Geometry[])((Object[])new Geometry[]{g0, g1}));
        Geometry union = gColl.buffer(0.0);
        return union;
    }

    public boolean org$locationtech$jts$operation$union$OverlapUnion$$intersects(Envelope env, Coordinate p0, Coordinate p1) {
        return env.intersects(p0) || env.intersects(p1);
    }

    public boolean org$locationtech$jts$operation$union$OverlapUnion$$containsProperly(Envelope env, Coordinate p0, Coordinate p1) {
        return this.containsProperly(env, p0) && this.containsProperly(env, p1);
    }

    private boolean containsProperly(Envelope env, Coordinate p) {
        if (env.isNull()) {
            return false;
        }
        return p.getX() > env.getMinX() && p.getX() < env.getMaxX() && p.getY() > env.getMinY() && p.getY() < env.getMaxY();
    }

    public void org$locationtech$jts$operation$union$OverlapUnion$$extractBorderSegments(Geometry geom, Envelope env, List<LineSegment> segs) {
        geom.applyF(new CoordinateSequenceFilter(env, segs){
            private final Envelope env$1;
            private final List segs$1;

            public void filter(CoordinateSequence seq, int i) {
                Object object;
                Coordinate p1;
                boolean isBorder;
                if (i <= 0) {
                    return;
                }
                Coordinate p0 = seq.getCoordinate(i - 1);
                boolean bl = isBorder = OverlapUnion$.MODULE$.org$locationtech$jts$operation$union$OverlapUnion$$intersects(this.env$1, p0, p1 = seq.getCoordinate(i)) && !OverlapUnion$.MODULE$.org$locationtech$jts$operation$union$OverlapUnion$$containsProperly(this.env$1, p0, p1);
                if (isBorder) {
                    LineSegment seg = new LineSegment(p0, p1);
                    object = BoxesRunTime.boxToBoolean((boolean)this.segs$1.add(seg));
                } else {
                    object = BoxedUnit.UNIT;
                }
            }

            public boolean isDone() {
                return false;
            }

            public boolean isGeometryChanged() {
                return false;
            }
            {
                this.env$1 = env$1;
                this.segs$1 = segs$1;
            }
        });
    }

    private OverlapUnion$() {
    }
}

