/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.geomgraph.Position$;
import org.locationtech.jts.operation.overlay.MaximalEdgeRing;
import org.locationtech.jts.operation.overlay.MinimalEdgeRing;
import org.locationtech.jts.operation.overlay.OverlayNodeFactory;
import org.locationtech.jts.operation.valid.ConnectedInteriorTester$;
import org.locationtech.jts.util.Assert$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005s!\u0002\f\u0018\u0011\u0003\u0011c!\u0002\u0013\u0018\u0011\u0003)\u0003\"\u0002\u0017\u0002\t\u0003i\u0003\"\u0002\u0018\u0002\t\u0003yc\u0001\u0002\u0013\u0018\u0001uB\u0001B\u0010\u0003\u0003\u0002\u0004%\ta\u0010\u0005\t\r\u0012\u0011\t\u0019!C\u0001\u000f\"AQ\n\u0002B\u0001B\u0003&\u0001\tC\u0003-\t\u0011\u0005a\nC\u0004R\t\t\u0007I\u0011\u0002*\t\rY#\u0001\u0015!\u0003T\u0011\u001d9F\u00011A\u0005\naCq!\u0017\u0003A\u0002\u0013%!\f\u0003\u0004]\t\u0001\u0006K\u0001\r\u0005\u0006;\u0012!\t\u0001\u0017\u0005\u0006=\u0012!\ta\u0018\u0005\u0006G\u0012!I\u0001\u001a\u0005\u0006U\u0012!Ia\u001b\u0005\b\u0003\u000b!A\u0011BA\u0004\u0011\u001d\t)\u0002\u0002C\u0005\u0003/Aq!!\n\u0005\t#\t9\u0003C\u0004\u00024\u0011!I!!\u000e\u0002/\r{gN\\3di\u0016$\u0017J\u001c;fe&|'\u000fV3ti\u0016\u0014(B\u0001\r\u001a\u0003\u00151\u0018\r\\5e\u0015\tQ2$A\u0005pa\u0016\u0014\u0018\r^5p]*\u0011A$H\u0001\u0004UR\u001c(B\u0001\u0010 \u00031awnY1uS>tG/Z2i\u0015\u0005\u0001\u0013aA8sO\u000e\u0001\u0001CA\u0012\u0002\u001b\u00059\"aF\"p]:,7\r^3e\u0013:$XM]5peR+7\u000f^3s'\t\ta\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\n!CZ5oI\u0012KgMZ3sK:$\bk\\5oiR\u0019\u0001GN\u001e\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005MZ\u0012\u0001B4f_6L!!\u000e\u001a\u0003\u0015\r{wN\u001d3j]\u0006$X\rC\u00038\u0007\u0001\u0007\u0001(A\u0003d_>\u0014H\rE\u0002(sAJ!A\u000f\u0015\u0003\u000b\u0005\u0013(/Y=\t\u000bq\u001a\u0001\u0019\u0001\u0019\u0002\u0005A$8C\u0001\u0003'\u0003%9Wm\\7He\u0006\u0004\b.F\u0001A!\t\tE)D\u0001C\u0015\t\u00195$A\u0005hK>lwM]1qQ&\u0011QI\u0011\u0002\u000e\u000f\u0016|W.\u001a;ss\u001e\u0013\u0018\r\u001d5\u0002\u001b\u001d,w.\\$sCBDw\fJ3r)\tA5\n\u0005\u0002(\u0013&\u0011!\n\u000b\u0002\u0005+:LG\u000fC\u0004M\r\u0005\u0005\t\u0019\u0001!\u0002\u0007a$\u0013'\u0001\u0006hK>lwI]1qQ\u0002\"\"a\u0014)\u0011\u0005\r\"\u0001\"\u0002 \t\u0001\u0004\u0001\u0015aD4f_6,GO]=GC\u000e$xN]=\u0016\u0003M\u0003\"!\r+\n\u0005U\u0013$aD$f_6,GO]=GC\u000e$xN]=\u0002!\u001d,w.\\3uef4\u0015m\u0019;pef\u0004\u0013!\u00063jg\u000e|gN\\3di\u0016$'+\u001b8hG>|'\u000fZ\u000b\u0002a\u0005IB-[:d_:tWm\u0019;fIJKgnZ2p_J$w\fJ3r)\tA5\fC\u0004M\u0019\u0005\u0005\t\u0019\u0001\u0019\u0002-\u0011L7oY8o]\u0016\u001cG/\u001a3SS:<7m\\8sI\u0002\nQbZ3u\u0007>|'\u000fZ5oCR,\u0017\u0001F5t\u0013:$XM]5peN\u001cuN\u001c8fGR,G-F\u0001a!\t9\u0013-\u0003\u0002cQ\t9!i\\8mK\u0006t\u0017\u0001G:fi&sG/\u001a:j_J,EmZ3t\u0013:\u0014Vm];miR\u0011\u0001*\u001a\u0005\u0006MB\u0001\raZ\u0001\u0006OJ\f\u0007\u000f\u001b\t\u0003\u0003\"L!!\u001b\"\u0003\u0017Ac\u0017M\\1s\u000fJ\f\u0007\u000f[\u0001\u000fEVLG\u000eZ#eO\u0016\u0014\u0016N\\4t)\ta'\u0010E\u0002neRl\u0011A\u001c\u0006\u0003_B\fA!\u001e;jY*\t\u0011/\u0001\u0003kCZ\f\u0017BA:o\u0005%\t%O]1z\u0019&\u001cH\u000f\u0005\u0002vq6\taO\u0003\u0002x3\u00059qN^3sY\u0006L\u0018BA=w\u0005=i\u0015N\\5nC2,EmZ3SS:<\u0007\"B>\u0012\u0001\u0004a\u0018\u0001\u00033je\u0016#w-Z:\u0011\u00075lx0\u0003\u0002\u007f]\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007\u0005\u000b\t!C\u0002\u0002\u0004\t\u0013q!\u00123hK\u0016sG-A\nwSNLGo\u00155fY2Le\u000e^3sS>\u00148\u000fF\u0003I\u0003\u0013\t\u0019\u0002C\u0004\u0002\fI\u0001\r!!\u0004\u0002\u0003\u001d\u00042!MA\b\u0013\r\t\tB\r\u0002\t\u000f\u0016|W.\u001a;ss\")aM\u0005a\u0001O\u0006\tb/[:ji&sG/\u001a:j_J\u0014\u0016N\\4\u0015\u000b!\u000bI\"a\t\t\u000f\u0005m1\u00031\u0001\u0002\u001e\u0005!!/\u001b8h!\r\t\u0014qD\u0005\u0004\u0003C\u0011$A\u0003'j]\u0016\u001cFO]5oO\")am\u0005a\u0001O\u0006Ab/[:ji2Kgn[3e\t&\u0014Xm\u0019;fI\u0016#w-Z:\u0015\u0007!\u000bI\u0003C\u0004\u0002,Q\u0001\r!!\f\u0002\u000bM$\u0018M\u001d;\u0011\u0007\u0005\u000by#C\u0002\u00022\t\u0013A\u0002R5sK\u000e$X\rZ#eO\u0016\fQ\u0003[1t+:4\u0018n]5uK\u0012\u001c\u0006.\u001a7m\u000b\u0012<W\rF\u0002a\u0003oAq!!\u000f\u0016\u0001\u0004\tY$A\u0005fI\u001e,'+\u001b8hgB!Q.!\u0010u\u0013\r\tyD\u001c\u0002\u0005\u0019&\u001cH\u000f")
public class ConnectedInteriorTester {
    private GeometryGraph geomGraph;
    private final GeometryFactory geometryFactory;
    private Coordinate disconnectedRingcoord;
    private volatile byte bitmap$init$0;

    public static Coordinate findDifferentPoint(Coordinate[] coordinateArray, Coordinate coordinate) {
        return ConnectedInteriorTester$.MODULE$.findDifferentPoint(coordinateArray, coordinate);
    }

    public GeometryGraph geomGraph() {
        return this.geomGraph;
    }

    public void geomGraph_$eq(GeometryGraph x$1) {
        this.geomGraph = x$1;
    }

    private GeometryFactory geometryFactory() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/valid/ConnectedInteriorTester.scala: 55");
        }
        return this.geometryFactory;
    }

    private Coordinate disconnectedRingcoord() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/valid/ConnectedInteriorTester.scala: 58");
        }
        return this.disconnectedRingcoord;
    }

    private void disconnectedRingcoord_$eq(Coordinate x$1) {
        this.disconnectedRingcoord = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public Coordinate getCoordinate() {
        return this.disconnectedRingcoord();
    }

    public boolean isInteriorsConnected() {
        ArrayList<Edge> splitEdges = new ArrayList<Edge>();
        this.geomGraph().computeSplitEdges(splitEdges);
        PlanarGraph graph = new PlanarGraph(new OverlayNodeFactory());
        graph.addEdges(splitEdges);
        this.setInteriorEdgesInResult(graph);
        graph.linkResultDirectedEdges();
        ArrayList<MinimalEdgeRing> edgeRings = this.buildEdgeRings(graph.getEdgeEnds());
        this.visitShellInteriors(this.geomGraph().getGeometry(), graph);
        return !this.hasUnvisitedShellEdge(edgeRings);
    }

    private void setInteriorEdgesInResult(PlanarGraph graph) {
        for (DirectedEdge directedEdge : graph.getEdgeEnds()) {
            if (directedEdge.getLabel().getLocation(0, Position$.MODULE$.RIGHT()) != Location$.MODULE$.INTERIOR()) continue;
            directedEdge.setInResult(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<MinimalEdgeRing> buildEdgeRings(Collection<EdgeEnd> dirEdges) {
        void var2_2;
        ArrayList<MinimalEdgeRing> edgeRings = new ArrayList<MinimalEdgeRing>();
        for (DirectedEdge directedEdge : dirEdges) {
            Object object;
            if (directedEdge.isInResult() && directedEdge.getEdgeRing() == null) {
                MaximalEdgeRing er = new MaximalEdgeRing(directedEdge, this.geometryFactory());
                er.linkDirectedEdgesForMinimalEdgeRings();
                ArrayList<MinimalEdgeRing> minEdgeRings = er.buildMinimalRings();
                object = BoxesRunTime.boxToBoolean((boolean)edgeRings.addAll(minEdgeRings));
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    private void visitShellInteriors(Geometry g, PlanarGraph graph) {
        if (g instanceof Polygon) {
            Polygon p = (Polygon)g;
            this.visitInteriorRing(p.getExteriorRing(), graph);
        }
        if (g instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)g;
            for (int i = 0; i < mp.getNumGeometries(); ++i) {
                Polygon p = (Polygon)mp.getGeometryN(i);
                this.visitInteriorRing(p.getExteriorRing(), graph);
            }
        }
    }

    private void visitInteriorRing(LineString ring, PlanarGraph graph) {
        if (ring.isEmpty()) {
            return;
        }
        Coordinate[] pts = ring.getCoordinates();
        Coordinate pt0 = pts[0];
        Coordinate pt1 = ConnectedInteriorTester$.MODULE$.findDifferentPoint(pts, pt0);
        Edge e = graph.findEdgeInSameDirection(pt0, pt1);
        DirectedEdge de = (DirectedEdge)graph.findEdgeEnd(e);
        DirectedEdge intDe = null;
        if (de.getLabel().getLocation(0, Position$.MODULE$.RIGHT()) == Location$.MODULE$.INTERIOR()) {
            intDe = de;
        } else if (de.getSym().getLabel().getLocation(0, Position$.MODULE$.RIGHT()) == Location$.MODULE$.INTERIOR()) {
            intDe = de.getSym();
        }
        Assert$.MODULE$.isTrue(intDe != null, "unable to find dirEdge with Interior on RHS");
        this.visitLinkedDirectedEdges(intDe);
    }

    public void visitLinkedDirectedEdges(DirectedEdge start) {
        DirectedEdge startDe = start;
        DirectedEdge de = start;
        do {
            Assert$.MODULE$.isTrue(de != null, "found null Directed Edge");
            de.setVisited(true);
            de = de.getNext();
        } while (de != startDe);
    }

    private boolean hasUnvisitedShellEdge(List<MinimalEdgeRing> edgeRings) {
        for (int i = 0; i < edgeRings.size(); ++i) {
            ArrayList<?> edges;
            DirectedEdge de;
            MinimalEdgeRing er = edgeRings.get(i);
            if (er.isHole() || (de = (DirectedEdge)(edges = er.getEdges()).get(0)).getLabel().getLocation(0, Position$.MODULE$.RIGHT()) != Location$.MODULE$.INTERIOR()) continue;
            for (int j = 0; j < edges.size(); ++j) {
                de = (DirectedEdge)edges.get(j);
                if (de.isVisited()) continue;
                this.disconnectedRingcoord_$eq(de.getCoordinate());
                return true;
            }
        }
        return false;
    }

    public ConnectedInteriorTester(GeometryGraph geomGraph) {
        this.geomGraph = geomGraph;
        this.geometryFactory = new GeometryFactory();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.disconnectedRingcoord = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

