/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.Iterator;
import java.util.TreeSet;
import org.locationtech.jts.algorithm.PointLocation$;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.EdgeIntersectionList;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.operation.valid.ConnectedInteriorTester;
import org.locationtech.jts.operation.valid.ConsistentAreaTester;
import org.locationtech.jts.operation.valid.IndexedNestedRingTester;
import org.locationtech.jts.operation.valid.IsValidOp$;
import org.locationtech.jts.operation.valid.TopologyValidationError;
import org.locationtech.jts.operation.valid.TopologyValidationError$;
import org.locationtech.jts.util.Assert$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Mw!\u0002\u0016,\u0011\u00031d!\u0002\u001d,\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005\"\u0002\"\u0002\t\u0003\u0019\u0005\"\u0002\"\u0002\t\u0003q\u0005\"\u0002+\u0002\t\u0003)f\u0001\u0002\u001d,\u0001!D\u0001\"\u001b\u0004\u0003\u0002\u0004%\tA\u001b\u0005\tW\u001a\u0011\t\u0019!C\u0001Y\"A!O\u0002B\u0001B\u0003&\u0011\nC\u0003A\r\u0011\u00051\u000fC\u0004w\r\u0001\u0007I\u0011B<\t\u000fa4\u0001\u0019!C\u0005s\"11P\u0002Q!\n\u0011Cq\u0001 \u0004A\u0002\u0013%Q\u0010C\u0005\u0002\u0004\u0019\u0001\r\u0011\"\u0003\u0002\u0006!9\u0011\u0011\u0002\u0004!B\u0013q\bbBA\u0006\r\u0011\u0005\u0011Q\u0002\u0005\u0006\u0005\u001a!\ta\u001e\u0005\u0007\u0003#1A\u0011A?\t\u000f\u0005Ma\u0001\"\u0003\u0002\u0016!9\u00111\u0003\u0004\u0005\n\u0005m\u0001bBA\n\r\u0011%\u0011Q\u0005\u0005\b\u0003'1A\u0011BA\u0018\u0011\u001d\t\u0019B\u0002C\u0005\u0003sAq!a\u0005\u0007\t\u0013\ti\u0004C\u0004\u0002\u0014\u0019!I!a\u0012\t\u000f\u0005Ma\u0001\"\u0003\u0002R!9\u0011Q\f\u0004\u0005\n\u0005}\u0003bBA/\r\u0011%\u0011Q\r\u0005\b\u0003W2A\u0011BA7\u0011\u001d\t\tH\u0002C\u0005\u0003gBq!!\u001f\u0007\t\u0013\tY\bC\u0004\u0002\u0000\u0019!I!!!\t\u000f\u0005\u0015e\u0001\"\u0003\u0002\b\"9\u00111\u0012\u0004\u0005\n\u00055\u0005bBAM\r\u0011%\u00111\u0014\u0005\b\u0003G3A\u0011BAS\u0011\u001d\tYK\u0002C\u0005\u0003[Cq!!.\u0007\t\u0013\t9\fC\u0004\u0002B\u001a!I!a1\t\u000f\u00055g\u0001\"\u0003\u0002P\u0006I\u0011j\u001d,bY&$w\n\u001d\u0006\u0003Y5\nQA^1mS\u0012T!AL\u0018\u0002\u0013=\u0004XM]1uS>t'B\u0001\u00192\u0003\rQGo\u001d\u0006\u0003eM\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011\u0001N\u0001\u0004_J<7\u0001\u0001\t\u0003o\u0005i\u0011a\u000b\u0002\n\u0013N4\u0016\r\\5e\u001fB\u001c\"!\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta'A\u0004jgZ\u000bG.\u001b3\u0015\u0005\u0011;\u0005CA\u001eF\u0013\t1EHA\u0004C_>dW-\u00198\t\u000b!\u001b\u0001\u0019A%\u0002\t\u001d,w.\u001c\t\u0003\u00152k\u0011a\u0013\u0006\u0003\u0011>J!!T&\u0003\u0011\u001d+w.\\3uef$\"\u0001R(\t\u000bA#\u0001\u0019A)\u0002\u000b\r|wN\u001d3\u0011\u0005)\u0013\u0016BA*L\u0005)\u0019un\u001c:eS:\fG/Z\u0001\u000eM&tG\r\u0015;O_Rtu\u000eZ3\u0015\tE36\f\u0019\u0005\u0006/\u0016\u0001\r\u0001W\u0001\u000bi\u0016\u001cHoQ8pe\u0012\u001c\bcA\u001eZ#&\u0011!\f\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u00069\u0016\u0001\r!X\u0001\u000bg\u0016\f'o\u00195SS:<\u0007C\u0001&_\u0013\ty6J\u0001\u0006MS:,\u0017M\u001d*j]\u001eDQ!Y\u0003A\u0002\t\fQa\u001a:ba\"\u0004\"a\u00194\u000e\u0003\u0011T!!Z\u0018\u0002\u0013\u001d,w.\\4sCBD\u0017BA4e\u000559Um\\7fiJLxI]1qQN\u0011aAO\u0001\u000fa\u0006\u0014XM\u001c;HK>lW\r\u001e:z+\u0005I\u0015A\u00059be\u0016tGoR3p[\u0016$(/_0%KF$\"!\u001c9\u0011\u0005mr\u0017BA8=\u0005\u0011)f.\u001b;\t\u000fED\u0011\u0011!a\u0001\u0013\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\f'/\u001a8u\u000f\u0016|W.\u001a;ss\u0002\"\"\u0001^;\u0011\u0005]2\u0001\"B5\u000b\u0001\u0004I\u0015AI5t'\u0016dg\rV8vG\"Lgn\u001a*j]\u001e4uN]7j]\u001eDu\u000e\\3WC2LG-F\u0001E\u0003\u0019J7oU3mMR{Wo\u00195j]\u001e\u0014\u0016N\\4G_Jl\u0017N\\4I_2,g+\u00197jI~#S-\u001d\u000b\u0003[jDq!\u001d\u0007\u0002\u0002\u0003\u0007A)A\u0012jgN+GN\u001a+pk\u000eD\u0017N\\4SS:<gi\u001c:nS:<\u0007j\u001c7f-\u0006d\u0017\u000e\u001a\u0011\u0002\u0011Y\fG.\u001b3FeJ,\u0012A \t\u0003o}L1!!\u0001,\u0005]!v\u000e]8m_\u001eLh+\u00197jI\u0006$\u0018n\u001c8FeJ|'/\u0001\u0007wC2LG-\u0012:s?\u0012*\u0017\u000fF\u0002n\u0003\u000fAq!]\b\u0002\u0002\u0003\u0007a0A\u0005wC2LG-\u0012:sA\u0005\u00193/\u001a;TK24Gk\\;dQ&twMU5oO\u001a{'/\\5oO\"{G.\u001a,bY&$GcA7\u0002\u0010!)!)\u0005a\u0001\t\u0006\u0011r-\u001a;WC2LG-\u0019;j_:,%O]8s\u0003)\u0019\u0007.Z2l-\u0006d\u0017\u000e\u001a\u000b\u0004[\u0006]\u0001BBA\r)\u0001\u0007\u0011*A\u0001h)\ri\u0017Q\u0004\u0005\b\u00033)\u0002\u0019AA\u0010!\rQ\u0015\u0011E\u0005\u0004\u0003GY%!\u0002)pS:$HcA7\u0002(!9\u0011\u0011\u0004\fA\u0002\u0005%\u0002c\u0001&\u0002,%\u0019\u0011QF&\u0003\u00155+H\u000e^5Q_&tG\u000fF\u0002n\u0003cAq!!\u0007\u0018\u0001\u0004\t\u0019\u0004E\u0002K\u0003kI1!a\u000eL\u0005)a\u0015N\\3TiJLgn\u001a\u000b\u0004[\u0006m\u0002BBA\r1\u0001\u0007Q\fF\u0002n\u0003\u007fAq!!\u0007\u001a\u0001\u0004\t\t\u0005E\u0002K\u0003\u0007J1!!\u0012L\u0005\u001d\u0001v\u000e\\=h_:$2!\\A%\u0011\u001d\tIB\u0007a\u0001\u0003\u0017\u00022ASA'\u0013\r\tye\u0013\u0002\r\u001bVdG/\u001b)pYf<wN\u001c\u000b\u0004[\u0006M\u0003bBA+7\u0001\u0007\u0011qK\u0001\u0003O\u000e\u00042ASA-\u0013\r\tYf\u0013\u0002\u0013\u000f\u0016|W.\u001a;ss\u000e{G\u000e\\3di&|g.A\fdQ\u0016\u001c7.\u00138wC2LGmQ8pe\u0012Lg.\u0019;fgR\u0019Q.!\u0019\t\r\u0005\rD\u00041\u0001Y\u0003\u0019\u0019wn\u001c:egR\u0019Q.a\u001a\t\u000f\u0005%T\u00041\u0001\u0002B\u0005!\u0001o\u001c7z\u0003A\u0019\u0007.Z2l\u00072|7/\u001a3SS:<7\u000fF\u0002n\u0003_Bq!!\u001b\u001f\u0001\u0004\t\t%A\bdQ\u0016\u001c7n\u00117pg\u0016$'+\u001b8h)\ri\u0017Q\u000f\u0005\u0007\u0003oz\u0002\u0019A/\u0002\tILgnZ\u0001\u0012G\",7m\u001b+p_\u001a+w\u000fU8j]R\u001cHcA7\u0002~!)\u0011\r\ta\u0001E\u0006\u00192\r[3dW\u000e{gn]5ti\u0016tG/\u0011:fCR\u0019Q.a!\t\u000b\u0005\f\u0003\u0019\u00012\u00029\rDWmY6O_N+GNZ%oi\u0016\u00148/Z2uS:<'+\u001b8hgR\u0019Q.!#\t\u000b\u0005\u0014\u0003\u0019\u00012\u00027\rDWmY6O_N+GNZ%oi\u0016\u00148/Z2uS:<'+\u001b8h)\ri\u0017q\u0012\u0005\b\u0003#\u001b\u0003\u0019AAJ\u0003\u0019)\u0017\u000eT5tiB\u00191-!&\n\u0007\u0005]EM\u0001\u000bFI\u001e,\u0017J\u001c;feN,7\r^5p]2K7\u000f^\u0001\u0012G\",7m\u001b%pY\u0016\u001c\u0018J\\*iK2dG#B7\u0002\u001e\u0006\u0005\u0006bBAPI\u0001\u0007\u0011\u0011I\u0001\u0002a\")\u0011\r\na\u0001E\u0006\u00192\r[3dW\"{G.Z:O_RtUm\u001d;fIR)Q.a*\u0002*\"9\u0011qT\u0013A\u0002\u0005\u0005\u0003\"B1&\u0001\u0004\u0011\u0017\u0001F2iK\u000e\\7\u000b[3mYNtu\u000e\u001e(fgR,G\rF\u0003n\u0003_\u000b\u0019\fC\u0004\u00022\u001a\u0002\r!a\u0013\u0002\u00055\u0004\b\"B1'\u0001\u0004\u0011\u0017aE2iK\u000e\\7\u000b[3mY:{GOT3ti\u0016$GcB7\u0002:\u0006u\u0016q\u0018\u0005\u0007\u0003w;\u0003\u0019A/\u0002\u000bMDW\r\u001c7\t\u000f\u0005}u\u00051\u0001\u0002B!)\u0011m\na\u0001E\u0006!2\r[3dWNCW\r\u001c7J]NLG-\u001a%pY\u0016$r!UAc\u0003\u000f\fY\r\u0003\u0004\u0002<\"\u0002\r!\u0018\u0005\u0007\u0003\u0013D\u0003\u0019A/\u0002\t!|G.\u001a\u0005\u0006C\"\u0002\rAY\u0001\u0018G\",7m[\"p]:,7\r^3e\u0013:$XM]5peN$2!\\Ai\u0011\u0015\t\u0017\u00061\u0001c\u0001")
public class IsValidOp {
    private Geometry parentGeometry;
    private boolean isSelfTouchingRingFormingHoleValid;
    private TopologyValidationError validErr;
    private volatile byte bitmap$init$0;

    public static Coordinate findPtNotNode(Coordinate[] coordinateArray, LinearRing linearRing, GeometryGraph geometryGraph) {
        return IsValidOp$.MODULE$.findPtNotNode(coordinateArray, linearRing, geometryGraph);
    }

    public Geometry parentGeometry() {
        return this.parentGeometry;
    }

    public void parentGeometry_$eq(Geometry x$1) {
        this.parentGeometry = x$1;
    }

    private boolean isSelfTouchingRingFormingHoleValid() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/valid/IsValidOp.scala: 97");
        }
        return this.isSelfTouchingRingFormingHoleValid;
    }

    private void isSelfTouchingRingFormingHoleValid_$eq(boolean x$1) {
        this.isSelfTouchingRingFormingHoleValid = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private TopologyValidationError validErr() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/operation/valid/IsValidOp.scala: 98");
        }
        return this.validErr;
    }

    private void validErr_$eq(TopologyValidationError x$1) {
        this.validErr = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public void setSelfTouchingRingFormingHoleValid(boolean isValid) {
        this.isSelfTouchingRingFormingHoleValid_$eq(isValid);
    }

    public boolean isValid() {
        this.checkValid(this.parentGeometry());
        return this.validErr() == null;
    }

    public TopologyValidationError getValidationError() {
        this.checkValid(this.parentGeometry());
        return this.validErr();
    }

    private void checkValid(Geometry g) {
        this.validErr_$eq(null);
        if (g.isEmpty()) {
            return;
        }
        if (g instanceof Point) {
            this.checkValid((Point)g);
        } else if (g instanceof MultiPoint) {
            this.checkValid((MultiPoint)g);
        } else if (g instanceof LinearRing) {
            this.checkValid((LinearRing)g);
        } else if (g instanceof LineString) {
            this.checkValid((LineString)g);
        } else if (g instanceof Polygon) {
            this.checkValid((Polygon)g);
        } else if (g instanceof MultiPolygon) {
            this.checkValid((MultiPolygon)g);
        } else if (g instanceof GeometryCollection) {
            this.checkValid((GeometryCollection)g);
        } else {
            throw new UnsupportedOperationException(g.getClass().getName());
        }
    }

    private void checkValid(Point g) {
        this.checkInvalidCoordinates(g.getCoordinates());
    }

    private void checkValid(MultiPoint g) {
        this.checkInvalidCoordinates(g.getCoordinates());
    }

    private void checkValid(LineString g) {
        this.checkInvalidCoordinates(g.getCoordinates());
        if (this.validErr() != null) {
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g);
        this.checkTooFewPoints(graph);
    }

    private void checkValid(LinearRing g) {
        this.checkInvalidCoordinates(g.getCoordinates());
        if (this.validErr() != null) {
            return;
        }
        this.checkClosedRing(g);
        if (this.validErr() != null) {
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g);
        this.checkTooFewPoints(graph);
        if (this.validErr() != null) {
            return;
        }
        RobustLineIntersector li = new RobustLineIntersector();
        graph.computeSelfNodes(li, true, true);
        this.checkNoSelfIntersectingRings(graph);
    }

    private void checkValid(Polygon g) {
        this.checkInvalidCoordinates(g);
        if (this.validErr() != null) {
            return;
        }
        this.checkClosedRings(g);
        if (this.validErr() != null) {
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g);
        this.checkTooFewPoints(graph);
        if (this.validErr() != null) {
            return;
        }
        this.checkConsistentArea(graph);
        if (this.validErr() != null) {
            return;
        }
        if (!this.isSelfTouchingRingFormingHoleValid()) {
            this.checkNoSelfIntersectingRings(graph);
            if (this.validErr() != null) {
                return;
            }
        }
        this.checkHolesInShell(g, graph);
        if (this.validErr() != null) {
            return;
        }
        this.checkHolesNotNested(g, graph);
        if (this.validErr() != null) {
            return;
        }
        this.checkConnectedInteriors(graph);
    }

    private void checkValid(MultiPolygon g) {
        int i;
        for (i = 0; i < g.getNumGeometries(); ++i) {
            Polygon p = (Polygon)g.getGeometryN(i);
            this.checkInvalidCoordinates(p);
            if (this.validErr() != null) {
                return;
            }
            this.checkClosedRings(p);
            if (this.validErr() == null) continue;
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g);
        this.checkTooFewPoints(graph);
        if (this.validErr() != null) {
            return;
        }
        this.checkConsistentArea(graph);
        if (this.validErr() != null) {
            return;
        }
        if (!this.isSelfTouchingRingFormingHoleValid()) {
            this.checkNoSelfIntersectingRings(graph);
            if (this.validErr() != null) {
                return;
            }
        }
        for (i = 0; i < g.getNumGeometries(); ++i) {
            Polygon p = (Polygon)g.getGeometryN(i);
            this.checkHolesInShell(p, graph);
            if (this.validErr() == null) continue;
            return;
        }
        for (i = 0; i < g.getNumGeometries(); ++i) {
            Polygon p = (Polygon)g.getGeometryN(i);
            this.checkHolesNotNested(p, graph);
            if (this.validErr() == null) continue;
            return;
        }
        this.checkShellsNotNested(g, graph);
        if (this.validErr() != null) {
            return;
        }
        this.checkConnectedInteriors(graph);
    }

    private void checkValid(GeometryCollection gc) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            this.checkValid(g);
            if (this.validErr() == null) continue;
            return;
        }
    }

    private void checkInvalidCoordinates(Coordinate[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            if (IsValidOp$.MODULE$.isValid(coords[i])) continue;
            this.validErr_$eq(new TopologyValidationError(TopologyValidationError$.MODULE$.INVALID_COORDINATE(), coords[i]));
            return;
        }
    }

    private void checkInvalidCoordinates(Polygon poly) {
        this.checkInvalidCoordinates(poly.getExteriorRing().getCoordinates());
        if (this.validErr() != null) {
            return;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.checkInvalidCoordinates(poly.getInteriorRingN(i).getCoordinates());
            if (this.validErr() == null) continue;
            return;
        }
    }

    private void checkClosedRings(Polygon poly) {
        this.checkClosedRing(poly.getExteriorRing());
        if (this.validErr() != null) {
            return;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.checkClosedRing(poly.getInteriorRingN(i));
            if (this.validErr() == null) continue;
            return;
        }
    }

    private void checkClosedRing(LinearRing ring) {
        block2: {
            if (ring.isEmpty()) {
                return;
            }
            if (ring.isClosed()) break block2;
            Coordinate pt = null;
            if (ring.getNumPoints() >= 1) {
                pt = ring.getCoordinateN(0);
            }
            this.validErr_$eq(new TopologyValidationError(TopologyValidationError$.MODULE$.RING_NOT_CLOSED(), pt));
        }
    }

    private void checkTooFewPoints(GeometryGraph graph) {
        block0: {
            if (!graph.hasTooFewPoints()) break block0;
            this.validErr_$eq(new TopologyValidationError(TopologyValidationError$.MODULE$.TOO_FEW_POINTS(), graph.getInvalidPoint()));
        }
    }

    private void checkConsistentArea(GeometryGraph graph) {
        block1: {
            ConsistentAreaTester cat = new ConsistentAreaTester(graph);
            boolean isValidArea = cat.isNodeConsistentArea();
            if (!isValidArea) {
                this.validErr_$eq(new TopologyValidationError(TopologyValidationError$.MODULE$.SELF_INTERSECTION(), cat.getInvalidPoint()));
                return;
            }
            if (!cat.hasDuplicateRings()) break block1;
            this.validErr_$eq(new TopologyValidationError(TopologyValidationError$.MODULE$.DUPLICATE_RINGS(), cat.getInvalidPoint()));
        }
    }

    private void checkNoSelfIntersectingRings(GeometryGraph graph) {
        Iterator<Edge> i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            this.checkNoSelfIntersectingRing(e.getEdgeIntersectionList());
            if (this.validErr() == null) continue;
            return;
        }
    }

    private void checkNoSelfIntersectingRing(EdgeIntersectionList eiList) {
        TreeSet<Coordinate> nodeSet = new TreeSet<Coordinate>();
        boolean isFirst = true;
        Iterator<EdgeIntersection> i = eiList.iterator();
        while (i.hasNext()) {
            Object object;
            EdgeIntersection ei = i.next();
            if (isFirst) {
                isFirst = false;
                object = BoxedUnit.UNIT;
                continue;
            }
            if (nodeSet.contains(ei.coord())) {
                this.validErr_$eq(new TopologyValidationError(TopologyValidationError$.MODULE$.RING_SELF_INTERSECTION(), ei.coord()));
                return;
            }
            object = BoxesRunTime.boxToBoolean((boolean)nodeSet.add(ei.coord()));
        }
    }

    private void checkHolesInShell(Polygon p, GeometryGraph graph) {
        if (p.getNumInteriorRing() <= 0) {
            return;
        }
        LinearRing shell = p.getExteriorRing();
        boolean isShellEmpty = shell.isEmpty();
        IndexedPointInAreaLocator pir = new IndexedPointInAreaLocator(shell);
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            boolean outside;
            LinearRing hole = p.getInteriorRingN(i);
            Coordinate holePt = null;
            if (hole.isEmpty()) continue;
            holePt = IsValidOp$.MODULE$.findPtNotNode(hole.getCoordinates(), shell, graph);
            if (holePt == null) {
                return;
            }
            boolean bl = outside = isShellEmpty || Location$.MODULE$.EXTERIOR() == pir.locate(holePt);
            if (!outside) continue;
            this.validErr_$eq(new TopologyValidationError(TopologyValidationError$.MODULE$.HOLE_OUTSIDE_SHELL(), holePt));
            return;
        }
    }

    private void checkHolesNotNested(Polygon p, GeometryGraph graph) {
        block2: {
            if (p.getNumInteriorRing() <= 0) {
                return;
            }
            IndexedNestedRingTester nestedTester = new IndexedNestedRingTester(graph);
            for (int i = 0; i < p.getNumInteriorRing(); ++i) {
                LinearRing innerHole = p.getInteriorRingN(i);
                if (innerHole.isEmpty()) continue;
                nestedTester.add(innerHole);
            }
            boolean isNonNested = nestedTester.isNonNested();
            if (isNonNested) break block2;
            this.validErr_$eq(new TopologyValidationError(TopologyValidationError$.MODULE$.NESTED_HOLES(), nestedTester.getNestedPoint()));
        }
    }

    private void checkShellsNotNested(MultiPolygon mp, GeometryGraph graph) {
        int i = 0;
        while (i < mp.getNumGeometries()) {
            Polygon p = (Polygon)mp.getGeometryN(i);
            LinearRing shell = p.getExteriorRing();
            int j = 0;
            while (j < mp.getNumGeometries()) {
                if (i != j) {
                    Polygon p2 = (Polygon)mp.getGeometryN(j);
                    this.checkShellNotNested(shell, p2, graph);
                    if (this.validErr() != null) {
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void checkShellNotNested(LinearRing shell, Polygon p, GeometryGraph graph) {
        Coordinate[] shellPts = shell.getCoordinates();
        LinearRing polyShell = p.getExteriorRing();
        if (polyShell.isEmpty()) {
            return;
        }
        Coordinate[] polyPts = polyShell.getCoordinates();
        Coordinate shellPt = IsValidOp$.MODULE$.findPtNotNode(shellPts, polyShell, graph);
        if (shellPt == null) {
            return;
        }
        boolean insidePolyShell = PointLocation$.MODULE$.isInRing(shellPt, polyPts);
        if (!insidePolyShell) {
            return;
        }
        if (p.getNumInteriorRing() <= 0) {
            this.validErr_$eq(new TopologyValidationError(TopologyValidationError$.MODULE$.NESTED_SHELLS(), shellPt));
            return;
        }
        Coordinate badNestedPt = null;
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            LinearRing hole = p.getInteriorRingN(i);
            badNestedPt = this.checkShellInsideHole(shell, hole, graph);
            if (badNestedPt != null) continue;
            return;
        }
        this.validErr_$eq(new TopologyValidationError(TopologyValidationError$.MODULE$.NESTED_SHELLS(), badNestedPt));
    }

    private Coordinate checkShellInsideHole(LinearRing shell, LinearRing hole, GeometryGraph graph) {
        boolean insideHole;
        Coordinate[] shellPts = shell.getCoordinates();
        Coordinate[] holePts = hole.getCoordinates();
        Coordinate shellPt = IsValidOp$.MODULE$.findPtNotNode(shellPts, hole, graph);
        if (shellPt != null && !(insideHole = PointLocation$.MODULE$.isInRing(shellPt, holePts))) {
            return shellPt;
        }
        Coordinate holePt = IsValidOp$.MODULE$.findPtNotNode(holePts, shell, graph);
        if (holePt != null) {
            boolean insideShell = PointLocation$.MODULE$.isInRing(holePt, shellPts);
            if (insideShell) {
                return holePt;
            }
            return null;
        }
        Assert$.MODULE$.shouldNeverReachHere("points in shell and hole appear to be equal");
        return null;
    }

    private void checkConnectedInteriors(GeometryGraph graph) {
        block0: {
            ConnectedInteriorTester cit = new ConnectedInteriorTester(graph);
            if (cit.isInteriorsConnected()) break block0;
            this.validErr_$eq(new TopologyValidationError(TopologyValidationError$.MODULE$.DISCONNECTED_INTERIOR(), cit.getCoordinate()));
        }
    }

    public IsValidOp(Geometry parentGeometry) {
        this.parentGeometry = parentGeometry;
        this.isSelfTouchingRingFormingHoleValid = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.validErr = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

