/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.geom.util.AffineTransformation$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\tEq!B!C\u0011\u0003Ye!B'C\u0011\u0003q\u0005\"B+\u0002\t\u00031f\u0001B,\u0002\u0011aCQ!V\u0002\u0005\u0002eCq\u0001X\u0002A\u0002\u0013\u0005Q\fC\u0004e\u0007\u0001\u0007I\u0011A3\t\r-\u001c\u0001\u0015)\u0003_\u0011\u001da7\u00011A\u0005\u0002uCq!\\\u0002A\u0002\u0013\u0005a\u000e\u0003\u0004q\u0007\u0001\u0006KA\u0018\u0005\bc\u000e\u0001\r\u0011\"\u0001s\u0011\u001d18\u00011A\u0005\u0002]Da!_\u0002!B\u0013\u0019\bb\u0002>\u0004\u0001\u0004%\tA\u001d\u0005\bw\u000e\u0001\r\u0011\"\u0001}\u0011\u0019q8\u0001)Q\u0005g\"1qp\u0001C\u0001\u0003\u0003Aa!!\u0002\u0004\t\u0003i\u0006bBA\u0004\u0007\u0011\u0005\u0011\u0011\u0002\u0005\u0007\u0003\u001b\u0019A\u0011A/\t\u000f\u0005=1\u0001\"\u0001\u0002\u0012!1\u0011qC\u0002\u0005\u0002IDq!!\u0007\u0004\t\u0003\tY\u0002\u0003\u0004\u0002 \r!\tA\u001d\u0005\u0007\u0003C\u0019A\u0011\u0001:\t\u000f\u0005\r2\u0001\"\u0001\u0002&!9\u0011\u0011F\u0002\u0005\u0002\u0005-\u0002bBA\u001c\u0007\u0011\u0005\u0011\u0011\b\u0004\u0006\u001b\n\u0003\u00111\b\u0005\u000b\u0003{i\"\u00111A\u0005\u0002\u0005}\u0002BCA$;\t\u0005\r\u0011\"\u0001\u0002J!Q\u0011QJ\u000f\u0003\u0002\u0003\u0006K!!\u0011\t\rUkB\u0011AA(\u0011%\t)&\ba\u0001\n#\t9\u0006C\u0005\u0002`u\u0001\r\u0011\"\u0005\u0002b!A\u0011QM\u000f!B\u0013\tI\u0006C\u0005\u0002hu\u0001\r\u0011\"\u0005\u0002j!I\u0011qN\u000fA\u0002\u0013E\u0011\u0011\u000f\u0005\t\u0003kj\u0002\u0015)\u0003\u0002l!I\u0011qO\u000fA\u0002\u0013E\u0011\u0011\u0010\u0005\n\u0003\u0003k\u0002\u0019!C\t\u0003\u0007C\u0001\"a\"\u001eA\u0003&\u00111\u0010\u0005\t\u0003\u0013k\u0002\u0019!C\te\"I\u00111R\u000fA\u0002\u0013E\u0011Q\u0012\u0005\b\u0003#k\u0002\u0015)\u0003t\u0011\u0019)V\u0004\"\u0001\u0002\u0014\"9\u0011\u0011F\u000f\u0005\u0002\u0005U\u0005BB@\u001e\t\u0003\tI\nC\u0004\u0002\bu!\t!!(\t\u000f\u0005\u0005V\u0004\"\u0001\u0002$\"9\u0011qB\u000f\u0005\u0002\u0005\u001d\u0006bBA\r;\u0011\u0005\u00111\u0016\u0005\b\u0003GiB\u0011AAX\u0011\u001d\t\u0019,\bC\u0001\u0003kCq!a/\u001e\t#\ti\fC\u0004\u0002Hv!\t!!3\t\u000f\u0005EW\u0004\"\u0001\u0002J\"9\u00111[\u000f\u0005\u0002\u0005%\u0007bBAk;\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003/lB\u0011AAm\u0011\u001d\ty.\bC\u0001\u0003CDq!!=\u001e\t\u0003\t\u0019\u0010C\u0004\u0002zv!\t\"a?\t\u000f\t\u0015Q\u0004\"\u0005\u0003\b\u0005)r)Z8nKR\u0014\u0018nY*iCB,g)Y2u_JL(BA\"E\u0003\u0011)H/\u001b7\u000b\u0005\u00153\u0015a\u00016ug*\u0011q\tS\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0013\u0006\u0019qN]4\u0004\u0001A\u0011A*A\u0007\u0002\u0005\n)r)Z8nKR\u0014\u0018nY*iCB,g)Y2u_JL8CA\u0001P!\t\u00016+D\u0001R\u0015\u0005\u0011\u0016!B:dC2\f\u0017B\u0001+R\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0013\u0002\u000b\t&lWM\\:j_:\u001c8CA\u0002P)\u0005Q\u0006CA.\u0004\u001b\u0005\t\u0011\u0001\u00022bg\u0016,\u0012A\u0018\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\u0012\u000bAaZ3p[&\u00111\r\u0019\u0002\u000b\u0007>|'\u000fZ5oCR,\u0017\u0001\u00032bg\u0016|F%Z9\u0015\u0005\u0019L\u0007C\u0001)h\u0013\tA\u0017K\u0001\u0003V]&$\bb\u00026\u0007\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\n\u0014!\u00022bg\u0016\u0004\u0013AB2f]R\u0014X-\u0001\u0006dK:$(/Z0%KF$\"AZ8\t\u000f)L\u0011\u0011!a\u0001=\u000691-\u001a8ue\u0016\u0004\u0013!B<jIRDW#A:\u0011\u0005A#\u0018BA;R\u0005\u0019!u.\u001e2mK\u0006Iq/\u001b3uQ~#S-\u001d\u000b\u0003MbDqA\u001b\u0007\u0002\u0002\u0003\u00071/\u0001\u0004xS\u0012$\b\u000eI\u0001\u0007Q\u0016Lw\r\u001b;\u0002\u0015!,\u0017n\u001a5u?\u0012*\u0017\u000f\u0006\u0002g{\"9!nDA\u0001\u0002\u0004\u0019\u0018a\u00025fS\u001eDG\u000fI\u0001\bg\u0016$()Y:f)\r1\u00171\u0001\u0005\u00069F\u0001\rAX\u0001\bO\u0016$()Y:f\u0003%\u0019X\r^\"f]R\u0014X\rF\u0002g\u0003\u0017AQ\u0001\\\nA\u0002y\u000b\u0011bZ3u\u0007\u0016tGO]3\u0002\u000fM,GoU5{KR\u0019a-a\u0005\t\r\u0005UQ\u00031\u0001t\u0003\u0011\u0019\u0018N_3\u0002\u0015\u001d,G/T5o'&TX-\u0001\u0005tKR<\u0016\u000e\u001a;i)\r1\u0017Q\u0004\u0005\u0006c^\u0001\ra]\u0001\tO\u0016$x+\u001b3uQ\u0006Iq-\u001a;IK&<\u0007\u000e^\u0001\ng\u0016$\b*Z5hQR$2AZA\u0014\u0011\u0015Q(\u00041\u0001t\u0003-\u0019X\r^#om\u0016dw\u000e]3\u0015\u0007\u0019\fi\u0003C\u0004\u00020m\u0001\r!!\r\u0002\u0007\u0015tg\u000fE\u0002`\u0003gI1!!\u000ea\u0005!)eN^3m_B,\u0017aC4fi\u0016sg/\u001a7pa\u0016,\"!!\r\u0014\u0005uy\u0015\u0001C4f_64\u0015m\u0019;\u0016\u0005\u0005\u0005\u0003cA0\u0002D%\u0019\u0011Q\t1\u0003\u001f\u001d+w.\\3uef4\u0015m\u0019;pef\fAbZ3p[\u001a\u000b7\r^0%KF$2AZA&\u0011!Qw$!AA\u0002\u0005\u0005\u0013!C4f_64\u0015m\u0019;!)\u0011\t\t&a\u0015\u0011\u00051k\u0002bBA\u001fC\u0001\u0007\u0011\u0011I\u0001\naJ,7-T8eK2,\"!!\u0017\u0011\u0007}\u000bY&C\u0002\u0002^\u0001\u0014a\u0002\u0015:fG&\u001c\u0018n\u001c8N_\u0012,G.A\u0007qe\u0016\u001cWj\u001c3fY~#S-\u001d\u000b\u0004M\u0006\r\u0004\u0002\u00036$\u0003\u0003\u0005\r!!\u0017\u0002\u0015A\u0014XmY'pI\u0016d\u0007%A\u0002eS6,\"!a\u001b\u0011\u0007\u000554A\u0004\u0002M\u0001\u00059A-[7`I\u0015\fHc\u00014\u0002t!A!NJA\u0001\u0002\u0004\tY'\u0001\u0003eS6\u0004\u0013\u0001\u00028QiN,\"!a\u001f\u0011\u0007A\u000bi(C\u0002\u0002\u0000E\u00131!\u00138u\u0003!q\u0007\u000b^:`I\u0015\fHc\u00014\u0002\u0006\"A!.KA\u0001\u0002\u0004\tY(A\u0003o!R\u001c\b%A\u0007s_R\fG/[8o\u0003:<G.Z\u0001\u0012e>$\u0018\r^5p]\u0006sw\r\\3`I\u0015\fHc\u00014\u0002\u0010\"9!\u000eLA\u0001\u0002\u0004\u0019\u0018A\u0004:pi\u0006$\u0018n\u001c8B]\u001edW\r\t\u000b\u0003\u0003#\"2AZAL\u0011\u001d\tyc\fa\u0001\u0003c!2AZAN\u0011\u0015a\u0006\u00071\u0001_)\r1\u0017q\u0014\u0005\u0006YF\u0002\rAX\u0001\rg\u0016$h*^7Q_&tGo\u001d\u000b\u0004M\u0006\u0015\u0006bBA<e\u0001\u0007\u00111\u0010\u000b\u0004M\u0006%\u0006BBA\u000bg\u0001\u00071\u000fF\u0002g\u0003[CQ!\u001d\u001bA\u0002M$2AZAY\u0011\u0015QX\u00071\u0001t\u0003-\u0019X\r\u001e*pi\u0006$\u0018n\u001c8\u0015\u0007\u0019\f9\f\u0003\u0004\u0002:Z\u0002\ra]\u0001\be\u0006$\u0017.\u00198t\u0003\u0019\u0011x\u000e^1uKR!\u0011qXAc!\ry\u0016\u0011Y\u0005\u0004\u0003\u0007\u0004'\u0001C$f_6,GO]=\t\r\u0005<\u0004\u0019AA`\u0003=\u0019'/Z1uKJ+7\r^1oO2,WCAAf!\ry\u0016QZ\u0005\u0004\u0003\u001f\u0004'a\u0002)pYf<wN\\\u0001\rGJ,\u0017\r^3DSJ\u001cG.Z\u0001\u000eGJ,\u0017\r^3FY2L\u0007o]3\u0002\u001d\r\u0014X-\u0019;f'F,\u0018N]2mK\u0006\t2M]3bi\u0016\u001cV\u000f]3sG&\u00148\r\\3\u0015\t\u0005-\u00171\u001c\u0005\u0007\u0003;d\u0004\u0019A:\u0002\u000bA|w/\u001a:\u0002\u0013\r\u0014X-\u0019;f\u0003J\u001cGCBAr\u0003S\fi\u000fE\u0002`\u0003KL1!a:a\u0005)a\u0015N\\3TiJLgn\u001a\u0005\u0007\u0003Wl\u0004\u0019A:\u0002\u0011M$\u0018M\u001d;B]\u001eDa!a<>\u0001\u0004\u0019\u0018!C1oO\u0016CH/\u001a8u\u0003A\u0019'/Z1uK\u0006\u00138\rU8ms\u001e|g\u000e\u0006\u0004\u0002L\u0006U\u0018q\u001f\u0005\u0007\u0003Wt\u0004\u0019A:\t\r\u0005=h\b1\u0001t\u0003\u0015\u0019wn\u001c:e)\u0015q\u0016Q B\u0001\u0011\u0019\typ\u0010a\u0001g\u0006\t\u0001\u0010\u0003\u0004\u0003\u0004}\u0002\ra]\u0001\u0002s\u0006Q1m\\8sIR\u0013\u0018M\\:\u0015\u000fy\u0013IAa\u0003\u0003\u000e!1\u0011q !A\u0002MDaAa\u0001A\u0001\u0004\u0019\bB\u0002B\b\u0001\u0002\u0007a,A\u0003ue\u0006t7\u000f")
public class GeometricShapeFactory {
    private GeometryFactory geomFact;
    private PrecisionModel precModel;
    private Dimensions dim;
    private int nPts;
    private double rotationAngle;
    private volatile byte bitmap$init$0;

    public GeometryFactory geomFact() {
        return this.geomFact;
    }

    public void geomFact_$eq(GeometryFactory x$1) {
        this.geomFact = x$1;
    }

    public PrecisionModel precModel() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/util/GeometricShapeFactory.scala: 109");
        }
        return this.precModel;
    }

    public void precModel_$eq(PrecisionModel x$1) {
        this.precModel = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    public Dimensions dim() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/util/GeometricShapeFactory.scala: 110");
        }
        return this.dim;
    }

    public void dim_$eq(Dimensions x$1) {
        this.dim = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public int nPts() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/util/GeometricShapeFactory.scala: 111");
        }
        return this.nPts;
    }

    public void nPts_$eq(int x$1) {
        this.nPts = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    public double rotationAngle() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/util/GeometricShapeFactory.scala: 115");
        }
        return this.rotationAngle;
    }

    public void rotationAngle_$eq(double x$1) {
        this.rotationAngle = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    public void setEnvelope(Envelope env) {
        this.dim().setEnvelope(env);
    }

    public void setBase(Coordinate base) {
        this.dim().setBase(base);
    }

    public void setCentre(Coordinate centre) {
        this.dim().setCentre(centre);
    }

    public void setNumPoints(int nPts) {
        this.nPts_$eq(nPts);
    }

    public void setSize(double size) {
        this.dim().setSize(size);
    }

    public void setWidth(double width) {
        this.dim().setWidth(width);
    }

    public void setHeight(double height) {
        this.dim().setHeight(height);
    }

    public void setRotation(double radians) {
        this.rotationAngle_$eq(radians);
    }

    public Geometry rotate(Geometry geom) {
        block0: {
            if (this.rotationAngle() == 0.0) break block0;
            AffineTransformation trans = AffineTransformation$.MODULE$.rotationInstance(this.rotationAngle(), this.dim().getCentre().x(), this.dim().getCentre().y());
            geom.applyF(trans);
        }
        return geom;
    }

    public Polygon createRectangle() {
        int i = 0;
        int ipt = 0;
        int nSide = this.nPts() / 4;
        if (nSide < 1) {
            nSide = 1;
        }
        double XsegLen = this.dim().getEnvelope().getWidth() / (double)nSide;
        double YsegLen = this.dim().getEnvelope().getHeight() / (double)nSide;
        Coordinate[] pts = new Coordinate[4 * nSide + 1];
        Envelope env = this.dim().getEnvelope();
        for (i = 0; i < nSide; ++i) {
            double x = env.getMinX() + (double)i * XsegLen;
            double y = env.getMinY();
            pts[++ipt - 1] = this.coord(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            double x = env.getMaxX();
            double y = env.getMinY() + (double)i * YsegLen;
            pts[++ipt - 1] = this.coord(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            double x = env.getMaxX() - (double)i * XsegLen;
            double y = env.getMaxY();
            pts[++ipt - 1] = this.coord(x, y);
        }
        for (i = 0; i < nSide; ++i) {
            double x = env.getMinX();
            double y = env.getMaxY() - (double)i * YsegLen;
            pts[++ipt - 1] = this.coord(x, y);
        }
        pts[++ipt - 1] = new Coordinate(pts[0]);
        LinearRing ring = this.geomFact().createLinearRing(pts);
        Polygon poly = this.geomFact().createPolygon(ring);
        return (Polygon)this.rotate(poly);
    }

    public Polygon createCircle() {
        return this.createEllipse();
    }

    public Polygon createEllipse() {
        Envelope env = this.dim().getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        Coordinate[] pts = new Coordinate[this.nPts() + 1];
        int iPt = 0;
        for (int i = 0; i < this.nPts(); ++i) {
            double ang = (double)i * (Math.PI * 2 / (double)this.nPts());
            double x = xRadius * Math.cos(ang) + centreX;
            double y = yRadius * Math.sin(ang) + centreY;
            pts[++iPt - 1] = this.coord(x, y);
        }
        pts[iPt] = new Coordinate(pts[0]);
        LinearRing ring = this.geomFact().createLinearRing(pts);
        Polygon poly = this.geomFact().createPolygon(ring);
        return (Polygon)this.rotate(poly);
    }

    public Polygon createSquircle() {
        return this.createSupercircle(4.0);
    }

    public Polygon createSupercircle(double power) {
        double recipPow = 1.0 / power;
        double radius = this.dim().getMinSize() / (double)2;
        Coordinate centre = this.dim().getCentre();
        double r4 = Math.pow(radius, power);
        double y0 = radius;
        double xyInt = Math.pow(r4 / (double)2, recipPow);
        int nSegsInOct = this.nPts() / 8;
        int totPts = nSegsInOct * 8 + 1;
        Coordinate[] pts = new Coordinate[totPts];
        double xInc = xyInt / (double)nSegsInOct;
        for (int i = 0; i <= nSegsInOct; ++i) {
            double x = 0.0;
            double y = y0;
            if (i != 0) {
                x = xInc * (double)i;
                double x4 = Math.pow(x, power);
                y = Math.pow(r4 - x4, recipPow);
            }
            pts[i] = this.coordTrans(x, y, centre);
            pts[2 * nSegsInOct - i] = this.coordTrans(y, x, centre);
            pts[2 * nSegsInOct + i] = this.coordTrans(y, -x, centre);
            pts[4 * nSegsInOct - i] = this.coordTrans(x, -y, centre);
            pts[4 * nSegsInOct + i] = this.coordTrans(-x, -y, centre);
            pts[6 * nSegsInOct - i] = this.coordTrans(-y, -x, centre);
            pts[6 * nSegsInOct + i] = this.coordTrans(-y, x, centre);
            pts[8 * nSegsInOct - i] = this.coordTrans(-x, y, centre);
        }
        pts[pts.length - 1] = new Coordinate(pts[0]);
        LinearRing ring = this.geomFact().createLinearRing(pts);
        Polygon poly = this.geomFact().createPolygon(ring);
        return (Polygon)this.rotate(poly);
    }

    public LineString createArc(double startAng, double angExtent) {
        Envelope env = this.dim().getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        double angSize = angExtent;
        if (angSize <= 0.0 || angSize > Math.PI * 2) {
            angSize = Math.PI * 2;
        }
        double angInc = angSize / (double)(this.nPts() - 1);
        Coordinate[] pts = new Coordinate[this.nPts()];
        int iPt = 0;
        for (int i = 0; i < this.nPts(); ++i) {
            double ang = startAng + (double)i * angInc;
            double x = xRadius * Math.cos(ang) + centreX;
            double y = yRadius * Math.sin(ang) + centreY;
            pts[++iPt - 1] = this.coord(x, y);
        }
        LineString line = this.geomFact().createLineString(pts);
        return (LineString)this.rotate(line);
    }

    public Polygon createArcPolygon(double startAng, double angExtent) {
        Envelope env = this.dim().getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        double angSize = angExtent;
        if (angSize <= 0.0 || angSize > Math.PI * 2) {
            angSize = Math.PI * 2;
        }
        double angInc = angSize / (double)(this.nPts() - 1);
        Coordinate[] pts = new Coordinate[this.nPts() + 2];
        int iPt = 0;
        pts[++iPt - 1] = this.coord(centreX, centreY);
        for (int i = 0; i < this.nPts(); ++i) {
            double ang = startAng + angInc * (double)i;
            double x = xRadius * Math.cos(ang) + centreX;
            double y = yRadius * Math.sin(ang) + centreY;
            pts[++iPt - 1] = this.coord(x, y);
        }
        pts[++iPt - 1] = this.coord(centreX, centreY);
        LinearRing ring = this.geomFact().createLinearRing(pts);
        Polygon poly = this.geomFact().createPolygon(ring);
        return (Polygon)this.rotate(poly);
    }

    public Coordinate coord(double x, double y) {
        Coordinate pt = new Coordinate(x, y);
        this.precModel().makePrecise(pt);
        return pt;
    }

    public Coordinate coordTrans(double x, double y, Coordinate trans) {
        return this.coord(x + trans.x(), y + trans.y());
    }

    public GeometricShapeFactory(GeometryFactory geomFact) {
        this.geomFact = geomFact;
        this.precModel = this.geomFact().getPrecisionModel();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.dim = new Dimensions();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.nPts = 100;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.rotationAngle = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    public GeometricShapeFactory() {
        this(new GeometryFactory());
    }

    public static class Dimensions {
        private Coordinate base = null;
        private Coordinate centre = null;
        private double width = 0.0;
        private double height = 0.0;
        private volatile byte bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);

        public Coordinate base() {
            if ((byte)(this.bitmap$init$0 & 1) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/util/GeometricShapeFactory.scala: 54");
            }
            return this.base;
        }

        public void base_$eq(Coordinate x$1) {
            this.base = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        }

        public Coordinate centre() {
            if ((byte)(this.bitmap$init$0 & 2) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/util/GeometricShapeFactory.scala: 55");
            }
            return this.centre;
        }

        public void centre_$eq(Coordinate x$1) {
            this.centre = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        }

        public double width() {
            if ((byte)(this.bitmap$init$0 & 4) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/util/GeometricShapeFactory.scala: 56");
            }
            return this.width;
        }

        public void width_$eq(double x$1) {
            this.width = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        }

        public double height() {
            if ((byte)(this.bitmap$init$0 & 8) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/util/GeometricShapeFactory.scala: 57");
            }
            return this.height;
        }

        public void height_$eq(double x$1) {
            this.height = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        }

        public void setBase(Coordinate base) {
            this.base_$eq(base);
        }

        public Coordinate getBase() {
            return this.base();
        }

        public void setCentre(Coordinate centre) {
            this.centre_$eq(centre);
        }

        public Coordinate getCentre() {
            block0: {
                if (this.centre() != null) break block0;
                this.centre_$eq(new Coordinate(this.base().x() + this.width() / (double)2, this.base().y() + this.height() / (double)2));
            }
            return this.centre();
        }

        public void setSize(double size) {
            this.height_$eq(size);
            this.width_$eq(size);
        }

        public double getMinSize() {
            return Math.min(this.width(), this.height());
        }

        public void setWidth(double width) {
            this.width_$eq(width);
        }

        public double getWidth() {
            return this.width();
        }

        public double getHeight() {
            return this.height();
        }

        public void setHeight(double height) {
            this.height_$eq(height);
        }

        public void setEnvelope(Envelope env) {
            this.width_$eq(env.getWidth());
            this.height_$eq(env.getHeight());
            this.base_$eq(new Coordinate(env.getMinX(), env.getMinY()));
            this.centre_$eq(new Coordinate(env.centre()));
        }

        public Envelope getEnvelope() {
            if (this.base() != null) {
                return new Envelope(this.base().x(), this.base().x() + this.width(), this.base().y(), this.base().y() + this.height());
            }
            if (this.centre() != null) {
                return new Envelope(this.centre().x() - this.width() / (double)2, this.centre().x() + this.width() / (double)2, this.centre().y() - this.height() / (double)2, this.centre().y() + this.height() / (double)2);
            }
            return new Envelope(0.0, this.width(), 0.0, this.height());
        }
    }
}

