/*
 * Decompiled with CFR 0.152.
 */
package ec.app.klandscapes;

import ec.EvolutionState;
import ec.Individual;
import ec.app.klandscapes.func.KLandscapeTree;
import ec.gp.GPIndividual;
import ec.gp.GPNode;
import ec.gp.GPProblem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;

public class KLandscapes
extends GPProblem
implements SimpleProblemForm {
    double[] nodeScore;
    double[][] edgeScore;
    double bestFitness;
    int k;
    String P_PROBLEMNAME = "k-landscapes";
    String P_KVALUE = "k-value";
    int[] indices = new int[256];

    public void setup(EvolutionState state, Parameter base) {
        int i;
        super.setup(state, base);
        state.output.exitIfErrors();
        Parameter kval = new Parameter("eval").push("problem").push(this.P_PROBLEMNAME).push(this.P_KVALUE);
        this.k = state.parameters.getInt(kval, null, 0);
        for (int i2 = 0; i2 < this.indices.length; ++i2) {
            this.indices[i2] = -1;
        }
        this.indices[0] = 0;
        this.indices[1] = 1;
        this.indices[23] = 2;
        this.indices[24] = 3;
        this.indices[25] = 4;
        this.indices[22] = 5;
        MersenneTwisterFast r = state.random[0];
        this.nodeScore = new double[6];
        this.edgeScore = new double[2][6];
        for (int i3 = 0; i3 < 6; ++i3) {
            this.nodeScore[i3] = 2.0 * r.nextDouble() - 1.0;
        }
        boolean ok = false;
        for (i = 2; i < 6; ++i) {
            if (!(this.nodeScore[i] > 0.0)) continue;
            ok = true;
        }
        if (!ok) {
            this.nodeScore[2] = r.nextDouble();
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.edgeScore[i][j] = r.nextDouble();
            }
        }
        this.bestFitness = this.computeBestFitness();
    }

    int getIndex(char c) {
        return this.indices[c - 65];
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            double score = this.fitness(((GPIndividual)ind).trees[0].child);
            SimpleFitness f = (SimpleFitness)ind.fitness;
            f.setFitness(state, score, score == 1.0);
            ind.evaluated = true;
        }
    }

    double fitness(GPNode root) {
        double penalty = 1.0 / (double)(1 + Math.abs(this.k + 1 - root.depth()));
        return penalty * this.fitnessHelper(root) / this.bestFitness;
    }

    double fitnessHelper(GPNode node) {
        double max = this.subtreeFitness(node, this.k);
        for (int i = 0; i < node.children.length; ++i) {
            GPNode child = node.children[i];
            double tmp = this.fitnessHelper(child);
            if (!(tmp > max)) continue;
            max = tmp;
        }
        return max;
    }

    double subtreeFitness(GPNode node, int depth) {
        int index = this.getIndex(((KLandscapeTree)node).value());
        double score = this.nodeScore[index];
        if (depth == 0 || index > 1) {
            return score;
        }
        for (int i = 0; i < node.children.length; ++i) {
            GPNode child = node.children[i];
            int childindex = this.getIndex(((KLandscapeTree)child).value());
            score += (1.0 + this.edgeScore[index][childindex]) * this.subtreeFitness(child, depth - 1);
        }
        return score;
    }

    double computeBestFitness() {
        int i;
        double tmp;
        int h;
        double max;
        int j;
        int i2;
        double[][] ttable = new double[this.k][2];
        double[][] ftable = new double[this.k + 1][2];
        for (i2 = 0; i2 < 2; ++i2) {
            ftable[0][i2] = this.nodeScore[i2];
        }
        for (i2 = 0; i2 < this.k; ++i2) {
            for (j = 0; j < 2; ++j) {
                if (i2 == 0) {
                    max = (1.0 + this.edgeScore[j][2]) * this.nodeScore[2];
                    for (h = 3; h < 6; ++h) {
                        tmp = (1.0 + this.edgeScore[j][h]) * this.nodeScore[h];
                        if (!(tmp > max)) continue;
                        max = tmp;
                    }
                    ttable[i2][j] = this.nodeScore[j] + 2.0 * max;
                    continue;
                }
                max = (1.0 + this.edgeScore[j][0]) * ttable[i2 - 1][0];
                for (h = 1; h < 2; ++h) {
                    tmp = (1.0 + this.edgeScore[j][h]) * ttable[i2 - 1][h];
                    if (!(tmp > max)) continue;
                    max = tmp;
                }
                ttable[i2][j] = this.nodeScore[j] + 2.0 * max;
            }
        }
        for (i2 = 1; i2 < this.k + 1; ++i2) {
            for (j = 0; j < 2; ++j) {
                max = (1.0 + this.edgeScore[j][0]) * ftable[i2 - 1][0];
                for (h = 1; h < 2; ++h) {
                    tmp = (1.0 + this.edgeScore[j][h]) * ftable[i2 - 1][h];
                    if (!(tmp > max)) continue;
                    max = tmp;
                }
                ftable[i2][j] = this.nodeScore[j] + 2.0 * max;
            }
        }
        double best = this.nodeScore[2];
        for (i = 3; i < 6; ++i) {
            if (!(this.nodeScore[i] > best)) continue;
            best = this.nodeScore[i];
        }
        for (i = 0; i < this.k; ++i) {
            for (int j2 = 0; j2 < 2; ++j2) {
                if (!(ttable[i][j2] > best)) continue;
                best = ttable[i][j2];
            }
        }
        for (i = 0; i < 2; ++i) {
            if (!(0.5 * ftable[this.k][i] > best)) continue;
            best = 0.5 * ftable[this.k][i];
        }
        return best;
    }

    public Object clone() {
        KLandscapes tmp = (KLandscapes)super.clone();
        tmp.nodeScore = new double[6];
        tmp.edgeScore = new double[2][6];
        tmp.bestFitness = this.bestFitness;
        tmp.k = this.k;
        for (int i = 0; i < 6; ++i) {
            tmp.nodeScore[i] = this.nodeScore[i];
            for (int j = 0; j < 2; ++j) {
                tmp.edgeScore[j][i] = this.edgeScore[j][i];
            }
        }
        return tmp;
    }
}

