/*
 * Decompiled with CFR 0.152.
 */
package ec.app.majority;

import ec.EvolutionState;
import ec.util.MersenneTwisterFast;
import java.io.Serializable;

public class CA
implements Serializable {
    private static final long serialVersionUID = 1L;
    int[] ca;
    int[] ca2;
    int[] rule;
    int neighborhood;

    public CA(int width, int neighborhood) {
        this.ca = new int[width];
        this.ca2 = new int[width];
        this.neighborhood = neighborhood;
        this.rule = new int[1 << neighborhood];
    }

    public int[] getVals() {
        return this.ca;
    }

    public int[] getRule() {
        return this.rule;
    }

    public void setRule(int[] r) {
        if (r.length != this.rule.length) {
            throw new RuntimeException("Rule length invalid given neighborhood size.");
        }
        this.rule = r;
    }

    public void setVals(int[] vals) {
        if (vals.length != this.ca.length) {
            throw new RuntimeException("CA length invalid given prespecified size.");
        }
        this.ca = (int[])vals.clone();
    }

    public void clear(boolean toOnes) {
        if (toOnes) {
            for (int i = 0; i < this.ca.length; ++i) {
                this.ca[i] = 1;
            }
        } else {
            for (int i = 0; i < this.ca.length; ++i) {
                this.ca[i] = 0;
            }
        }
    }

    public final boolean converged() {
        int t = this.ca[0];
        for (int i = 1; i < this.ca.length; ++i) {
            if (this.ca[i] == t) continue;
            return false;
        }
        return true;
    }

    public void randomize(EvolutionState state, int thread) {
        MersenneTwisterFast random = state.random[thread];
        for (int i = 0; i < this.ca.length; ++i) {
            this.ca[i] = random.nextBoolean() ? 0 : 1;
        }
    }

    public void step(int steps, boolean stopWhenConverged) {
        int len = this.ca.length;
        int halfhood = this.neighborhood / 2;
        int mask = (1 << this.neighborhood) - 1;
        for (int q = 0; q < steps; ++q) {
            int i;
            int state = 0;
            for (i = len - halfhood; i < len; ++i) {
                state = state << 1 | this.ca[i];
            }
            for (i = 0; i < halfhood + 1; ++i) {
                state = state << 1 | this.ca[i];
            }
            for (i = 0; i < len - halfhood - 1; ++i) {
                this.ca2[i] = this.rule[state];
                state = (state << 1 | this.ca[i + halfhood + 1]) & mask;
            }
            int j = 0;
            for (int i2 = len - halfhood - 1; i2 < len; ++i2) {
                this.ca2[i2] = this.rule[state];
                state = (state << 1 | this.ca[j++]) & mask;
            }
            int[] tmp = this.ca;
            this.ca = this.ca2;
            this.ca2 = tmp;
            if (!stopWhenConverged || !this.converged()) continue;
            return;
        }
    }
}

