/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.breed.BreedDefaults;
import ec.util.Parameter;

public class CheckingPipeline
extends BreedingPipeline {
    public static final String P_CHECK = "check";
    public static final String P_NUMTIMES = "num-times";
    public static final int NUM_SOURCES = 2;
    int numTimes = 0;

    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_CHECK);
    }

    public int numSources() {
        return 2;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.numTimes = state.parameters.getInt(base.push(P_NUMTIMES), def.push(P_NUMTIMES), 1);
        if (this.numTimes < 1) {
            state.output.fatal("CheckingPipeline must have a num-times value >= 1.", base.push(P_NUMTIMES), def.push(P_NUMTIMES));
        }
        if (this.likelihood != 1.0) {
            state.output.warning("CheckingPipeline given a likelihood other than 1.0.  This is nonsensical and will be ignored.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    public boolean allValid(Individual[] inds, int numInds, int subpopulation, EvolutionState state, int thread) {
        return true;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        Individual[] inds2 = new Individual[max];
        for (int i = 0; i < this.numTimes; ++i) {
            int n = this.sources[0].produce(min, max, 0, subpopulation, inds2, state, thread);
            if (!this.allValid(inds2, n, subpopulation, state, thread)) continue;
            System.arraycopy(inds2, 0, inds, start, n);
            if (this.sources[0] instanceof SelectionMethod) {
                for (int q = start; q < n + start; ++q) {
                    inds[q] = (Individual)inds[q].clone();
                }
            }
            return n;
        }
        int n = this.sources[1].produce(min, max, start, subpopulation, inds, state, thread);
        if (this.sources[0] instanceof SelectionMethod) {
            for (int q = start; q < n + start; ++q) {
                inds[q] = (Individual)inds[q].clone();
            }
        }
        return n;
    }
}

