/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.Species;
import ec.breed.BreedDefaults;
import ec.util.Parameter;

public class InitializationPipeline
extends BreedingPipeline {
    public static final String P_INIT = "init";
    public static final int NUM_SOURCES = 0;

    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_INIT);
    }

    public int numSources() {
        return 0;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (this.likelihood != 1.0) {
            state.output.warning("InitializationPipeline given a likelihood other than 1.0.  This is nonsensical and will be ignored.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        Species s = state.population.subpops[subpopulation].species;
        for (int q = start; q < start + max; ++q) {
            inds[q] = s.newIndividual(state, thread);
        }
        return max;
    }
}

