/*
 * Decompiled with CFR 0.152.
 */
package ec.eval;

import ec.EvolutionState;
import ec.Evolve;
import ec.Fitness;
import ec.Individual;
import ec.Problem;
import ec.simple.SimpleProblemForm;
import ec.simple.SimpleShortStatistics;
import ec.simple.SimpleStatistics;
import ec.util.DataPipe;
import ec.util.MersenneTwisterFast;
import ec.util.Output;
import ec.util.Parameter;
import ec.util.ParameterDatabase;
import ec.vector.DoubleVectorIndividual;
import ec.vector.FloatVectorSpecies;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class MetaProblem
extends Problem
implements SimpleProblemForm {
    public static final String P_FILE = "file";
    public static final String P_RUNS = "runs";
    public static final String P_REEVALUATE_INDIVIDUALS = "reevaluate";
    public static final String P_NUM_PARAMS = "num-params";
    public static final String P_PARAM = "param";
    public static final String P_TYPE = "type";
    public static final String V_INTEGER = "integer";
    public static final String V_BOOLEAN = "boolean";
    public static final String V_FLOAT = "float";
    public static final String P_NUM_VALS = "num-vals";
    public static final String P_VAL = "val";
    public static final String P_MUZZLE = "muzzle";
    public static final String P_SET_RANDOM = "set-random";
    public Parameter base;
    public ParameterDatabase p_database;
    public ParameterDatabase currentDatabase;
    public int runs;
    public boolean reevaluateIndividuals;
    public Individual[] bestUnderlyingIndividual;
    public Object lock = new Object[0];
    public Object[] domain;
    boolean setRandom;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.base = base;
        File file = state.parameters.getFile(base.push(P_FILE), null);
        try {
            this.p_database = new ParameterDatabase(file, new String[]{"-file", file.getCanonicalPath()});
        }
        catch (IOException e) {
            state.output.fatal("Exception loading meta-parameter-database:\n" + e, base.push(P_FILE));
        }
        this.runs = state.parameters.getInt(base.push(P_RUNS), null, 1);
        if (this.runs < 1) {
            state.output.fatal("Number of runs must be >= 1", base.push(P_RUNS));
        }
        this.reevaluateIndividuals = state.parameters.getBoolean(base.push(P_REEVALUATE_INDIVIDUALS), null, true);
        if (state.parameters.exists(base.push(P_MUZZLE), null)) {
            state.output.warning("" + base.push(P_MUZZLE) + " no longer exists.  Use 'silent' in the lower-level EA parameters instead.");
        }
        Parameter pop = new Parameter("pop");
        int subpopsLength = state.parameters.getInt(pop.push("subpops"), null, 1);
        this.bestUnderlyingIndividual = new Individual[subpopsLength];
        this.setRandom = state.parameters.getBoolean(base.push(P_SET_RANDOM), null, false);
        this.loadDomain(state, base);
    }

    protected void loadDomain(EvolutionState state, Parameter base) {
        Parameter p;
        int numParams = state.parameters.getInt(base.push(P_NUM_PARAMS), null, 1);
        if (numParams < 1) {
            state.output.fatal("Number of parameters must be >= 1", base.push(P_NUM_PARAMS));
        }
        this.domain = new Object[numParams];
        Parameter pb = base.push(P_PARAM);
        for (int i = 0; i < numParams && state.parameters.exists(p = pb.push("" + i), null); ++i) {
            if (state.parameters.exists(p.push(P_TYPE), null)) {
                String type = state.parameters.getString(p.push(P_TYPE), null);
                if (type.equalsIgnoreCase(V_INTEGER)) {
                    this.domain[i] = new int[0];
                } else if (type.equalsIgnoreCase(V_FLOAT)) {
                    this.domain[i] = new double[0];
                } else if (type.equalsIgnoreCase(V_BOOLEAN)) {
                    this.domain[i] = new boolean[0];
                } else {
                    state.output.fatal("Meta parameter number " + i + " has a malformed type declaration.", p.push(P_TYPE), null);
                }
                if (!state.parameters.exists(p.push(P_NUM_VALS), null)) continue;
                state.output.fatal("Meta parameter number " + i + " has both a type declaration and a num-vals declaration.", p.push(P_TYPE), p.push(P_NUM_VALS));
                continue;
            }
            if (state.parameters.exists(p.push(P_NUM_VALS), null)) {
                int len = state.parameters.getInt(p.push(P_NUM_VALS), null, 1);
                if (len > 0) {
                    String[] tags = new String[len];
                    for (int j = 0; j < len; ++j) {
                        tags[j] = state.parameters.getString(p.push(P_VAL).push("" + j), null);
                        if (tags[j] != null) continue;
                        state.output.fatal("Meta parameter number " + i + " is missing value number " + j + ".", p.push(P_VAL).push("" + j));
                    }
                    this.domain[i] = tags;
                    continue;
                }
                state.output.fatal("Meta parameter number " + i + " has a malformed domain.", p.push(P_NUM_VALS));
                continue;
            }
            state.output.fatal("Meta parameter number " + i + " has no type declaration or num-vals declaration.", p.push(P_TYPE), p.push(P_NUM_VALS));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String map(EvolutionState state, double[] genome, FloatVectorSpecies species, int index) {
        if (index < 0 || index >= this.domain.length) {
            state.output.fatal("No domain provided for meta parameter number " + index + ".");
        }
        Object d = this.domain[index];
        double min = species.minGene(index);
        double max = species.maxGene(index);
        double gene = genome[index];
        if (d instanceof boolean[]) {
            if (!(gene < min) && !(gene > max)) {
                if (!(gene < (min + max) / 2.0)) return "true";
                return "false";
            }
            state.output.fatal("Gene index " + index + " has a value (" + gene + ") outside the min-max range (from " + min + " to " + max + " inclusive).  Did you forget to bound the mutation?");
            return null;
        }
        if (d instanceof int[]) {
            return "" + (int)Math.floor(gene);
        }
        if (d instanceof double[]) {
            return "" + gene;
        }
        if (!(d instanceof String[])) {
            state.output.fatal("INTERNAL ERROR.  Invalid mapping for domain of meta parameter number " + index + " in MetaProblem.");
            return null;
        }
        String[] dom = (String[])d;
        if (min != 0.0) {
            state.output.fatal("Invalid min-gene value (" + min + ") for a string type in MetaProblem.  Gene index was " + index + ".  Should have been 0.");
            return null;
        }
        if (max != (double)(dom.length - 1)) {
            state.output.fatal("Invalid max-gene value (" + max + ") for a string type in MetaProblem.  Gene index was " + index + ".  Should have been " + (dom.length - 1) + ", that is, the number of vals - 1.");
            return null;
        }
        if (!(gene < min)) {
            if (!(gene > max)) return dom[(int)Math.floor(gene)];
        }
        state.output.fatal("Gene index " + index + " has a value (" + gene + ") outside the min-max range (from " + min + " to " + max + " inclusive).  Did you forget to bound the mutation?");
        return null;
    }

    public void modifyParameters(EvolutionState state, ParameterDatabase database, int run, Individual metaIndividual) {
        if (!(metaIndividual instanceof DoubleVectorIndividual)) {
            state.output.fatal("Meta-individual is not a DoubleVectorIndividual.");
        }
        DoubleVectorIndividual individual = (DoubleVectorIndividual)metaIndividual;
        FloatVectorSpecies species = (FloatVectorSpecies)individual.species;
        double[] genome = individual.genome;
        Parameter pb = this.base.push(P_PARAM);
        for (int i = 0; i < genome.length; ++i) {
            Parameter p = pb.push("" + i);
            String param = state.parameters.getString(p, null);
            if (param == null) {
                state.output.fatal("Meta parameter number " + i + " missing.", p);
            }
            database.set(new Parameter(param), "" + this.map(state, genome, species, i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (ind.evaluated && !this.reevaluateIndividuals) {
            return;
        }
        ArrayList<Fitness> fits = new ArrayList<Fitness>();
        Individual bestOfRuns = null;
        for (int run = 0; run < this.runs; ++run) {
            try {
                this.currentDatabase = (ParameterDatabase)DataPipe.copy(this.p_database);
            }
            catch (Exception e) {
                state.output.fatal("Exception copying database.\n" + e);
            }
            this.modifyParameters(state, this.currentDatabase, run, ind);
            Output out = new Output(false);
            out.addLog(0, false);
            out.addLog(1, true);
            out.setThrowsErrors(true);
            EvolutionState evaluatedState = null;
            try {
                evaluatedState = Evolve.initialize(this.currentDatabase, 0, out);
                if (this.setRandom) {
                    for (int i = 0; i < evaluatedState.random.length; ++i) {
                        int seed = state.random[threadnum].nextInt();
                        evaluatedState.random[i] = Evolve.primeGenerator(new MersenneTwisterFast(seed));
                    }
                }
                evaluatedState.run(0);
                if (evaluatedState.population.subpops.length > 1) {
                    state.output.warnOnce("MetaProblem used, but underlying evolution state has more than one subpopulation: only the results from subpopulation 0 will be considered.");
                }
                Individual[] inds = null;
                if (evaluatedState.statistics != null && (evaluatedState.statistics instanceof SimpleStatistics || evaluatedState.statistics instanceof SimpleShortStatistics)) {
                    inds = null;
                    inds = evaluatedState.statistics instanceof SimpleStatistics ? ((SimpleStatistics)evaluatedState.statistics).getBestSoFar() : ((SimpleShortStatistics)evaluatedState.statistics).getBestSoFar();
                    if (inds == null) {
                        state.output.fatal("Underlying evolution state has a Statistics object which provides a null best-so-far array.  Can't extract fitness.");
                    }
                    fits.add(inds[0].fitness);
                } else if (evaluatedState.statistics == null) {
                    state.output.fatal("Underlying evolution state has a null Statistics object.  Can't extract fitness.");
                } else {
                    state.output.fatal("Underlying evolution state has a Statistics object which doesn't implement ProvidesBestSoFar.  Can't extract fitness.");
                }
                if (evaluatedState.evaluator.p_problem instanceof MetaProblem) {
                    MetaProblem mp = (MetaProblem)evaluatedState.evaluator.p_problem;
                    Object object = mp.lock;
                    synchronized (object) {
                        Individual bestind = mp.bestUnderlyingIndividual[0];
                        if (bestOfRuns == null || bestind.fitness.betterThan(bestOfRuns.fitness)) {
                            bestOfRuns = (Individual)bestind.clone();
                        }
                    }
                } else if (bestOfRuns == null || inds[0].fitness.betterThan(bestOfRuns.fitness)) {
                    bestOfRuns = (Individual)inds[0].clone();
                }
                Evolve.cleanup(evaluatedState);
                continue;
            }
            catch (Output.OutputExitException e) {
                state.output.warning("Error occurred in underlying evolutionary run.  NOTE: multiple threads may still be running:\n" + e.getMessage());
                continue;
            }
            catch (OutOfMemoryError e) {
                evaluatedState = null;
                System.gc();
                state.output.warning("An Out of Memory error occurred in underlying evolutionary run.  Attempting to recover and reset.  NOTE: multiple threads may still be running:\n" + e.getMessage());
            }
        }
        Fitness[] fits2 = new Fitness[fits.size()];
        for (int i = 0; i < fits2.length; ++i) {
            fits2[i] = (Fitness)fits.get(i);
        }
        this.combine(state, fits2, ind.fitness);
        ind.evaluated = true;
        Object object = this.lock;
        synchronized (object) {
            if (bestOfRuns != null && (this.bestUnderlyingIndividual[subpopulation] == null || bestOfRuns.fitness.betterThan(this.bestUnderlyingIndividual[subpopulation].fitness))) {
                this.bestUnderlyingIndividual[subpopulation] = bestOfRuns;
            }
        }
    }

    public void combine(EvolutionState state, Fitness[] runs, Fitness finalFitness) {
        finalFitness.setToMeanOf(state, runs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void describe(EvolutionState state, Individual ind, int subpopulation, int threadnum, int log) {
        state.output.println("\nParameters:", log);
        if (!(ind instanceof DoubleVectorIndividual)) {
            state.output.fatal("Meta-individual is not a DoubleVectorIndividual.");
        }
        DoubleVectorIndividual individual = (DoubleVectorIndividual)ind;
        FloatVectorSpecies species = (FloatVectorSpecies)individual.species;
        double[] genome = individual.genome;
        Parameter pb = this.base.push(P_PARAM);
        for (int i = 0; i < genome.length; ++i) {
            Parameter p = pb.push("" + i);
            String param = state.parameters.getString(p, null);
            if (param == null) {
                state.output.fatal("Meta parameter number " + i + " missing.", p);
            }
            state.output.println("" + param + " = " + this.map(state, genome, species, i), log);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.bestUnderlyingIndividual[subpopulation] != null) {
                state.output.println("\nUnderlying Individual:", log);
                this.bestUnderlyingIndividual[subpopulation].printIndividualForHumans(state, log);
            }
        }
    }
}

