/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.EvolutionState;
import ec.Prototype;
import ec.gp.ADFContext;
import ec.gp.GPDefaults;
import ec.util.Parameter;

public class ADFStack
implements Prototype {
    private static final long serialVersionUID = 1L;
    public static final String P_ADFSTACK = "adf-stack";
    public static final String P_ADF = "adf";
    public static final String P_CONTEXT = "context";
    public ADFContext context_proto;
    public static final int INITIAL_STACK_SIZE = 2;
    protected int onStack = 0;
    protected int onSubstack = 0;
    protected int inReserve = 0;
    protected ADFContext[] stack = new ADFContext[2];
    protected ADFContext[] substack = new ADFContext[2];
    protected ADFContext[] reserve = new ADFContext[2];

    public Parameter defaultBase() {
        return GPDefaults.base().push(P_ADFSTACK);
    }

    public void setup(EvolutionState state, Parameter base) {
        Parameter p = base.push(P_CONTEXT);
        Parameter d = this.defaultBase().push(P_CONTEXT);
        this.context_proto = (ADFContext)state.parameters.getInstanceForParameterEq(p, d, ADFContext.class);
        this.context_proto.setup(state, p);
    }

    public Object clone() {
        try {
            int x;
            ADFStack myobj = (ADFStack)super.clone();
            myobj.context_proto = (ADFContext)this.context_proto.clone();
            myobj.stack = (ADFContext[])this.stack.clone();
            myobj.substack = (ADFContext[])this.substack.clone();
            myobj.reserve = (ADFContext[])this.reserve.clone();
            for (x = 0; x < this.onStack; ++x) {
                myobj.stack[x] = (ADFContext)this.stack[x].clone();
            }
            for (x = 0; x < this.onSubstack; ++x) {
                myobj.substack[x] = (ADFContext)this.substack[x].clone();
            }
            for (x = 0; x < this.inReserve; ++x) {
                myobj.reserve[x] = (ADFContext)this.reserve[x].clone();
            }
            return myobj;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final ADFContext get() {
        ADFContext obj = this.inReserve > 0 ? this.reserve[--this.inReserve] : (ADFContext)this.context_proto.clone();
        return obj;
    }

    public final ADFContext push(ADFContext obj) {
        if (this.onStack == this.stack.length) {
            ADFContext[] newstack = new ADFContext[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newstack, 0, this.stack.length);
            this.stack = newstack;
        }
        this.stack[this.onStack++] = obj;
        return obj;
    }

    public final int pop(int n) {
        int x;
        for (x = 0; x < n && this.onStack != 0; ++x) {
            ADFContext obj = this.stack[--this.onStack];
            if (this.inReserve == this.reserve.length) {
                ADFContext[] newreserve = new ADFContext[this.reserve.length * 2];
                System.arraycopy(this.reserve, 0, newreserve, 0, this.reserve.length);
                this.reserve = newreserve;
            }
            this.reserve[this.inReserve++] = obj;
        }
        return x;
    }

    public final ADFContext top(int n) {
        if (this.onStack - n <= 0) {
            return null;
        }
        return this.stack[this.onStack - n - 1];
    }

    public final int moveOntoSubstack(int n) {
        int x;
        for (x = 0; x < n && this.onStack != 0; ++x) {
            ADFContext obj = this.stack[--this.onStack];
            if (this.onSubstack == this.substack.length) {
                ADFContext[] newsubstack = new ADFContext[this.substack.length * 2];
                System.arraycopy(this.substack, 0, newsubstack, 0, this.substack.length);
                this.substack = newsubstack;
            }
            this.substack[this.onSubstack++] = obj;
        }
        return x;
    }

    public final int moveFromSubstack(int n) {
        int x;
        for (x = 0; x < n && this.onSubstack != 0; ++x) {
            ADFContext obj = this.substack[--this.onSubstack];
            if (this.onStack == this.stack.length) {
                ADFContext[] newstack = new ADFContext[this.stack.length * 2];
                System.arraycopy(this.stack, 0, newstack, 0, this.stack.length);
                this.stack = newstack;
            }
            this.stack[this.onStack++] = obj;
        }
        return x;
    }

    public final void reset() {
        if (this.onSubstack > 0) {
            this.moveFromSubstack(this.onSubstack);
        }
        if (this.onStack > 0) {
            this.pop(this.onStack);
        }
    }
}

