/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.Clique;
import ec.EvolutionState;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPType;
import ec.util.Parameter;

public class GPNodeConstraints
implements Clique {
    public static final int SIZE_OF_BYTE = 256;
    public static final String P_NAME = "name";
    public static final String P_RETURNS = "returns";
    public static final String P_CHILD = "child";
    public static final String P_SIZE = "size";
    public static final String P_PROBABILITY = "prob";
    public static final double DEFAULT_PROBABILITY = 1.0;
    public double probabilityOfSelection;
    public byte constraintNumber;
    public GPType returntype;
    public GPType[] childtypes;
    public String name;
    public GPNode[] zeroChildren = new GPNode[0];

    public String toString() {
        return this.name;
    }

    public void setup(EvolutionState state, Parameter base) {
        String s;
        GPNodeConstraints old_constraints;
        this.name = state.parameters.getString(base.push(P_NAME), null);
        if (this.name == null) {
            state.output.fatal("No name was given for this node constraints.", base.push(P_NAME));
        }
        if ((old_constraints = ((GPInitializer)state.initializer).nodeConstraintRepository.put(this.name, this)) != null) {
            state.output.fatal("The GP node constraint \"" + this.name + "\" has been defined multiple times.", base.push(P_NAME));
        }
        if ((s = state.parameters.getString(base.push(P_RETURNS), null)) == null) {
            state.output.fatal("No return type given for the GPNodeConstraints " + this.name, base.push(P_RETURNS));
        }
        this.returntype = GPType.typeFor(s, state);
        if (state.parameters.exists(base.push(P_PROBABILITY), null)) {
            double f = state.parameters.getDouble(base.push(P_PROBABILITY), null, 0.0);
            if (f < 0.0) {
                state.output.fatal("The probability of selection is < 0, which is not valid.", base.push(P_PROBABILITY), null);
            }
            this.probabilityOfSelection = f;
        } else {
            this.probabilityOfSelection = 1.0;
        }
        int x = state.parameters.getInt(base.push(P_SIZE), null, 0);
        if (x < 0) {
            state.output.fatal("The number of children types for the GPNodeConstraints " + this.name + " must be >= 0.", base.push(P_SIZE));
        }
        this.childtypes = new GPType[x];
        Parameter p = base.push(P_CHILD);
        for (x = 0; x < this.childtypes.length; ++x) {
            s = state.parameters.getString(p.push("" + x), null);
            if (s == null) {
                state.output.fatal("Type #" + x + " is not defined for the GPNodeConstraints " + this.name + ".", base.push("" + x));
            }
            this.childtypes[x] = GPType.typeFor(s, state);
        }
        state.output.exitIfErrors();
    }

    public static GPNodeConstraints constraintsFor(String constraintsName, EvolutionState state) {
        GPNodeConstraints myConstraints = (GPNodeConstraints)((GPInitializer)state.initializer).nodeConstraintRepository.get(constraintsName);
        if (myConstraints == null) {
            state.output.error("The GP node constraint \"" + constraintsName + "\" could not be found.");
        }
        return myConstraints;
    }
}

