/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPBreedingPipeline;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeParent;
import ec.gp.GPNodeSelector;
import ec.gp.GPTree;
import ec.gp.breed.GPBreedDefaults;
import ec.util.Parameter;

public class InternalCrossoverPipeline
extends GPBreedingPipeline {
    private static final long serialVersionUID = 1L;
    public static final String P_INTERNALCROSSOVER = "internal-xover";
    public static final String P_NUM_TRIES = "tries";
    public static final String P_MAXDEPTH = "maxdepth";
    public static final int NUM_SOURCES = 1;
    public GPNodeSelector nodeselect0;
    public GPNodeSelector nodeselect1;
    public int numTries;
    public int maxDepth;
    public int tree1;
    public int tree2;

    public Parameter defaultBase() {
        return GPBreedDefaults.base().push(P_INTERNALCROSSOVER);
    }

    public int numSources() {
        return 1;
    }

    public Object clone() {
        InternalCrossoverPipeline c = (InternalCrossoverPipeline)super.clone();
        c.nodeselect0 = (GPNodeSelector)this.nodeselect0.clone();
        c.nodeselect1 = (GPNodeSelector)this.nodeselect1.clone();
        return c;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        Parameter p = base.push("ns").push("0");
        Parameter d = def.push("ns").push("0");
        this.nodeselect0 = (GPNodeSelector)state.parameters.getInstanceForParameter(p, d, GPNodeSelector.class);
        this.nodeselect0.setup(state, p);
        p = base.push("ns").push("1");
        d = def.push("ns").push("1");
        if (state.parameters.exists(p, d) && state.parameters.getString(p, d).equals("same")) {
            this.nodeselect1 = (GPNodeSelector)this.nodeselect0.clone();
        } else {
            this.nodeselect1 = (GPNodeSelector)state.parameters.getInstanceForParameter(p, d, GPNodeSelector.class);
            this.nodeselect1.setup(state, p);
        }
        this.numTries = state.parameters.getInt(base.push(P_NUM_TRIES), def.push(P_NUM_TRIES), 1);
        if (this.numTries == 0) {
            state.output.fatal("InternalCrossover Pipeline has an invalid number of tries (it must be >= 1).", base.push(P_NUM_TRIES), def.push(P_NUM_TRIES));
        }
        this.maxDepth = state.parameters.getInt(base.push(P_MAXDEPTH), def.push(P_MAXDEPTH), 1);
        if (this.maxDepth == 0) {
            state.output.fatal("InternalCrossover Pipeline has an invalid maximum depth (it must be >= 1).", base.push(P_MAXDEPTH), def.push(P_MAXDEPTH));
        }
        this.tree1 = -1;
        if (state.parameters.exists(base.push("tree").push("0"), def.push("tree").push("0"))) {
            this.tree1 = state.parameters.getInt(base.push("tree").push("0"), def.push("tree").push("0"), 0);
            if (this.tree1 == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
        this.tree2 = -1;
        if (state.parameters.exists(base.push("tree").push("1"), def.push("tree").push("1"))) {
            this.tree2 = state.parameters.getInt(base.push("tree").push("1"), def.push("tree").push("1"), 0);
            if (this.tree2 == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
    }

    private boolean noContainment(GPNode inner1, GPNode inner2) {
        GPNodeParent current = inner1;
        while (current != null && current instanceof GPNode) {
            if (current == inner2) {
                return false;
            }
            current = current.parent;
        }
        current = inner2;
        while (current != null && current instanceof GPNode) {
            if (current == inner1) {
                return false;
            }
            current = current.parent;
        }
        return true;
    }

    boolean verifyPoints(GPInitializer initializer, GPNode inner1, GPNode inner2) {
        if (!inner1.swapCompatibleWith(initializer, inner2)) {
            return false;
        }
        return inner1.depth() + inner2.atDepth() <= this.maxDepth;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.sources[0].produce(min, max, start, subpopulation, inds, state, thread);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, false);
        }
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int q = start; q < n + start; ++q) {
            GPIndividual j;
            GPIndividual i = (GPIndividual)inds[q];
            if (this.tree1 != -1 && (this.tree1 < 0 || this.tree1 >= i.trees.length)) {
                state.output.fatal("Internal Crossover Pipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            if (this.tree2 != -1 && (this.tree2 < 0 || this.tree2 >= i.trees.length)) {
                state.output.fatal("Internal Crossover Pipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            if (this.sources[0] instanceof BreedingPipeline) {
                j = i;
            } else {
                j = i.lightClone();
                j.trees = new GPTree[i.trees.length];
                for (int x = 0; x < j.trees.length; ++x) {
                    j.trees[x] = i.trees[x].lightClone();
                    j.trees[x].owner = j;
                    j.trees[x].child = (GPNode)i.trees[x].child.clone();
                    j.trees[x].child.parent = j.trees[x];
                    j.trees[x].child.argposition = 0;
                }
            }
            int t1 = 0;
            int t2 = 0;
            if (this.tree1 == -1 || this.tree2 == -1) {
                do {
                    t1 = this.tree1 == -1 ? (i.trees.length > 1 ? state.random[thread].nextInt(i.trees.length) : 0) : this.tree1;
                    if (this.tree2 == -1) {
                        if (i.trees.length > 1) {
                            t2 = state.random[thread].nextInt(i.trees.length);
                            continue;
                        }
                        t2 = 0;
                        continue;
                    }
                    t2 = this.tree2;
                } while (i.trees[t1].constraints(initializer) != i.trees[t2].constraints(initializer));
            } else {
                t1 = this.tree1;
                t2 = this.tree2;
                if (i.trees[t1].constraints(initializer) != i.trees[t2].constraints(initializer)) {
                    state.output.fatal("GP Crossover Pipeline's two tree choices are both specified by the user -- but their GPTreeConstraints are not the same");
                }
            }
            this.nodeselect0.reset();
            this.nodeselect1.reset();
            GPNode p1 = null;
            GPNode p2 = null;
            boolean res = false;
            for (int x = 0; x < this.numTries; ++x) {
                p1 = this.nodeselect0.pickNode(state, subpopulation, thread, j, j.trees[t1]);
                boolean bl = res = p1 != (p2 = this.nodeselect1.pickNode(state, subpopulation, thread, j, j.trees[t2])) && (t1 != t2 || this.noContainment(p1, p2)) && this.verifyPoints(initializer, p1, p2) && this.verifyPoints(initializer, p2, p1);
                if (res) break;
            }
            if (res) {
                GPNodeParent oldparent = p1.parent;
                byte oldargposition = p1.argposition;
                p1.parent = p2.parent;
                p1.argposition = p2.argposition;
                p2.parent = oldparent;
                p2.argposition = oldargposition;
                if (p1.parent instanceof GPNode) {
                    ((GPNode)p1.parent).children[p1.argposition] = p1;
                } else {
                    ((GPTree)p1.parent).child = p1;
                }
                if (p2.parent instanceof GPNode) {
                    ((GPNode)p2.parent).children[p2.argposition] = p2;
                } else {
                    ((GPTree)p2.parent).child = p2;
                }
                j.evaluated = false;
            }
            inds[q] = j;
        }
        return n;
    }
}

