/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPBreedingPipeline;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPTree;
import ec.gp.GPType;
import ec.gp.breed.GPBreedDefaults;
import ec.util.Parameter;

public class MutatePromotePipeline
extends GPBreedingPipeline {
    public static final String P_MUTATEPROMOTE = "mutate-promote";
    public static final String P_NUM_TRIES = "tries";
    public static final int NUM_SOURCES = 1;
    int tree;
    int numTries;
    private GPNode promotableNode;

    public Parameter defaultBase() {
        return GPBreedDefaults.base().push(P_MUTATEPROMOTE);
    }

    public int numSources() {
        return 1;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.numTries = state.parameters.getInt(base.push(P_NUM_TRIES), def.push(P_NUM_TRIES), 1);
        if (this.numTries == 0) {
            state.output.fatal("MutatePromotePipeline has an invalid number of tries (it must be >= 1).", base.push(P_NUM_TRIES), def.push(P_NUM_TRIES));
        }
        this.tree = -1;
        if (state.parameters.exists(base.push("tree").push("0"), def.push("tree").push("0"))) {
            this.tree = state.parameters.getInt(base.push("tree").push("0"), def.push("tree").push("0"), 0);
            if (this.tree == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
    }

    private boolean promotable(GPInitializer initializer, GPNode node) {
        if (!(node.parent instanceof GPNode)) {
            return false;
        }
        GPNode parent = (GPNode)node.parent;
        GPType t = parent.parent instanceof GPNode ? ((GPNode)parent.parent).constraints((GPInitializer)initializer).childtypes[parent.argposition] : ((GPTree)parent.parent).constraints((GPInitializer)initializer).treetype;
        return node.constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, t);
    }

    private void promoteSomething(GPNode node) {
        GPNode parent = (GPNode)node.parent;
        node.parent = parent.parent;
        node.argposition = parent.argposition;
        if (parent.parent instanceof GPNode) {
            ((GPNode)parent.parent).children[parent.argposition] = node;
        } else {
            ((GPTree)parent.parent).child = node;
        }
    }

    private int numPromotableNodes(GPInitializer initializer, GPNode root, int soFar) {
        if (this.promotable(initializer, root)) {
            ++soFar;
        }
        for (int x = 0; x < root.children.length; ++x) {
            soFar = this.numPromotableNodes(initializer, root.children[x], soFar);
        }
        return soFar;
    }

    private int pickPromotableNode(GPInitializer initializer, GPNode root, int num) {
        if (this.promotable(initializer, root) && --num == -1) {
            this.promotableNode = root;
            return num;
        }
        for (int x = 0; x < root.children.length && (num = this.pickPromotableNode(initializer, root.children[x], num)) != -1; ++x) {
        }
        return num;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.sources[0].produce(min, max, start, subpopulation, inds, state, thread);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, false);
        }
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int q = start; q < n + start; ++q) {
            int x;
            GPIndividual j;
            GPIndividual i = (GPIndividual)inds[q];
            if (this.tree != -1 && (this.tree < 0 || this.tree >= i.trees.length)) {
                state.output.fatal("MutatePromotePipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            if (this.sources[0] instanceof BreedingPipeline) {
                j = i;
            } else {
                j = i.lightClone();
                j.trees = new GPTree[i.trees.length];
                for (x = 0; x < j.trees.length; ++x) {
                    j.trees[x] = i.trees[x].lightClone();
                    j.trees[x].owner = j;
                    j.trees[x].child = (GPNode)i.trees[x].child.clone();
                    j.trees[x].child.parent = j.trees[x];
                    j.trees[x].child.argposition = 0;
                }
            }
            for (x = 0; x < this.numTries; ++x) {
                int t = this.tree == -1 ? (i.trees.length > 1 ? state.random[thread].nextInt(i.trees.length) : 0) : this.tree;
                int numpromote = this.numPromotableNodes(initializer, j.trees[t].child, 0);
                if (numpromote == 0) continue;
                this.pickPromotableNode(initializer, j.trees[t].child, state.random[thread].nextInt(numpromote));
                this.promoteSomething(this.promotableNode);
                j.evaluated = false;
                break;
            }
            inds[q] = j;
        }
        return n;
    }
}

