/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.koza;

import ec.EvolutionState;
import ec.Fitness;
import ec.gp.koza.GPKozaDefaults;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class KozaFitness
extends Fitness {
    public static final String P_KOZAFITNESS = "fitness";
    protected double standardizedFitness;
    public int hits;

    public Parameter defaultBase() {
        return GPKozaDefaults.base().push(P_KOZAFITNESS);
    }

    public void setFitness(EvolutionState state, double _f) {
        this.setStandardizedFitness(state, _f);
    }

    public void setStandardizedFitness(EvolutionState state, double _f) {
        if (_f < 0.0 || _f >= Double.POSITIVE_INFINITY || Double.isNaN(_f)) {
            state.output.warning("Bad fitness (may not be < 0, NaN, or infinity): " + _f + ", setting to 0.");
            this.standardizedFitness = 0.0;
        } else {
            this.standardizedFitness = _f;
        }
    }

    public double fitness() {
        return 1.0 / (1.0 + this.standardizedFitness);
    }

    public double rawFitness() {
        return this.standardizedFitness();
    }

    public double standardizedFitness() {
        return this.standardizedFitness;
    }

    public double adjustedFitness() {
        return this.fitness();
    }

    public void setup(EvolutionState state, Parameter base) {
    }

    public boolean isIdealFitness() {
        return this.standardizedFitness <= 0.0;
    }

    public boolean equivalentTo(Fitness _fitness) {
        return ((KozaFitness)_fitness).standardizedFitness() == this.standardizedFitness;
    }

    public boolean betterThan(Fitness _fitness) {
        return ((KozaFitness)_fitness).standardizedFitness() > this.standardizedFitness;
    }

    public String fitnessToString() {
        return "Fitness: " + Code.encode(this.standardizedFitness) + Code.encode(this.hits);
    }

    public String fitnessToStringForHumans() {
        return "Fitness: Standardized=" + this.standardizedFitness + " Adjusted=" + this.adjustedFitness() + " Hits=" + this.hits;
    }

    public void readFitness(EvolutionState state, LineNumberReader reader) throws IOException {
        DecodeReturn d = Code.checkPreamble("Fitness: ", state, reader);
        Code.decode(d);
        if (d.type != 7) {
            state.output.fatal("Reading Line " + d.lineNumber + ": " + "Bad Fitness.");
        }
        this.standardizedFitness = d.d;
        Code.decode(d);
        if (d.type != 4) {
            state.output.fatal("Reading Line " + d.lineNumber + ": " + "Bad Fitness.");
        }
        this.hits = (int)d.l;
    }

    public void writeFitness(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.standardizedFitness);
        dataOutput.writeInt(this.hits);
        this.writeTrials(state, dataOutput);
    }

    public void readFitness(EvolutionState state, DataInput dataInput) throws IOException {
        this.standardizedFitness = dataInput.readDouble();
        this.hits = dataInput.readInt();
        this.readTrials(state, dataInput);
    }

    public void setToMeanOf(EvolutionState state, Fitness[] fitnesses) {
        double f = 0.0;
        long h = 0L;
        for (int i = 0; i < fitnesses.length; ++i) {
            KozaFitness fit = (KozaFitness)fitnesses[i];
            f += fit.standardizedFitness;
            h += (long)fit.hits;
        }
        this.standardizedFitness = f /= (double)fitnesses.length;
        this.hits = (int)(h /= (long)fitnesses.length);
    }
}

