/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.nsga2;

import ec.EvolutionState;
import ec.Individual;
import ec.Subpopulation;
import ec.multiobjective.MultiObjectiveFitness;
import ec.multiobjective.nsga2.NSGA2Breeder;
import ec.multiobjective.nsga2.NSGA2MultiObjectiveFitness;
import ec.simple.SimpleEvaluator;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.SortComparator;
import java.util.ArrayList;

public class NSGA2Evaluator
extends SimpleEvaluator {
    public int[] originalPopSize;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter p = new Parameter("pop");
        int subpopsLength = state.parameters.getInt(p.push("subpops"), null, 1);
        this.originalPopSize = new int[subpopsLength];
        for (int i = 0; i < subpopsLength; ++i) {
            Parameter p_subpop = p.push("subpop").push("" + i).push("size");
            this.originalPopSize[i] = state.parameters.getInt(p_subpop, null, 1);
        }
    }

    public void evaluatePopulation(EvolutionState state) {
        super.evaluatePopulation(state);
        for (int x = 0; x < state.population.subpops.length; ++x) {
            state.population.subpops[x].individuals = this.buildArchive(state, x);
        }
    }

    public Individual[] buildArchive(EvolutionState state, int subpop) {
        Individual[] dummy = new Individual[]{};
        ArrayList ranks = this.assignFrontRanks(state.population.subpops[subpop]);
        ArrayList<Object> newSubpopulation = new ArrayList<Object>();
        int size = ranks.size();
        for (int i = 0; i < size; ++i) {
            Object[] rank = ((ArrayList)ranks.get(i)).toArray(dummy);
            this.assignSparsity((Individual[])rank);
            if (rank.length + newSubpopulation.size() >= this.originalPopSize[subpop]) {
                QuickSort.qsort(rank, new SortComparator(){

                    public boolean lt(Object a, Object b) {
                        Individual i1 = (Individual)a;
                        Individual i2 = (Individual)b;
                        return ((NSGA2MultiObjectiveFitness)i1.fitness).sparsity > ((NSGA2MultiObjectiveFitness)i2.fitness).sparsity;
                    }

                    public boolean gt(Object a, Object b) {
                        Individual i1 = (Individual)a;
                        Individual i2 = (Individual)b;
                        return ((NSGA2MultiObjectiveFitness)i1.fitness).sparsity < ((NSGA2MultiObjectiveFitness)i2.fitness).sparsity;
                    }
                });
                int m = this.originalPopSize[subpop] - newSubpopulation.size();
                for (int j = 0; j < m; ++j) {
                    newSubpopulation.add(rank[j]);
                }
                break;
            }
            for (int j = 0; j < rank.length; ++j) {
                newSubpopulation.add(rank[j]);
            }
        }
        Individual[] archive = newSubpopulation.toArray(dummy);
        NSGA2Breeder breeder = (NSGA2Breeder)state.breeder;
        if (breeder.reevaluateElites[subpop]) {
            for (int i = 0; i < archive.length; ++i) {
                archive[i].evaluated = false;
            }
        }
        return archive;
    }

    public ArrayList assignFrontRanks(Subpopulation subpop) {
        Individual[] inds = subpop.individuals;
        ArrayList frontsByRank = MultiObjectiveFitness.partitionIntoRanks(inds);
        int numRanks = frontsByRank.size();
        for (int rank = 0; rank < numRanks; ++rank) {
            ArrayList front = (ArrayList)frontsByRank.get(rank);
            int numInds = front.size();
            for (int ind = 0; ind < numInds; ++ind) {
                ((NSGA2MultiObjectiveFitness)((Individual)front.get((int)ind)).fitness).rank = rank;
            }
        }
        return frontsByRank;
    }

    public void assignSparsity(Individual[] front) {
        int i;
        int numObjectives = ((NSGA2MultiObjectiveFitness)front[0].fitness).getObjectives().length;
        for (i = 0; i < front.length; ++i) {
            ((NSGA2MultiObjectiveFitness)front[i].fitness).sparsity = 0.0;
        }
        for (i = 0; i < numObjectives; ++i) {
            final int o = i;
            QuickSort.qsort(front, new SortComparator(){

                public boolean lt(Object a, Object b) {
                    Individual i1 = (Individual)a;
                    Individual i2 = (Individual)b;
                    return ((NSGA2MultiObjectiveFitness)i1.fitness).getObjective(o) < ((NSGA2MultiObjectiveFitness)i2.fitness).getObjective(o);
                }

                public boolean gt(Object a, Object b) {
                    Individual i1 = (Individual)a;
                    Individual i2 = (Individual)b;
                    return ((NSGA2MultiObjectiveFitness)i1.fitness).getObjective(o) > ((NSGA2MultiObjectiveFitness)i2.fitness).getObjective(o);
                }
            });
            ((NSGA2MultiObjectiveFitness)front[0].fitness).sparsity = Double.POSITIVE_INFINITY;
            ((NSGA2MultiObjectiveFitness)front[front.length - 1].fitness).sparsity = Double.POSITIVE_INFINITY;
            for (int j = 1; j < front.length - 1; ++j) {
                NSGA2MultiObjectiveFitness f_j = (NSGA2MultiObjectiveFitness)front[j].fitness;
                NSGA2MultiObjectiveFitness f_jplus1 = (NSGA2MultiObjectiveFitness)front[j + 1].fitness;
                NSGA2MultiObjectiveFitness f_jminus1 = (NSGA2MultiObjectiveFitness)front[j - 1].fitness;
                f_j.sparsity += (f_jplus1.getObjective(o) - f_jminus1.getObjective(o)) / (f_j.maxObjective[o] - f_j.minObjective[o]);
            }
        }
    }
}

