/*
 * Decompiled with CFR 0.152.
 */
package ec.rule;

import ec.EvolutionState;
import ec.rule.RuleConstraints;
import ec.rule.RuleDefaults;
import ec.rule.RuleSetConstraints;
import ec.simple.SimpleInitializer;
import ec.util.Parameter;
import java.util.Enumeration;
import java.util.Hashtable;

public class RuleInitializer
extends SimpleInitializer {
    private static final long serialVersionUID = 1L;
    public static final int SIZE_OF_BYTE = 256;
    public static final String P_RULESETCONSTRAINTS = "rsc";
    public static final String P_RULECONSTRAINTS = "rc";
    public static final String P_SIZE = "size";
    public Hashtable ruleConstraintRepository;
    public RuleConstraints[] ruleConstraints;
    public byte numRuleConstraints;
    public Hashtable ruleSetConstraintRepository;
    public RuleSetConstraints[] ruleSetConstraints;
    public byte numRuleSetConstraints;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.ruleConstraintRepository = new Hashtable();
        this.ruleConstraints = new RuleConstraints[256];
        this.numRuleConstraints = 0;
        this.ruleSetConstraintRepository = new Hashtable();
        this.ruleSetConstraints = new RuleSetConstraints[256];
        this.numRuleSetConstraints = 0;
        this.setupConstraints(state, RuleDefaults.base().push(P_RULECONSTRAINTS));
        this.setupRuleSetConstraints(state, RuleDefaults.base().push(P_RULESETCONSTRAINTS));
    }

    public void setupConstraints(EvolutionState state, Parameter base) {
        RuleConstraints c;
        state.output.message("Processing Rule Constraints");
        int x = state.parameters.getInt(base.push(P_SIZE), null, 1);
        if (x <= 0) {
            state.output.fatal("The number of rule constraints must be at least 1.", base.push(P_SIZE));
        }
        for (int y = 0; y < x; ++y) {
            if (state.parameters.exists(base.push("" + y), null)) {
                c = (RuleConstraints)state.parameters.getInstanceForParameterEq(base.push("" + y), null, RuleConstraints.class);
            } else {
                state.output.message("No Rule Constraints specified, assuming the default class: ec.rule.RuleConstraints for " + base.push("" + y));
                c = new RuleConstraints();
            }
            c.setup(state, base.push("" + y));
        }
        Enumeration e = this.ruleConstraintRepository.elements();
        while (e.hasMoreElements()) {
            c = (RuleConstraints)e.nextElement();
            c.constraintNumber = this.numRuleConstraints;
            this.ruleConstraints[this.numRuleConstraints] = c;
            this.numRuleConstraints = (byte)(this.numRuleConstraints + 1);
        }
    }

    public void setupRuleSetConstraints(EvolutionState state, Parameter base) {
        RuleSetConstraints c;
        state.output.message("Processing Ruleset Constraints");
        int x = state.parameters.getInt(base.push(P_SIZE), null, 1);
        if (x <= 0) {
            state.output.fatal("The number of RuleSetConstraints must be at least 1.", base.push(P_SIZE));
        }
        for (int y = 0; y < x; ++y) {
            if (state.parameters.exists(base.push("" + y), null)) {
                c = (RuleSetConstraints)state.parameters.getInstanceForParameterEq(base.push("" + y), null, RuleSetConstraints.class);
            } else {
                state.output.message("No RuleSetConstraints specified, assuming the default class: ec.gp.RuleSetConstraints for " + base.push("" + y));
                c = new RuleSetConstraints();
            }
            c.setup(state, base.push("" + y));
        }
        Enumeration e = this.ruleSetConstraintRepository.elements();
        while (e.hasMoreElements()) {
            c = (RuleSetConstraints)e.nextElement();
            c.constraintNumber = this.numRuleSetConstraints;
            this.ruleSetConstraints[this.numRuleSetConstraints] = c;
            this.numRuleSetConstraints = (byte)(this.numRuleSetConstraints + 1);
        }
    }
}

