/*
 * Decompiled with CFR 0.152.
 */
package ec.spatial;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.simple.SimpleBreeder;
import ec.spatial.Space;
import ec.util.Parameter;

public class SpatialBreeder
extends SimpleBreeder {
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        for (int i = 0; i < this.elite.length; ++i) {
            if (!this.usingElitism(i)) continue;
            state.output.warning("You're using elitism with SpatialBreeder.  This is unwise as elitism is done by moving individuals around in the population, thus messing up the spatial nature of breeding.", base.push("elite").push("" + i));
            break;
        }
        if (this.sequentialBreeding) {
            state.output.warning("SpationBreeder hasn't been well tested with sequential evaluation, though it should probably work fine.  You're on your own.", base.push("sequential"));
        }
        if (!this.clonePipelineAndPopulation) {
            state.output.fatal("clonePipelineAndPopulation must be true for SpatialBreeder.");
        }
    }

    protected void breedPopChunk(Population newpop, EvolutionState state, int[] numinds, int[] from, int threadnum) {
        for (int subpop = 0; subpop < newpop.subpops.length; ++subpop) {
            if (!this.shouldBreedSubpop(state, subpop, threadnum)) {
                for (int ind = from[subpop]; ind < numinds[subpop] - from[subpop]; ++ind) {
                    newpop.subpops[subpop].individuals[ind] = (Individual)state.population.subpops[subpop].individuals[ind].clone();
                }
                continue;
            }
            BreedingPipeline bp = (BreedingPipeline)newpop.subpops[subpop].species.pipe_prototype.clone();
            if (!(state.population.subpops[subpop] instanceof Space)) {
                state.output.fatal("Subpopulation " + subpop + " does not implement the Space interface.");
            }
            Space space = (Space)((Object)state.population.subpops[subpop]);
            if (!bp.produces(state, newpop, subpop, threadnum)) {
                state.output.fatal("The Breeding Pipeline of subpopulation " + subpop + " does not produce individuals of the expected species " + newpop.subpops[subpop].species.getClass().getName() + " or fitness " + newpop.subpops[subpop].species.f_prototype);
            }
            bp.prepareToProduce(state, subpop, threadnum);
            for (int x = from[subpop]; x < from[subpop] + numinds[subpop]; ++x) {
                space.setIndex(threadnum, x);
                if (bp.produce(1, 1, x, subpop, newpop.subpops[subpop].individuals, state, threadnum) == 1) continue;
                state.output.fatal("The pipelines should produce one individual at a time!");
            }
            bp.finishProducing(state, subpop, threadnum);
        }
    }
}

