/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class DataPipe {
    byte[] buffer = new byte[8192];
    int size = 0;
    int pull = 0;
    public DataInputStream input;
    public DataOutputStream output;

    void resize() {
        byte[] newbuffer = new byte[this.buffer.length * 2];
        System.arraycopy(this.buffer, 0, newbuffer, 0, this.buffer.length);
        this.buffer = newbuffer;
    }

    void push(byte b) {
        if (this.size >= this.buffer.length) {
            this.resize();
        }
        this.buffer[this.size++] = b;
    }

    void push(byte[] b, int offset, int length) {
        if (this.size + length > this.buffer.length) {
            this.resize();
        }
        System.arraycopy(b, offset, this.buffer, this.size, length);
        this.size += length;
    }

    int pull() {
        byte b;
        if (this.pull == this.size) {
            return -1;
        }
        if ((b = this.buffer[this.pull++]) < 0) {
            return b + 256;
        }
        return b;
    }

    int pull(byte[] b, int offset, int length) {
        if (this.pull == this.size) {
            return -1;
        }
        if (length > this.size - this.pull) {
            length = this.size - this.pull;
        }
        System.arraycopy(this.buffer, this.pull, b, offset, length);
        this.pull += length;
        return length;
    }

    public DataPipe() {
        OutputStream outStream = new OutputStream(){

            public void write(int b) throws IOException {
                DataPipe.this.push((byte)b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                DataPipe.this.push(b, off, len);
            }

            public void write(byte[] b) throws IOException {
                DataPipe.this.push(b, 0, b.length);
            }
        };
        this.output = new DataOutputStream(outStream);
        InputStream inStream = new InputStream(){

            public int read() throws IOException {
                return DataPipe.this.pull();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return DataPipe.this.pull(b, off, len);
            }

            public int read(byte[] b) throws IOException {
                return DataPipe.this.pull(b, 0, b.length);
            }
        };
        this.input = new DataInputStream(inStream);
    }

    public void reset() {
        this.size = 0;
        this.pull = 0;
    }

    public int size() {
        return this.buffer.length;
    }

    public int numWritten() {
        return this.size;
    }

    public int numRead() {
        return this.pull;
    }

    public static Object copy(Serializable obj) throws IOException, ClassNotFoundException {
        DataPipe pipe = new DataPipe();
        ObjectOutputStream s = new ObjectOutputStream(pipe.output);
        ObjectInputStream u = new ObjectInputStream(pipe.input);
        s.writeObject(obj);
        return u.readObject();
    }

    public String toString() {
        return "DataPipe(" + this.numWritten() + ", " + this.numRead() + ", " + this.size() + ")";
    }
}

