/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.Individual;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.vector.IntegerVectorSpecies;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class ByteVectorIndividual
extends VectorIndividual {
    public static final String P_BYTEVECTORINDIVIDUAL = "byte-vect-ind";
    public byte[] genome;

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_BYTEVECTORINDIVIDUAL);
    }

    public Object clone() {
        ByteVectorIndividual myobj = (ByteVectorIndividual)super.clone();
        myobj.genome = (byte[])this.genome.clone();
        return myobj;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (!(this.species instanceof IntegerVectorSpecies)) {
            state.output.fatal("ByteVectorIndividual requires an IntegerVectorSpecies", base, def);
        }
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        this.genome = new byte[s.genomeSize];
    }

    public void defaultCrossover(EvolutionState state, int thread, VectorIndividual ind) {
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        ByteVectorIndividual i = (ByteVectorIndividual)ind;
        int len = Math.min(this.genome.length, i.genome.length);
        if (len != this.genome.length || len != i.genome.length) {
            state.output.warnOnce("Genome lengths are not the same.  Vector crossover will only be done in overlapping region.");
        }
        switch (s.crossoverType) {
            case 0: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                for (int x = 0; x < point * s.chunksize; ++x) {
                    byte tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 2: {
                int point = state.random[thread].nextInt(len / s.chunksize - 1) + 1;
                for (int x = 0; x < point * s.chunksize; ++x) {
                    byte tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 4: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                int point0 = state.random[thread].nextInt(len / s.chunksize);
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    byte tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 8: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                int point0 = 0;
                while ((point0 = state.random[thread].nextInt(len / s.chunksize)) == point) {
                }
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    byte tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 128: {
                for (int x = 0; x < len / s.chunksize; ++x) {
                    if (!state.random[thread].nextBoolean(s.crossoverProbability)) continue;
                    for (int y = x * s.chunksize; y < (x + 1) * s.chunksize; ++y) {
                        byte tmp = i.genome[y];
                        i.genome[y] = this.genome[y];
                        this.genome[y] = tmp;
                    }
                }
                break;
            }
            case 256: {
                double alpha = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                double beta = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                for (int x = 0; x < len; ++x) {
                    long min = s.minGene(x);
                    long max = s.maxGene(x);
                    long t = (long)Math.floor(alpha * (double)this.genome[x] + (1.0 - alpha) * (double)i.genome[x] + 0.5);
                    long u = (long)Math.floor(beta * (double)i.genome[x] + (1.0 - beta) * (double)this.genome[x] + 0.5);
                    if (t < min || t > max || u < min || u > max) continue;
                    this.genome[x] = (byte)t;
                    i.genome[x] = (byte)u;
                }
                break;
            }
            case 512: {
                for (int x = 0; x < len; ++x) {
                    long u;
                    long max;
                    long min;
                    long t;
                    do {
                        double alpha = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                        double beta = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                        min = s.minGene(x);
                        max = s.maxGene(x);
                        t = (long)Math.floor(alpha * (double)this.genome[x] + (1.0 - alpha) * (double)i.genome[x] + 0.5);
                        u = (long)Math.floor(beta * (double)i.genome[x] + (1.0 - beta) * (double)this.genome[x] + 0.5);
                    } while (t < min || t > max || u < min || u > max);
                    this.genome[x] = (byte)t;
                    i.genome[x] = (byte)u;
                }
                break;
            }
        }
    }

    public void split(int[] points, Object[] pieces) {
        int point0 = 0;
        int point1 = points[0];
        for (int x = 0; x < pieces.length; ++x) {
            pieces[x] = new byte[point1 - point0];
            System.arraycopy(this.genome, point0, pieces[x], 0, point1 - point0);
            point0 = point1;
            point1 = x >= pieces.length - 2 ? this.genome.length : points[x + 1];
        }
    }

    public void join(Object[] pieces) {
        int sum = 0;
        for (int x = 0; x < pieces.length; ++x) {
            sum += ((byte[])pieces[x]).length;
        }
        int runningsum = 0;
        byte[] newgenome = new byte[sum];
        for (int x = 0; x < pieces.length; ++x) {
            System.arraycopy(pieces[x], 0, newgenome, runningsum, ((byte[])pieces[x]).length);
            runningsum += ((byte[])pieces[x]).length;
        }
        this.genome = newgenome;
    }

    public byte randomValueFromClosedInterval(byte min, byte max, MersenneTwisterFast random) {
        if (max - min < 0) {
            byte l = 0;
            while ((l = (byte)random.nextInt()) < min || l > max) {
            }
            return l;
        }
        return (byte)(min + random.nextInt(max - min + 1));
    }

    public void defaultMutate(EvolutionState state, int thread) {
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        block4: for (int x = 0; x < this.genome.length; ++x) {
            if (!state.random[thread].nextBoolean(s.mutationProbability(x))) continue;
            byte old = this.genome[x];
            for (int retries = 0; retries < s.duplicateRetries(x) + 1; ++retries) {
                switch (s.mutationType(x)) {
                    case 0: {
                        this.genome[x] = this.randomValueFromClosedInterval((byte)s.minGene(x), (byte)s.maxGene(x), state.random[thread]);
                        break;
                    }
                    case 1: {
                        int min = (int)s.minGene(x);
                        int max = (int)s.maxGene(x);
                        if (!s.mutationIsBounded(x)) {
                            max = 127;
                            min = -128;
                        }
                        do {
                            int n = state.random[thread].nextBoolean() ? 1 : -1;
                            byte g = this.genome[x];
                            if (n == 1 && g < max || n == -1 && g > min) {
                                this.genome[x] = (byte)(g + n);
                                continue;
                            }
                            if ((n != -1 || g >= max) && (n != 1 || g <= min)) continue;
                            this.genome[x] = (byte)(g - n);
                        } while (state.random[thread].nextBoolean(s.randomWalkProbability(x)));
                        break;
                    }
                    default: {
                        state.output.fatal("In ByteVectorIndividual.defaultMutate, default case occurred when it shouldn't have");
                    }
                }
                if (this.genome[x] != old) continue block4;
            }
        }
    }

    public void reset(EvolutionState state, int thread) {
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = this.randomValueFromClosedInterval((byte)s.minGene(x), (byte)s.maxGene(x), state.random[thread]);
        }
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash << 1 | hash >>> 31;
        for (int x = 0; x < this.genome.length; ++x) {
            hash = (hash << 1 | hash >>> 31) ^ this.genome[x];
        }
        return hash;
    }

    public String genotypeToStringForHumans() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.genome.length; ++i) {
            if (i > 0) {
                s.append(" ");
            }
            s.append(this.genome[i]);
        }
        return s.toString();
    }

    public String genotypeToString() {
        StringBuilder s = new StringBuilder();
        s.append(Code.encode(this.genome.length));
        for (int i = 0; i < this.genome.length; ++i) {
            s.append(Code.encode(this.genome[i]));
        }
        return s.toString();
    }

    protected void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        String s = reader.readLine();
        DecodeReturn d = new DecodeReturn(s);
        Code.decode(d);
        if (d.type != 4) {
            state.output.fatal("Individual with genome:\n" + s + "\n... does not have an integer at the beginning indicating the genome count.");
        }
        int lll = (int)d.l;
        this.genome = new byte[lll];
        for (int i = 0; i < this.genome.length; ++i) {
            Code.decode(d);
            this.genome[i] = (byte)d.l;
        }
    }

    public boolean equals(Object ind) {
        if (ind == null) {
            return false;
        }
        if (!this.getClass().equals(ind.getClass())) {
            return false;
        }
        ByteVectorIndividual i = (ByteVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            return false;
        }
        for (int j = 0; j < this.genome.length; ++j) {
            if (this.genome[j] == i.genome[j]) continue;
            return false;
        }
        return true;
    }

    public Object getGenome() {
        return this.genome;
    }

    public void setGenome(Object gen) {
        this.genome = (byte[])gen;
    }

    public int genomeLength() {
        return this.genome.length;
    }

    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.genome.length);
        for (int x = 0; x < this.genome.length; ++x) {
            dataOutput.writeByte(this.genome[x]);
        }
    }

    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.genome == null || this.genome.length != len) {
            this.genome = new byte[len];
        }
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = dataInput.readByte();
        }
    }

    public void clamp() {
        IntegerVectorSpecies _species = (IntegerVectorSpecies)this.species;
        for (int i = 0; i < this.genomeLength(); ++i) {
            byte minGene = (byte)_species.minGene(i);
            if (this.genome[i] < minGene) {
                this.genome[i] = minGene;
                continue;
            }
            byte maxGene = (byte)_species.maxGene(i);
            if (this.genome[i] <= maxGene) continue;
            this.genome[i] = maxGene;
        }
    }

    public void setGenomeLength(int len) {
        byte[] newGenome;
        System.arraycopy(this.genome, 0, newGenome, 0, this.genome.length < (newGenome = new byte[len]).length ? this.genome.length : newGenome.length);
        this.genome = newGenome;
    }

    public boolean isInRange() {
        IntegerVectorSpecies _species = (IntegerVectorSpecies)this.species;
        for (int i = 0; i < this.genomeLength(); ++i) {
            if ((long)this.genome[i] >= _species.minGene(i) && (long)this.genome[i] <= _species.maxGene(i)) continue;
            return false;
        }
        return true;
    }

    public double distanceTo(Individual otherInd) {
        if (!(otherInd instanceof ByteVectorIndividual)) {
            return super.distanceTo(otherInd);
        }
        ByteVectorIndividual other = (ByteVectorIndividual)otherInd;
        byte[] otherGenome = other.genome;
        double sumSquaredDistance = 0.0;
        for (int i = 0; i < other.genomeLength(); ++i) {
            long dist = (long)this.genome[i] - (long)otherGenome[i];
            sumSquaredDistance += (double)(dist * dist);
        }
        return StrictMath.sqrt(sumSquaredDistance);
    }
}

