/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class IssueDifference {
    private static final List<Issue> EMPTY = Collections.emptyList();
    private final Report newIssues;
    private final Report fixedIssues;
    private final Report outstandingIssues;
    private final Map<Integer, List<Issue>> referencesByHash;
    private final Map<String, List<Issue>> referencesByFingerprint;

    public IssueDifference(Report currentIssues, String referenceId, Report referenceIssues) {
        this.newIssues = currentIssues.copy();
        this.fixedIssues = referenceIssues.copy();
        this.outstandingIssues = new Report();
        this.referencesByHash = new HashMap<Integer, List<Issue>>();
        this.referencesByFingerprint = new HashMap<String, List<Issue>>();
        for (Issue issue2 : referenceIssues) {
            this.addIssueToMap(this.referencesByHash, issue2.hashCode(), issue2);
            this.addIssueToMap(this.referencesByFingerprint, issue2.getFingerprint(), issue2);
        }
        List<UUID> removed = this.matchIssuesByEquals(currentIssues);
        Report secondPass = currentIssues.copy();
        removed.forEach(secondPass::remove);
        this.matchIssuesByFingerprint(secondPass);
        this.newIssues.forEach(issue -> issue.setReference(referenceId));
    }

    private List<UUID> matchIssuesByEquals(Report currentIssues) {
        ArrayList<UUID> removedIds = new ArrayList<UUID>();
        for (Issue current : currentIssues) {
            List<Issue> equalIssues = this.findReferenceByEquals(current);
            if (equalIssues.isEmpty()) continue;
            removedIds.add(this.remove(current, this.selectIssueWithSameFingerprint(current, equalIssues)));
        }
        return removedIds;
    }

    private void matchIssuesByFingerprint(Report currentIssues) {
        for (Issue current : currentIssues) {
            this.findReferenceByFingerprint(current).ifPresent(issue -> this.remove(current, (Issue)issue));
        }
    }

    private <K> void addIssueToMap(Map<K, List<Issue>> map, K key, Issue issue) {
        map.computeIfAbsent(key, k -> new ArrayList()).add(issue);
    }

    private <K> void removeIssueFromMap(Map<K, List<Issue>> map, K key, Issue issue) {
        List<Issue> issues = map.get(key);
        issues.remove(issue);
        if (issues.isEmpty()) {
            map.remove(key);
        }
    }

    private UUID remove(Issue current, Issue oldIssue) {
        UUID id = current.getId();
        Issue issueWithLatestProperties = this.newIssues.remove(id);
        issueWithLatestProperties.setReference(oldIssue.getReference());
        this.outstandingIssues.add(issueWithLatestProperties);
        this.fixedIssues.remove(oldIssue.getId());
        this.removeIssueFromMap(this.referencesByFingerprint, oldIssue.getFingerprint(), oldIssue);
        this.removeIssueFromMap(this.referencesByHash, oldIssue.hashCode(), oldIssue);
        return id;
    }

    private Issue selectIssueWithSameFingerprint(Issue current, List<Issue> equalIssues) {
        return equalIssues.stream().filter(issue -> issue.getFingerprint().equals(current.getFingerprint())).findFirst().orElse(equalIssues.get(0));
    }

    private Optional<Issue> findReferenceByFingerprint(Issue current) {
        return this.referencesByFingerprint.getOrDefault(current.getFingerprint(), EMPTY).stream().findAny();
    }

    private List<Issue> findReferenceByEquals(Issue current) {
        ArrayList<Issue> equalIssues = new ArrayList<Issue>();
        for (Issue reference : this.referencesByHash.getOrDefault(current.hashCode(), EMPTY)) {
            if (!current.equals(reference)) continue;
            equalIssues.add(reference);
        }
        return equalIssues;
    }

    @SuppressFBWarnings(value={"EI"})
    public Report getOutstandingIssues() {
        return this.outstandingIssues;
    }

    @SuppressFBWarnings(value={"EI"})
    public Report getNewIssues() {
        return this.newIssues;
    }

    @SuppressFBWarnings(value={"EI"})
    public Report getFixedIssues() {
        return this.fixedIssues;
    }
}

